/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.diagnostics;

import com.jetbrains.rd.tracing.SyncEventsLogger;
import com.jetbrains.rdclient.diagnostics.UtilsKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001eB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rdclient/diagnostics/ConflictTracker;", "", "sessionType", "Lcom/jetbrains/rd/tracing/SyncEventsLogger$RebaseSessionType;", "batchSize", "", "ConflictTracker", "(Lcom/jetbrains/rd/tracing/SyncEventsLogger$RebaseSessionType;I)V", "getSessionType", "()Lcom/jetbrains/rd/tracing/SyncEventsLogger$RebaseSessionType;", "getBatchSize", "()I", "startTime", "", "primaryConflict", "Lcom/jetbrains/rdclient/diagnostics/ConflictTracker$ConflictEvent;", "getPrimaryConflict", "()Lcom/jetbrains/rdclient/diagnostics/ConflictTracker$ConflictEvent;", "setPrimaryConflict", "(Lcom/jetbrains/rdclient/diagnostics/ConflictTracker$ConflictEvent;)V", "restoredChangesCount", "totalConflictsCount", "trackConflict", "", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "conflicts", "trackRestoredChanges", "count", "reportSummary", "ConflictEvent", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nConflictTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConflictTracker.kt\ncom/jetbrains/rdclient/diagnostics/ConflictTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class ConflictTracker {
    @NotNull
    private final SyncEventsLogger.RebaseSessionType sessionType;
    private final int batchSize;
    private final long startTime;
    @Nullable
    private ConflictEvent primaryConflict;
    private int restoredChangesCount;
    private int totalConflictsCount;

    public ConflictTracker(@NotNull SyncEventsLogger.RebaseSessionType sessionType, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
        this.sessionType = sessionType;
        this.batchSize = batchSize;
        this.startTime = System.nanoTime();
    }

    public /* synthetic */ ConflictTracker(SyncEventsLogger.RebaseSessionType rebaseSessionType, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            rebaseSessionType = SyncEventsLogger.RebaseSessionType.OTHER;
        }
        this(rebaseSessionType, n);
    }

    @NotNull
    public final SyncEventsLogger.RebaseSessionType getSessionType() {
        return this.sessionType;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    public final ConflictEvent getPrimaryConflict() {
        return this.primaryConflict;
    }

    public final void setPrimaryConflict(@Nullable ConflictEvent conflictEvent) {
        this.primaryConflict = conflictEvent;
    }

    public final void trackConflict(@Nullable FrontendAsyncRequest request, int conflicts) {
        String string;
        if (conflicts <= 0) {
            return;
        }
        this.totalConflictsCount += conflicts;
        FrontendAsyncRequest frontendAsyncRequest = request;
        Class<?> clazz = frontendAsyncRequest != null ? frontendAsyncRequest.getClass() : null;
        FrontendAsyncRequest frontendAsyncRequest2 = request;
        String string2 = string = frontendAsyncRequest2 != null ? UtilsKt.actionIdOrNull(frontendAsyncRequest2) : null;
        if (this.primaryConflict == null) {
            this.primaryConflict = new ConflictEvent(conflicts, clazz, string);
        }
        SyncEventsLogger.INSTANCE.logConflict(this.sessionType, conflicts, clazz, string);
    }

    public final void trackRestoredChanges(int count) {
        this.restoredChangesCount += count;
    }

    public final void reportSummary() {
        if (this.totalConflictsCount == 0) {
            return;
        }
        ConflictEvent conflictEvent = this.primaryConflict;
        if (conflictEvent == null) {
            boolean bl = false;
            String string = "totalConflictsCount > 0 but primaryConflict is null";
            throw new IllegalArgumentException(string.toString());
        }
        long l = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)(System.nanoTime() - this.startTime), (DurationUnit)DurationUnit.NANOSECONDS));
        int n = this.totalConflictsCount - this.restoredChangesCount;
        SyncEventsLogger.INSTANCE.logRebase(this.sessionType, this.totalConflictsCount, this.restoredChangesCount, n, conflictEvent.getRequestType(), conflictEvent.getActionId(), l, this.batchSize);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/diagnostics/ConflictTracker$ConflictEvent;", "", "conflictsCount", "", "requestType", "Ljava/lang/Class;", "actionId", "", "ConflictTracker$ConflictEvent", "(ILjava/lang/Class;Ljava/lang/String;)V", "getConflictsCount", "()I", "getRequestType", "()Ljava/lang/Class;", "getActionId", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.rd.client"})
    public static final class ConflictEvent {
        private final int conflictsCount;
        @Nullable
        private final Class<?> requestType;
        @Nullable
        private final String actionId;

        public ConflictEvent(int conflictsCount, @Nullable Class<?> requestType, @Nullable String actionId) {
            this.conflictsCount = conflictsCount;
            this.requestType = requestType;
            this.actionId = actionId;
        }

        public final int getConflictsCount() {
            return this.conflictsCount;
        }

        @Nullable
        public final Class<?> getRequestType() {
            return this.requestType;
        }

        @Nullable
        public final String getActionId() {
            return this.actionId;
        }

        public final int component1() {
            return this.conflictsCount;
        }

        @Nullable
        public final Class<?> component2() {
            return this.requestType;
        }

        @Nullable
        public final String component3() {
            return this.actionId;
        }

        @NotNull
        public final ConflictEvent copy(int conflictsCount, @Nullable Class<?> requestType, @Nullable String actionId) {
            return new ConflictEvent(conflictsCount, requestType, actionId);
        }

        public static /* synthetic */ ConflictEvent copy$default(ConflictEvent conflictEvent, int n, Class clazz, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = conflictEvent.conflictsCount;
            }
            if ((n2 & 2) != 0) {
                clazz = conflictEvent.requestType;
            }
            if ((n2 & 4) != 0) {
                string = conflictEvent.actionId;
            }
            return conflictEvent.copy(n, clazz, string);
        }

        @NotNull
        public String toString() {
            return "ConflictEvent(conflictsCount=" + this.conflictsCount + ", requestType=" + this.requestType + ", actionId=" + this.actionId + ")";
        }

        public int hashCode() {
            int n = Integer.hashCode(this.conflictsCount);
            n = n * 31 + (this.requestType == null ? 0 : this.requestType.hashCode());
            n = n * 31 + (this.actionId == null ? 0 : this.actionId.hashCode());
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConflictEvent)) {
                return false;
            }
            ConflictEvent conflictEvent = (ConflictEvent)other;
            if (this.conflictsCount != conflictEvent.conflictsCount) {
                return false;
            }
            if (!Intrinsics.areEqual(this.requestType, conflictEvent.requestType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.actionId, (Object)conflictEvent.actionId);
        }
    }
}

