/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.tooltips;

import com.jetbrains.rd.ide.model.NotCalculatedTooltipModel;
import com.jetbrains.rd.ide.model.TooltipModel;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH&J\u0006\u0010\u0010\u001a\u00020\rJ(\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipCalculator;", "", "modelId", "", "provider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "FrontendTooltipCalculator", "(JLcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;)V", "requested", "Ljava/util/concurrent/atomic/AtomicBoolean;", "tooltipTimestamp", "", "updateData", "", "tooltipModel", "Lcom/jetbrains/rd/ide/model/TooltipModel;", "calculateTooltip", "x", "model", "currentTimestamp", "retry", "Companion", "intellij.rd.client"})
public abstract class FrontendTooltipCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long modelId;
    @NotNull
    private final FrontendTooltipProvider provider;
    @NotNull
    private final AtomicBoolean requested;
    private int tooltipTimestamp;
    private static final int CALCULATION_RETRY_LIMIT = 10;

    public FrontendTooltipCalculator(long modelId, @NotNull FrontendTooltipProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        this.modelId = modelId;
        this.provider = provider2;
        this.requested = new AtomicBoolean();
        this.tooltipTimestamp = -1;
    }

    public abstract void updateData(@Nullable TooltipModel var1);

    public final void calculateTooltip() {
        if (this.modelId < 0L) {
            return;
        }
        int n = this.provider.getCurrentTimestamp();
        if (this.tooltipTimestamp == n) {
            return;
        }
        if (!this.requested.compareAndSet(false, true)) {
            return;
        }
        this.tooltipTimestamp = n;
        this.updateData(null);
        this.provider.requestTooltip(this.modelId, (Function1<? super TooltipModel, Unit>)((Function1)arg_0 -> FrontendTooltipCalculator.x(this, n, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void x(TooltipModel tooltipModel, FrontendTooltipProvider frontendTooltipProvider, int n, int n2) {
        try {
            if (n == frontendTooltipProvider.getCurrentTimestamp() && !(tooltipModel instanceof NotCalculatedTooltipModel)) {
                this.updateData(tooltipModel);
            } else {
                if (n2 <= 0) {
                    this.updateData(tooltipModel);
                    return;
                }
                this.updateData(tooltipModel);
                frontendTooltipProvider.requestTooltip(this.modelId, (Function1<? super TooltipModel, Unit>)((Function1)arg_0 -> FrontendTooltipCalculator.x(this, tooltipModel, frontendTooltipProvider, n2, arg_0)));
                this.tooltipTimestamp = -1;
            }
        }
        finally {
            this.requested.set(false);
        }
    }

    private static final Unit x(FrontendTooltipCalculator frontendTooltipCalculator, int n, TooltipModel tooltipModel) {
        Intrinsics.checkNotNullParameter((Object)tooltipModel, (String)"it");
        frontendTooltipCalculator.x(tooltipModel, frontendTooltipCalculator.provider, n, 10);
        return Unit.INSTANCE;
    }

    private static final Unit x(FrontendTooltipCalculator frontendTooltipCalculator, TooltipModel tooltipModel, FrontendTooltipProvider frontendTooltipProvider, int n, TooltipModel tooltipModel2) {
        Intrinsics.checkNotNullParameter((Object)tooltipModel2, (String)"it");
        frontendTooltipCalculator.x(tooltipModel, frontendTooltipProvider, frontendTooltipProvider.getCurrentTimestamp(), n - 1);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipCalculator$Companion;", "", "FrontendTooltipCalculator$Companion", "()V", "CALCULATION_RETRY_LIMIT", "", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

