/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.model.InlayMouseEvent;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.ide.model.MouseTrackingInlayExtensionModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.IFrontendProtocolMarkupExtension;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendMouseAwareInlayRenderer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/MouseTrackingInlayExtension;", "Lcom/jetbrains/rdclient/daemon/IFrontendProtocolMarkupExtension;", "MouseTrackingInlayExtension", "()V", "createExtensions", "", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "MyListener", "intellij.rd.client"})
public final class MouseTrackingInlayExtension
implements IFrontendProtocolMarkupExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<MouseTrackingInlayExtensionModel> INLAY_EVENTS_MODEL_EXTENSION_KEY = new Key("INLAY_MOUSE_EVENTS_MODEL_EXTENSION_KEY");

    @Override
    @NotNull
    public List<MarkupModelExtension> createExtensions(@NotNull Lifetime lifetime, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<MarkupModelExtension> createExtensions(@NotNull Lifetime lifetime, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String string = INLAY_EVENTS_MODEL_EXTENSION_KEY.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        MouseTrackingInlayExtensionModel mouseTrackingInlayExtensionModel = new MouseTrackingInlayExtensionModel(string);
        MyListener myListener2 = new MyListener(mouseTrackingInlayExtensionModel);
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
        editor.addEditorMouseListener((EditorMouseListener)myListener2, disposable);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)myListener2, disposable);
        return CollectionsKt.listOf((Object)((Object)mouseTrackingInlayExtensionModel));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/MouseTrackingInlayExtension$Companion;", "", "MouseTrackingInlayExtension$Companion", "()V", "INLAY_EVENTS_MODEL_EXTENSION_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rd/ide/model/MouseTrackingInlayExtensionModel;", "getINLAY_EVENTS_MODEL_EXTENSION_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<MouseTrackingInlayExtensionModel> getINLAY_EVENTS_MODEL_EXTENSION_KEY() {
            return INLAY_EVENTS_MODEL_EXTENSION_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/MouseTrackingInlayExtension$MyListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "inlayEventsModel", "Lcom/jetbrains/rd/ide/model/MouseTrackingInlayExtensionModel;", "MouseTrackingInlayExtension$MyListener", "(Lcom/jetbrains/rd/ide/model/MouseTrackingInlayExtensionModel;)V", "lastHoveredInlay", "Lcom/intellij/openapi/editor/Inlay;", "mouseClicked", "", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseMoved", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nMouseTrackingInlayExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MouseTrackingInlayExtension.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/MouseTrackingInlayExtension$MyListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
    private static final class MyListener
    implements EditorMouseListener,
    EditorMouseMotionListener {
        @NotNull
        private final MouseTrackingInlayExtensionModel inlayEventsModel;
        @Nullable
        private Inlay<?> lastHoveredInlay;

        public MyListener(@NotNull MouseTrackingInlayExtensionModel inlayEventsModel) {
            Intrinsics.checkNotNullParameter((Object)((Object)inlayEventsModel), (String)"inlayEventsModel");
            this.inlayEventsModel = inlayEventsModel;
        }

        public void mouseClicked(@NotNull EditorMouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Inlay inlay = event.getInlay();
            EditorCustomElementRenderer editorCustomElementRenderer = inlay != null ? inlay.getRenderer() : null;
            FrontendMouseAwareInlayRenderer frontendMouseAwareInlayRenderer = editorCustomElementRenderer instanceof FrontendMouseAwareInlayRenderer ? (FrontendMouseAwareInlayRenderer)editorCustomElementRenderer : null;
            if (frontendMouseAwareInlayRenderer == null) {
                return;
            }
            FrontendMouseAwareInlayRenderer frontendMouseAwareInlayRenderer2 = frontendMouseAwareInlayRenderer;
            InlayMouseEvent inlayMouseEvent = frontendMouseAwareInlayRenderer2.mouseClicked(event);
            if (inlayMouseEvent == null) {
                return;
            }
            InlayMouseEvent inlayMouseEvent2 = inlayMouseEvent;
            this.inlayEventsModel.getSendMouseEvent().fire((Object)inlayMouseEvent2);
        }

        public void mouseMoved(@NotNull EditorMouseEvent event) {
            boolean bl;
            InlayMouseEvent inlayMouseEvent;
            EditorCustomElementRenderer editorCustomElementRenderer;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Inlay inlay = event.getInlay();
            Inlay<?> inlay2 = this.lastHoveredInlay;
            if (inlay2 != null) {
                EditorCustomElementRenderer editorCustomElementRenderer2 = inlay2.getRenderer();
                Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer2, (String)"getRenderer(...)");
                editorCustomElementRenderer = editorCustomElementRenderer2;
                if (editorCustomElementRenderer instanceof FrontendMouseAwareInlayRenderer && !Intrinsics.areEqual(inlay2, (Object)event.getInlay())) {
                    InlayMouseEvent inlayMouseEvent2 = ((FrontendMouseAwareInlayRenderer)editorCustomElementRenderer).mouseExited(event, inlay2);
                    if (inlayMouseEvent2 != null) {
                        inlayMouseEvent = inlayMouseEvent2;
                        bl = false;
                        this.inlayEventsModel.getSendMouseEvent().fire((Object)inlayMouseEvent);
                    }
                }
                this.lastHoveredInlay = null;
            }
            Inlay inlay3 = inlay;
            Object object = editorCustomElementRenderer = inlay3 != null ? inlay3.getRenderer() : null;
            if (editorCustomElementRenderer instanceof FrontendMouseAwareInlayRenderer) {
                InlayMouseEvent inlayMouseEvent3 = ((FrontendMouseAwareInlayRenderer)editorCustomElementRenderer).mouseMoved(event);
                if (inlayMouseEvent3 != null) {
                    inlayMouseEvent = inlayMouseEvent3;
                    bl = false;
                    this.inlayEventsModel.getSendMouseEvent().fire((Object)inlayMouseEvent);
                }
                this.lastHoveredInlay = inlay;
            } else {
                this.lastHoveredInlay = null;
            }
        }
    }
}

