/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.impl.inline.InlineDebugRendererBase;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.InlineDebugRendererModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendDebugRenderer;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayWithPresentationModelSupportKt;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendDebugInlayModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "FrontendDebugInlayModelHandler", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "createRender", "Lcom/intellij/xdebugger/impl/inline/InlineDebugRendererBase;", "Lcom/jetbrains/rd/ide/model/InlineDebugRendererModel;", "compare", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
@ApiStatus.Internal
public class FrontendDebugInlayModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final EditorImpl editor;

    public FrontendDebugInlayModelHandler(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return model2 instanceof InlineDebugRendererModel && Intrinsics.areEqual((Object)((InlineDebugRendererModel)model2).getSpecialRenderId(), (Object)"");
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        EditorCustomElementRenderer editorCustomElementRenderer;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        InlineDebugRendererModel cfr_ignored_0 = (InlineDebugRendererModel)model2;
        Inlay<?> inlay = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter);
        if (inlay != null) {
            EditorCustomElementRenderer editorCustomElementRenderer2 = inlay.getRenderer();
            Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer2, (String)"getRenderer(...)");
            editorCustomElementRenderer = editorCustomElementRenderer2;
            if (editorCustomElementRenderer instanceof FrontendDebugRenderer) {
                ((FrontendDebugRenderer)editorCustomElementRenderer).updateFromModel((InlineDebugRendererModel)model2);
                inlay.update();
                return;
            }
            Disposer.dispose((Disposable)((Disposable)inlay));
            FrontendInlayWithPresentationModelSupportKt.setInlay(highlighter, null);
        }
        editorCustomElementRenderer = new InlayProperties().disableSoftWrapping(true).priority(((InlineDebugRendererModel)model2).isCustomNode() ? 0 : -1);
        Inlay inlay2 = this.editor.getInlayModel().addAfterLineEndElement(model2.getStart(), (InlayProperties)editorCustomElementRenderer, (EditorCustomElementRenderer)this.createRender((InlineDebugRendererModel)model2, highlighter));
        FrontendInlayWithPresentationModelSupportKt.setInlay(highlighter, inlay2);
    }

    @NotNull
    protected InlineDebugRendererBase createRender(@NotNull InlineDebugRendererModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return new FrontendDebugRenderer(model2, highlighter);
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (!HighlighterModelAgnosticComparator.INSTANCE.compare(model2, highlighter)) {
            return false;
        }
        Inlay<?> inlay = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter);
        if (inlay == null) {
            return false;
        }
        Inlay<?> inlay2 = inlay;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"getRenderer(...)");
        EditorCustomElementRenderer editorCustomElementRenderer2 = editorCustomElementRenderer;
        return editorCustomElementRenderer2 instanceof FrontendDebugRenderer && Intrinsics.areEqual((Object)((FrontendDebugRenderer)editorCustomElementRenderer2).getModel(), (Object)model2);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        InlineDebugRendererModel inlineDebugRendererModel = (InlineDebugRendererModel)model2;
        boolean bl = false;
        return new InlineDebugRendererModel(inlineDebugRendererModel.getColoredText(), inlineDebugRendererModel.isInExecutionPointHighlight(), inlineDebugRendererModel.isCustomNode(), inlineDebugRendererModel.isErrorMessage(), inlineDebugRendererModel.getSpecialRenderId(), inlineDebugRendererModel.getLayer(), inlineDebugRendererModel.isExactRange(), inlineDebugRendererModel.getDocumentVersion(), inlineDebugRendererModel.isGreedyToLeft(), inlineDebugRendererModel.isGreedyToRight(), inlineDebugRendererModel.isThinErrorStripeMark(), inlineDebugRendererModel.getTextToHighlight(), inlineDebugRendererModel.getTextAttributesKey(), inlineDebugRendererModel.getId(), inlineDebugRendererModel.getProperties(), startOffset, endOffset);
    }
}

