/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides;

import com.intellij.codeInsight.daemon.impl.IndentGuideRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideRenderResultCollector;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideRendererKt;
import java.awt.Graphics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderer;", "Lcom/intellij/codeInsight/daemon/impl/IndentGuideRenderer;", "FrontendIndentGuideRenderer", "()V", "isSelected", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "endOffset", "", "off", "indentColumn", "paint", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "x", "resultCollector", "Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderResultCollector;", "doPaintInTest", "intellij.rd.client"})
public final class FrontendIndentGuideRenderer
extends IndentGuideRenderer {
    protected boolean isSelected(@NotNull Editor editor, int endOffset, int off, int indentColumn) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return IndentGuideRenderer.isCaretOnGuide((Editor)editor, (int)endOffset, (int)off, (int)indentColumn);
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!editor.getSettings().isIndentGuidesShown()) {
            return;
        }
        if (FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(highlighter) == null) {
            super.paint(editor, highlighter, g);
            return;
        }
        FrontendIndentGuideRenderResultCollector frontendIndentGuideRenderResultCollector = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> FrontendIndentGuideRenderer.x(this, g, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
        this.x(editor, highlighter, frontendIndentGuideRenderResultCollector);
    }

    private final void x(Editor editor, RangeHighlighter rangeHighlighter, FrontendIndentGuideRenderResultCollector frontendIndentGuideRenderResultCollector) {
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(rangeHighlighter);
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        int n3 = rangeHighlighter.getStartOffset();
        Document document = rangeHighlighter.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (n3 >= document2.getTextLength()) {
            return;
        }
        int n4 = rangeHighlighter.getEndOffset();
        int n5 = document2.getLineNumber(n3);
        int n6 = document2.getLineNumber(n4);
        int n7 = editor.logicalPositionToOffset(new LogicalPosition(n5, 0)) + n2;
        int n8 = editor.offsetToVisualPosition((int)n7).column;
        int n9 = editor.offsetToLogicalPosition((int)n7).column;
        Integer n10 = n5;
        for (int j = n5; j < n6; ++j) {
            if (FrontendIndentGuideRendererKt.access$shouldRenderIndentGuideOnLine(editor, j, n9)) {
                Integer n11 = n10;
                if (n11 == null) {
                    n11 = j - 1;
                }
                n10 = n11;
                continue;
            }
            if (n10 == null) continue;
            FrontendIndentGuideRenderer.x(editor, n2, n8, frontendIndentGuideRenderResultCollector, n7, n4, document2, n10, j);
            n10 = null;
        }
        if (n10 == null) {
            return;
        }
        FrontendIndentGuideRenderer.x(editor, n2, n8, frontendIndentGuideRenderResultCollector, n7, n4, document2, n10, n6);
    }

    @TestOnly
    public final void doPaintInTest(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull FrontendIndentGuideRenderResultCollector resultCollector) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)resultCollector, (String)"resultCollector");
        this.x(editor, highlighter, resultCollector);
    }

    private static final void x(FrontendIndentGuideRenderer frontendIndentGuideRenderer, Graphics graphics, Editor editor, VisualPosition visualPosition, VisualPosition visualPosition2, int n, int n2, Document document) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editorParam");
        Intrinsics.checkNotNullParameter((Object)visualPosition, (String)"currentPartStartVisualPosition");
        Intrinsics.checkNotNullParameter((Object)visualPosition2, (String)"currentPartEndVisualPosition");
        Intrinsics.checkNotNullParameter((Object)document, (String)"doc");
        frontendIndentGuideRenderer.paint(editor, visualPosition, visualPosition2, n, n2, document, graphics);
    }

    private static final void x(Editor editor, int n, int n2, FrontendIndentGuideRenderResultCollector frontendIndentGuideRenderResultCollector, int n3, int n4, Document document, int n5, int n6) {
        int n7 = editor.logicalPositionToOffset(new LogicalPosition(n5, 0)) + n;
        VisualPosition visualPosition = new VisualPosition(editor.offsetToVisualPosition((int)n7).line, n2);
        int n8 = editor.logicalPositionToOffset(new LogicalPosition(n6, 0)) + n;
        VisualPosition visualPosition2 = new VisualPosition(editor.offsetToVisualPosition((int)n8).line, n2);
        frontendIndentGuideRenderResultCollector.collect(editor, visualPosition, visualPosition2, n3, n4, document);
    }
}

