/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.gutterMarks;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.ide.model.highlighterRegistration.IdeaTextAttributes;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.model.GutterMarkActionModel;
import com.jetbrains.rd.ide.model.GutterMarkDnDModel;
import com.jetbrains.rd.ide.model.GutterMarkHighlighterModel;
import com.jetbrains.rd.ide.model.GutterMarkHoverModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rd.platform.daemon.TextAttributesUtilKt;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.FrontendGutterMarkModelHandlerKt;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendTooltipProvider;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/FrontendGutterMarkModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "gutterMarkActionModel", "Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;", "gutterMarkHoverModel", "Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;", "tooltipProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;", "dndModel", "Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;", "FrontendGutterMarkModelHandler", "(Lcom/jetbrains/rd/ide/model/GutterMarkActionModel;Lcom/jetbrains/rd/ide/model/GutterMarkHoverModel;Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendTooltipProvider;Lcom/jetbrains/rd/ide/model/GutterMarkDnDModel;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
public final class FrontendGutterMarkModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final GutterMarkActionModel gutterMarkActionModel;
    @NotNull
    private final GutterMarkHoverModel gutterMarkHoverModel;
    @NotNull
    private final FrontendTooltipProvider tooltipProvider;
    @NotNull
    private final GutterMarkDnDModel dndModel;

    public FrontendGutterMarkModelHandler(@NotNull GutterMarkActionModel gutterMarkActionModel, @NotNull GutterMarkHoverModel gutterMarkHoverModel, @NotNull FrontendTooltipProvider tooltipProvider, @NotNull GutterMarkDnDModel dndModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)gutterMarkActionModel), (String)"gutterMarkActionModel");
        Intrinsics.checkNotNullParameter((Object)((Object)gutterMarkHoverModel), (String)"gutterMarkHoverModel");
        Intrinsics.checkNotNullParameter((Object)tooltipProvider, (String)"tooltipProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)dndModel), (String)"dndModel");
        this.gutterMarkActionModel = gutterMarkActionModel;
        this.gutterMarkHoverModel = gutterMarkHoverModel;
        this.tooltipProvider = tooltipProvider;
        this.dndModel = dndModel;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return model2 instanceof GutterMarkHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        GutterMarkHighlighterModel cfr_ignored_0 = (GutterMarkHighlighterModel)model2;
        TextAttributesKeyModel textAttributesKeyModel = model2.getTextAttributesKey();
        if (textAttributesKeyModel != null) {
            TextAttributesKeyModel textAttributesKeyModel2 = textAttributesKeyModel;
            boolean bl = false;
            TextAttributesKey textAttributesKey = TextAttributesRegistrationHost.Companion.getInstance().getTextAttributesKey(textAttributesKeyModel2);
            highlighter.setTextAttributesKey(textAttributesKey);
        }
        IdeaTextAttributes ideaTextAttributes = ((GutterMarkHighlighterModel)model2).getTextAttributes();
        if (model2.getTextAttributesKey() == null && ideaTextAttributes != null) {
            RangeHighlighterEx rangeHighlighterEx = highlighter instanceof RangeHighlighterEx ? (RangeHighlighterEx)highlighter : null;
            if (rangeHighlighterEx != null) {
                rangeHighlighterEx.setTextAttributes(TextAttributesUtilKt.toTextAttributes(ideaTextAttributes));
            }
        }
        highlighter.setGutterIconRenderer(FrontendGutterMarkModelHandlerKt.createRenderer(((GutterMarkHighlighterModel)model2).getGutterMarkRenderer(), model2.getId(), highlighter, this.gutterMarkActionModel, this.gutterMarkHoverModel, this.tooltipProvider, this.dndModel));
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        GutterMarkHighlighterModel cfr_ignored_0 = (GutterMarkHighlighterModel)model2;
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model2, highlighter);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        GutterMarkHighlighterModel gutterMarkHighlighterModel = (GutterMarkHighlighterModel)model2;
        boolean bl = false;
        return new GutterMarkHighlighterModel(gutterMarkHighlighterModel.getGutterMarkRenderer(), gutterMarkHighlighterModel.getTextAttributes(), gutterMarkHighlighterModel.getLayer(), gutterMarkHighlighterModel.isExactRange(), gutterMarkHighlighterModel.getDocumentVersion(), gutterMarkHighlighterModel.isGreedyToLeft(), gutterMarkHighlighterModel.isGreedyToRight(), gutterMarkHighlighterModel.isThinErrorStripeMark(), gutterMarkHighlighterModel.getTextToHighlight(), gutterMarkHighlighterModel.getTextAttributesKey(), gutterMarkHighlighterModel.getId(), gutterMarkHighlighterModel.getProperties(), startOffset, endOffset);
    }
}

