/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.foldings;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.FoldingKeys;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.zombie.CodeFoldingZombieUtils;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.util.SmartList;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfo;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfoKt;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingRestoreRecord;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendCodeFoldingModelSupportKt;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0016\u0018\u0000 a2\u00020\u0001:\u0001aB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012 \u0010\u0007\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tj\u0002`\u000b0\bj\u0002`\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J \u00101\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u000206H\u0002J\u0016\u00107\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0002J\u0014\u00108\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002090/J\b\u0010:\u001a\u00020\u0006H\u0014J&\u0010;\u001a\b\u0012\u0004\u0012\u00020<0/2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010=\u001a\u00020\nH\u0014J8\u0010>\u001a\u00020-2\u0006\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020\n2\u001e\u0010@\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060B0AH\u0002J\u0016\u0010C\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002090DH\u0014J\u0018\u0010E\u001a\u00020\u00062\u0006\u0010F\u001a\u0002092\u0006\u0010=\u001a\u00020\nH\u0014J\u0016\u0010G\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002090/H\u0014J\u001e\u0010H\u001a\u00020-2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020<0/2\u0006\u0010J\u001a\u00020\u0006H\u0002J,\u0010K\u001a\u001e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060Lj\u0002`M2\u0006\u0010N\u001a\u00020\u0006H\u0002J>\u0010O\u001a\u00020-2\u0006\u0010P\u001a\u0002032\u0006\u0010Q\u001a\u0002032\u0006\u0010=\u001a\u00020\n2\u0006\u0010J\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u00062\f\u0010I\u001a\b\u0012\u0004\u0012\u00020<0/H\u0002J\u0018\u0010S\u001a\u00020\u00062\u0006\u0010P\u001a\u0002032\u0006\u0010Q\u001a\u000203H\u0002J\u0016\u0010T\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u000e\u0010U\u001a\u00020-2\u0006\u0010V\u001a\u000200J\u0010\u0010W\u001a\u00020-2\u0006\u0010V\u001a\u000200H\u0002J\u0018\u0010X\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020<2\u0006\u0010=\u001a\u00020\nH\u0014J4\u0010Z\u001a\u0004\u0018\u00010<2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010=\u001a\u00020\n2\u0006\u0010[\u001a\u00020\u00062\b\b\u0002\u0010\\\u001a\u00020\u0006H\u0014J\"\u0010]\u001a\u0004\u0018\u00010<2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010^\u001a\u00020\nH\u0014J\u0018\u0010_\u001a\u00020-2\u0006\u0010=\u001a\u00020\n2\u0006\u0010`\u001a\u00020<H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R+\u0010\u0007\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tj\u0002`\u000b0\bj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010%\u001a\u00070&\u00a2\u0006\u0002\b'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0016R\u000e\u0010)\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "riderBackendFoldingInitializationInProgress", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "isExpandedCallbackFactory", "Lkotlin/Function0;", "Lkotlin/Function1;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingInfo;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingExpandedCallback;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingExpandedCallbackFactory;", "FrontendEditorFoldingModelAdapter", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/util/reactive/IOptProperty;Lkotlin/jvm/functions/Function0;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getRiderBackendFoldingInitializationInProgress", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "()Lkotlin/jvm/functions/Function0;", "applyIsExpandedUpdatesFromBackend", "getApplyIsExpandedUpdatesFromBackend", "()Z", "uiRegionDebugging", "groups", "", "", "Lcom/intellij/openapi/editor/FoldingGroup;", "getGroups", "()Ljava/util/Map;", "foldingModel", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "getFoldingModel", "()Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "foldingManager", "Lkotlin/Lazy;", "Lcom/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl;", "frontendEditorFoldingInfo", "Lcom/intellij/codeInsight/folding/impl/EditorFoldingInfo;", "Lorg/jetbrains/annotations/NotNull;", "isFoldingInitializationCompleted", "frontendFoldingInitializationCompleted", "lock", "", "afterBulkAdd", "", "highlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "x", "start", "", "end", "attr", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "x", "updateCollapsedStates", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "isUserFoldRegionsSupported", "getExistingFoldRegionsAtRange", "Lcom/intellij/openapi/editor/FoldRegion;", "foldingInfo", "x", "existingFoldRegion", "mergeResult", "Lcom/intellij/openapi/util/Ref;", "Lkotlin/Triple;", "addFoldings", "", "isCustomFoldRegion", "rangeHighlighter", "initFoldings", "x", "existingFoldRegionsAtRange", "defaultExpansion", "x", "Lkotlin/Function3;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/RestoreFoldingExpandedCallback;", "foldingInitializationForOpenedEditor", "x", "startOffset", "endOffset", "mandatoryExpansion", "x", "beforeBulkRemove", "afterUpdated", "highlighter", "x", "canBeReused", "oldRegion", "createNewRegionOrIgnore", "isExpanded", "canBeRemovedWhenCollapsed", "createFoldRegion", "info", "x", "existingRegion", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendEditorFoldingModelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorFoldingModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,475:1\n774#2:476\n865#2,2:477\n2746#2,3:479\n230#2,2:501\n774#2:505\n865#2,2:506\n295#2,2:509\n1#3:482\n382#4,7:483\n382#4,7:490\n67#5,4:497\n67#5,2:503\n70#5:508\n67#5,4:511\n13#5:515\n*S KotlinDebug\n*F\n+ 1 FrontendEditorFoldingModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter\n*L\n115#1:476\n115#1:477,2\n364#1:479,3\n158#1:501,2\n366#1:505\n366#1:506,2\n371#1:509,2\n433#1:483,7\n458#1:490,7\n119#1:497,4\n366#1:503,2\n366#1:508\n410#1:511,4\n62#1:515\n*E\n"})
public class FrontendEditorFoldingModelAdapter
implements FrontendMarkupAdapterListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final IOptProperty<Boolean> riderBackendFoldingInitializationInProgress;
    @NotNull
    private final Function0<Function1<FoldingInfo, Boolean>> isExpandedCallbackFactory;
    private final boolean applyIsExpandedUpdatesFromBackend;
    private final boolean uiRegionDebugging;
    @NotNull
    private final Map<Long, FoldingGroup> groups;
    @NotNull
    private final FoldingModelImpl foldingModel;
    @NotNull
    private final Lazy<CodeFoldingManagerImpl> foldingManager;
    @NotNull
    private final EditorFoldingInfo frontendEditorFoldingInfo;
    private boolean frontendFoldingInitializationCompleted;
    @NotNull
    private final Object lock;
    @NotNull
    private static final Key<Boolean> RESTORE_FOLDING_STATE;
    @NotNull
    private static final Map<FoldingRestoreRecord, Boolean> foldingRestoreRecords;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final TextAttributes redFromBackend;
    @NotNull
    private static final TextAttributes greenMergedWithExisting;
    @NotNull
    private static final TextAttributes blueMergedWithCreatedByFrontend;
    @NotNull
    private static final TextAttributes cyanExoticStateFromFrontend;

    public FrontendEditorFoldingModelAdapter(@NotNull Editor editor, @NotNull IOptProperty<Boolean> riderBackendFoldingInitializationInProgress, @NotNull Function0<? extends Function1<? super FoldingInfo, Boolean>> isExpandedCallbackFactory) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(riderBackendFoldingInitializationInProgress, (String)"riderBackendFoldingInitializationInProgress");
        Intrinsics.checkNotNullParameter(isExpandedCallbackFactory, (String)"isExpandedCallbackFactory");
        this.editor = editor;
        this.riderBackendFoldingInitializationInProgress = riderBackendFoldingInitializationInProgress;
        this.isExpandedCallbackFactory = isExpandedCallbackFactory;
        this.applyIsExpandedUpdatesFromBackend = true;
        this.uiRegionDebugging = Registry.Companion.is("rdclient.fold.debug.ui.enabled", false);
        this.groups = new LinkedHashMap();
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
        this.foldingModel = (FoldingModelImpl)foldingModel;
        this.foldingManager = LazyKt.lazy(() -> FrontendEditorFoldingModelAdapter.x(this));
        EditorFoldingInfo editorFoldingInfo = EditorFoldingInfo.get((Editor)this.editor);
        Intrinsics.checkNotNullExpressionValue((Object)editorFoldingInfo, (String)"get(...)");
        this.frontendEditorFoldingInfo = editorFoldingInfo;
        this.lock = new Object();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final IOptProperty<Boolean> getRiderBackendFoldingInitializationInProgress() {
        return this.riderBackendFoldingInitializationInProgress;
    }

    @NotNull
    public final Function0<Function1<FoldingInfo, Boolean>> isExpandedCallbackFactory() {
        return this.isExpandedCallbackFactory;
    }

    protected boolean getApplyIsExpandedUpdatesFromBackend() {
        return this.applyIsExpandedUpdatesFromBackend;
    }

    @NotNull
    protected final Map<Long, FoldingGroup> getGroups() {
        return this.groups;
    }

    @NotNull
    protected final FoldingModelImpl getFoldingModel() {
        return this.foldingModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFoldingInitializationCompleted() {
        if (this.frontendFoldingInitializationCompleted) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.frontendFoldingInitializationCompleted;
            return bl2;
        }
    }

    @Override
    public final void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        LocalChangeKt.ignoreOnReentrancy(FrontendCodeFoldingModelSupportKt.getFoldingStateChangeFromBackend(), (Function0<Unit>)((Function0)() -> FrontendEditorFoldingModelAdapter.x(this, highlighters)));
    }

    private final void x(int n, int n2, TextAttributes textAttributes) {
        if (this.uiRegionDebugging) {
            this.editor.getMarkupModel().addRangeHighlighter(n, n2, 6000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private final void x(List<? extends RangeHighlighterEx> list2) {
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t : iterable2) {
            RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
            boolean bl3 = false;
            if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)rangeHighlighterEx)) continue;
            collection.add(t);
        }
        List list3 = (List)collection;
        if (list3.isEmpty()) {
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.x(this, list3, list2));
    }

    public final void updateCollapsedStates(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Function3<Integer, Integer, FoldingInfo, Boolean> function3 = this.x(true);
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.x(highlighters, function3, this));
    }

    protected boolean isUserFoldRegionsSupported() {
        return false;
    }

    @NotNull
    protected List<FoldRegion> getExistingFoldRegionsAtRange(int start, int end, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        FoldRegion foldRegion = this.foldingModel.getFoldRegion(start, end);
        return foldRegion == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)foldRegion);
    }

    private final void x(FoldRegion foldRegion, FoldingInfo foldingInfo, Ref<Triple<FoldRegion, Boolean, Boolean>> ref) {
        boolean bl = true;
        boolean bl2 = foldRegion.isExpanded();
        if (CodeFoldingManagerImpl.isFrontendCreated((FoldRegion)foldRegion)) {
            this.frontendEditorFoldingInfo.removeRegion(foldRegion);
            bl = false;
        }
        if (ref.isNull() && this.canBeReused(foldRegion, foldingInfo)) {
            if (bl) {
                this.x(foldingInfo, foldRegion);
                ((CodeFoldingManagerImpl)this.foldingManager.getValue()).markUpdated(foldRegion);
                ref.set((Object)new Triple((Object)foldRegion, (Object)bl2, (Object)true));
                return;
            }
            ref.set((Object)new Triple((Object)foldRegion, (Object)bl2, (Object)false));
        }
        this.foldingModel.removeFoldRegion(foldRegion);
    }

    protected void addFoldings(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Map map = CodeFoldingManagerImpl.getAsyncExpandStatusMap((Editor)this.editor);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map map2 = map;
        Function3<Integer, Integer, FoldingInfo, Boolean> function3 = this.x(false);
        for (RangeHighlighter rangeHighlighter : highlighters) {
            FoldingInfo foldingInfo;
            if (FoldingInfoKt.getFoldingInfo(rangeHighlighter) == null || this.isCustomFoldRegion(rangeHighlighter, foldingInfo)) continue;
            Boolean bl = (Boolean)map2.get(TextRange.create((Segment)((Segment)rangeHighlighter)));
            boolean bl2 = bl != null ? bl.booleanValue() : ((Boolean)function3.invoke((Object)rangeHighlighter.getStartOffset(), (Object)rangeHighlighter.getEndOffset(), (Object)foldingInfo)).booleanValue();
            this.x(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo, bl2, false, this.getExistingFoldRegionsAtRange(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo));
            if (!this.uiRegionDebugging || !map2.containsKey(TextRange.create((Segment)((Segment)rangeHighlighter)))) continue;
            this.x(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), cyanExoticStateFromFrontend);
        }
    }

    protected boolean isCustomFoldRegion(@NotNull RangeHighlighter rangeHighlighter, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"rangeHighlighter");
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        return false;
    }

    protected void initFoldings(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Function3<Integer, Integer, FoldingInfo, Boolean> function3 = this.x(true);
        for (RangeHighlighter rangeHighlighter : highlighters) {
            FoldingInfo foldingInfo;
            if (FoldingInfoKt.getFoldingInfo(rangeHighlighter) == null) continue;
            boolean bl = (Boolean)function3.invoke((Object)rangeHighlighter.getStartOffset(), (Object)rangeHighlighter.getEndOffset(), (Object)foldingInfo);
            List<FoldRegion> list2 = this.getExistingFoldRegionsAtRange(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo);
            this.x(list2, bl);
            this.x(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo, bl, this.x(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset()), list2);
        }
        CodeFoldingZombieUtils.INSTANCE.postponeAndScheduleCleanupZombieRegions(this.editor);
    }

    private final void x(List<? extends FoldRegion> list2, boolean bl) {
        for (FoldRegion foldRegion : list2) {
            Boolean bl2 = CodeFoldingManagerImpl.getCollapsedByDef((FoldRegion)foldRegion);
            if (bl2 == null || Intrinsics.areEqual((Object)foldRegion.isExpanded(), (Object)bl2) || foldRegion.isExpanded() == bl) continue;
            foldRegion.setExpanded(bl);
        }
    }

    private final Function3<Integer, Integer, FoldingInfo, Boolean> x(boolean bl) {
        Function1 function1 = (Function1)this.isExpandedCallbackFactory.invoke();
        if (bl) {
            return (arg_0, arg_1, arg_2) -> FrontendEditorFoldingModelAdapter.x(function1, arg_0, arg_1, arg_2);
        }
        if (Companion.isReloadingState(this.editor)) {
            return (arg_0, arg_1, arg_2) -> FrontendEditorFoldingModelAdapter.x(this, function1, arg_0, arg_1, arg_2);
        }
        return (arg_0, arg_1, arg_2) -> FrontendEditorFoldingModelAdapter.G(function1, arg_0, arg_1, arg_2);
    }

    private final void x(int n, int n2, FoldingInfo foldingInfo, boolean bl, boolean bl2, List<? extends FoldRegion> list2) {
        Ref ref = new Ref();
        for (FoldRegion foldRegion2 : list2) {
            this.x(foldRegion2, foldingInfo, (Ref<Triple<FoldRegion, Boolean, Boolean>>)ref);
        }
        FoldRegion foldRegion = null;
        if (ref.isNull()) {
            this.x(n, n2, redFromBackend);
            foldRegion = FrontendEditorFoldingModelAdapter.createNewRegionOrIgnore$default(this, n, n2, foldingInfo, bl || bl2, false, 16, null);
        } else {
            Triple triple = (Triple)ref.get();
            FoldRegion foldRegion2 = (FoldRegion)triple.component1();
            boolean bl3 = (Boolean)triple.component2();
            boolean bl4 = (Boolean)triple.component3();
            if (bl4) {
                FoldingKeys.ZOMBIE_REGION_KEY.set((UserDataHolder)foldRegion2, null);
                this.x(foldRegion2.getStartOffset(), foldRegion2.getEndOffset(), greenMergedWithExisting);
                foldRegion = foldRegion2;
            } else {
                this.x(foldRegion2.getStartOffset(), foldRegion2.getEndOffset(), blueMergedWithCreatedByFrontend);
                foldRegion = this.createNewRegionOrIgnore(foldRegion2.getStartOffset(), foldRegion2.getEndOffset(), foldingInfo, bl3 || bl2, CodeFoldingManagerImpl.canBeRemovedWhenCollapsed((FoldRegion)foldRegion2));
            }
        }
        if (foldRegion != null) {
            if (bl2 && !foldRegion.isExpanded()) {
                this.x(n, n2, cyanExoticStateFromFrontend);
                foldRegion.setExpanded(true);
            }
            foldingInfo.getRegions().add((Object)foldRegion);
        }
    }

    private final boolean x(int n, int n2) {
        for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
            int n3 = caret.getOffset();
            if (n3 == 0) continue;
            boolean bl = n + 1 <= n3 ? n3 < n2 : false;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
            Iterable iterable = highlighters;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t : iterable) {
                    RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
                    boolean bl3 = false;
                    if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)rangeHighlighterEx)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.x(this, highlighters));
    }

    @Override
    public final void afterUpdated(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        LocalChangeKt.ignoreOnReentrancy(FrontendCodeFoldingModelSupportKt.getFoldingStateChangeFromBackend(), (Function0<Unit>)((Function0)() -> FrontendEditorFoldingModelAdapter.x(this, highlighter)));
    }

    private final void x(RangeHighlighterEx rangeHighlighterEx) {
        Object v1;
        SmartList<FoldRegion> smartList;
        FoldingInfo foldingInfo;
        block5: {
            FoldingInfo foldingInfo2 = FoldingInfoKt.getFoldingInfo((RangeHighlighter)rangeHighlighterEx);
            if (foldingInfo2 == null) {
                return;
            }
            foldingInfo = foldingInfo2;
            smartList = foldingInfo.getRegions();
            Iterable iterable = (Iterable)smartList;
            for (Object t : iterable) {
                FoldRegion foldRegion = (FoldRegion)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)foldRegion.getEditor(), (Object)this.editor)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        FoldRegion foldRegion = v1;
        if (foldRegion == null) {
            return;
        }
        FoldRegion foldRegion2 = foldRegion;
        if (this.canBeReused(foldRegion2, foldingInfo)) {
            if (this.getApplyIsExpandedUpdatesFromBackend() && foldRegion2.isExpanded() == foldingInfo.getCollapsedByDefault()) {
                this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.x(foldRegion2, foldingInfo));
            }
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.x(foldRegion2, smartList, this, rangeHighlighterEx, foldingInfo));
    }

    protected boolean canBeReused(@NotNull FoldRegion oldRegion, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)oldRegion, (String)"oldRegion");
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        if (!Intrinsics.areEqual((Object)oldRegion.getPlaceholderText(), (Object)foldingInfo.getPlaceholderText())) {
            return false;
        }
        FoldingGroup foldingGroup = oldRegion.getGroup();
        Long l = foldingInfo.getGroupId();
        if (foldingGroup != null && l != null) {
            FoldingGroup foldingGroup2;
            FoldingGroup foldingGroup3 = foldingGroup;
            Map<Long, FoldingGroup> map = this.groups;
            Long l2 = l;
            boolean bl = false;
            FoldingGroup foldingGroup4 = map.get(l2);
            if (foldingGroup4 == null) {
                FoldingGroup foldingGroup5 = foldingGroup3;
                boolean bl2 = false;
                foldingGroup3 = foldingGroup5;
                FoldingGroup foldingGroup6 = foldingGroup;
                map.put(l2, foldingGroup6);
                foldingGroup2 = foldingGroup6;
            } else {
                foldingGroup2 = foldingGroup4;
            }
            return Intrinsics.areEqual((Object)foldingGroup3, (Object)foldingGroup2);
        }
        if (oldRegion.shouldNeverExpand() != foldingInfo.getNeverExpands()) {
            return false;
        }
        return foldingGroup == null && l == null;
    }

    @Nullable
    protected FoldRegion createNewRegionOrIgnore(int start, int end, @NotNull FoldingInfo foldingInfo, boolean isExpanded, boolean canBeRemovedWhenCollapsed) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        FoldRegion foldRegion = this.createFoldRegion(start, end, foldingInfo);
        if (foldRegion == null) {
            logger.warn("Unable to insert (" + start + ", " + end + ") in the folding tree. Maybe the duplicate range already/still exist.");
            return null;
        }
        foldRegion.setExpanded(isExpanded && !foldingInfo.getNeverExpands());
        if (canBeRemovedWhenCollapsed) {
            CodeFoldingManagerImpl.markAsCanBeRemovedWhenCollapsed((FoldRegion)foldRegion);
        }
        return foldRegion;
    }

    public static /* synthetic */ FoldRegion createNewRegionOrIgnore$default(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, int n, int n2, FoldingInfo foldingInfo, boolean bl, boolean bl2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createNewRegionOrIgnore");
        }
        if ((n3 & 0x10) != 0) {
            bl2 = false;
        }
        return frontendEditorFoldingModelAdapter.createNewRegionOrIgnore(n, n2, foldingInfo, bl, bl2);
    }

    @Nullable
    protected FoldRegion createFoldRegion(int start, int end, @NotNull FoldingInfo info) {
        FoldRegion foldRegion;
        block4: {
            FoldingGroup foldingGroup;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Long l = info.getGroupId();
            if (l != null) {
                FoldingGroup foldingGroup2;
                long l2 = ((Number)l).longValue();
                boolean bl = false;
                Map<Long, FoldingGroup> map = this.groups;
                Long l3 = l2;
                boolean bl2 = false;
                FoldingGroup foldingGroup3 = map.get(l3);
                if (foldingGroup3 == null) {
                    boolean bl3 = false;
                    FoldingGroup foldingGroup4 = FoldingGroup.newGroup((String)String.valueOf(l2));
                    Intrinsics.checkNotNullExpressionValue((Object)foldingGroup4, (String)"newGroup(...)");
                    FoldingGroup foldingGroup5 = foldingGroup4;
                    map.put(l3, foldingGroup5);
                    foldingGroup2 = foldingGroup5;
                } else {
                    foldingGroup2 = foldingGroup3;
                }
                foldingGroup = foldingGroup2;
            } else {
                foldingGroup = null;
            }
            FoldingGroup foldingGroup6 = foldingGroup;
            FoldRegion foldRegion2 = foldRegion = this.foldingModel.createFoldRegion(start, end, info.getPlaceholderText(), foldingGroup6, info.getNeverExpands());
            if (foldRegion2 == null) break block4;
            FoldRegion foldRegion3 = foldRegion2;
            boolean bl = false;
            this.x(info, foldRegion);
        }
        return foldRegion;
    }

    private final void x(FoldingInfo foldingInfo, FoldRegion foldRegion) {
        if (FoldingInfoKt.isDocComment(foldingInfo)) {
            FoldingInfoKt.markAsDocComment(foldRegion);
        }
        if (FoldingInfoKt.isDefinition(foldingInfo)) {
            FoldingInfoKt.markAsDefinition(foldRegion);
        }
        if (FoldingInfoKt.isCodeBlock(foldingInfo)) {
            FoldingInfoKt.markAsCodeBlock(foldRegion);
        }
        CodeFoldingManagerImpl.setCollapsedByDef((FoldRegion)foldRegion, (boolean)foldingInfo.getCollapsedByDefault());
        CodeFoldingManagerImpl.markAsAutoCreated((FoldRegion)foldRegion);
    }

    private static final CodeFoldingManagerImpl x(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter) {
        CodeFoldingManager codeFoldingManager = CodeFoldingManager.getInstance((Project)frontendEditorFoldingModelAdapter.editor.getProject());
        Intrinsics.checkNotNull((Object)codeFoldingManager, (String)"null cannot be cast to non-null type com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl");
        return (CodeFoldingManagerImpl)codeFoldingManager;
    }

    private static final Unit x(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, List list2) {
        frontendEditorFoldingModelAdapter.x(list2);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void x(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, List list2, List list3) {
        boolean bl;
        Logger logger = FrontendEditorFoldingModelAdapter.logger;
        boolean bl2 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            bl = false;
            logger2.trace("doAfterBulkAdd (runBatchFoldingOperation): allHighlighters=" + list3.size() + ", foldings=" + list2.size());
        }
        if (frontendEditorFoldingModelAdapter.frontendFoldingInitializationCompleted) {
            Companion.setFoldingInitializationInProgress(frontendEditorFoldingModelAdapter.editor, Companion.isReloadingState(frontendEditorFoldingModelAdapter.editor));
            if (((Boolean)InterfacesKt.valueOrDefault(frontendEditorFoldingModelAdapter.riderBackendFoldingInitializationInProgress, (Object)false)).booleanValue()) {
                frontendEditorFoldingModelAdapter.initFoldings(list2);
            } else {
                try {
                    frontendEditorFoldingModelAdapter.addFoldings(list2);
                }
                finally {
                    Companion.setReloadingState(frontendEditorFoldingModelAdapter.editor, false);
                    CodeFoldingManagerImpl.setAsyncExpandStatusMap((Editor)frontendEditorFoldingModelAdapter.editor, null);
                }
            }
        } else {
            Object object = frontendEditorFoldingModelAdapter.lock;
            synchronized (object) {
                bl = false;
                try {
                    CodeFoldingManagerImpl.markAsAsyncFoldingUpdater((Editor)frontendEditorFoldingModelAdapter.editor);
                    Companion.setFoldingInitializationInProgress(frontendEditorFoldingModelAdapter.editor, true);
                    frontendEditorFoldingModelAdapter.initFoldings(list2);
                    CodeFoldingZombieUtils.INSTANCE.getZombieRegions(frontendEditorFoldingModelAdapter.editor, true, FrontendEditorFoldingModelAdapter::x);
                }
                finally {
                    frontendEditorFoldingModelAdapter.frontendFoldingInitializationCompleted = true;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private static final boolean x(FoldRegion foldRegion) {
        Intrinsics.checkNotNullParameter((Object)foldRegion, (String)"it");
        return foldRegion.shouldNeverExpand();
    }

    private static final void x(List list2, Function3 function3, FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter) {
        for (RangeHighlighter rangeHighlighter : list2) {
            Object t2;
            FoldingInfo foldingInfo;
            block2: {
                Intrinsics.checkNotNull((Object)FoldingInfoKt.getFoldingInfo(rangeHighlighter));
                Iterable iterable = (Iterable)foldingInfo.getRegions();
                boolean bl = false;
                for (Object t2 : iterable) {
                    FoldRegion foldRegion = (FoldRegion)t2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)foldRegion.getEditor(), (Object)frontendEditorFoldingModelAdapter.editor)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            FoldRegion foldRegion = (FoldRegion)t2;
            foldRegion.setExpanded(((Boolean)function3.invoke((Object)rangeHighlighter.getStartOffset(), (Object)rangeHighlighter.getEndOffset(), (Object)foldingInfo)).booleanValue());
        }
    }

    private static final boolean x(Function1 function1, int n, int n2, FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        return (Boolean)function1.invoke((Object)foldingInfo);
    }

    private static final boolean x(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, Function1 function1, int n, int n2, FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        frontendEditorFoldingModelAdapter.x(n, n2, cyanExoticStateFromFrontend);
        boolean bl = (Boolean)function1.invoke((Object)foldingInfo);
        Boolean bl2 = foldingRestoreRecords.get(new FoldingRestoreRecord(n, n2, foldingInfo.getAttributeId(), foldingInfo.getPlaceholderText()));
        return bl2 != null ? bl2 : bl;
    }

    private static final boolean G(Function1 function1, int n, int n2, FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        function1.invoke((Object)foldingInfo);
        return true;
    }

    private static final void x(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, List list2) {
        boolean bl;
        RangeHighlighterEx rangeHighlighterEx;
        boolean bl2;
        Object object;
        Iterable iterable;
        Iterable iterable2;
        Logger logger = FrontendEditorFoldingModelAdapter.logger;
        boolean bl3 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl4 = false;
            iterable2 = list2;
            int n = list2.size();
            boolean bl5 = false;
            iterable = iterable2;
            object = new ArrayList();
            bl2 = false;
            for (Object object2 : iterable) {
                rangeHighlighterEx = (RangeHighlighterEx)object2;
                bl = false;
                if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)rangeHighlighterEx)) continue;
                object.add(object2);
            }
            List list3 = (List)object;
            logger2.trace("beforeBulkRemove (runBatchFoldingOperation): allHighlighters=" + n + ", foldings=" + list3.size());
        }
        boolean bl6 = Companion.isReloadingState(frontendEditorFoldingModelAdapter.editor);
        for (RangeHighlighterEx rangeHighlighterEx2 : list2) {
            FoldRegion foldRegion;
            Object v0;
            SmartList<FoldRegion> smartList;
            block6: {
                if (FoldingInfoKt.getFoldingInfo((RangeHighlighter)rangeHighlighterEx2) == null) continue;
                smartList = ((FoldingInfo)((Object)iterable2)).getRegions();
                object = (Iterable)smartList;
                bl2 = false;
                Iterator<Object> iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Object object2;
                    object2 = iterator2.next();
                    rangeHighlighterEx = (FoldRegion)object2;
                    bl = false;
                    if (!Intrinsics.areEqual((Object)rangeHighlighterEx.getEditor(), (Object)frontendEditorFoldingModelAdapter.editor)) continue;
                    v0 = object2;
                    break block6;
                }
                v0 = null;
            }
            if ((FoldRegion)v0 == null) continue;
            smartList.remove((Object)foldRegion);
            if (!foldRegion.isValid()) continue;
            if (bl6 && foldRegion.isExpanded() == ((FoldingInfo)((Object)iterable2)).getCollapsedByDefault()) {
                foldingRestoreRecords.put(new FoldingRestoreRecord(rangeHighlighterEx2.getStartOffset(), rangeHighlighterEx2.getEndOffset(), ((FoldingInfo)((Object)iterable2)).getAttributeId(), ((FoldingInfo)((Object)iterable2)).getPlaceholderText()), foldRegion.isExpanded());
            }
            if ((iterable = foldRegion.getGroup()) != null && frontendEditorFoldingModelAdapter.foldingModel.getGroupedRegions((FoldingGroup)iterable).size() == 1) {
                object = frontendEditorFoldingModelAdapter.groups;
                Long l = ((FoldingInfo)((Object)iterable2)).getGroupId();
                TypeIntrinsics.asMutableMap((Object)object).remove(l);
            }
            frontendEditorFoldingModelAdapter.foldingModel.removeFoldRegion(foldRegion);
        }
    }

    private static final Unit x(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, RangeHighlighterEx rangeHighlighterEx) {
        frontendEditorFoldingModelAdapter.x(rangeHighlighterEx);
        return Unit.INSTANCE;
    }

    private static final void x(FoldRegion foldRegion, FoldingInfo foldingInfo) {
        foldRegion.setExpanded(!foldingInfo.getCollapsedByDefault());
    }

    private static final void x(FoldRegion foldRegion, SmartList smartList, FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, RangeHighlighterEx rangeHighlighterEx, FoldingInfo foldingInfo) {
        block1: {
            FoldRegion foldRegion2;
            Logger logger = FrontendEditorFoldingModelAdapter.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("doAfterUpdated (runBatchFoldingOperation): a single folding");
            }
            boolean bl3 = foldRegion.isExpanded();
            bl = CodeFoldingManagerImpl.canBeRemovedWhenCollapsed((FoldRegion)foldRegion);
            smartList.remove((Object)foldRegion);
            frontendEditorFoldingModelAdapter.foldingModel.removeFoldRegion(foldRegion);
            FoldRegion foldRegion3 = foldRegion2 = frontendEditorFoldingModelAdapter.createNewRegionOrIgnore(rangeHighlighterEx.getStartOffset(), rangeHighlighterEx.getEndOffset(), foldingInfo, frontendEditorFoldingModelAdapter.getApplyIsExpandedUpdatesFromBackend() ? !foldingInfo.getCollapsedByDefault() : bl3, bl);
            if (foldRegion3 == null) break block1;
            FoldRegion foldRegion4 = foldRegion3;
            boolean bl4 = false;
            smartList.add((Object)foldRegion2);
        }
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        Key key = Key.create((String)"RESTORE_FOLDING_STATE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        RESTORE_FOLDING_STATE = key;
        foldingRestoreRecords = new LinkedHashMap();
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendEditorFoldingModelAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendEditorFoldingModelAdapter.logger = logger;
        redFromBackend = new TextAttributes();
        greenMergedWithExisting = new TextAttributes();
        blueMergedWithCreatedByFrontend = new TextAttributes();
        cyanExoticStateFromFrontend = new TextAttributes();
        redFromBackend.withAdditionalEffect(EffectType.ROUNDED_BOX, (Color)JBColor.RED);
        greenMergedWithExisting.withAdditionalEffect(EffectType.ROUNDED_BOX, (Color)JBColor.GREEN);
        blueMergedWithCreatedByFrontend.withAdditionalEffect(EffectType.ROUNDED_BOX, (Color)JBColor.BLUE);
        cyanExoticStateFromFrontend.withAdditionalEffect(EffectType.WAVE_UNDERSCORE, JBColor.CYAN);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u00020\u00138\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\u001f\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001a\u00a8\u0006!"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter$Companion;", "", "FrontendEditorFoldingModelAdapter$Companion", "()V", "RESTORE_FOLDING_STATE", "Lcom/intellij/openapi/util/Key;", "", "foldingRestoreRecords", "", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingRestoreRecord;", "setFoldingInitializationInProgress", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isInProgress", "setReloadingState", "inReload", "isReloadingState", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "redFromBackend", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getRedFromBackend", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "greenMergedWithExisting", "getGreenMergedWithExisting", "blueMergedWithCreatedByFrontend", "getBlueMergedWithCreatedByFrontend", "cyanExoticStateFromFrontend", "getCyanExoticStateFromFrontend", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final void setFoldingInitializationInProgress(@NotNull Editor editor, boolean isInProgress) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                FoldingModel foldingModel = editor.getFoldingModel();
                FoldingModelImpl foldingModelImpl = foldingModel instanceof FoldingModelImpl ? (FoldingModelImpl)foldingModel : null;
                if (foldingModelImpl == null) break block0;
                foldingModelImpl.onFoldInitializationStatusChanged(isInProgress);
            }
        }

        public final void setReloadingState(@NotNull Editor editor, boolean inReload) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            RESTORE_FOLDING_STATE.set((UserDataHolder)editor, (Object)inReload);
            if (!inReload) {
                foldingRestoreRecords.clear();
            }
        }

        public final boolean isReloadingState(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return Intrinsics.areEqual((Object)RESTORE_FOLDING_STATE.get((UserDataHolder)editor), (Object)true);
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        @NotNull
        public final TextAttributes getRedFromBackend() {
            return redFromBackend;
        }

        @NotNull
        public final TextAttributes getGreenMergedWithExisting() {
            return greenMergedWithExisting;
        }

        @NotNull
        public final TextAttributes getBlueMergedWithCreatedByFrontend() {
            return blueMergedWithCreatedByFrontend;
        }

        @NotNull
        public final TextAttributes getCyanExoticStateFromFrontend() {
            return cyanExoticStateFromFrontend;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

