/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.CompoundHighlighterModelsHandler;
import com.jetbrains.rdclient.daemon.HighlighterStorage;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "Lcom/jetbrains/rdclient/daemon/HighlighterStorage;", "compoundHandler", "Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "ideaMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "RecyclingHighlighterStorage", "(Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;Lcom/intellij/openapi/editor/ex/MarkupModelEx;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "queueDeletion", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "flushNotDeleted", "", "recycle", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nRecyclingHighlighterStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecyclingHighlighterStorage.kt\ncom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,69:1\n1869#2,2:70\n67#3,4:72\n13#3:77\n13#4:76\n*S KotlinDebug\n*F\n+ 1 RecyclingHighlighterStorage.kt\ncom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage\n*L\n44#1:70,2\n63#1:72,4\n23#1:77\n23#1:76\n*E\n"})
public final class RecyclingHighlighterStorage
extends HighlighterStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompoundHighlighterModelsHandler compoundHandler;
    @NotNull
    private final MarkupModelEx ideaMarkup;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<Boolean> queuedForDeletionKey;

    public RecyclingHighlighterStorage(@NotNull CompoundHighlighterModelsHandler compoundHandler, @NotNull MarkupModelEx ideaMarkup, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)compoundHandler, (String)"compoundHandler");
        Intrinsics.checkNotNullParameter((Object)ideaMarkup, (String)"ideaMarkup");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super(lifetime);
        this.compoundHandler = compoundHandler;
        this.ideaMarkup = ideaMarkup;
    }

    @Override
    public void queueDeletion(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        super.queueDeletion(highlighter);
        RecyclingHighlighterStorage.Companion.x((RangeHighlighter)highlighter, true);
    }

    @Override
    @NotNull
    public List<RangeHighlighterEx> flushNotDeleted() {
        List<RangeHighlighterEx> list2 = super.flushNotDeleted();
        Iterable iterable = list2;
        boolean bl = false;
        for (Object t : iterable) {
            RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
            boolean bl2 = false;
            RecyclingHighlighterStorage.Companion.x((RangeHighlighter)rangeHighlighterEx, false);
        }
        return list2;
    }

    @Nullable
    public final RangeHighlighterEx recycle(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        if (this.getQueuedForDeletion().isEmpty()) {
            return null;
        }
        IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler = this.compoundHandler.getHandler(model2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        this.ideaMarkup.processRangeHighlightersOverlappingWith(model2.getStart(), model2.getStart(), arg_0 -> RecyclingHighlighterStorage.x(arg_0 -> RecyclingHighlighterStorage.x(iProtocolHighlighterModelHandler, model2, objectRef, arg_0), arg_0));
        RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)objectRef.element;
        if (rangeHighlighterEx == null) {
            return null;
        }
        RangeHighlighterEx rangeHighlighterEx2 = rangeHighlighterEx;
        Logger logger = RecyclingHighlighterStorage.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Successfully recycled highlighter for " + HighlightersUtilKt.prettyPrint((RangeHighlighter)rangeHighlighterEx2));
        }
        this.getQueuedForDeletion().remove(rangeHighlighterEx2);
        RecyclingHighlighterStorage.Companion.x((RangeHighlighter)rangeHighlighterEx2, false);
        this.addHighlighter(model2.getId(), rangeHighlighterEx2);
        return rangeHighlighterEx2;
    }

    private static final boolean x(IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler, HighlighterModel highlighterModel, Ref.ObjectRef objectRef, RangeHighlighterEx rangeHighlighterEx) {
        Intrinsics.checkNotNull((Object)rangeHighlighterEx);
        if (iProtocolHighlighterModelHandler.compare(highlighterModel, (RangeHighlighter)rangeHighlighterEx) && RecyclingHighlighterStorage.Companion.x((RangeHighlighter)rangeHighlighterEx)) {
            objectRef.element = rangeHighlighterEx;
            return false;
        }
        return true;
    }

    private static final boolean x(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(RecyclingHighlighterStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RecyclingHighlighterStorage.logger = logger;
        queuedForDeletionKey = new Key("FrontendHighlighterStorage.QueuedForDeletion");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u00020\b*\u00020\u000b2\u0006\u0010\t\u001a\u00020\b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage$Companion;", "", "RecyclingHighlighterStorage$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "queuedForDeletionKey", "Lcom/intellij/openapi/util/Key;", "", "value", "x", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Z", "x", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Z)V", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean x(RangeHighlighter rangeHighlighter) {
            Boolean bl = (Boolean)rangeHighlighter.getUserData(queuedForDeletionKey);
            return bl != null ? bl : false;
        }

        private final void x(RangeHighlighter rangeHighlighter, boolean bl) {
            Boolean bl2 = bl ? Boolean.valueOf(true) : null;
            rangeHighlighter.putUserData(queuedForDeletionKey, (Object)bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

