/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.ide.model.highlighterRegistration.IdeaTextAttributesKey;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterExtension;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupSuppressor;
import com.jetbrains.rdclient.daemon.HighlighterRangeRepairer;
import com.jetbrains.rdclient.daemon.MarkupSuppressionKind;
import com.jetbrains.rdclient.daemon.RecyclingHighlighterStorage;
import com.jetbrains.rdclient.daemon.suppressors.ProtocolSuppressableMarkupModel;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 A2\u00020\u0001:\u0002@AB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0016\u0010\"\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020 2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010(2\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0015H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020%H\u0002J\u0016\u00101\u001a\u00020 2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030$H\u0002J\b\u00104\u001a\u00020 H\u0002J\u0016\u00105\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00106\u001a\u000207J\u0016\u00108\u001a\u00020 2\f\u00109\u001a\b\u0012\u0004\u0012\u00020 0:H\u0002J\u001d\u0010;\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>J\b\u0010?\u001a\u000207H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006B"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "markupAdapter", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "highlighterRepairer", "Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;", "storage", "Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "suppressor", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "FrontendMarkupContributor", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getMarkupAdapter", "()Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "getStorage", "()Lcom/jetbrains/rdclient/daemon/RecyclingHighlighterStorage;", "value", "", "isUpdating", "()Z", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "isFlushedFlowMutable", "Lkotlinx/coroutines/flow/MutableStateFlow;", "isFlushedFlow", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "k", "", "G", "k", "added", "", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "x", "highlighterModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "x", "updated", "x", "model", "trackInvalid", "x", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "element", "G", "removed", "", "x", "suppress", "suppressionKind", "Lcom/jetbrains/rdclient/daemon/MarkupSuppressionKind;", "x", "block", "Lkotlin/Function0;", "bind", "protocolMarkup", "Lcom/jetbrains/rdclient/daemon/suppressors/ProtocolSuppressableMarkupModel;", "bind$intellij_rd_client", "isSuppressed", "MergingUpdateTask", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,328:1\n67#2,4:329\n67#2,4:334\n67#2,4:338\n67#2,4:342\n67#2,4:346\n67#2,4:350\n67#2,4:354\n67#2,4:360\n67#2,2:364\n70#2:370\n67#2,4:371\n67#2,4:375\n67#2,4:379\n67#2,4:383\n13#2:387\n1#3:333\n12970#4,2:358\n1563#5:366\n1634#5,3:367\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor\n*L\n155#1:329,4\n70#1:334,4\n87#1:338,4\n99#1:342,4\n104#1:346,4\n109#1:350,4\n232#1:354,4\n261#1:360,4\n265#1:364,2\n265#1:370\n279#1:371,4\n283#1:375,4\n287#1:379,4\n291#1:383,4\n301#1:387\n233#1:358,2\n269#1:366\n269#1:367,3\n*E\n"})
public final class FrontendMarkupContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final FrontendMarkupAdapter markupAdapter;
    @NotNull
    private final HighlighterRangeRepairer highlighterRepairer;
    @NotNull
    private final RecyclingHighlighterStorage storage;
    @NotNull
    private final FrontendMarkupSuppressor suppressor;
    private boolean isUpdating;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;
    @NotNull
    private final MutableStateFlow<Boolean> isFlushedFlowMutable;
    @NotNull
    private final StateFlow<Boolean> isFlushedFlow;
    @NotNull
    private static final Logger logger;

    public FrontendMarkupContributor(@NotNull Lifetime lifetime, @NotNull FrontendMarkupAdapter markupAdapter, @NotNull HighlighterRangeRepairer highlighterRepairer, @NotNull RecyclingHighlighterStorage storage, @NotNull FrontendMarkupSuppressor suppressor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)markupAdapter, (String)"markupAdapter");
        Intrinsics.checkNotNullParameter((Object)highlighterRepairer, (String)"highlighterRepairer");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        this.lifetime = lifetime;
        this.markupAdapter = markupAdapter;
        this.highlighterRepairer = highlighterRepairer;
        this.storage = storage;
        this.suppressor = suppressor;
        this.mergingUpdateQueue = new MergingUpdateQueue("FrontendMarkupContributor.mergingUpdateQueue", 50, true, null, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null), null, false, 96, null);
        this.isFlushedFlowMutable = StateFlowKt.MutableStateFlow((Object)false);
        this.isFlushedFlow = FlowKt.asStateFlow(this.isFlushedFlowMutable);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final FrontendMarkupAdapter getMarkupAdapter() {
        return this.markupAdapter;
    }

    @NotNull
    public final RecyclingHighlighterStorage getStorage() {
        return this.storage;
    }

    public final boolean isUpdating() {
        return this.isUpdating;
    }

    @NotNull
    public final StateFlow<Boolean> isFlushedFlow() {
        return this.isFlushedFlow;
    }

    private final void k() {
        if (this.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE) {
            ModalityState modalityState = ModalityState.current();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
            this.mergingUpdateQueue.queue((Update)new MergingUpdateTask(modalityState));
        }
    }

    private final void G() {
        this.x((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.x(this)));
    }

    private final void k(List<HighlighterElement> list2) {
        this.x((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.G(list2, this)));
    }

    private final boolean x(HighlighterModel highlighterModel) {
        FrontendHighlighterSuppressionHandler frontendHighlighterSuppressionHandler = (FrontendHighlighterSuppressionHandler)FrontendHighlighterSuppressionHandler.Companion.getEP_NAME().findFirstSafe(arg_0 -> FrontendMarkupContributor.x(arg_0 -> FrontendMarkupContributor.x(highlighterModel, this, arg_0), arg_0));
        if (frontendHighlighterSuppressionHandler != null) {
            Logger logger = FrontendMarkupContributor.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Suppressing " + highlighterModel.getClass().getSimpleName() + " highlighter " + HighlightersUtilKt.prettyPrint(highlighterModel) + " by " + frontendHighlighterSuppressionHandler.getClass().getSimpleName());
            }
            return true;
        }
        return false;
    }

    private final void x(List<HighlighterElement> list2) {
        this.x((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.k(list2, this)));
    }

    private final HighlighterModel x(HighlighterModel highlighterModel, boolean bl) {
        HighlighterModel highlighterModel2 = this.highlighterRepairer.repair(highlighterModel);
        if (highlighterModel2 != null) {
            HighlighterModel highlighterModel3 = highlighterModel2;
            boolean bl2 = false;
            return highlighterModel3;
        }
        if (bl) {
            this.storage.addInvalidHighlighter(highlighterModel);
        }
        return null;
    }

    private final RangeHighlighterEx x(HighlighterElement highlighterElement) {
        RangeHighlighterEx rangeHighlighterEx = this.storage.recycle(highlighterElement.getHighlighter());
        if (rangeHighlighterEx != null) {
            this.markupAdapter.updateHighlighter(rangeHighlighterEx, highlighterElement);
        }
        return rangeHighlighterEx;
    }

    private final void G(List<Long> list2) {
        this.x((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.x(list2, this)));
    }

    private final void x() {
        this.x((Function0<Unit>)((Function0)() -> FrontendMarkupContributor.k(this)));
    }

    public final void suppress(@NotNull Lifetime lifetime, @NotNull MarkupSuppressionKind suppressionKind) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)suppressionKind), (String)"suppressionKind");
        this.suppressor.suppress(lifetime, suppressionKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void x(Function0<Unit> function0) {
        try {
            this.isUpdating = true;
            this.isFlushedFlowMutable.setValue((Object)false);
            function0.invoke();
        }
        finally {
            this.isUpdating = false;
            this.isFlushedFlowMutable.setValue((Object)this.storage.isFlushed());
        }
    }

    public final void bind$intellij_rd_client(@NotNull Lifetime lifetime, @NotNull ProtocolSuppressableMarkupModel protocolMarkup) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)protocolMarkup, (String)"protocolMarkup");
        protocolMarkup.getHighlightersRemoved().advise(lifetime, arg_0 -> FrontendMarkupContributor.k(this, arg_0));
        protocolMarkup.getHighlightersAdded().advise(lifetime, arg_0 -> FrontendMarkupContributor.G(this, arg_0));
        protocolMarkup.getHighlightersUpdated().advise(lifetime, arg_0 -> FrontendMarkupContributor.x(this, arg_0));
        protocolMarkup.getHighlightersCleared().advise(lifetime, arg_0 -> FrontendMarkupContributor.x(this, arg_0));
        this.suppressor.released(lifetime, (Function1<? super Lifetime, Unit>)((Function1)arg_0 -> FrontendMarkupContributor.x(this, arg_0)));
        lifetime.onTermination(() -> FrontendMarkupContributor.G(this));
        protocolMarkup.bind(lifetime);
    }

    @TestOnly
    @NotNull
    public final MarkupSuppressionKind isSuppressed() {
        return this.suppressor.isSuppressed$intellij_rd_client();
    }

    private static final Unit x(FrontendMarkupContributor frontendMarkupContributor) {
        List<RangeHighlighterEx> list2;
        HighlighterModel highlighterModel;
        List<HighlighterExtension> list3;
        Object object;
        Object object2;
        Object object3;
        logger.debug("highlighter flush triggered!");
        Object object4 = logger;
        boolean bl = false;
        if (object4.isTraceEnabled()) {
            object3 = object4;
            boolean bl2 = false;
            object3.trace("highlighters in document:" + frontendMarkupContributor.markupAdapter.getAllHighlighters().length);
        }
        object4 = frontendMarkupContributor.storage.flushNotUpdated();
        if (!((Collection)object4).isEmpty()) {
            Iterator iterator2 = object4.iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator2.next();
                object2 = (RangeHighlighterEx)entry.getKey();
                object = (HighlighterElement)entry.getValue();
                HighlighterModel highlighterModel2 = ((HighlighterElement)object).component1();
                list3 = ((HighlighterElement)object).component2();
                highlighterModel = frontendMarkupContributor.x(highlighterModel2, false);
                if (highlighterModel == null) {
                    logger.warn("Received unrepairable update for highlighter during flush. Model: " + HighlightersUtilKt.prettyPrint(highlighterModel2));
                    continue;
                }
                frontendMarkupContributor.markupAdapter.updateHighlighter((RangeHighlighterEx)object2, new HighlighterElement(highlighterModel, list3));
            }
        }
        ArrayList<HighlighterElement> arrayList = new ArrayList<HighlighterElement>();
        List<HighlighterElement> list4 = frontendMarkupContributor.storage.flushNotRegistered();
        if (!((Collection)list4).isEmpty()) {
            object2 = logger;
            boolean bl3 = false;
            if (object2.isTraceEnabled()) {
                object3 = object2;
                boolean bl4 = false;
                object3.trace("Flushing to markup " + list4.size() + " not registered highlighters");
            }
            for (HighlighterElement highlighterElement : list4) {
                HighlighterModel highlighterModel3 = highlighterElement.component1();
                list3 = highlighterElement.component2();
                highlighterModel = frontendMarkupContributor.x(highlighterModel3, true);
                if (highlighterModel == null) {
                    logger.warn("Invalid highlighters are presented in notRegistered highlighters during flush");
                    continue;
                }
                HighlighterElement highlighterElement2 = new HighlighterElement(highlighterModel, list3);
                RangeHighlighterEx rangeHighlighterEx = frontendMarkupContributor.x(highlighterElement2);
                if (rangeHighlighterEx != null) continue;
                arrayList.add(highlighterElement2);
            }
            int n = list4.size() - arrayList.size();
            object = logger;
            boolean bl5 = false;
            if (object.isTraceEnabled()) {
                object3 = object;
                boolean bl6 = false;
                object3.trace("Reused " + n + " highlighters during flush");
            }
        }
        if (!((Collection)(list2 = frontendMarkupContributor.storage.flushNotDeleted())).isEmpty()) {
            object = logger;
            boolean bl7 = false;
            if (object.isTraceEnabled()) {
                object3 = object;
                boolean bl8 = false;
                object3.trace("Deleting " + list2.size() + " highlighters from markup");
            }
            frontendMarkupContributor.markupAdapter.bulkRemoveHighlighters(list2);
        }
        if (arrayList.size() != 0) {
            object = logger;
            int n = 0;
            if (object.isTraceEnabled()) {
                object3 = object;
                boolean bl9 = false;
                object3.trace("Registering last portion of " + arrayList.size() + " highlighters which have failed at reusing");
            }
            object = frontendMarkupContributor.markupAdapter.bulkAddHighlighters((List<HighlighterElement>)arrayList);
            int n2 = ((Collection)object).size();
            for (n = 0; n < n2; ++n) {
                frontendMarkupContributor.storage.addHighlighter(((HighlighterElement)arrayList.get(n)).getHighlighter().getId(), (RangeHighlighterEx)object.get(n));
            }
        }
        frontendMarkupContributor.highlighterRepairer.shrinkHistory();
        return Unit.INSTANCE;
    }

    private static final Unit G(List list2, FrontendMarkupContributor frontendMarkupContributor) {
        List list3 = new ArrayList();
        for (HighlighterElement highlighterElement : list2) {
            Object object;
            HighlighterModel highlighterModel;
            boolean bl;
            HighlighterModel highlighterModel2 = highlighterElement.getHighlighter();
            List<HighlighterExtension> list4 = highlighterElement.getExtensions();
            boolean bl2 = bl = frontendMarkupContributor.storage.get(highlighterModel2.getId()) == null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Multiple highlighter registration on IDEA-side! id: " + highlighterModel2.getId() + " model: " + HighlightersUtilKt.prettyPrint(highlighterModel2);
                throw new AssertionError((Object)string);
            }
            if (frontendMarkupContributor.x(highlighterModel2, true) == null || frontendMarkupContributor.x(highlighterModel2)) continue;
            HighlighterElement highlighterElement2 = new HighlighterElement(highlighterModel, list4);
            if (frontendMarkupContributor.suppressor.shouldSuppressAddition(highlighterModel2.getProperties())) {
                object = frontendMarkupContributor.x(highlighterElement2);
                if (object == null) {
                    FrontendMarkupContributor frontendMarkupContributor2 = frontendMarkupContributor;
                    boolean bl4 = false;
                    frontendMarkupContributor2.storage.queueRegistration(highlighterElement);
                    frontendMarkupContributor2.k();
                    object = Unit.INSTANCE;
                }
                continue;
            }
            object = list3.add(highlighterElement2);
        }
        if (list3.isEmpty()) {
            return Unit.INSTANCE;
        }
        List<RangeHighlighterEx> list5 = frontendMarkupContributor.markupAdapter.bulkAddHighlighters(list3);
        int n = ((Collection)list5).size();
        for (int j = 0; j < n; ++j) {
            frontendMarkupContributor.storage.addHighlighter(((HighlighterElement)list3.get(j)).getHighlighter().getId(), (RangeHighlighterEx)list5.get(j));
        }
        return Unit.INSTANCE;
    }

    private static final boolean x(HighlighterModel highlighterModel, FrontendMarkupContributor frontendMarkupContributor, FrontendHighlighterSuppressionHandler frontendHighlighterSuppressionHandler) {
        Intrinsics.checkNotNullParameter((Object)frontendHighlighterSuppressionHandler, (String)"it");
        return frontendHighlighterSuppressionHandler.shouldSuppress(highlighterModel, frontendMarkupContributor.markupAdapter.getDocument());
    }

    private static final boolean x(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    private static final Unit k(List list2, FrontendMarkupContributor frontendMarkupContributor) {
        for (HighlighterElement highlighterElement : list2) {
            if (frontendMarkupContributor.storage.updateRegistration(highlighterElement)) continue;
            RangeHighlighterEx rangeHighlighterEx = frontendMarkupContributor.storage.get(highlighterElement.getHighlighter().getId());
            if (rangeHighlighterEx == null) {
                logger.warn("Received update for not registered highlighter " + HighlightersUtilKt.prettyPrint(highlighterElement.getHighlighter()));
                continue;
            }
            if (frontendMarkupContributor.suppressor.shouldSuppressUpdate()) {
                frontendMarkupContributor.storage.queueUpdate(rangeHighlighterEx, highlighterElement);
                frontendMarkupContributor.k();
                continue;
            }
            HighlighterModel highlighterModel = frontendMarkupContributor.x(highlighterElement.getHighlighter(), false);
            if (highlighterModel == null) {
                if (highlighterElement.getHighlighter().getProperties().isVerifiable()) {
                    logger.trace("Received unrepairable update for highlighter. Model: " + HighlightersUtilKt.prettyPrint(highlighterElement.getHighlighter()));
                    continue;
                }
                logger.warn("Received unrepairable update for highlighter. Model: " + HighlightersUtilKt.prettyPrint(highlighterElement.getHighlighter()));
                continue;
            }
            frontendMarkupContributor.markupAdapter.updateHighlighter(rangeHighlighterEx, new HighlighterElement(highlighterModel, highlighterElement.getExtensions()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(List list2, FrontendMarkupContributor frontendMarkupContributor) {
        List list3 = new ArrayList();
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            RangeHighlighterEx rangeHighlighterEx;
            long l = ((Number)iterator2.next()).longValue();
            if (frontendMarkupContributor.storage.remove(l) == null) continue;
            if (frontendMarkupContributor.suppressor.shouldSuppressDeletion(UtilKt.getBackendProperties((RangeHighlighter)rangeHighlighterEx))) {
                frontendMarkupContributor.storage.queueDeletion(rangeHighlighterEx);
                frontendMarkupContributor.k();
                continue;
            }
            list3.add(rangeHighlighterEx);
        }
        if (list3.isEmpty()) {
            return Unit.INSTANCE;
        }
        frontendMarkupContributor.markupAdapter.bulkRemoveHighlighters(list3);
        return Unit.INSTANCE;
    }

    private static final Unit k(FrontendMarkupContributor frontendMarkupContributor) {
        boolean bl;
        block3: {
            boolean bl2;
            boolean bl3;
            List list2 = CollectionsKt.plus(frontendMarkupContributor.storage.getRegisteredHighlighters(), (Iterable)frontendMarkupContributor.storage.flushNotDeleted());
            logger.debug("Cleaning highlighter storage. Total amount " + list2.size());
            frontendMarkupContributor.markupAdapter.bulkRemoveHighlighters(list2);
            frontendMarkupContributor.storage.clear();
            Logger logger = FrontendMarkupContributor.logger;
            boolean bl4 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                bl3 = false;
                logger2.trace("storage: " + frontendMarkupContributor.storage);
            }
            RangeHighlighterEx[] rangeHighlighterExArray = frontendMarkupContributor.markupAdapter.getAllHighlighters();
            bl3 = false;
            int n = rangeHighlighterExArray.length;
            for (int j = 0; j < n; ++j) {
                RangeHighlighterEx rangeHighlighterEx;
                RangeHighlighterEx rangeHighlighterEx2 = rangeHighlighterEx = rangeHighlighterExArray[j];
                boolean bl5 = false;
                if (!HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)rangeHighlighterEx2)) continue;
                bl2 = true;
                break block3;
            }
            bl2 = bl = false;
        }
        if (bl) {
            logger.error("backend highlighters present in Markup model after cleaning");
        }
        return Unit.INSTANCE;
    }

    private static final Unit k(FrontendMarkupContributor frontendMarkupContributor, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"it");
        Logger logger = FrontendMarkupContributor.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("RdMarkupModel.highlightersRemoved fired: count=" + list2.size());
        }
        frontendMarkupContributor.G(list2);
        return Unit.INSTANCE;
    }

    private static final Unit G(FrontendMarkupContributor frontendMarkupContributor, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"it");
        Logger logger = FrontendMarkupContributor.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append("RdMarkupModel.highlightersAdded fired: count=" + list2.size()).append('\n').append("Received highlighters from backend.  Highlighter breakdown:").append('\n');
            Iterable iterable = list2;
            boolean bl3 = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl4 = false;
            for (Object t : iterable2) {
                HighlighterElement highlighterElement = (HighlighterElement)t;
                Collection collection2 = collection;
                boolean bl5 = false;
                HighlighterModel highlighterModel = highlighterElement.getHighlighter();
                stringBuilder.append(highlighterModel.getProperties().getAttributeId()).append(":");
                com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.prettyPrint$default(Companion, highlighterModel.getTextAttributesKey(), stringBuilder, 0, 2, null);
                collection2.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)collection;
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            logger2.trace(string);
        }
        frontendMarkupContributor.k(list2);
        return Unit.INSTANCE;
    }

    private static final Unit x(FrontendMarkupContributor frontendMarkupContributor, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"it");
        Logger logger = FrontendMarkupContributor.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("RdMarkupModel.highlightersUpdated fired: count=" + list2.size());
        }
        frontendMarkupContributor.x(list2);
        return Unit.INSTANCE;
    }

    private static final Unit x(FrontendMarkupContributor frontendMarkupContributor, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
        Logger logger = FrontendMarkupContributor.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
        }
        frontendMarkupContributor.x();
        return Unit.INSTANCE;
    }

    private static final Unit x(FrontendMarkupContributor frontendMarkupContributor, Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"it");
        Logger logger = FrontendMarkupContributor.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("suppressor is released. call flushHighlighters()");
        }
        frontendMarkupContributor.G();
        return Unit.INSTANCE;
    }

    private static final Unit G(FrontendMarkupContributor frontendMarkupContributor) {
        Logger logger = FrontendMarkupContributor.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("RdMarkupModel.highlightersCleared fired. call removeAllHighlighters()");
        }
        frontendMarkupContributor.x();
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendMarkupContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendMarkupContributor.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\b\b\u0002\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$Companion;", "", "FrontendMarkupContributor$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "prettyPrint", "", "Lcom/jetbrains/ide/model/highlighterRegistration/TextAttributesKeyModel;", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "depth", "", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final void prettyPrint(@Nullable TextAttributesKeyModel $this$prettyPrint, @NotNull StringBuilder result2, int depth) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            if ($this$prettyPrint == null) {
                result2.append("[NULL KEY]").append('\n');
                return;
            }
            if (!($this$prettyPrint instanceof IdeaTextAttributesKey)) {
                result2.append("[NON-IDEA KEY]").append('\n');
                return;
            }
            String string = "  ";
            StringBuilder stringBuilder = result2.append(((IdeaTextAttributesKey)$this$prettyPrint).getExternalName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Object object = stringBuilder;
            ((StringBuilder)object).append(" (").append('\n');
            com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.x(depth, result2, string).append(string).append("fallback: ");
            object = ((IdeaTextAttributesKey)$this$prettyPrint).getFallback();
            if (object == null) {
                result2.append("NULL").append('\n');
            } else {
                this.prettyPrint((TextAttributesKeyModel)object, result2, depth + 1);
            }
            com.jetbrains.rdclient.daemon.FrontendMarkupContributor$Companion.x(depth, result2, string).append(")").append('\n');
        }

        public static /* synthetic */ void prettyPrint$default(Companion companion, TextAttributesKeyModel textAttributesKeyModel, StringBuilder stringBuilder, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            companion.prettyPrint(textAttributesKeyModel, stringBuilder, n);
        }

        private static final StringBuilder x(int n, StringBuilder stringBuilder, String string) {
            for (int j = 0; j < n; ++j) {
                stringBuilder.append(string);
            }
            return stringBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask;", "Lcom/intellij/util/ui/update/Update;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "FrontendMarkupContributor$MergingUpdateTask", "(Lcom/jetbrains/rdclient/daemon/FrontendMarkupContributor;Lcom/intellij/openapi/application/ModalityState;)V", "run", "", "canEat", "", "update", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendMarkupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,328:1\n67#2,4:329\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupContributor.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupContributor$MergingUpdateTask\n*L\n47#1:329,4\n*E\n"})
    private final class MergingUpdateTask
    extends Update {
        @NotNull
        private final ModalityState modality;

        public MergingUpdateTask(ModalityState modality) {
            Intrinsics.checkNotNullParameter((Object)modality, (String)"modality");
            super((Object)modality, false, 0, 6, null);
            this.modality = modality;
        }

        public void run() {
            ApplicationKt.getApplication().invokeLater(() -> MergingUpdateTask.x(FrontendMarkupContributor.this, this), this.modality);
        }

        public boolean canEat(@NotNull Update update2) {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            if (!(update2 instanceof MergingUpdateTask)) {
                return false;
            }
            ModalityState modalityState = ((MergingUpdateTask)update2).modality;
            return Intrinsics.areEqual((Object)this.modality, (Object)modalityState) || this.modality.dominates(modalityState);
        }

        private static final void x(FrontendMarkupContributor frontendMarkupContributor, MergingUpdateTask mergingUpdateTask) {
            if (frontendMarkupContributor.suppressor.isSuppressed$intellij_rd_client() == MarkupSuppressionKind.NONE && RLifetimeKt.isAlive((Lifetime)frontendMarkupContributor.getLifetime())) {
                Logger logger = logger;
                boolean bl = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl2 = false;
                    logger2.trace("MergingUpdateTask.run&invokeLater: call flushHighlighters(). modality: " + mergingUpdateTask.modality);
                }
                frontendMarkupContributor.G();
            }
        }
    }
}

