/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.completion.summaryInfo;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupPositionManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0017\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/completion/summaryInfo/SummaryInfoPositionAdjuster;", "Lcom/intellij/ui/popup/PopupPositionManager$PositionAdjuster;", "rectangle", "Ljava/awt/Rectangle;", "component", "Ljava/awt/Component;", "gap", "", "SummaryInfoPositionAdjuster", "(Ljava/awt/Rectangle;Ljava/awt/Component;I)V", "y", "adjust", "", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "positionRight", "d", "Ljava/awt/Dimension;", "positionLeft", "traversalPolicy", "", "Lcom/intellij/ui/popup/PopupPositionManager$Position;", "(Lcom/intellij/openapi/ui/popup/JBPopup;[Lcom/intellij/ui/popup/PopupPositionManager$Position;)V", "calculatePopupRectangle", "(Lcom/intellij/openapi/ui/popup/JBPopup;[Lcom/intellij/ui/popup/PopupPositionManager$Position;)Ljava/awt/Rectangle;", "intellij.rd.client"})
public final class SummaryInfoPositionAdjuster
extends PopupPositionManager.PositionAdjuster {
    private final int y;

    public SummaryInfoPositionAdjuster(@NotNull Rectangle rectangle, @NotNull Component component, int gap) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(component, gap);
        this.y = component.getLocationOnScreen().y + rectangle.y;
    }

    public void adjust(@NotNull JBPopup popup) {
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        PopupPositionManager.Position[] positionArray = new PopupPositionManager.Position[]{PopupPositionManager.Position.RIGHT, PopupPositionManager.Position.LEFT};
        this.adjust(popup, positionArray);
    }

    @NotNull
    protected Rectangle positionRight(@NotNull Dimension d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.y, d.width, d.height);
    }

    @NotNull
    protected Rectangle positionLeft(@NotNull Dimension d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return new Rectangle(this.myRelativeOnScreen.x - this.myGap - d.width, this.y, d.width, d.height);
    }

    public void adjust(@NotNull JBPopup popup, PopupPositionManager.Position ... traversalPolicy) {
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)traversalPolicy, (String)"traversalPolicy");
        Rectangle rectangle = this.calculatePopupRectangle(popup, Arrays.copyOf(traversalPolicy, traversalPolicy.length));
        popup.setSize(rectangle.getSize());
        if (popup.isVisible()) {
            popup.setLocation(rectangle.getLocation());
        } else {
            popup.show(new RelativePoint(this.myRelativeTo, new Point(rectangle.getLocation().x - this.myRelativeOnScreen.x, rectangle.getLocation().y - this.myRelativeOnScreen.y)));
        }
    }

    @NotNull
    public final Rectangle calculatePopupRectangle(@NotNull JBPopup popup, PopupPositionManager.Position ... traversalPolicy) {
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)traversalPolicy, (String)"traversalPolicy");
        Dimension dimension = PopupPositionManager.PositionAdjuster.getPopupSize((JBPopup)popup);
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPopupSize(...)");
        Dimension dimension2 = dimension;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        for (PopupPositionManager.Position position : traversalPolicy) {
            Rectangle rectangle3 = rectangle2 = (switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
                case 1 -> this.positionAbove(dimension2);
                case 2 -> this.positionUnder(dimension2);
                case 3 -> this.positionLeft(dimension2);
                case 4 -> this.positionRight(dimension2);
                default -> throw new NoWhenBranchMatchedException();
            });
            Intrinsics.checkNotNull((Object)rectangle3);
            if (!this.myScreenRect.contains(rectangle3)) continue;
            rectangle = rectangle2;
            break;
        }
        if (rectangle != null) {
            Rectangle rectangle4 = rectangle2;
            Intrinsics.checkNotNull(rectangle4);
            return rectangle4;
        }
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        arrayList.add(PopupPositionManager.PositionAdjuster.crop((Rectangle)this.myScreenRect, (Rectangle)new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.y, this.myScreenRect.width, this.myScreenRect.height)));
        arrayList.add(PopupPositionManager.PositionAdjuster.crop((Rectangle)this.myScreenRect, (Rectangle)new Rectangle(this.myScreenRect.x, this.y, this.myRelativeOnScreen.x - this.myScreenRect.x - this.myGap, this.myScreenRect.height)));
        CollectionsKt.sortWith((List)arrayList, (arg_0, arg_1) -> SummaryInfoPositionAdjuster.x(SummaryInfoPositionAdjuster::x, arg_0, arg_1));
        Object e = arrayList.get(arrayList.size() - 1);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        Rectangle rectangle5 = (Rectangle)e;
        int n = rectangle5.x < this.myRelativeOnScreen.x ? rectangle5.x + rectangle5.width - dimension2.width : rectangle5.x;
        int n2 = rectangle5.y < this.y ? rectangle5.y + rectangle5.height - dimension2.height : rectangle5.y;
        Rectangle rectangle6 = PopupPositionManager.PositionAdjuster.crop((Rectangle)rectangle5, (Rectangle)new Rectangle(n, n2, dimension2.width, dimension2.height));
        Intrinsics.checkNotNullExpressionValue((Object)rectangle6, (String)"crop(...)");
        return rectangle6;
    }

    private static final int x(Rectangle rectangle, Rectangle rectangle2) {
        int n = Intrinsics.compare((int)rectangle.width, (int)rectangle2.width);
        return n == 0 ? Intrinsics.compare((int)rectangle.height, (int)rectangle2.height) : n;
    }

    private static final int x(Function2 function2, Object object, Object object2) {
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PopupPositionManager.Position.values().length];
            try {
                nArray[PopupPositionManager.Position.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPositionManager.Position.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPositionManager.Position.LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPositionManager.Position.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

