/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.ui.TextIcon;
import com.intellij.util.ui.JBFont;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.FontStyle;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RectangleModel;
import com.jetbrains.rd.ide.model.TextBadgeIconModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.converters.TextBadgeIconConverterKt;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/TextBadgeIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/ui/TextIcon;", "Lcom/jetbrains/rd/ide/model/TextBadgeIconModel;", "TextBadgeIconConverter", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "intellij.rd.ui"})
public final class TextBadgeIconConverter
implements ProtocolIconConverter<TextIcon, TextBadgeIconModel> {
    @Override
    @Nullable
    public Icon createIcon(@NotNull TextBadgeIconModel model2, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        AbstractColor abstractColor = model2.getForeground();
        AbstractColor abstractColor2 = model2.getBackground();
        AbstractColor abstractColor3 = model2.getBorderColor();
        TextIcon textIcon = new TextIcon(model2.getText(), abstractColor != null ? ColorHostKt.toColor(abstractColor) : null, abstractColor2 != null ? ColorHostKt.toColor(abstractColor2) : null, abstractColor3 != null ? ColorHostKt.toColor(abstractColor3) : null, 0, model2.getWithBorders());
        textIcon.setRound(model2.getRound());
        textIcon.setInsets(model2.getInsets().getY(), model2.getInsets().getX(), model2.getInsets().getHeight(), model2.getInsets().getWidth());
        if (model2.getFontSize() > 0.0f && model2.getFontStyle() != null) {
            JBFont jBFont = JBFont.label();
            FontStyle fontStyle = model2.getFontStyle();
            Intrinsics.checkNotNull((Object)((Object)fontStyle));
            textIcon.setFont((Font)jBFont.deriveFont(TextBadgeIconConverterKt.toStyle(fontStyle), model2.getFontSize()));
        }
        if (model2.getFontTransform() != null) {
            textIcon.setFontTransform(new AffineTransform(model2.getFontTransform()));
        }
        return (Icon)textIcon;
    }

    @Override
    @Nullable
    public IconModel createModel(@NotNull TextIcon icon, @NotNull ProtocolIconModelRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Font font = icon.getFont();
        float f = font != null ? (float)font.getSize() : 0.0f;
        Font font2 = icon.getFont();
        FontStyle fontStyle = font2 != null ? TextBadgeIconConverterKt.toFontStyle(font2.getStyle()) : null;
        Font font3 = icon.getFont();
        int n = font3 != null ? font3.hashCode() : 0;
        double[] dArray = null;
        AffineTransform affineTransform = icon.getFontTransform();
        if (affineTransform != null) {
            dArray = new double[6];
            affineTransform.getMatrix(dArray);
        }
        Insets insets = icon.getInsets();
        String string = icon.getText();
        Integer n2 = icon.getRound();
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getRound(...)");
        int n3 = ((Number)n2).intValue();
        Boolean bl = icon.getWithBorders();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getWithBorders(...)");
        Color color = icon.getForeground();
        Color color2 = icon.getBackground();
        Color color3 = icon.getBorderColor();
        return new TextBadgeIconModel(string, f, fontStyle, n, dArray, n3, bl, color != null ? ColorHostKt.toModel(color) : null, color2 != null ? ColorHostKt.toModel(color2) : null, color3 != null ? ColorHostKt.toModel(color3) : null, new RectangleModel(insets.left, insets.top, insets.right, insets.bottom));
    }
}

