/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.EmptyImageDataLoaderDescriptor;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.svg.SvgCacheClassifier;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.IconUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.ImageUtil;
import com.jetbrains.rd.ide.model.IconSource;
import com.jetbrains.rd.ide.model.ImageIconModelId;
import com.jetbrains.rd.ide.model.ImageIconSources;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 62\u00020\u0001:\u00016B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020(\u0018\u00010'H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\u00012\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020(H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u001a\u00100\u001a\u0004\u0018\u00010\u00192\u0006\u00101\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u00104\u001a\u00020\u001fH\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00192\u0006\u00101\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u00102\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0012\u00a8\u00067"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ProtocolImageDataLoader;", "Lcom/intellij/ui/icons/ImageDataLoader;", "id", "Lcom/jetbrains/rd/ide/model/ImageIconModelId;", "imageSources", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/jetbrains/rd/ide/model/ImageIconSources;", "localLoader", "width", "", "height", "imageFlags", "ProtocolImageDataLoader", "(Lcom/jetbrains/rd/ide/model/ImageIconModelId;Ljava/util/concurrent/atomic/AtomicReference;Lcom/intellij/ui/icons/ImageDataLoader;III)V", "getImageSources", "()Ljava/util/concurrent/atomic/AtomicReference;", "modificationCount", "getModificationCount", "()I", "value", "", "wasRequested", "getWasRequested", "()Z", "loadImage", "Ljava/awt/Image;", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "path", "", "getPath", "()Ljava/lang/String;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "getCoords", "Lkotlin/Pair;", "Ljava/lang/ClassLoader;", "patch", "transform", "Lcom/intellij/ui/icons/IconTransform;", "isMyClassLoader", "classLoader", "serializeToByteArray", "Lcom/intellij/ui/icons/EmptyImageDataLoaderDescriptor;", "x", "ctx", "flags", "getFlags", "toString", "x", "Companion", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nProtocolImageDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolImageDataLoader.kt\ncom/jetbrains/rd/ui/icons/converters/ProtocolImageDataLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n13#2:149\n60#2,5:150\n13#2:160\n1#3:155\n1563#4:156\n1634#4,3:157\n*S KotlinDebug\n*F\n+ 1 ProtocolImageDataLoader.kt\ncom/jetbrains/rd/ui/icons/converters/ProtocolImageDataLoader\n*L\n39#1:149\n39#1:150,5\n146#1:160\n122#1:156\n122#1:157,3\n*E\n"})
public final class ProtocolImageDataLoader
implements ImageDataLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageIconModelId id;
    @NotNull
    private final AtomicReference<ImageIconSources> imageSources;
    @Nullable
    private final ImageDataLoader localLoader;
    private final int width;
    private final int height;
    private final int imageFlags;
    private boolean wasRequested;
    @Nullable
    private final URL url;
    @NotNull
    private static final Logger LOG;

    public ProtocolImageDataLoader(@NotNull ImageIconModelId id, @NotNull AtomicReference<ImageIconSources> imageSources, @Nullable ImageDataLoader localLoader, int width, int height, int imageFlags) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(imageSources, (String)"imageSources");
        this.id = id;
        this.imageSources = imageSources;
        this.localLoader = localLoader;
        this.width = width;
        this.height = height;
        this.imageFlags = imageFlags;
        ImageDataLoader imageDataLoader = this.localLoader;
        this.url = imageDataLoader != null ? imageDataLoader.getUrl() : null;
    }

    @NotNull
    public final AtomicReference<ImageIconSources> getImageSources() {
        return this.imageSources;
    }

    public int getModificationCount() {
        return this.imageSources.get() == null ? 0 : 1;
    }

    public final boolean getWasRequested() {
        return this.wasRequested;
    }

    @Nullable
    public Image loadImage(@NotNull LoadIconParameters parameters, @NotNull ScaleContext scaleContext) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        ImageDataLoader imageDataLoader = this.localLoader;
        Image image2 = image = imageDataLoader != null ? imageDataLoader.loadImage(parameters, scaleContext) : null;
        if (image != null) {
            if (this.imageSources.get() != null) {
                boolean bl = false;
                Logger logger = Logger.getInstance(ProtocolImageDataLoader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Logger logger2 = logger;
                Throwable throwable = null;
                boolean bl2 = false;
                if (logger2.isDebugEnabled()) {
                    Logger logger3 = logger2;
                    boolean bl3 = false;
                    logger3.debug("Icon sources were not needed for " + this.id, throwable);
                }
            }
            return image;
        }
        return this.x(scaleContext, parameters);
    }

    @NotNull
    public String getPath() {
        Object object = this.localLoader;
        if (object == null || (object = object.getPath()) == null) {
            object = this.id.getPath();
        }
        return object;
    }

    @Nullable
    public URL getUrl() {
        return this.url;
    }

    @Nullable
    public Pair<String, ClassLoader> getCoords() {
        ImageDataLoader imageDataLoader = this.localLoader;
        return imageDataLoader != null ? imageDataLoader.getCoords() : null;
    }

    @Nullable
    public ImageDataLoader patch(@NotNull IconTransform transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        ImageDataLoader imageDataLoader = this.localLoader;
        if (imageDataLoader == null || (imageDataLoader = imageDataLoader.patch(transform)) == null) {
            return null;
        }
        ImageDataLoader imageDataLoader2 = imageDataLoader;
        return new ProtocolImageDataLoader(this.id, this.imageSources, imageDataLoader2, this.width, this.height, this.imageFlags);
    }

    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        ImageDataLoader imageDataLoader = this.localLoader;
        return imageDataLoader != null ? imageDataLoader.isMyClassLoader(classLoader) : false;
    }

    @NotNull
    public EmptyImageDataLoaderDescriptor serializeToByteArray() {
        return EmptyImageDataLoaderDescriptor.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Image x(ScaleContext scaleContext, LoadIconParameters loadIconParameters) {
        Object object;
        block21: {
            Object object2;
            object = this;
            try {
                Image image;
                block18: {
                    String string;
                    String string2;
                    ImageIconSources imageIconSources;
                    block19: {
                        object2 = object;
                        boolean bl = false;
                        ((ProtocolImageDataLoader)object2).wasRequested = true;
                        imageIconSources = ((ProtocolImageDataLoader)object2).imageSources.get();
                        if (imageIconSources != null) break block19;
                        image = super.x(scaleContext);
                        break block18;
                    }
                    ImageIconSources imageIconSources2 = imageIconSources;
                    String string3 = imageIconSources2.getOriginalPath();
                    int n = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null);
                    if (n == -1) {
                        string2 = string3;
                    } else {
                        String string4 = string3.substring(0, n);
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    }
                    String string5 = string2;
                    if (n == -1) {
                        string = "svg";
                    } else {
                        String string6 = string3.substring(n + 1);
                        string = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                    }
                    String string7 = string;
                    List list2 = ImageDescriptorKt.createImageDescriptorTransformListWithSizeSpecialization((String)string3, (boolean)loadIconParameters.isDark, (boolean)loadIconParameters.isStroke, (ScaleContext)scaleContext, (int)((ProtocolImageDataLoader)object2).width, (int)((ProtocolImageDataLoader)object2).height);
                    for (ImageDescriptor imageDescriptor : list2) {
                        try {
                            IconSource iconSource;
                            Object v6;
                            int n2;
                            Object object3;
                            Object object4;
                            Object object5;
                            block17: {
                                String string8 = (String)imageDescriptor.pathTransform.invoke((Object)string5, (Object)string7);
                                object5 = imageIconSources2.getSources();
                                object4 = object5.iterator();
                                while (object4.hasNext()) {
                                    object3 = object4.next();
                                    IconSource iconSource2 = (IconSource)object3;
                                    n2 = 0;
                                    if (!Intrinsics.areEqual((Object)iconSource2.getPath(), (Object)string8)) continue;
                                    v6 = object3;
                                    break block17;
                                }
                                v6 = null;
                            }
                            if ((IconSource)v6 == null) continue;
                            byte[] byArray = iconSource.getBody();
                            if (byArray == null) continue;
                            byte[] byArray2 = byArray;
                            object5 = new ByteArrayInputStream(byArray2);
                            object4 = null;
                            try {
                                BufferedImage bufferedImage;
                                object3 = (ByteArrayInputStream)object5;
                                boolean bl = false;
                                if (imageDescriptor.isSvg) {
                                    n2 = SvgCacheClassifier.constructor-impl((float)imageDescriptor.scale, (boolean)loadIconParameters.isDark, (boolean)loadIconParameters.isStroke);
                                    bufferedImage = SvgKt.loadSvg-0e6sKCk((String)iconSource.getPath(), (InputStream)((InputStream)object3), (float)imageDescriptor.scale, (SvgCacheClassifier)SvgCacheClassifier.box-impl((int)n2), (SVGLoader.SvgElementColorPatcherProvider)loadIconParameters.colorPatcher);
                                } else {
                                    bufferedImage = IconUtilKt.loadRasterImage((InputStream)((InputStream)object3));
                                }
                                object3 = bufferedImage;
                            }
                            catch (Throwable throwable) {
                                try {
                                    object4 = throwable;
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    CloseableKt.closeFinally((Closeable)object5, object4);
                                    throw throwable2;
                                }
                            }
                            CloseableKt.closeFinally((Closeable)object5, (Throwable)object4);
                            Object object6 = object3;
                            image = IconUtilKt.convertImage((Image)((Image)object6), (List)loadIconParameters.filters, (ScaleContext)scaleContext, (!imageDescriptor.isSvg ? 1 : 0) != 0, (float)imageDescriptor.scale);
                            break block18;
                        }
                        catch (IOException iOException) {
                        }
                    }
                    LOG.warn("Unable to create an image for icon " + string3);
                    image = super.x(scaleContext);
                }
                object2 = Result.constructor-impl((Object)image);
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block21;
            Object object7 = object2 = throwable;
            boolean bl = false;
            if (object7 instanceof CancellationException) {
                throw object7;
            }
            LOG.error("Path " + this.id.getPath() + ". Exception " + (Throwable)object7);
        }
        return (Image)(Result.isFailure-impl((Object)object) ? null : object);
    }

    public int getFlags() {
        ImageDataLoader imageDataLoader = this.localLoader;
        return (imageDataLoader != null ? imageDataLoader.getFlags() : 0) | this.imageFlags;
    }

    @NotNull
    public String toString() {
        Collection<String> collection;
        String string = this.id.getPath();
        int n = this.getFlags();
        ImageIconSources imageIconSources = this.imageSources.get();
        List list2 = imageIconSources != null ? imageIconSources.getSources() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable iterable = list2;
        int n2 = n;
        String string2 = string;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            IconSource iconSource = (IconSource)t;
            collection = collection2;
            boolean bl3 = false;
            collection.add(iconSource.getPath());
        }
        collection = (List)collection2;
        return "ProtocolImageDataLoader(originalPath='" + string2 + "', flags=" + n2 + ", sources=" + (List)collection + ", localLoader=" + this.localLoader + ")";
    }

    private final Image x(ScaleContext scaleContext) {
        if (this.width <= 0 || this.height <= 0) {
            return null;
        }
        float f = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        float f2 = (float)scaleContext.getScale(DerivedScaleType.EFF_USR_SCALE);
        BufferedImage bufferedImage = ImageUtil.createImage((ScaleContext)scaleContext, (double)((double)this.width * (double)f2), (double)((double)this.height * (double)f2), (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage bufferedImage2 = bufferedImage;
        Icon icon = AllIcons.Toolbar.Unknown;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Unknown");
        Icon icon2 = icon;
        float f3 = (float)this.width * f2 / (float)icon2.getIconWidth();
        Icon icon3 = IconUtil.scale((Icon)icon2, null, (float)f3);
        icon3.paintIcon(null, bufferedImage2.getGraphics(), 0, 0);
        return IconUtilKt.convertImage((Image)bufferedImage2, (List)CollectionsKt.emptyList(), (ScaleContext)scaleContext, (boolean)false, (float)f);
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(ProtocolImageDataLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ProtocolImageDataLoader$Companion;", "", "ProtocolImageDataLoader$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

