/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.ui.icons.RgbImageFilterSupplier;
import com.intellij.util.ColorFilter;
import com.intellij.util.IconUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.rd.ide.model.ColorFilterModel;
import com.jetbrains.rd.ide.model.CustomImageIconModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.IconSource;
import com.jetbrains.rd.ide.model.ImageIconModel;
import com.jetbrains.rd.ide.model.ImageIconModelId;
import com.jetbrains.rd.ide.model.ImageIconSources;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.converters.ImageIconConverterKt;
import com.jetbrains.rd.ui.icons.converters.ProtocolImageDataLoader;
import java.awt.Color;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00182\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ImageIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Ljavax/swing/Icon;", "Lcom/jetbrains/rd/ide/model/IconModel;", "ImageIconConverter", "()V", "updateIconSourcesIfNeeded", "", "model", "Lcom/jetbrains/rd/ide/model/ImageIconModel;", "icon", "Lcom/intellij/ui/icons/CachedImageIcon;", "loader", "Lcom/jetbrains/rd/ui/icons/converters/ProtocolImageDataLoader;", "loadIconSourcesIfNeeded", "cacheIconModelIfNeeded", "createIcon", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "x", "iconModel", "localIcon", "createModel", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "Companion", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nImageIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
public abstract class ImageIconConverter
implements ProtocolIconConverter<Icon, IconModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void updateIconSourcesIfNeeded(@NotNull ImageIconModel model2, @NotNull CachedImageIcon icon, @NotNull ProtocolImageDataLoader loader) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
    }

    protected void loadIconSourcesIfNeeded(@NotNull ImageIconModel model2, @NotNull CachedImageIcon icon, @NotNull ProtocolImageDataLoader loader) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
    }

    protected void cacheIconModelIfNeeded(@NotNull ImageIconModel model2, @NotNull CachedImageIcon icon) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
    }

    @Override
    @Nullable
    public Icon createIcon(@NotNull IconModel model2, @NotNull ProtocolIconRegistry registry) {
        Icon icon;
        ImageIconModel imageIconModel;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Object object = model2;
        if (object instanceof ImageIconModel) {
            imageIconModel = (ImageIconModel)model2;
        } else if (object instanceof CustomImageIconModel) {
            imageIconModel = ((CustomImageIconModel)model2).getModel();
        } else {
            return null;
        }
        ImageIconModel imageIconModel2 = imageIconModel;
        object = Companion.findLocalIcon(imageIconModel2.getId());
        if (!(object instanceof CachedImageIcon)) {
            return object;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        Icon icon2 = registry.cacheIcon(imageIconModel2.getId().getIdentity(), (Function1<? super Long, ? extends Icon>)((Function1)arg_0 -> ImageIconConverter.x(booleanRef, this, imageIconModel2, (Icon)object, arg_0)));
        if (!booleanRef.element && icon2 instanceof CachedImageIcon && (icon = ((CachedImageIcon)icon2).getOriginalLoader()) instanceof ProtocolImageDataLoader) {
            this.updateIconSourcesIfNeeded(imageIconModel2, (CachedImageIcon)icon2, (ProtocolImageDataLoader)((Object)icon));
        }
        icon = icon2;
        if (model2 instanceof CustomImageIconModel) {
            ColorFilterModel colorFilterModel;
            Float f = ((CustomImageIconModel)model2).getInitialScale();
            if (f != null && icon instanceof CachedImageIcon) {
                icon = (Icon)((CachedImageIcon)icon).scale(f.floatValue());
            }
            if ((colorFilterModel = ((CustomImageIconModel)model2).getColorFilter()) != null) {
                icon = IconUtil.colorize$default((Icon)icon, (Color)ColorHostKt.toColor(colorFilterModel.getColor()), (boolean)colorFilterModel.getKeepGray(), (boolean)false, (int)8, null);
            }
        }
        return icon;
    }

    private final CachedImageIcon x(ImageIconModel imageIconModel, CachedImageIcon cachedImageIcon) {
        ProtocolImageDataLoader protocolImageDataLoader = new ProtocolImageDataLoader(imageIconModel.getId(), new AtomicReference<ImageIconSources>(imageIconModel.getImageSources()), cachedImageIcon.getOriginalLoader(), imageIconModel.getWidth(), imageIconModel.getHeight(), imageIconModel.getFlags());
        CachedImageIcon cachedImageIcon2 = new CachedImageIcon((ImageDataLoader)protocolImageDataLoader);
        if (imageIconModel.getImageSources() == null) {
            this.loadIconSourcesIfNeeded(imageIconModel, cachedImageIcon2, protocolImageDataLoader);
        }
        return cachedImageIcon2;
    }

    @Override
    @Nullable
    public IconModel createModel(@NotNull Icon icon, @NotNull ProtocolIconModelRegistry registry) {
        ColorFilterModel colorFilterModel;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (!(icon instanceof CachedImageIcon)) {
            return null;
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        IconModel iconModel = registry.cacheModel(icon, (Function1<? super Long, ? extends IconModel>)((Function1)arg_0 -> ImageIconConverter.x(booleanRef, icon, arg_0)));
        if (!(iconModel instanceof ImageIconModel)) {
            return null;
        }
        if (registry.getForceLightModel() && ((ImageIconModel)iconModel).getImageSources() != null) {
            iconModel = new ImageIconModel(((ImageIconModel)iconModel).getId(), ((ImageIconModel)iconModel).getWidth(), ((ImageIconModel)iconModel).getHeight(), ((ImageIconModel)iconModel).getFlags(), null);
        }
        if (booleanRef.element && ((ImageIconModel)iconModel).getImageSources() == null) {
            this.cacheIconModelIfNeeded((ImageIconModel)iconModel, (CachedImageIcon)icon);
        }
        Double d = ((CachedImageIcon)icon).getObjScale();
        RgbImageFilterSupplier rgbImageFilterSupplier = ((CachedImageIcon)icon).getLocalFilterSupplier();
        RGBImageFilter rGBImageFilter = rgbImageFilterSupplier != null ? rgbImageFilterSupplier.getFilter() : null;
        ColorFilter colorFilter = rGBImageFilter instanceof ColorFilter ? (ColorFilter)rGBImageFilter : null;
        if (colorFilter != null) {
            ColorFilter colorFilter2 = colorFilter;
            boolean bl = false;
            v2 = new ColorFilterModel(ColorHostKt.toModel(colorFilter2.getColor()), colorFilter2.getKeepGray());
        } else {
            v2 = colorFilterModel = null;
        }
        if (d != null || colorFilterModel != null) {
            Double d2 = d;
            return new CustomImageIconModel((ImageIconModel)iconModel, d2 != null ? Float.valueOf((float)d2.doubleValue()) : null, colorFilterModel);
        }
        return iconModel;
    }

    private static final Icon x(Ref.BooleanRef booleanRef, ImageIconConverter imageIconConverter, ImageIconModel imageIconModel, Icon icon, long l) {
        booleanRef.element = true;
        return (Icon)imageIconConverter.x(imageIconModel, (CachedImageIcon)icon);
    }

    private static final IconModel x(Ref.BooleanRef booleanRef, Icon icon, long l) {
        booleanRef.element = true;
        return ImageIconConverter.Companion.x(l, (CachedImageIcon)icon);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ImageIconConverter$Companion;", "", "ImageIconConverter$Companion", "()V", "x", "Lcom/jetbrains/rd/ide/model/ImageIconModel;", "identity", "", "icon", "Lcom/intellij/ui/icons/CachedImageIcon;", "createImageSources", "Lcom/jetbrains/rd/ide/model/ImageIconSources;", "findLocalIcon", "Ljavax/swing/Icon;", "modelId", "Lcom/jetbrains/rd/ide/model/ImageIconModelId;", "intellij.rd.ui"})
    @SourceDebugExtension(value={"SMAP\nImageIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n67#2,4:199\n67#2,4:204\n1#3:203\n1#3:218\n1617#4,9:208\n1869#4:217\n1870#4:219\n1626#4:220\n*S KotlinDebug\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter$Companion\n*L\n124#1:199,4\n159#1:204,4\n162#1:218\n162#1:208,9\n162#1:217\n162#1:219\n162#1:220\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ImageIconModel x(long l, CachedImageIcon cachedImageIcon) {
            Pair pair = cachedImageIcon.getOriginalLoader().getCoords();
            if (pair != null) {
                Pair pair2 = pair;
                String string = (String)pair2.component1();
                ClassLoader classLoader = (ClassLoader)pair2.component2();
                Pair pair3 = IconManager.Companion.getInstance().getPluginAndModuleId(classLoader);
                String string2 = (String)pair3.component1();
                String string3 = (String)pair3.component2();
                String string4 = cachedImageIcon.getExpUIPath();
                if (string4 == null && (string4 = cachedImageIcon.getOriginalPath()) == null) {
                    string4 = string;
                }
                String string5 = string4;
                boolean bl = !Intrinsics.areEqual((Object)string2, (Object)"com.intellij") && !ImageIconConverterKt.access$getFRONTEND_PLUGINS_WITH_ICONS$p().contains(string2);
                ImageIconSources imageIconSources = bl ? this.createImageSources(l, cachedImageIcon) : null;
                Object object = ImageIconConverterKt.access$getLogger$p();
                boolean bl2 = false;
                if (object.isTraceEnabled()) {
                    Logger logger = object;
                    boolean bl3 = false;
                    logger.trace("creating model for: path=" + string5 + ", pluginId=" + string2 + ", moduleId=" + string3 + ", hasSources: " + (imageIconSources != null));
                }
                object = new ImageIconModelId(l, string5, string2, string3);
                return new ImageIconModel((ImageIconModelId)object, cachedImageIcon.getIconWidth(), cachedImageIcon.getIconHeight(), cachedImageIcon.getImageFlags(), imageIconSources);
            }
            ImageIconSources imageIconSources = this.createImageSources(l, cachedImageIcon);
            String string = cachedImageIcon.getExpUIPath();
            if (string == null && (string = cachedImageIcon.getOriginalPath()) == null) {
                string = imageIconSources.getOriginalPath();
            }
            String string6 = string;
            URL uRL = cachedImageIcon.getUrl();
            ImageIconConverterKt.access$getLogger$p().warn("creating model without coords: originalPath=" + string6 + ", icon.url.path=" + (uRL != null ? uRL.getPath() : null));
            ImageIconModelId imageIconModelId = new ImageIconModelId(l, string6, null, null);
            return new ImageIconModel(imageIconModelId, cachedImageIcon.getIconWidth(), cachedImageIcon.getIconHeight(), cachedImageIcon.getImageFlags(), imageIconSources);
        }

        @NotNull
        public final ImageIconSources createImageSources(long identity, @NotNull CachedImageIcon icon) {
            CharSequence charSequence;
            String string;
            Object object;
            Object object2;
            URL uRL;
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            URL uRL2 = uRL = icon.getUrl();
            String string2 = uRL2 != null ? uRL2.getPath() : null;
            String string3 = icon.getExpUIPath();
            if (string3 == null && (string3 = icon.getOriginalPath()) == null) {
                object2 = this;
                boolean bl = false;
                String string4 = string2;
                if (string4 == null) {
                    string4 = "protocol_icon_no_path.svg";
                }
                String string5 = string4;
                ImageIconConverterKt.access$getLogger$p().warn("originalPath is null, using " + string5 + " as a fallback");
                string3 = string5;
            }
            if ((object = URLUtil.splitJarUrl((String)(string = string3))) == null || (object = (String)object.second) == null) {
                object = string;
            }
            Object object3 = object;
            String string6 = FileUtilRt.getNameWithoutExtension((String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getNameWithoutExtension(...)");
            String string7 = string6;
            CharSequence charSequence2 = FileUtilRt.getExtension((String)object3);
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = "svg";
            } else {
                charSequence = charSequence2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ifBlank(...)");
            String string8 = (String)charSequence;
            if (string2 != null) {
                charSequence2 = StringsKt.substringAfterLast$default((String)string2, (String)".", null, (int)2, null);
                String string9 = StringsKt.substringBeforeLast$default((String)string2, (String)".", null, (int)2, null);
                Object object4 = ImageIconConverterKt.access$getLogger$p();
                boolean bl = false;
                if (object4.isTraceEnabled()) {
                    Logger logger = object4;
                    boolean bl2 = false;
                    logger.trace("loading sources for: path=" + (String)object3 + ", name=" + string7 + ", ext=" + string8 + ", effectivePath=" + string2);
                }
                object4 = ImageDescriptorKt.createCommonImagePathTransforms((String)object3);
                bl = false;
                Object object5 = object4;
                Collection collection = new ArrayList();
                boolean bl3 = false;
                Object object6 = object5;
                boolean bl4 = false;
                Iterator iterator2 = object6.iterator();
                while (iterator2.hasNext()) {
                    Object object7;
                    Object t;
                    Object t2 = t = iterator2.next();
                    boolean bl5 = false;
                    Function2 function2 = (Function2)t2;
                    boolean bl6 = false;
                    String string10 = (String)function2.invoke((Object)string9, (Object)charSequence2);
                    String string11 = (String)function2.invoke((Object)string7, (Object)string8);
                    URL uRL3 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string10);
                    try {
                        object7 = TextStreamsKt.readBytes((URL)uRL3);
                        object7 = new IconSource(string11, (byte[])object7);
                    }
                    catch (IOException iOException) {
                        ImageIconConverterKt.access$getLogger$p().trace((Throwable)iOException);
                        object7 = null;
                    }
                    if (object7 == null) continue;
                    byte[] byArray = object7;
                    boolean bl7 = false;
                    collection.add(byArray);
                }
                v6 = (List)collection;
            } else {
                v6 = object2 = CollectionsKt.emptyList();
            }
            if (object2.isEmpty()) {
                ImageIconConverterKt.access$getLogger$p().error("Failed to read icon: '" + (String)object3 + "': " + uRL + ", " + icon.getOriginalLoader().getCoords());
            }
            return new ImageIconSources(identity, (String)object3, (List<IconSource>)object2);
        }

        @NotNull
        public final Icon findLocalIcon(@NotNull ImageIconModelId modelId) {
            Object object;
            IconManager iconManager;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
                    iconManager = IconManager.Companion.getInstance();
                    object = modelId.getPlugin();
                    if (object == null) break block2;
                    String string = object;
                    boolean bl = false;
                    ClassLoader classLoader = iconManager.getClassLoader(string, modelId.getModule());
                    object = classLoader;
                    if (classLoader != null) break block3;
                }
                object = AllIcons.class.getClassLoader();
            }
            Object object2 = object;
            String string = modelId.getPath();
            Intrinsics.checkNotNull((Object)object2);
            return iconManager.getIcon(string, (ClassLoader)object2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

