/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.BadgeDotProvider;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.BadgeRectProvider;
import com.intellij.ui.BadgeShapeProvider;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.BadgeDotProviderModel;
import com.jetbrains.rd.ide.model.BadgeIconModel;
import com.jetbrains.rd.ide.model.BadgeRectProviderModel;
import com.jetbrains.rd.ide.model.BadgeShapeProviderModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.UtilKt;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/BadgeIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/ui/BadgeIcon;", "Lcom/jetbrains/rd/ide/model/BadgeIconModel;", "BadgeIconConverter", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nBadgeIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BadgeIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/BadgeIconConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,50:1\n23#2:51\n23#2:52\n*S KotlinDebug\n*F\n+ 1 BadgeIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/BadgeIconConverter\n*L\n29#1:51\n44#1:52\n*E\n"})
public final class BadgeIconConverter
implements ProtocolIconConverter<BadgeIcon, BadgeIconModel> {
    @Override
    @Nullable
    public Icon createIcon(@NotNull BadgeIconModel model2, @NotNull ProtocolIconRegistry registry) {
        BadgeShapeProvider badgeShapeProvider;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Icon icon = UtilKt.fromModel(model2.getIcon());
        Color color = ColorHostKt.toColor(model2.getColor());
        BadgeShapeProviderModel badgeShapeProviderModel = model2.getProvider();
        if (badgeShapeProviderModel instanceof BadgeDotProviderModel) {
            badgeShapeProvider = (BadgeShapeProvider)new BadgeDotProvider(((BadgeDotProviderModel)badgeShapeProviderModel).getX(), ((BadgeDotProviderModel)badgeShapeProviderModel).getY(), ((BadgeDotProviderModel)badgeShapeProviderModel).getRadius(), badgeShapeProviderModel.getBorder());
        } else if (badgeShapeProviderModel instanceof BadgeRectProviderModel) {
            badgeShapeProvider = (BadgeShapeProvider)new BadgeRectProvider(((BadgeRectProviderModel)badgeShapeProviderModel).getArc(), ((BadgeRectProviderModel)badgeShapeProviderModel).getTop(), ((BadgeRectProviderModel)badgeShapeProviderModel).getLeft(), ((BadgeRectProviderModel)badgeShapeProviderModel).getRight(), ((BadgeRectProviderModel)badgeShapeProviderModel).getBottom(), badgeShapeProviderModel.getBorder());
        } else {
            BadgeIconConverter badgeIconConverter = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(BadgeIconConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown BadgeIconProviderModel. " + model2.getProvider());
            return null;
        }
        BadgeShapeProvider badgeShapeProvider2 = badgeShapeProvider;
        return (Icon)new BadgeIcon(icon, (Paint)color, badgeShapeProvider2);
    }

    @Override
    @Nullable
    public IconModel createModel(@NotNull BadgeIcon icon, @NotNull ProtocolIconModelRegistry registry) {
        BadgeShapeProviderModel badgeShapeProviderModel;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        IconModel iconModel = registry.createModel(icon.getIcon());
        if (iconModel == null) {
            return null;
        }
        IconModel iconModel2 = iconModel;
        Paint paint = icon.getPaint();
        Object object = paint instanceof Color ? (Color)paint : null;
        if (object == null || (object = ColorHostKt.toModel((Color)object)) == null) {
            return null;
        }
        Object object2 = object;
        paint = icon.getProvider();
        if (paint instanceof BadgeDotProvider) {
            badgeShapeProviderModel = new BadgeDotProviderModel(((BadgeDotProvider)paint).getX(), ((BadgeDotProvider)paint).getY(), ((BadgeDotProvider)paint).getRadius(), paint.getBorder());
        } else if (paint instanceof BadgeRectProvider) {
            badgeShapeProviderModel = new BadgeRectProviderModel(((BadgeRectProvider)paint).getArc(), ((BadgeRectProvider)paint).getTop(), ((BadgeRectProvider)paint).getLeft(), ((BadgeRectProvider)paint).getRight(), ((BadgeRectProvider)paint).getBottom(), paint.getBorder());
        } else {
            BadgeIconConverter badgeIconConverter = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(BadgeIconConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown BadgeIconProvider. " + icon.getProvider().getClass());
            return null;
        }
        BadgeShapeProviderModel badgeShapeProviderModel2 = badgeShapeProviderModel;
        return new BadgeIconModel(iconModel2, (AbstractColor)object2, badgeShapeProviderModel2);
    }
}

