/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.ide.FixedProjectAvatarPresentation;
import com.intellij.ide.FullProjectAvatarPresentation;
import com.intellij.ide.ProjectAvatarPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.AvatarIcon;
import com.intellij.util.ui.AvatarPalette;
import com.intellij.util.ui.AvatarPresentation;
import com.intellij.util.ui.ColorPalette;
import com.intellij.util.ui.PaletteAvatarPresentation;
import com.jetbrains.rd.ide.model.AvatarIconModel;
import com.jetbrains.rd.ide.model.AvatarIconPresentationModel;
import com.jetbrains.rd.ide.model.FixedProjectAvatarIconPresentationModel;
import com.jetbrains.rd.ide.model.FullProjectAvatarIconPresentationModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.PaletteAvatarIconPresentationModel;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/AvatarIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/util/ui/AvatarIcon;", "Lcom/jetbrains/rd/ide/model/AvatarIconModel;", "AvatarIconConverter", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nAvatarIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvatarIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/AvatarIconConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n13#2:55\n13#2:57\n1#3:56\n*S KotlinDebug\n*F\n+ 1 AvatarIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/AvatarIconConverter\n*L\n27#1:55\n42#1:57\n*E\n"})
public final class AvatarIconConverter
implements ProtocolIconConverter<AvatarIcon, AvatarIconModel> {
    @Override
    @NotNull
    public Icon createIcon(@NotNull AvatarIconModel model2, @NotNull ProtocolIconRegistry registry) {
        AvatarIconModel avatarIconModel;
        AvatarPresentation avatarPresentation;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        AvatarIconPresentationModel avatarIconPresentationModel = model2.getPresentation();
        if (avatarIconPresentationModel instanceof PaletteAvatarIconPresentationModel) {
            avatarPresentation = (AvatarPresentation)new PaletteAvatarPresentation(((PaletteAvatarIconPresentationModel)avatarIconPresentationModel).getGradientSeed(), ((PaletteAvatarIconPresentationModel)avatarIconPresentationModel).getAvatarName(), (ColorPalette)AvatarPalette.INSTANCE);
        } else if (avatarIconPresentationModel instanceof FullProjectAvatarIconPresentationModel) {
            try {
                String string = ((FullProjectAvatarIconPresentationModel)avatarIconPresentationModel).getName();
                Path path2 = Path.of(((FullProjectAvatarIconPresentationModel)avatarIconPresentationModel).getPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
                avatarIconModel = (ProjectAvatarPresentation)new FullProjectAvatarPresentation(string, path2);
            }
            catch (InvalidPathException invalidPathException) {
                boolean bl = false;
                Logger logger = Logger.getInstance(AvatarIconConverter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)invalidPathException);
                avatarIconModel = (ProjectAvatarPresentation)new FixedProjectAvatarPresentation(((FullProjectAvatarIconPresentationModel)avatarIconPresentationModel).getName(), 0);
            }
            avatarPresentation = (AvatarPresentation)avatarIconModel;
        } else if (avatarIconPresentationModel instanceof FixedProjectAvatarIconPresentationModel) {
            avatarPresentation = (AvatarPresentation)new FixedProjectAvatarPresentation(((FixedProjectAvatarIconPresentationModel)avatarIconPresentationModel).getName(), ((FixedProjectAvatarIconPresentationModel)avatarIconPresentationModel).getFixedIndex());
        } else {
            throw new IllegalStateException(("unknown palette type " + avatarIconPresentationModel).toString());
        }
        AvatarPresentation avatarPresentation2 = avatarPresentation;
        avatarIconModel = model2;
        boolean bl = false;
        return (Icon)new AvatarIcon(avatarIconModel.getTargetSize(), avatarIconModel.getArcRatio(), avatarPresentation2);
    }

    @Override
    @NotNull
    public IconModel createModel(@NotNull AvatarIcon icon, @NotNull ProtocolIconModelRegistry registry) {
        AvatarIconPresentationModel avatarIconPresentationModel;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        AvatarPresentation avatarPresentation = icon.getPresentation();
        if (avatarPresentation instanceof PaletteAvatarPresentation) {
            boolean bl = false;
            Logger logger = Logger.getInstance(AvatarIconConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.assertTrue(((PaletteAvatarPresentation)avatarPresentation).getPalette() instanceof AvatarPalette, (Object)("unknown palette type " + ((PaletteAvatarPresentation)avatarPresentation).getPalette().getClass().getCanonicalName()));
            avatarIconPresentationModel = new PaletteAvatarIconPresentationModel(((PaletteAvatarPresentation)avatarPresentation).getGradientSeed(), ((PaletteAvatarPresentation)avatarPresentation).getName());
        } else if (avatarPresentation instanceof FullProjectAvatarPresentation) {
            avatarIconPresentationModel = new FullProjectAvatarIconPresentationModel(((FullProjectAvatarPresentation)avatarPresentation).getName(), PathsKt.getInvariantSeparatorsPathString((Path)((FullProjectAvatarPresentation)avatarPresentation).getPath()));
        } else if (avatarPresentation instanceof FixedProjectAvatarPresentation) {
            avatarIconPresentationModel = new FixedProjectAvatarIconPresentationModel(((FixedProjectAvatarPresentation)avatarPresentation).getName(), ((FixedProjectAvatarPresentation)avatarPresentation).getFixedIndex());
        } else {
            throw new IllegalStateException(("unknown presentation type " + avatarPresentation.getClass().getCanonicalName()).toString());
        }
        AvatarIconPresentationModel avatarIconPresentationModel2 = avatarIconPresentationModel;
        AvatarIcon avatarIcon = icon;
        boolean bl = false;
        return new AvatarIconModel(avatarIcon.getTargetSize(), avatarIcon.getArcRatio(), avatarIconPresentationModel2);
    }
}

