/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.utils;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.ide.model.uiautomation.BeAbstractText;
import com.jetbrains.ide.model.uiautomation.BeFontSize;
import com.jetbrains.ide.model.uiautomation.BeFontStyle;
import com.jetbrains.ide.model.uiautomation.BeLabel;
import com.jetbrains.ide.model.uiautomation.BeRichAttributedText;
import com.jetbrains.ide.model.uiautomation.BeRichText;
import com.jetbrains.ide.model.uiautomation.BeTextHorizontalPosition;
import com.jetbrains.ide.model.uiautomation.BeTextSettings;
import com.jetbrains.ide.model.uiautomation.ControlVisibility;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RichAttributedStringModel;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.ide.model.RichStringModel;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.ui.MaximumAndPreferredSizeLimitedComponentWrapperKt;
import com.jetbrains.rd.ui.ProtocolUIKt;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslTextPresentationKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.util.idea.ui.ModelRichTextExKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\u0003\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0003*\u00020\tH\u0000\u001a(\u0010\n\u001a\u00020\u000b*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a&\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u0011\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017*\u00020\u0013H\u0000\u001a\u000f\u0010\u0018\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0019*\u00020\u001a\u001a\u000f\u0010\u001b\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0019*\u00020\u001a\u001a\u0017\u0010\u001c\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00192\b\b\u0001\u0010\u001d\u001a\u00020\u0016H\u0000\u001a\u0016\u0010\u001e\u001a\u00020\u0016*\u00020\u00162\b\b\u0002\u0010\u001f\u001a\u00020\u000fH\u0007\u001a\f\u0010 \u001a\u00020!*\u00020\u001aH\u0000\u001a3\u0010\"\u001a\u00020#*\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u001d\u0010&\u001a\u0019\u0012\u0004\u0012\u00020%\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u0019\u0012\u0004\u0012\u00020#0'H\u0000\u001a$\u0010+\u001a\u00020,*\u00020-2\u0006\u0010$\u001a\u00020%2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u000fH\u0000\u001a\u0014\u00100\u001a\u00020,*\u00020\u001a2\u0006\u00101\u001a\u00020,H\u0000\u001a\u0014\u00102\u001a\u000203*\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0000\u001a\n\u00104\u001a\u000205*\u000206\"\u0018\u0010(\u001a\u00020\u000f*\u00020\u001a8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00067"}, d2={"getFontSize", "", "styledFont", "Ljava/awt/Font;", "size", "Lcom/jetbrains/ide/model/uiautomation/BeFontSize;", "toBeFontStyle", "Lcom/jetbrains/ide/model/uiautomation/BeFontStyle;", "getFont", "Lcom/jetbrains/ide/model/uiautomation/BeTextSettings;", "applyModel", "Lcom/intellij/ui/SimpleColoredComponent;", "modelRichText", "Lcom/jetbrains/rd/ide/model/RichTextModel;", "isSelected", "", "overrideFg", "Ljava/awt/Color;", "beRichText", "Lcom/jetbrains/ide/model/uiautomation/BeRichText;", "bg", "getHtmlLabelFromBeRichText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getLabelText", "Lorg/jetbrains/annotations/Nls;", "Lcom/jetbrains/ide/model/uiautomation/BeAbstractText;", "getSimpleText", "convertToDisabled", "result", "wrapToHtmlWrap", "wrap", "getLabelShortcut", "", "onTextChanged", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "onChange", "Lkotlin/Function2;", "shouldBeWrappedIntoHtml", "getShouldBeWrappedIntoHtml", "(Lcom/jetbrains/ide/model/uiautomation/BeAbstractText;)Z", "initFromText", "Ljavax/swing/JComponent;", "Ljavax/swing/AbstractButton;", "beAbstractText", "widthFromText", "allowWrapped", "component", "getLabelForAbstractText", "Ljavax/swing/JLabel;", "toJLabelTextPosition", "", "Lcom/jetbrains/ide/model/uiautomation/BeTextHorizontalPosition;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nBeTextSettingsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeTextSettingsUtil.kt\ncom/jetbrains/rd/ui/bindable/views/utils/BeTextSettingsUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1#2:309\n*E\n"})
public final class BeTextSettingsUtilKt {
    public static final float getFontSize(@NotNull Font styledFont, @NotNull BeFontSize size) {
        Intrinsics.checkNotNullParameter((Object)styledFont, (String)"styledFont");
        Intrinsics.checkNotNullParameter((Object)((Object)size), (String)"size");
        float f = styledFont.getSize();
        float f2 = switch (WhenMappings.$EnumSwitchMapping$0[size.ordinal()]) {
            case 1 -> f;
            case 2 -> UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            case 3 -> f + JBUIScale.scale((float)2.0f);
            case 4 -> f + JBUIScale.scale((float)2.0f);
            case 5 -> UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL);
            case 6 -> UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            case 7 -> UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI);
            default -> f;
        };
        return f2;
    }

    @NotNull
    public static final BeFontStyle toBeFontStyle(@Nullable Font $this$toBeFontStyle) {
        BeFontStyle beFontStyle;
        if (Intrinsics.areEqual((Object)$this$toBeFontStyle, (Object)EditorUtil.getEditorFont())) {
            beFontStyle = BeFontStyle.MONOSPACE;
        } else {
            Font font = $this$toBeFontStyle;
            boolean bl = font != null ? font.isBold() : false;
            if (bl) {
                beFontStyle = BeFontStyle.BOLD;
            } else {
                Font font2 = $this$toBeFontStyle;
                beFontStyle = (font2 != null ? font2.isItalic() : false) ? BeFontStyle.ITALIC : BeFontStyle.DEFAULT;
            }
        }
        return beFontStyle;
    }

    @Nullable
    public static final Font getFont(@NotNull BeTextSettings $this$getFont) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getFont), (String)"<this>");
        Font font = switch (WhenMappings.$EnumSwitchMapping$1[((BeFontStyle)((Object)InterfacesKt.valueOrDefault($this$getFont.getFontStyle(), (Object)((Object)BeFontStyle.DEFAULT)))).ordinal()]) {
            case 1 -> (Font)JBFont.label();
            case 2 -> EditorUtil.getEditorFont();
            case 3 -> JBFont.label().deriveFont(1);
            case 4 -> JBFont.label().deriveFont(1);
            case 5 -> JBFont.label().deriveFont(2);
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)font);
        float f = BeTextSettingsUtilKt.getFontSize(font, (BeFontSize)((Object)InterfacesKt.valueOrDefault($this$getFont.getFontSize(), (Object)((Object)BeFontSize.DEFAULT))));
        return font.deriveFont(f);
    }

    @NotNull
    public static final SimpleColoredComponent applyModel(@NotNull SimpleColoredComponent $this$applyModel, @Nullable RichTextModel modelRichText, boolean isSelected, @Nullable Color overrideFg) {
        SimpleColoredComponent simpleColoredComponent;
        Intrinsics.checkNotNullParameter((Object)$this$applyModel, (String)"<this>");
        SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent = $this$applyModel;
        boolean bl = false;
        simpleColoredComponent2.clear();
        if (modelRichText != null) {
            for (RichStringModel richStringModel : modelRichText.getParts()) {
                SimpleTextAttributes simpleTextAttributes = ModelRichTextExKt.toSimpleTextAttributes(richStringModel, null, overrideFg, overrideFg == null);
                if (isSelected) {
                    SimpleTextAttributes simpleTextAttributes2 = simpleTextAttributes.derive(-1, null, null, null);
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"derive(...)");
                    simpleTextAttributes = simpleTextAttributes2;
                }
                simpleColoredComponent2.append(richStringModel.getText(), simpleTextAttributes);
            }
        }
        return simpleColoredComponent;
    }

    public static /* synthetic */ SimpleColoredComponent applyModel$default(SimpleColoredComponent simpleColoredComponent, RichTextModel richTextModel, boolean bl, Color color, int n, Object object) {
        if ((n & 4) != 0) {
            color = null;
        }
        return BeTextSettingsUtilKt.applyModel(simpleColoredComponent, richTextModel, bl, color);
    }

    @NotNull
    public static final SimpleColoredComponent applyModel(@NotNull SimpleColoredComponent $this$applyModel, @NotNull BeRichText beRichText, @NotNull Color bg, @Nullable Color overrideFg) {
        SimpleColoredComponent simpleColoredComponent;
        Intrinsics.checkNotNullParameter((Object)$this$applyModel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)beRichText), (String)"beRichText");
        Intrinsics.checkNotNullParameter((Object)bg, (String)"bg");
        SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent = $this$applyModel;
        boolean bl = false;
        RichTextModel richTextModel = (RichTextModel)beRichText.getText().getValueOrNull();
        simpleColoredComponent2.clear();
        if (richTextModel != null) {
            for (RichStringModel richStringModel : richTextModel.getParts()) {
                SimpleTextAttributes simpleTextAttributes = ModelRichTextExKt.toSimpleTextAttributes(richStringModel, bg, overrideFg, overrideFg == null);
                if (InterfacesKt.valueOrDefault(beRichText.getSettings().getFontSize(), (Object)((Object)BeFontSize.DEFAULT)) == BeFontSize.SMALLER) {
                    SimpleTextAttributes simpleTextAttributes2 = simpleTextAttributes.derive(128, null, null, null);
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"derive(...)");
                    simpleTextAttributes = simpleTextAttributes2;
                }
                simpleColoredComponent2.append(richStringModel.getText(), simpleTextAttributes);
            }
        }
        return simpleColoredComponent;
    }

    public static /* synthetic */ SimpleColoredComponent applyModel$default(SimpleColoredComponent simpleColoredComponent, BeRichText beRichText, Color color, Color color2, int n, Object object) {
        if ((n & 4) != 0) {
            color2 = null;
        }
        return BeTextSettingsUtilKt.applyModel(simpleColoredComponent, beRichText, color, color2);
    }

    @NotNull
    public static final String getHtmlLabelFromBeRichText(@NotNull BeRichText $this$getHtmlLabelFromBeRichText) {
        Object object;
        var var2_2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getHtmlLabelFromBeRichText), (String)"<this>");
        RichTextModel richTextModel = (RichTextModel)$this$getHtmlLabelFromBeRichText.getText().getValueOrNull();
        if (richTextModel == null) {
            return "invalid";
        }
        RichTextModel richTextModel2 = richTextModel;
        if (((Number)$this$getHtmlLabelFromBeRichText.getShortcutIndex().getValue()).intValue() >= 0) {
            return ProtocolUIKt.toSimpleText(richTextModel2);
        }
        Object object2 = var2_2 = new SimpleColoredComponent(){

            public final JLabel toLabel() {
                JLabel jLabel = this.formatToLabel(new JLabel());
                Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"formatToLabel(...)");
                return jLabel;
            }
        };
        boolean bl = false;
        SimpleColoredComponent simpleColoredComponent = object2;
        Color color = UIUtil.getLabelBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelBackground(...)");
        BeTextSettingsUtilKt.applyModel$default(simpleColoredComponent, $this$getHtmlLabelFromBeRichText, color, null, 4, null);
        object2 = var2_2.toLabel().getText();
        bl = false;
        if ($this$getHtmlLabelFromBeRichText.getWrapText()) {
            Intrinsics.checkNotNull((Object)object2);
            object = StringsKt.replace$default((String)object2, (String)"nowrap", (String)"normal", (boolean)false, (int)4, null);
        } else {
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        return object;
    }

    @NotNull
    public static final String getLabelText(@NotNull BeAbstractText $this$getLabelText) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getLabelText), (String)"<this>");
        Object object = $this$getLabelText;
        if (object instanceof BeLabel) {
            if (!BeTextSettingsUtilKt.getShouldBeWrappedIntoHtml($this$getLabelText)) {
                return (String)((BeLabel)$this$getLabelText).getText().getValue();
            }
            string = BeTextSettingsUtilKt.wrapToHtmlWrap$default((String)((BeLabel)$this$getLabelText).getText().getValue(), false, 1, null);
        } else {
            string = object instanceof BeRichText ? BeTextSettingsUtilKt.getHtmlLabelFromBeRichText((BeRichText)$this$getLabelText) : "";
        }
        String string2 = string;
        object = StringsKt.replace$default((String)string2, (String)"\n", (String)"<br/>", (boolean)false, (int)4, null);
        return (Boolean)$this$getLabelText.getEnabled().getValue() == false ? BeTextSettingsUtilKt.convertToDisabled((String)object) : object;
    }

    @NotNull
    public static final String getSimpleText(@NotNull BeAbstractText $this$getSimpleText) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getSimpleText), (String)"<this>");
        BeAbstractText beAbstractText = $this$getSimpleText;
        if (beAbstractText instanceof BeLabel) {
            object = (String)((BeLabel)$this$getSimpleText).getText().getValue();
        } else if (beAbstractText instanceof BeRichText) {
            object = (RichTextModel)((BeRichText)$this$getSimpleText).getText().getValueOrNull();
            if (object == null || (object = ProtocolUIKt.toSimpleText((RichTextModel)object)) == null) {
                object = "";
            }
        } else if (beAbstractText instanceof BeRichAttributedText) {
            object = (RichAttributedTextModel)((BeRichAttributedText)$this$getSimpleText).getText().getValueOrNull();
            if (object == null || (object = ((RichAttributedTextModel)object).getParts()) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), null, null, null, (int)0, null, BeTextSettingsUtilKt::x, (int)31, null)) == null) {
                object = "";
            }
        } else {
            object = "";
        }
        return object;
    }

    @NotNull
    public static final String convertToDisabled(@Nls @NotNull String result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        String string = result2;
        Color color = UIUtil.getLabelDisabledForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelDisabledForeground(...)");
        Color color2 = color;
        string = StringsKt.replace$default((String)string, (String)"<html>", (String)("<html><font color='rgb(" + color2.getRed() + ", " + color2.getGreen() + ", " + color2.getBlue() + ")'>"), (boolean)false, (int)4, null);
        return string;
    }

    @Nls
    @NotNull
    public static final String wrapToHtmlWrap(@NotNull String $this$wrapToHtmlWrap, boolean wrap) {
        Intrinsics.checkNotNullParameter((Object)$this$wrapToHtmlWrap, (String)"<this>");
        String string = wrap ? "normal" : "nowrap";
        return "<html><body style=\"white-space:" + string + "\"> " + $this$wrapToHtmlWrap + " </body></html>";
    }

    public static /* synthetic */ String wrapToHtmlWrap$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return BeTextSettingsUtilKt.wrapToHtmlWrap(string, bl);
    }

    public static final char getLabelShortcut(@NotNull BeAbstractText $this$getLabelShortcut) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getLabelShortcut), (String)"<this>");
        return BeTextSettingsUtilKt.getLabelText($this$getLabelShortcut).charAt(((Number)$this$getLabelShortcut.getShortcutIndex().getValue()).intValue());
    }

    public static final void onTextChanged(@NotNull BeAbstractText $this$onTextChanged, @NotNull Lifetime lifetime, @NotNull Function2<? super Lifetime, ? super String, Unit> onChange) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$onTextChanged), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onChange, (String)"onChange");
        BeAbstractText beAbstractText = $this$onTextChanged;
        if (beAbstractText instanceof BeLabel) {
            ((BeLabel)$this$onTextChanged).getText().view(lifetime, (arg_0, arg_1) -> BeTextSettingsUtilKt.x(onChange, $this$onTextChanged, arg_0, arg_1));
        } else if (beAbstractText instanceof BeRichText) {
            ((BeRichText)$this$onTextChanged).getText().view(lifetime, (arg_0, arg_1) -> BeTextSettingsUtilKt.x(onChange, $this$onTextChanged, arg_0, arg_1));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getShouldBeWrappedIntoHtml(@NotNull BeAbstractText $this$shouldBeWrappedIntoHtml) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$shouldBeWrappedIntoHtml), (String)"<this>");
        if ($this$shouldBeWrappedIntoHtml.getWrapText()) return true;
        BeAbstractText beAbstractText = $this$shouldBeWrappedIntoHtml;
        if (!(beAbstractText instanceof BeLabel)) {
            if (!(beAbstractText instanceof BeRichText)) return false;
            Object object = (RichTextModel)((BeRichText)$this$shouldBeWrappedIntoHtml).getText().getValueOrNull();
            if (object != null && (object = ProtocolUIKt.toSimpleText((RichTextModel)object)) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"\n", (boolean)false, (int)2, null) : false) return true;
            if (((Number)$this$shouldBeWrappedIntoHtml.getShortcutIndex().getValue()).intValue() < 0) return false;
            return true;
        }
        boolean bl = StringsKt.contains$default((CharSequence)((CharSequence)((BeLabel)$this$shouldBeWrappedIntoHtml).getText().getValue()), (CharSequence)"\n", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    @NotNull
    public static final JComponent initFromText(@NotNull AbstractButton $this$initFromText, @NotNull Lifetime lifetime, @NotNull BeAbstractText beAbstractText, boolean widthFromText) {
        Intrinsics.checkNotNullParameter((Object)$this$initFromText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)beAbstractText), (String)"beAbstractText");
        String string = BeTextSettingsUtilKt.getLabelText(beAbstractText);
        $this$initFromText.setText(string);
        BeTextSettingsUtilKt.onTextChanged(beAbstractText, lifetime, (Function2<? super Lifetime, ? super String, Unit>)((Function2)(arg_0, arg_1) -> BeTextSettingsUtilKt.x($this$initFromText, arg_0, arg_1)));
        int n = ((Number)beAbstractText.getShortcutIndex().getValue()).intValue();
        if (n >= 0) {
            $this$initFromText.setMnemonic(BeTextSettingsUtilKt.getLabelShortcut(beAbstractText));
            $this$initFromText.setDisplayedMnemonicIndex(n);
        }
        $this$initFromText.setRequestFocusEnabled(true);
        beAbstractText.getIcon().advise(lifetime, arg_0 -> BeTextSettingsUtilKt.x($this$initFromText, arg_0));
        beAbstractText.getEnabled().advise(lifetime, arg_0 -> BeTextSettingsUtilKt.x(beAbstractText, $this$initFromText, arg_0));
        beAbstractText.getTooltip().advise(lifetime, arg_0 -> BeTextSettingsUtilKt.x($this$initFromText, arg_0));
        BeTextSettings beTextSettings = BeDslTextPresentationKt.tryGetSettings(beAbstractText);
        if (beTextSettings != null) {
            $this$initFromText.setFont(BeTextSettingsUtilKt.getFont(beTextSettings));
        }
        if (widthFromText) {
            FontMetrics fontMetrics = $this$initFromText.getFontMetrics($this$initFromText.getFont());
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            FontMetrics fontMetrics2 = fontMetrics;
            int n2 = fontMetrics2.stringWidth($this$initFromText.getText());
            Dimension dimension = new Dimension(n2 + 20, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.height);
            $this$initFromText.setPreferredSize(dimension);
            $this$initFromText.setMinimumSize(dimension);
        }
        return BeTextSettingsUtilKt.allowWrapped(beAbstractText, $this$initFromText);
    }

    @NotNull
    public static final JComponent allowWrapped(@NotNull BeAbstractText $this$allowWrapped, @NotNull JComponent component) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$allowWrapped), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if ($this$allowWrapped.getWrapText()) {
            jComponent = MaximumAndPreferredSizeLimitedComponentWrapperKt.fillWidthWithWrapping(component, false);
        } else {
            BorderLayoutPanel borderLayoutPanel;
            BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = JBUI.Panels.simplePanel();
            boolean bl = false;
            borderLayoutPanel2.add((Component)component, (Object)"West");
            BorderLayoutPanel borderLayoutPanel3 = borderLayoutPanel;
            Intrinsics.checkNotNull((Object)borderLayoutPanel3);
            jComponent = (JComponent)borderLayoutPanel3;
        }
        return jComponent;
    }

    @NotNull
    public static final JLabel getLabelForAbstractText(@NotNull BeAbstractText $this$getLabelForAbstractText, @NotNull Lifetime lifetime) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getLabelForAbstractText), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Object object = jBLabel = new JBLabel();
        boolean bl = false;
        object.setBorder((Border)JBUI.Borders.empty());
        object.setHorizontalAlignment(2);
        object.setVerticalAlignment(0);
        object.setHorizontalTextPosition(BeTextSettingsUtilKt.toJLabelTextPosition((BeTextHorizontalPosition)((Object)InterfacesKt.valueOrDefault($this$getLabelForAbstractText.getHorizontalTextPosition(), (Object)((Object)BeTextHorizontalPosition.TRAILING)))));
        object.setOpaque(false);
        JBLabel jBLabel2 = jBLabel;
        BeTextSettingsUtilKt.onTextChanged($this$getLabelForAbstractText, lifetime, (Function2<? super Lifetime, ? super String, Unit>)((Function2)(arg_0, arg_1) -> BeTextSettingsUtilKt.x(jBLabel2, arg_0, arg_1)));
        int n = ((Number)$this$getLabelForAbstractText.getShortcutIndex().getValue()).intValue();
        if (n >= 0) {
            char c = BeTextSettingsUtilKt.getLabelShortcut($this$getLabelForAbstractText);
            jBLabel2.setDisplayedMnemonic(c);
            jBLabel2.setDisplayedMnemonicIndex(n);
        }
        $this$getLabelForAbstractText.getIcon().advise(lifetime, arg_0 -> BeTextSettingsUtilKt.x(jBLabel2, arg_0));
        $this$getLabelForAbstractText.getEnabled().advise(lifetime, arg_0 -> BeTextSettingsUtilKt.x($this$getLabelForAbstractText, jBLabel2, arg_0));
        SourceExKt.adviseNotNull((ISource)((ISource)$this$getLabelForAbstractText.getVisible()), (Lifetime)lifetime, arg_0 -> BeTextSettingsUtilKt.x(jBLabel2, arg_0));
        $this$getLabelForAbstractText.getTooltip().advise(lifetime, arg_0 -> BeTextSettingsUtilKt.x(jBLabel2, arg_0));
        object = BeDslTextPresentationKt.tryGetSettings($this$getLabelForAbstractText);
        if (object != null) {
            jBLabel2.setFont(BeTextSettingsUtilKt.getFont((BeTextSettings)((Object)object)));
        }
        return (JLabel)jBLabel2;
    }

    public static final int toJLabelTextPosition(@NotNull BeTextHorizontalPosition $this$toJLabelTextPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toJLabelTextPosition), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$toJLabelTextPosition.ordinal()]) {
            case 1 -> 10;
            case 2 -> 11;
            case 3 -> 2;
            case 4 -> 4;
            case 5 -> 0;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final CharSequence x(RichAttributedStringModel richAttributedStringModel) {
        Intrinsics.checkNotNullParameter((Object)richAttributedStringModel, (String)"it");
        return richAttributedStringModel.getText();
    }

    private static final Unit x(Function2 function2, BeAbstractText beAbstractText, Lifetime lifetime, String string) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        function2.invoke((Object)lifetime, (Object)BeTextSettingsUtilKt.getLabelText(beAbstractText));
        return Unit.INSTANCE;
    }

    private static final Unit x(Function2 function2, BeAbstractText beAbstractText, Lifetime lifetime, RichTextModel richTextModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)richTextModel, (String)"<unused var>");
        function2.invoke((Object)lifetime, (Object)BeTextSettingsUtilKt.getLabelText(beAbstractText));
        return Unit.INSTANCE;
    }

    private static final Unit x(AbstractButton abstractButton, Lifetime lifetime, String string) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"s");
        abstractButton.setText(string);
        abstractButton.revalidate();
        return Unit.INSTANCE;
    }

    private static final Unit x(AbstractButton abstractButton, IconModel iconModel) {
        IconModel iconModel2 = iconModel;
        abstractButton.setIcon(iconModel2 != null ? UtilKt.fromModel(iconModel2) : null);
        IconModel iconModel3 = iconModel;
        abstractButton.setDisabledIcon(iconModel3 != null ? UtilKt.fromModel(iconModel3) : null);
        return Unit.INSTANCE;
    }

    private static final Unit x(BeAbstractText beAbstractText, AbstractButton abstractButton, boolean bl) {
        if (BeTextSettingsUtilKt.getShouldBeWrappedIntoHtml(beAbstractText)) {
            abstractButton.setText(BeTextSettingsUtilKt.getLabelText(beAbstractText));
        } else {
            abstractButton.setEnabled(bl);
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(AbstractButton abstractButton, String string) {
        abstractButton.setToolTipText(string);
        return Unit.INSTANCE;
    }

    private static final Unit x(JBLabel jBLabel, Lifetime lifetime, String string) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"s");
        jBLabel.setText(string);
        jBLabel.revalidate();
        return Unit.INSTANCE;
    }

    private static final Unit x(JBLabel jBLabel, IconModel iconModel) {
        IconModel iconModel2 = iconModel;
        jBLabel.setIcon(iconModel2 != null ? UtilKt.fromModel(iconModel2) : null);
        if (jBLabel.getDisabledIcon() == null) {
            IconModel iconModel3 = iconModel;
            jBLabel.setDisabledIcon(iconModel3 != null ? UtilKt.fromModel(iconModel3) : null);
        }
        jBLabel.revalidate();
        return Unit.INSTANCE;
    }

    private static final Unit x(BeAbstractText beAbstractText, JBLabel jBLabel, boolean bl) {
        if (BeTextSettingsUtilKt.getShouldBeWrappedIntoHtml(beAbstractText)) {
            jBLabel.setText(BeTextSettingsUtilKt.getLabelText(beAbstractText));
        } else {
            jBLabel.setEnabled(bl);
        }
        jBLabel.repaint();
        return Unit.INSTANCE;
    }

    private static final Unit x(JBLabel jBLabel, ControlVisibility controlVisibility) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlVisibility), (String)"it");
        jBLabel.setVisible(controlVisibility == ControlVisibility.Visible);
        return Unit.INSTANCE;
    }

    private static final Unit x(JBLabel jBLabel, String string) {
        jBLabel.setToolTipText(string);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[BeFontSize.values().length];
            try {
                nArray[BeFontSize.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontSize.SMALLER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontSize.BIGGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontSize.LARGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontSize.MEDIUM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontSize.SMALL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontSize.CAPTION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BeFontStyle.values().length];
            try {
                nArray[BeFontStyle.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontStyle.MONOSPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontStyle.BOLD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontStyle.SEMIBOLD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeFontStyle.ITALIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[BeTextHorizontalPosition.values().length];
            try {
                nArray[BeTextHorizontalPosition.LEADING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeTextHorizontalPosition.TRAILING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeTextHorizontalPosition.LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeTextHorizontalPosition.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeTextHorizontalPosition.CENTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

