/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.listControl;

import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeTable;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/listControl/TreeTableMouseMotionListener;", "Ljava/awt/event/MouseMotionAdapter;", "treeTable", "Lcom/jetbrains/rd/ui/bindable/views/listControl/BeTreeTable;", "TreeTableMouseMotionListener", "(Lcom/jetbrains/rd/ui/bindable/views/listControl/BeTreeTable;)V", "myIsEngaged", "", "myLastSelectedIndex", "", "myLastMouseLocation", "Ljava/awt/Point;", "x", "location", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.rd.ui"})
public final class TreeTableMouseMotionListener
extends MouseMotionAdapter {
    @NotNull
    private final BeTreeTable treeTable;
    private boolean myIsEngaged;
    private int myLastSelectedIndex;
    @Nullable
    private Point myLastMouseLocation;

    public TreeTableMouseMotionListener(@NotNull BeTreeTable treeTable) {
        Intrinsics.checkNotNullParameter((Object)((Object)treeTable), (String)"treeTable");
        this.treeTable = treeTable;
        this.myLastSelectedIndex = -2;
    }

    private final boolean x(Point point) {
        if (this.myLastMouseLocation == null) {
            this.myLastMouseLocation = point;
            return false;
        }
        return !Intrinsics.areEqual((Object)this.myLastMouseLocation, (Object)point);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Point point = e.getLocationOnScreen();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
        if (!this.x(point)) {
            return;
        }
        Point point2 = e.getPoint();
        if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e) && this.treeTable.getSelectedRowCount() <= 1) {
            int n = this.treeTable.rowAtPoint(point2);
            if (n != this.myLastSelectedIndex && n >= 0) {
                this.treeTable.putClientProperty("byMouseEvent", true);
                this.treeTable.setRowSelectionInterval(n, n);
                this.treeTable.putClientProperty("byMouseEvent", false);
                this.myLastSelectedIndex = n;
            }
        } else {
            this.myIsEngaged = true;
        }
    }
}

