/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.DocumentUtil;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.ide.model.uiautomation.BeEditor;
import com.jetbrains.ide.model.uiautomation.BeEditorSettings;
import com.jetbrains.ide.model.uiautomation.BeIdeaEditorSettings;
import com.jetbrains.ide.model.uiautomation.ControlVisibility;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.RichAttributedStringModel;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/EditorViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeEditor;", "EditorViewControl", "()V", "reentrancyPreventer", "Lcom/jetbrains/rd/ui/bedsl/extensions/UpdateFlag;", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "x", "", "document", "Lcom/intellij/openapi/editor/Document;", "action", "Lkotlin/Function0;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nEditorViewControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/EditorViewControl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1869#2,2:127\n*S KotlinDebug\n*F\n+ 1 EditorViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/EditorViewControl\n*L\n87#1:127,2\n*E\n"})
public final class EditorViewControl
implements ViewBinder<BeEditor> {
    @NotNull
    private final UpdateFlag reentrancyPreventer = new UpdateFlag();

    @Override
    @NotNull
    public JComponent bind(@NotNull BeEditor viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JComponent jComponent = this.getEditor(viewModel, lifetime).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public final EditorEx getEditor(@NotNull BeEditor viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        Document document2 = document;
        document2.setReadOnly(((Boolean)viewModel.isReadonly().getValue()).booleanValue());
        RdProjectId rdProjectId = viewModel.getProjectId();
        Project project = rdProjectId != null ? ProjectUtilKt.toProject(rdProjectId) : null;
        Editor editor = editorFactory.createEditor(document2, project);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editorEx = (EditorEx)editor;
        lifetime.onTermination(() -> EditorViewControl.x(editorEx));
        BeEditorSettings beEditorSettings = (BeEditorSettings)((Object)viewModel.getSettings().getValue());
        if (beEditorSettings instanceof BeIdeaEditorSettings) {
            editorEx.getSettings().setAdditionalColumnsCount(((BeIdeaEditorSettings)beEditorSettings).getAdditionalColumnsCount());
            editorEx.getSettings().setAdditionalLinesCount(((BeIdeaEditorSettings)beEditorSettings).getAdditionalLinesCount());
            editorEx.getSettings().setRightMargin(((BeIdeaEditorSettings)beEditorSettings).getRightMargin());
            editorEx.getSettings().setLineCursorWidth(((BeIdeaEditorSettings)beEditorSettings).getLineCursorWidth());
            editorEx.getSettings().setCaretRowShown(((BeIdeaEditorSettings)beEditorSettings).isCaretRowShown());
            editorEx.getSettings().setFoldingOutlineShown(((BeIdeaEditorSettings)beEditorSettings).isFoldingOutlineShown());
            editorEx.getSettings().setIndentGuidesShown(((BeIdeaEditorSettings)beEditorSettings).isIndentGuidesShown());
            editorEx.getSettings().setLineMarkerAreaShown(((BeIdeaEditorSettings)beEditorSettings).isLineMarkerAreaShown());
            editorEx.getSettings().setLineNumbersShown(((BeIdeaEditorSettings)beEditorSettings).isLineNumbersShown());
            editorEx.getSettings().setUseSoftWraps(((BeIdeaEditorSettings)beEditorSettings).isUseSoftWraps());
            editorEx.getSettings().setWhitespacesShown(((BeIdeaEditorSettings)beEditorSettings).isWhitespacesShown());
            editorEx.getSettings().setShowingSpecialChars(((BeIdeaEditorSettings)beEditorSettings).isShowingSpecialChars());
            editorEx.setOneLineMode(((BeIdeaEditorSettings)beEditorSettings).isOneLineMode());
            editorEx.getSettings().setRightMarginShown(((BeIdeaEditorSettings)beEditorSettings).isRightMarginShown());
            editorEx.getSettings().setVirtualSpace(((BeIdeaEditorSettings)beEditorSettings).isVirtualSpace());
            editorEx.getSettings().setWheelFontChangeEnabled(((BeIdeaEditorSettings)beEditorSettings).isWheelFontChangeEnabled());
            editorEx.getSettings().setAdditionalPageAtBottom(((BeIdeaEditorSettings)beEditorSettings).isAdditionalPageAtBottom());
            editorEx.setHorizontalScrollbarVisible(((BeIdeaEditorSettings)beEditorSettings).isHorizontalScrollBarVisible());
            editorEx.setVerticalScrollbarVisible(((BeIdeaEditorSettings)beEditorSettings).isVerticalScrollBarVisible());
        } else {
            editorEx.setHorizontalScrollbarVisible(true);
            editorEx.setVerticalScrollbarVisible(true);
        }
        editorEx.getScrollPane().getVerticalScrollBar().setBackground(editorEx.getBackgroundColor());
        editorEx.getScrollPane().getHorizontalScrollBar().setBackground(editorEx.getBackgroundColor());
        viewModel.getText().getText().advise(lifetime, arg_0 -> EditorViewControl.x(this, document2, project, arg_0));
        viewModel.getEnabled().advise(lifetime, arg_0 -> EditorViewControl.x(editorEx, arg_0));
        viewModel.getVisible().advise(lifetime, arg_0 -> EditorViewControl.x(editorEx, arg_0));
        return editorEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void x(Document document, Function0<Unit> function0) {
        if (document.isWritable()) {
            function0.invoke();
        } else {
            document.setReadOnly(false);
            try {
                function0.invoke();
            }
            finally {
                document.setReadOnly(true);
            }
        }
    }

    private static final Unit x(EditorEx editorEx) {
        if (!editorEx.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)editorEx);
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(EditorViewControl editorViewControl, Document document, Project project, RichAttributedTextModel richAttributedTextModel) {
        Intrinsics.checkNotNullParameter((Object)richAttributedTextModel, (String)"it");
        LocalChangeKt.ignoreOnReentrancy(editorViewControl.reentrancyPreventer, (Function0<Unit>)((Function0)() -> EditorViewControl.x(document, project, editorViewControl, richAttributedTextModel)));
        return Unit.INSTANCE;
    }

    private static final Unit x(Document document, Project project, EditorViewControl editorViewControl, RichAttributedTextModel richAttributedTextModel) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markupModelEx = (MarkupModelEx)markupModel;
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> EditorViewControl.G(markupModelEx, editorViewControl, document, richAttributedTextModel));
        return Unit.INSTANCE;
    }

    private static final void G(MarkupModelEx markupModelEx, EditorViewControl editorViewControl, Document document, RichAttributedTextModel richAttributedTextModel) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> EditorViewControl.x(markupModelEx, editorViewControl, document, richAttributedTextModel));
    }

    private static final void x(MarkupModelEx markupModelEx, EditorViewControl editorViewControl, Document document, RichAttributedTextModel richAttributedTextModel) {
        markupModelEx.removeAllHighlighters();
        editorViewControl.x(document, (Function0<Unit>)((Function0)() -> EditorViewControl.x(document, richAttributedTextModel)));
        int n = 0;
        Iterable iterable = richAttributedTextModel.getParts();
        boolean bl = false;
        for (Object t : iterable) {
            RichAttributedStringModel richAttributedStringModel = (RichAttributedStringModel)t;
            boolean bl2 = false;
            String string = richAttributedStringModel.getText();
            TextAttributesKeyModel textAttributesKeyModel = richAttributedStringModel.getTextAttributesKey();
            if (textAttributesKeyModel != null) {
                TextAttributesRegistrationHost textAttributesRegistrationHost = TextAttributesRegistrationHost.Companion.getInstance();
                int n2 = n + string.length();
                TextAttributes textAttributes = TextAttributesRegistrationHost.getTextAttributes$default(textAttributesRegistrationHost, textAttributesKeyModel, null, 2, null);
                if (textAttributes == null) {
                    textAttributes = new TextAttributes();
                }
                markupModelEx.addRangeHighlighter(n, n2, 3000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
            n += string.length();
        }
    }

    private static final Unit x(Document document, RichAttributedTextModel richAttributedTextModel) {
        document.setText((CharSequence)CollectionsKt.joinToString$default((Iterable)richAttributedTextModel.getParts(), (CharSequence)"", null, null, (int)0, null, EditorViewControl::x, (int)30, null));
        return Unit.INSTANCE;
    }

    private static final CharSequence x(RichAttributedStringModel richAttributedStringModel) {
        Intrinsics.checkNotNullParameter((Object)richAttributedStringModel, (String)"it");
        return richAttributedStringModel.getText();
    }

    private static final Unit x(EditorEx editorEx, boolean bl) {
        editorEx.getComponent().setEnabled(bl);
        return Unit.INSTANCE;
    }

    private static final Unit x(EditorEx editorEx, ControlVisibility controlVisibility) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlVisibility), (String)"it");
        editorEx.getComponent().setVisible(controlVisibility == ControlVisibility.Visible);
        return Unit.INSTANCE;
    }
}

