/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.tracing;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import com.intellij.internal.statistic.utils.EventsRateWindowThrottle;
import com.intellij.openapi.fileTypes.FileType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003NOPB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J,\u0010\u0015\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014JN\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001cJ.\u0010 \u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u001c2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0011JP\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010*\u001a\u0004\u0018\u00010+R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u001705X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\u001a05X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\u0002088\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0016\u0010;\u001a\u0002088\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010:R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\u0002088\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010:R\u0016\u0010B\u001a\u0002088\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010:R(\u0010D\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00110E8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/jetbrains/rd/tracing/SyncEventsLogger;", "", "SyncEventsLogger", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGROUP", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "ACCEPTABLE_DURATION_IN_QUEUE", "", "ACCEPTABLE_PROCESSING_DURATION", "throttleRequestsInQueue", "Lcom/intellij/internal/statistic/utils/EventsRateWindowThrottle;", "throttleRequestsCompleted", "logRequestInQueueDuration", "", "requestType", "Ljava/lang/Class;", "durationMs", "actionId", "", "logRequestCompleted", "responseType", "Lcom/jetbrains/rd/tracing/SyncEventsLogger$ResponseType;", "logRebase", "sessionType", "Lcom/jetbrains/rd/tracing/SyncEventsLogger$RebaseSessionType;", "undoneRequests", "", "redoneRequests", "cancelledRequests", "batchSize", "logConflict", "logRecovery", "droppedRequests", "recoveryReason", "logCaretChange", "isInitialChange", "", "caretChange", "lineChange", "columnChange", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "UNDONE_REQUESTS", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "REDONE_REQUESTS", "CANCELLED_REQUESTS", "RECOVERY_REASON", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "BATCH_SIZE", "REQUEST_TYPE", "RESPONSE_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "SESSION_TYPE", "REQUEST_IN_QUEUE_DURATION", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "getREQUEST_IN_QUEUE_DURATION", "()Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "REQUEST_COMPLETED_DURATION", "getREQUEST_COMPLETED_DURATION", "TOO_MANY_IN_QUEUE_EVENTS", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "TOO_MANY_COMPLETED_EVENTS", "REBASE_EVENT", "getREBASE_EVENT", "CONFLICT_EVENT", "getCONFLICT_EVENT", "RECOVERY_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "getRECOVERY_EVENT", "()Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "IS_INITIAL_CARET_CHANGE", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "CARET_OFFSET_CHANGE", "CARET_LINE_CHANGE", "CARET_COLUMN_CHANGE", "CARET_CHANGE_EVENT", "MetricsCollector", "ResponseType", "RebaseSessionType", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nSyncEventsLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncEventsLogger.kt\ncom/jetbrains/rd/tracing/SyncEventsLogger\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,247:1\n37#2,2:248\n261#3,3:250\n261#3,3:253\n*S KotlinDebug\n*F\n+ 1 SyncEventsLogger.kt\ncom/jetbrains/rd/tracing/SyncEventsLogger\n*L\n119#1:248,2\n175#1:250,3\n184#1:253,3\n*E\n"})
public final class SyncEventsLogger {
    @NotNull
    public static final SyncEventsLogger INSTANCE = new SyncEventsLogger();
    @VisibleForTesting
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("rdct.editor.synchronization.events", 4, null, 4, null);
    @VisibleForTesting
    public static final long ACCEPTABLE_DURATION_IN_QUEUE = 100L;
    @VisibleForTesting
    public static final long ACCEPTABLE_PROCESSING_DURATION = 200L;
    @NotNull
    private static final EventsRateWindowThrottle throttleRequestsInQueue = new EventsRateWindowThrottle(4000, Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS)), System.currentTimeMillis());
    @NotNull
    private static final EventsRateWindowThrottle throttleRequestsCompleted = new EventsRateWindowThrottle(4000, Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS)), System.currentTimeMillis());
    @NotNull
    private static final IntEventField UNDONE_REQUESTS = EventFields.Int((String)"undone_requests");
    @NotNull
    private static final IntEventField REDONE_REQUESTS = EventFields.Int((String)"redone_requests");
    @NotNull
    private static final IntEventField CANCELLED_REQUESTS = EventFields.Int((String)"cancelled_requests");
    @NotNull
    private static final ClassEventField RECOVERY_REASON = new ClassEventField("recovery_reason", null, 2, null);
    @NotNull
    private static final IntEventField BATCH_SIZE = EventFields.Int((String)"elements_in_session");
    @NotNull
    private static final ClassEventField REQUEST_TYPE = new ClassEventField("request_type", null, 2, null);
    @NotNull
    private static final EnumEventField<ResponseType> RESPONSE_TYPE;
    @NotNull
    private static final EnumEventField<RebaseSessionType> SESSION_TYPE;
    @VisibleForTesting
    @NotNull
    private static final VarargEventId REQUEST_IN_QUEUE_DURATION;
    @VisibleForTesting
    @NotNull
    private static final VarargEventId REQUEST_COMPLETED_DURATION;
    @NotNull
    private static final EventId TOO_MANY_IN_QUEUE_EVENTS;
    @NotNull
    private static final EventId TOO_MANY_COMPLETED_EVENTS;
    @VisibleForTesting
    @NotNull
    private static final VarargEventId REBASE_EVENT;
    @VisibleForTesting
    @NotNull
    private static final VarargEventId CONFLICT_EVENT;
    @VisibleForTesting
    @NotNull
    private static final EventId2<Integer, Class<?>> RECOVERY_EVENT;
    @NotNull
    private static final BooleanEventField IS_INITIAL_CARET_CHANGE;
    @NotNull
    private static final IntEventField CARET_OFFSET_CHANGE;
    @NotNull
    private static final IntEventField CARET_LINE_CHANGE;
    @NotNull
    private static final IntEventField CARET_COLUMN_CHANGE;
    @NotNull
    private static final VarargEventId CARET_CHANGE_EVENT;

    private SyncEventsLogger() {
    }

    @NotNull
    public final EventLogGroup getGROUP() {
        return GROUP;
    }

    public final void logRequestInQueueDuration(@NotNull Class<?> requestType, long durationMs, @Nullable String actionId) {
        Intrinsics.checkNotNullParameter(requestType, (String)"requestType");
        if (durationMs < 100L) {
            return;
        }
        Object[] objectArray = new EventPair[]{REQUEST_TYPE.with(requestType), EventFields.DurationMs.with((Object)durationMs)};
        List list2 = CollectionsKt.mutableListOf((Object[])objectArray);
        if (actionId != null) {
            list2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        }
        switch (WhenMappings.$EnumSwitchMapping$0[throttleRequestsInQueue.tryPass(System.currentTimeMillis()).ordinal()]) {
            case 1: {
                REQUEST_IN_QUEUE_DURATION.log(list2);
                break;
            }
            case 2: {
                TOO_MANY_IN_QUEUE_EVENTS.log();
            }
        }
    }

    public final void logRequestCompleted(@NotNull Class<?> requestType, @NotNull ResponseType responseType, long durationMs, @Nullable String actionId) {
        Intrinsics.checkNotNullParameter(requestType, (String)"requestType");
        Intrinsics.checkNotNullParameter((Object)((Object)responseType), (String)"responseType");
        if (durationMs < 200L) {
            return;
        }
        Object[] objectArray = new EventPair[]{REQUEST_TYPE.with(requestType), RESPONSE_TYPE.with((Object)responseType), EventFields.DurationMs.with((Object)durationMs)};
        List list2 = CollectionsKt.mutableListOf((Object[])objectArray);
        if (actionId != null) {
            list2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        }
        switch (WhenMappings.$EnumSwitchMapping$0[throttleRequestsCompleted.tryPass(System.currentTimeMillis()).ordinal()]) {
            case 1: {
                REQUEST_COMPLETED_DURATION.log(list2);
                break;
            }
            case 2: {
                TOO_MANY_COMPLETED_EVENTS.log();
            }
        }
    }

    public final void logRebase(@NotNull RebaseSessionType sessionType, int undoneRequests, int redoneRequests, int cancelledRequests, @Nullable Class<?> requestType, @Nullable String actionId, long durationMs, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
        Object[] objectArray = new EventPair[]{SESSION_TYPE.with((Object)sessionType), UNDONE_REQUESTS.with((Object)undoneRequests), REDONE_REQUESTS.with((Object)redoneRequests), CANCELLED_REQUESTS.with((Object)cancelledRequests), BATCH_SIZE.with((Object)batchSize), EventFields.DurationMs.with((Object)durationMs)};
        List list2 = CollectionsKt.mutableListOf((Object[])objectArray);
        if (requestType != null) {
            list2.add(REQUEST_TYPE.with(requestType));
        }
        if (actionId != null) {
            list2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        }
        REBASE_EVENT.log(list2);
    }

    public final void logConflict(@NotNull RebaseSessionType sessionType, int undoneRequests, @Nullable Class<?> requestType, @Nullable String actionId) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
        Object[] objectArray = new EventPair[]{SESSION_TYPE.with((Object)sessionType), UNDONE_REQUESTS.with((Object)undoneRequests)};
        List list2 = CollectionsKt.mutableListOf((Object[])objectArray);
        if (requestType != null) {
            list2.add(REQUEST_TYPE.with(requestType));
        }
        if (actionId != null) {
            list2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        }
        Collection collection = list2;
        boolean bl = false;
        Collection collection2 = collection;
        objectArray = collection2.toArray(new EventPair[0]);
        CONFLICT_EVENT.log((EventPair[])Arrays.copyOf(objectArray, objectArray.length));
    }

    public final void logRecovery(int droppedRequests, @NotNull Class<?> recoveryReason) {
        Intrinsics.checkNotNullParameter(recoveryReason, (String)"recoveryReason");
        RECOVERY_EVENT.log((Object)droppedRequests, recoveryReason);
    }

    public final void logCaretChange(boolean isInitialChange, int caretChange, int lineChange, int columnChange, @NotNull RebaseSessionType sessionType, @Nullable Class<?> requestType, @Nullable String actionId, @Nullable FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
        Object[] objectArray = new EventPair[]{IS_INITIAL_CARET_CHANGE.with((Object)isInitialChange), CARET_OFFSET_CHANGE.with((Object)caretChange), CARET_LINE_CHANGE.with((Object)lineChange), CARET_COLUMN_CHANGE.with((Object)columnChange), SESSION_TYPE.with((Object)sessionType)};
        List list2 = CollectionsKt.mutableListOf((Object[])objectArray);
        if (requestType != null) {
            list2.add(REQUEST_TYPE.with(requestType));
        }
        if (actionId != null) {
            list2.add(ActionsEventLogGroup.ACTION_ID.with((Object)actionId));
        }
        if (fileType != null) {
            list2.add(EventFields.FileType.with((Object)fileType));
        }
        CARET_CHANGE_EVENT.log(list2);
    }

    @NotNull
    public final VarargEventId getREQUEST_IN_QUEUE_DURATION() {
        return REQUEST_IN_QUEUE_DURATION;
    }

    @NotNull
    public final VarargEventId getREQUEST_COMPLETED_DURATION() {
        return REQUEST_COMPLETED_DURATION;
    }

    @NotNull
    public final VarargEventId getREBASE_EVENT() {
        return REBASE_EVENT;
    }

    @NotNull
    public final VarargEventId getCONFLICT_EVENT() {
        return CONFLICT_EVENT;
    }

    @NotNull
    public final EventId2<Integer, Class<?>> getRECOVERY_EVENT() {
        return RECOVERY_EVENT;
    }

    static {
        EventField[] eventFieldArray = EventFields.INSTANCE;
        String string = "response";
        Function1 function1 = eventFieldArray.getDefaultEnumTransform();
        boolean bl = false;
        RESPONSE_TYPE = new EnumEventField(string, ResponseType.class, null, function1);
        eventFieldArray = EventFields.INSTANCE;
        string = "rebase_session_type";
        function1 = eventFieldArray.getDefaultEnumTransform();
        bl = false;
        SESSION_TYPE = new EnumEventField(string, RebaseSessionType.class, null, function1);
        eventFieldArray = new EventField[]{REQUEST_TYPE, EventFields.DurationMs, ActionsEventLogGroup.ACTION_ID};
        REQUEST_IN_QUEUE_DURATION = GROUP.registerVarargEvent("request.in.queue.duration", eventFieldArray);
        eventFieldArray = new EventField[]{REQUEST_TYPE, RESPONSE_TYPE, EventFields.DurationMs, ActionsEventLogGroup.ACTION_ID};
        REQUEST_COMPLETED_DURATION = GROUP.registerVarargEvent("request.completed", eventFieldArray);
        TOO_MANY_IN_QUEUE_EVENTS = GROUP.registerEvent("too.many.request.in.queue.duration");
        TOO_MANY_COMPLETED_EVENTS = GROUP.registerEvent("too.many.request.completed");
        eventFieldArray = new EventField[]{UNDONE_REQUESTS, REDONE_REQUESTS, CANCELLED_REQUESTS, REQUEST_TYPE, ActionsEventLogGroup.ACTION_ID, SESSION_TYPE, EventFields.DurationMs, BATCH_SIZE};
        REBASE_EVENT = GROUP.registerVarargEvent("rebase", eventFieldArray);
        eventFieldArray = new EventField[]{UNDONE_REQUESTS, REQUEST_TYPE, ActionsEventLogGroup.ACTION_ID, SESSION_TYPE};
        CONFLICT_EVENT = GROUP.registerVarargEvent("conflict", eventFieldArray);
        RECOVERY_EVENT = GROUP.registerEvent("recovery", (EventField)CANCELLED_REQUESTS, (EventField)RECOVERY_REASON);
        IS_INITIAL_CARET_CHANGE = EventFields.Boolean((String)"is_initial_change");
        CARET_OFFSET_CHANGE = EventFields.Int((String)"offset_change");
        CARET_LINE_CHANGE = EventFields.Int((String)"line_change");
        CARET_COLUMN_CHANGE = EventFields.Int((String)"column_change");
        eventFieldArray = new EventField[]{IS_INITIAL_CARET_CHANGE, CARET_OFFSET_CHANGE, CARET_LINE_CHANGE, CARET_COLUMN_CHANGE, SESSION_TYPE, REQUEST_TYPE, ActionsEventLogGroup.ACTION_ID, EventFields.FileType};
        CARET_CHANGE_EVENT = GROUP.registerVarargEvent("primary.caret.moved", eventFieldArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/tracing/SyncEventsLogger$MetricsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "SyncEventsLogger$MetricsCollector", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "intellij.rd.platform"})
    public static final class MetricsCollector
    extends CounterUsagesCollector {
        @NotNull
        public EventLogGroup getGroup() {
            return INSTANCE.getGROUP();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/tracing/SyncEventsLogger$RebaseSessionType;", "", "SyncEventsLogger$RebaseSessionType", "(Ljava/lang/String;I)V", "RESPONSE_HANDLING", "BACKEND_CHANGE", "RECOVERY", "RETRY", "OTHER", "intellij.rd.platform"})
    public static final class RebaseSessionType
    extends Enum<RebaseSessionType> {
        public static final /* enum */ RebaseSessionType RESPONSE_HANDLING = new RebaseSessionType();
        public static final /* enum */ RebaseSessionType BACKEND_CHANGE = new RebaseSessionType();
        public static final /* enum */ RebaseSessionType RECOVERY = new RebaseSessionType();
        public static final /* enum */ RebaseSessionType RETRY = new RebaseSessionType();
        public static final /* enum */ RebaseSessionType OTHER = new RebaseSessionType();
        private static final /* synthetic */ RebaseSessionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RebaseSessionType[] values() {
            return (RebaseSessionType[])$VALUES.clone();
        }

        public static RebaseSessionType valueOf(String value2) {
            return Enum.valueOf(RebaseSessionType.class, value2);
        }

        @NotNull
        public static EnumEntries<RebaseSessionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rebaseSessionTypeArray = new RebaseSessionType[]{RebaseSessionType.RESPONSE_HANDLING, RebaseSessionType.BACKEND_CHANGE, RebaseSessionType.RECOVERY, RebaseSessionType.RETRY, RebaseSessionType.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/tracing/SyncEventsLogger$ResponseType;", "", "SyncEventsLogger$ResponseType", "(Ljava/lang/String;I)V", "SUCCESS", "FAILURE", "FAILURE_EDITOR_UNBOUND_RECENTLY", "RETRY", "UNKNOWN", "intellij.rd.platform"})
    public static final class ResponseType
    extends Enum<ResponseType> {
        public static final /* enum */ ResponseType SUCCESS = new ResponseType();
        public static final /* enum */ ResponseType FAILURE = new ResponseType();
        public static final /* enum */ ResponseType FAILURE_EDITOR_UNBOUND_RECENTLY = new ResponseType();
        public static final /* enum */ ResponseType RETRY = new ResponseType();
        public static final /* enum */ ResponseType UNKNOWN = new ResponseType();
        private static final /* synthetic */ ResponseType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ResponseType[] values() {
            return (ResponseType[])$VALUES.clone();
        }

        public static ResponseType valueOf(String value2) {
            return Enum.valueOf(ResponseType.class, value2);
        }

        @NotNull
        public static EnumEntries<ResponseType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = responseTypeArray = new ResponseType[]{ResponseType.SUCCESS, ResponseType.FAILURE, ResponseType.FAILURE_EDITOR_UNBOUND_RECENTLY, ResponseType.RETRY, ResponseType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventRateThrottleResult.values().length];
            try {
                nArray[EventRateThrottleResult.ACCEPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventRateThrottleResult.DENY_AND_REPORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

