/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.AggregateConsumer;
import com.jetbrains.rd.platform.diagnostics.IMetricConsumer;
import com.jetbrains.rd.platform.diagnostics.MetricUnit;
import com.jetbrains.rd.platform.diagnostics.Policy;
import com.jetbrains.rd.platform.diagnostics.QuantileEstimatorConsumer;
import com.jetbrains.rd.platform.diagnostics.SumConsumer;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u001e\u001a\u00028\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\u0010\u001fJ\r\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00028\u00002\u0006\u0010#\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010%J\u001b\u0010&\u001a\u00028\u00002\f\u0010'\u001a\b\u0012\u0004\u0012\u00020$0(H\u0002\u00a2\u0006\u0002\u0010)J\u000b\u0010*\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u001a\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020$2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\nJ\u0015\u0010/\u001a\u00028\u00002\u0006\u00100\u001a\u00020\u001dH\u0004\u00a2\u0006\u0002\u00101J\u0006\u00102\u001a\u000203R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R2\u0010\u0015\u001a&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017 \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/PerformanceAggregatorBase;", "TThis", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "unit", "Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;", "watchdogName", "", "PerformanceAggregatorBase", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/diagnostic/Logger;Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;Ljava/lang/String;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getUnit", "()Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;", "getWatchdogName", "()Ljava/lang/String;", "policy", "Ljava/util/EnumSet;", "Lcom/jetbrains/rd/platform/diagnostics/Policy;", "kotlin.jvm.PlatformType", "application", "Lcom/intellij/openapi/application/Application;", "myConsumers", "", "Lcom/jetbrains/rd/platform/diagnostics/IMetricConsumer;", "withThreadingPolicy", "(Lcom/intellij/openapi/application/Application;Ljava/util/EnumSet;)Lcom/jetbrains/rd/platform/diagnostics/PerformanceAggregatorBase;", "withTotalElapsedTime", "()Lcom/jetbrains/rd/platform/diagnostics/PerformanceAggregatorBase;", "x", "quantile", "", "(D)Lcom/jetbrains/rd/platform/diagnostics/PerformanceAggregatorBase;", "x", "quantiles", "", "(Ljava/util/List;)Lcom/jetbrains/rd/platform/diagnostics/PerformanceAggregatorBase;", "withDefaultQuantiles", "addValue", "", "value", "comment", "addConsumer", "consumer", "(Lcom/jetbrains/rd/platform/diagnostics/IMetricConsumer;)Lcom/jetbrains/rd/platform/diagnostics/PerformanceAggregatorBase;", "checkPolicy", "", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nHotspotWatchdog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotspotWatchdog.kt\ncom/jetbrains/rd/platform/diagnostics/PerformanceAggregatorBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n1#2:301\n1869#3,2:302\n*S KotlinDebug\n*F\n+ 1 HotspotWatchdog.kt\ncom/jetbrains/rd/platform/diagnostics/PerformanceAggregatorBase\n*L\n182#1:302,2\n*E\n"})
public abstract class PerformanceAggregatorBase<TThis extends PerformanceAggregatorBase<TThis>> {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Logger logger;
    @NotNull
    private final MetricUnit unit;
    @NotNull
    private final String watchdogName;
    private EnumSet<Policy> policy;
    @Nullable
    private Application application;
    @NotNull
    private final List<IMetricConsumer> myConsumers;

    public PerformanceAggregatorBase(@NotNull Lifetime lifetime, @NotNull Logger logger, @NotNull MetricUnit unit, @NotNull String watchdogName) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter((Object)watchdogName, (String)"watchdogName");
        this.lifetime = lifetime;
        this.logger = logger;
        this.unit = unit;
        this.watchdogName = watchdogName;
        this.policy = EnumSet.of((Enum)Policy.None);
        this.myConsumers = new ArrayList();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final MetricUnit getUnit() {
        return this.unit;
    }

    @NotNull
    public final String getWatchdogName() {
        return this.watchdogName;
    }

    @NotNull
    public final TThis withThreadingPolicy(@Nullable Application application, @NotNull EnumSet<Policy> policy) {
        Intrinsics.checkNotNullParameter(policy, (String)"policy");
        if (policy.contains((Object)Policy.None)) {
            this.application = null;
            this.policy = EnumSet.of((Enum)Policy.None);
        } else {
            if (application == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            this.application = application;
            this.policy = policy;
        }
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type TThis of com.jetbrains.rd.platform.diagnostics.PerformanceAggregatorBase");
        return (TThis)this;
    }

    @NotNull
    public TThis withTotalElapsedTime() {
        return this.addConsumer(new SumConsumer(this.lifetime, this.logger, this.watchdogName));
    }

    private final TThis x(double d) {
        double d2 = d;
        IMetricConsumer iMetricConsumer = d2 == 0.0 ? (IMetricConsumer)new AggregateConsumer(this.lifetime, this.logger, this.unit, this.watchdogName, (Function2<? super Double, ? super Double, Double>)((Function2)PerformanceAggregatorBase::x), "P0") : (d2 == 1.0 ? (IMetricConsumer)new AggregateConsumer(this.lifetime, this.logger, this.unit, this.watchdogName, (Function2<? super Double, ? super Double, Double>)((Function2)PerformanceAggregatorBase::G), "P100") : (IMetricConsumer)new QuantileEstimatorConsumer(this.lifetime, this.logger, this.unit, this.watchdogName, d));
        return this.addConsumer(iMetricConsumer);
    }

    private final TThis x(List<Double> list2) {
        if (!(!((Collection)list2).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (int j = list2.size() - 1; -1 < j; --j) {
            this.x(((Number)list2.get(j)).doubleValue());
        }
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type TThis of com.jetbrains.rd.platform.diagnostics.PerformanceAggregatorBase");
        return (TThis)this;
    }

    @NotNull
    public final TThis withDefaultQuantiles() {
        Object[] objectArray = new Double[]{0.5, 0.75, 0.9, 0.95, 0.99, 1.0};
        return this.x(CollectionsKt.listOf((Object[])objectArray));
    }

    public final void addValue(double value2, @Nullable String comment) {
        if (!(!((Collection)this.myConsumers).isEmpty())) {
            boolean bl = false;
            String string = "You should add at least once consumer to HotspotWatchdog before reporting a value. Did you call any HotspotWatchdog.with...() method?";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable iterable = this.myConsumers;
        boolean bl = false;
        for (Object t : iterable) {
            IMetricConsumer iMetricConsumer = (IMetricConsumer)t;
            boolean bl2 = false;
            iMetricConsumer.consumeValue(value2, comment);
        }
    }

    public static /* synthetic */ void addValue$default(PerformanceAggregatorBase performanceAggregatorBase, double d, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addValue");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        performanceAggregatorBase.addValue(d, string);
    }

    @NotNull
    protected final TThis addConsumer(@NotNull IMetricConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.myConsumers.add(consumer);
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type TThis of com.jetbrains.rd.platform.diagnostics.PerformanceAggregatorBase");
        return (TThis)this;
    }

    public final boolean checkPolicy() {
        Application application = this.application;
        if (application == null) {
            return true;
        }
        Application application2 = application;
        if (this.policy.contains((Object)Policy.MainThread) && !application2.isDispatchThread()) {
            return false;
        }
        if (this.policy.contains((Object)Policy.ReadAccess) && !application2.isReadAccessAllowed()) {
            return false;
        }
        return !this.policy.contains((Object)Policy.WriteAccess) || application2.isWriteAccessAllowed();
    }

    private static final double x(double d, double d2) {
        return Math.min(d, d2);
    }

    private static final double G(double d, double d2) {
        return Math.max(d, d2);
    }
}

