/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.colors;

import com.intellij.application.options.colors.ColorSettingsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.util.containers.BidirectionalMap;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.ColorKeyModel;
import com.jetbrains.rd.ide.model.IdeaColorKey;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/platform/colors/ColorKeysStorage;", "", "ColorKeysStorage", "()V", "keysCache", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/jetbrains/rd/ide/model/ColorKeyModel;", "Lcom/intellij/openapi/editor/colors/ColorKey;", "preloadedPlatformKeys", "", "getColorKey", "modelKey", "getModel", "key", "x", "", "x", "model", "x", "", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nColorKeysStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorKeysStorage.kt\ncom/jetbrains/rd/platform/colors/ColorKeysStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n1#2:79\n13#3:80\n*S KotlinDebug\n*F\n+ 1 ColorKeysStorage.kt\ncom/jetbrains/rd/platform/colors/ColorKeysStorage\n*L\n13#1:80\n*E\n"})
public final class ColorKeysStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BidirectionalMap<ColorKeyModel, ColorKey> keysCache = new BidirectionalMap();
    private boolean preloadedPlatformKeys;
    @NotNull
    private static final Logger logger;

    @NotNull
    public final ColorKey getColorKey(@NotNull ColorKeyModel modelKey) {
        Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
        if (!this.preloadedPlatformKeys) {
            this.x();
            this.preloadedPlatformKeys = true;
        }
        return this.x(modelKey);
    }

    @NotNull
    public final ColorKeyModel getModel(@NotNull ColorKey key) {
        ColorKeyModel colorKeyModel;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.keysCache.getKeysByValue((Object)key);
        if (object != null && (object = (ColorKeyModel)CollectionsKt.firstOrNull((List)object)) != null) {
            Object object2 = object;
            boolean bl = false;
            return object2;
        }
        ColorKey colorKey = key.getFallbackColorKey();
        if (colorKey != null) {
            ColorKey colorKey2 = colorKey;
            boolean bl = false;
            colorKeyModel = this.getModel(colorKey2);
        } else {
            colorKeyModel = null;
        }
        ColorKeyModel colorKeyModel2 = colorKeyModel;
        String string = key.getExternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
        Color color = key.getDefaultColor();
        IdeaColorKey ideaColorKey = new IdeaColorKey(colorKeyModel2, string, color != null ? ColorHostKt.toModel(color) : null);
        ((Map)this.keysCache).put(ideaColorKey, key);
        return ideaColorKey;
    }

    private final void x() {
        for (ColorSettingsPage colorSettingsPage : (ColorSettingsPage[])ColorSettingsPage.EP_NAME.getExtensions()) {
            List list2 = ColorSettingsUtil.getAllColorDescriptors((ColorAndFontDescriptorsProvider)((ColorAndFontDescriptorsProvider)colorSettingsPage));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllColorDescriptors(...)");
            CollectionsKt.toList((Iterable)list2);
        }
    }

    private final ColorKey x(ColorKeyModel colorKeyModel) {
        ColorKey colorKey;
        ColorKey colorKey2;
        Object object = (ColorKey)this.keysCache.get((Object)colorKeyModel);
        if (object != null) {
            ColorKey colorKey3 = object;
            boolean bl = false;
            return colorKey3;
        }
        IdeaColorKey ideaColorKey = colorKeyModel instanceof IdeaColorKey ? (IdeaColorKey)colorKeyModel : null;
        Object object2 = object = ideaColorKey != null ? ideaColorKey.getFallback() : null;
        ColorKey colorKey4 = colorKey2 = object2 != null ? this.x((ColorKeyModel)object2) : null;
        if (colorKey2 == null) {
            AbstractColor abstractColor = colorKeyModel.getDefaultColor();
            colorKey = ColorKey.createColorKey((String)colorKeyModel.getExternalName(), (Color)(abstractColor != null ? ColorHostKt.toColor(abstractColor) : null));
        } else {
            ColorKey colorKey5 = ColorKey.createColorKey((String)colorKeyModel.getExternalName());
            Intrinsics.checkNotNullExpressionValue((Object)colorKey5, (String)"createColorKey(...)");
            ColorKey colorKey6 = colorKey5;
            if (colorKey6.getFallbackColorKey() != null) {
                colorKey = colorKey6;
            } else {
                ColorKey colorKey7 = ColorKey.createColorKeyWithFallback((String)colorKeyModel.getExternalName(), (ColorKey)colorKey2);
                Intrinsics.checkNotNull((Object)colorKey7);
                colorKey = colorKey7;
            }
        }
        ColorKey colorKey8 = colorKey;
        Intrinsics.checkNotNull((Object)colorKey8);
        ColorKey colorKey9 = colorKey8;
        if (!Intrinsics.areEqual((Object)colorKey9.getFallbackColorKey(), (Object)colorKey2)) {
            logger.warn("Fallback keys sausage was not registered properly for ColorKey " + colorKey9 + ": keys sausage for actual registered key = " + this.x(colorKey9) + ", keys sausage for model fallback key = " + this.x(colorKey2));
        }
        ((Map)this.keysCache).put(colorKeyModel, colorKey9);
        return colorKey9;
    }

    private final String x(ColorKey colorKey) {
        ColorKey colorKey2 = colorKey;
        return colorKey2 == null ? "null" : colorKey2 + "-->" + this.x(colorKey.getFallbackColorKey());
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(ColorKeysStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ColorKeysStorage.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/platform/colors/ColorKeysStorage$Companion;", "", "ColorKeysStorage$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

