/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform;

import com.intellij.configurationStore.ProjectIdManager;
import com.intellij.ide.Prefs;
import com.intellij.idea.AppMode;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PlatformUtils;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.RdProjectIdSettings;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/platform/RdProjectIdUtils;", "", "RdProjectIdUtils", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "RD_MACHINE_ID_KEY", "", "newUniqueProjectId", "Lcom/jetbrains/rd/ide/model/RdProjectId;", "project", "Lcom/intellij/openapi/project/Project;", "G", "x", "x", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nProjectUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectUtil.kt\ncom/jetbrains/rd/platform/RdProjectIdUtils\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n50#2:112\n30#2,2:113\n13#3:115\n*S KotlinDebug\n*F\n+ 1 ProjectUtil.kt\ncom/jetbrains/rd/platform/RdProjectIdUtils\n*L\n55#1:112\n99#1:113,2\n43#1:115\n*E\n"})
final class RdProjectIdUtils {
    @NotNull
    public static final RdProjectIdUtils INSTANCE = new RdProjectIdUtils();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String RD_MACHINE_ID_KEY = "JetBrains.rd.machineId";

    private RdProjectIdUtils() {
    }

    @NotNull
    public final RdProjectId newUniqueProjectId(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = this.x();
        String string2 = this.G(project);
        return new RdProjectId(string + ":" + string2);
    }

    private final String G(Project project) {
        ProjectIdManager projectIdManager;
        boolean bl;
        ProjectEx projectEx = project instanceof ProjectEx ? (ProjectEx)project : null;
        boolean bl2 = projectEx != null ? !projectEx.isComponentCreated() : (bl = false);
        if (bl) {
            v2 = null;
        } else {
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl3 = false;
            v2 = projectIdManager = (ProjectIdManager)componentManager.getService(ProjectIdManager.class);
        }
        if (projectIdManager == null) {
            if (AppMode.isRemoteDevHost()) {
                logger.info("Failed to get ProjectIdManager, switching to the \"emergency project id\"");
                return this.x(project);
            }
            logger.debug("ProjectIdManager is not available yet, using random project id. IDE: " + PlatformUtils.getPlatformPrefix());
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        String string = projectIdManager.getId();
        if (string == null) {
            RdProjectIdUtils rdProjectIdUtils = this;
            boolean bl4 = false;
            logger.error("`ProjectIdManager.id` is null, switching to the \"emergency project id\"");
            string = rdProjectIdUtils.x(project);
        }
        return string;
    }

    private final String x(Project project) {
        String string = (String)project.getUserData(ProjectUtilKt.getRdEarlyProjectDir());
        if (string == null) {
            RdProjectIdUtils rdProjectIdUtils = this;
            boolean bl = false;
            logger.error("Failed to get project path from `rdEarlyProjectDir` user data. Product info: " + PlatformUtils.getPlatformPrefix() + ". To support persisting of project settings in remote development for your product, put `projectPath` into `Project` user data before `SolutionInitializer.initSolution`.");
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        String string3 = string;
        ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
        boolean bl = false;
        Class<RdProjectIdSettings> clazz = RdProjectIdSettings.class;
        Object object = componentManager.getService(clazz);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
        }
        return ((RdProjectIdSettings)object).getOrCreateRdProjectId(string3);
    }

    private final String x() {
        String string = Prefs.get((String)RD_MACHINE_ID_KEY, null);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            return string2;
        }
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String string4 = string3;
        Prefs.put((String)RD_MACHINE_ID_KEY, (String)string4);
        return string4;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(RdProjectIdUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RdProjectIdUtils.logger = logger;
    }
}

