/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RdFileType;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.lang.ProtocolLanguageAssociationBean;
import com.jetbrains.rd.lang.ProtocolLanguageManager;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.PlatformDependentKt;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u001aH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rd/lang/ProtocolLanguageManagerImpl;", "Lcom/jetbrains/rd/lang/ProtocolLanguageManager;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "ProtocolLanguageManagerImpl", "(Lkotlinx/coroutines/CoroutineScope;)V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rd/lang/ProtocolLanguageAssociationBean;", "backendToFrontendLanguageCache", "", "Lcom/jetbrains/rd/ide/model/RdLanguage;", "", "frontendToBackendLanguageCache", "fileTypeToProtocolCache", "Lcom/jetbrains/rd/ide/model/RdFileType;", "protocolToFileTypeCache", "Lcom/intellij/openapi/fileTypes/FileType;", "toRdLanguage", "language", "Lcom/intellij/lang/Language;", "fromRdFileType", "rdFileType", "toRdFileType", "fileType", "isProtocolLanguage", "", "toIdeaLanguage", "rdLanguage", "addAssociation", "", "backendLanguageId", "frontendLanguageId", "default", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nProtocolLanguageManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolLanguageManagerImpl.kt\ncom/jetbrains/rd/lang/ProtocolLanguageManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,117:1\n1#2:118\n13#3:119\n*S KotlinDebug\n*F\n+ 1 ProtocolLanguageManagerImpl.kt\ncom/jetbrains/rd/lang/ProtocolLanguageManagerImpl\n*L\n84#1:119\n*E\n"})
public final class ProtocolLanguageManagerImpl
implements ProtocolLanguageManager {
    @NotNull
    private final ExtensionPointName<ProtocolLanguageAssociationBean> EP_NAME;
    @NotNull
    private final Map<RdLanguage, String> backendToFrontendLanguageCache;
    @NotNull
    private final Map<String, RdLanguage> frontendToBackendLanguageCache;
    @NotNull
    private final Map<String, RdFileType> fileTypeToProtocolCache;
    @NotNull
    private final Map<RdFileType, FileType> protocolToFileTypeCache;

    public ProtocolLanguageManagerImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.EP_NAME = ExtensionPointName.Companion.create("com.intellij.rd.languageAssociation");
        this.backendToFrontendLanguageCache = PlatformDependentKt.concurrentMapOf();
        this.frontendToBackendLanguageCache = PlatformDependentKt.concurrentMapOf();
        this.fileTypeToProtocolCache = PlatformDependentKt.concurrentMapOf();
        this.protocolToFileTypeCache = PlatformDependentKt.concurrentMapOf();
        ApplicationKt.getApplication().getExtensionArea().getExtensionPoint(this.EP_NAME).addExtensionPointListener(coroutineScope, true, (ExtensionPointListener)new ExtensionPointListener<ProtocolLanguageAssociationBean>(){

            public void extensionAdded(ProtocolLanguageAssociationBean extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                String string = extension.getBackendLanguage();
                Intrinsics.checkNotNull((Object)string);
                String string2 = extension.getFrontendLanguage();
                Intrinsics.checkNotNull((Object)string2);
                this.addAssociation(string, string2, extension.isDefault());
            }
        });
    }

    @Override
    @NotNull
    public RdLanguage toRdLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        RdLanguage rdLanguage = this.frontendToBackendLanguageCache.get(language.getID());
        if (rdLanguage == null) {
            String string = language.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            rdLanguage = new RdLanguage(string);
        }
        return rdLanguage;
    }

    @Override
    @Nullable
    public FileType fromRdFileType(@NotNull RdFileType rdFileType) {
        Intrinsics.checkNotNullParameter((Object)rdFileType, (String)"rdFileType");
        FileType fileType = this.protocolToFileTypeCache.get(rdFileType);
        if (fileType != null) {
            return fileType;
        }
        FileType fileType2 = FileTypeManager.getInstance().findFileTypeByName(rdFileType.getName());
        if (fileType2 != null) {
            this.protocolToFileTypeCache.put(rdFileType, fileType2);
            this.fileTypeToProtocolCache.put(fileType2.getName(), rdFileType);
        }
        return fileType2;
    }

    @Override
    @NotNull
    public RdFileType toRdFileType(@NotNull FileType fileType) {
        RdLanguage rdLanguage;
        RdFileType rdFileType;
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        RdFileType rdFileType2 = rdFileType = this.fileTypeToProtocolCache.get(fileType.getName());
        if (rdFileType2 != null) {
            return rdFileType2;
        }
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType != null && (languageFileType = languageFileType.getLanguage()) != null) {
            LanguageFileType languageFileType2 = languageFileType;
            boolean bl = false;
            rdLanguage = this.toRdLanguage((Language)languageFileType2);
        } else {
            rdLanguage = null;
        }
        RdLanguage rdLanguage2 = rdLanguage;
        FileType fileType2 = fileType;
        boolean bl = false;
        String string = fileType2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = fileType2.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
        String string3 = fileType2.getDefaultExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDefaultExtension(...)");
        Icon icon = fileType2.getIcon();
        RdFileType rdFileType3 = new RdFileType(string, string2, string3, icon != null ? UtilKt.toModel(icon) : null, fileType2.isBinary(), fileType2.isReadOnly(), rdLanguage2);
        this.protocolToFileTypeCache.put(rdFileType3, fileType);
        this.fileTypeToProtocolCache.put(fileType.getName(), rdFileType3);
        return rdFileType3;
    }

    @Override
    public boolean isProtocolLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.frontendToBackendLanguageCache.containsKey(language.getID());
    }

    @Override
    @Nullable
    public Language toIdeaLanguage(@NotNull RdLanguage rdLanguage) {
        Object v2;
        String string;
        block5: {
            Intrinsics.checkNotNullParameter((Object)rdLanguage, (String)"rdLanguage");
            string = this.backendToFrontendLanguageCache.get(rdLanguage);
            if (string != null) {
                Language language = Language.findLanguageByID((String)string);
                if (language == null) {
                    boolean bl = false;
                    Logger logger = Logger.getInstance(ProtocolLanguageManager.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Unable to find '" + string + "'. Possibly it's incorrect or com.intellij.lang.Language is not initialized");
                }
                return language;
            }
            Collection collection = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                Language language = (Language)t;
                boolean bl = false;
                if (!StringsKt.equals((String)language.getID(), (String)rdLanguage.getId(), (boolean)true)) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        Language language = v2;
        if (language == null) {
            return null;
        }
        Language language2 = language;
        string = language2.getID();
        this.backendToFrontendLanguageCache.put(rdLanguage, string);
        if (!this.frontendToBackendLanguageCache.containsKey(string)) {
            this.frontendToBackendLanguageCache.put(string, rdLanguage);
        }
        return language2;
    }

    @Override
    public void addAssociation(@NotNull String backendLanguageId, @NotNull String frontendLanguageId, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)backendLanguageId, (String)"backendLanguageId");
        Intrinsics.checkNotNullParameter((Object)frontendLanguageId, (String)"frontendLanguageId");
        if (bl) {
            RdLanguage rdLanguage = new RdLanguage(backendLanguageId);
            this.frontendToBackendLanguageCache.put(frontendLanguageId, rdLanguage);
            this.backendToFrontendLanguageCache.put(rdLanguage, frontendLanguageId);
            return;
        }
        RdLanguage rdLanguage = new RdLanguage(backendLanguageId);
        if (!this.frontendToBackendLanguageCache.containsKey(frontendLanguageId)) {
            this.frontendToBackendLanguageCache.put(frontendLanguageId, rdLanguage);
        }
        if (!this.backendToFrontendLanguageCache.containsKey(rdLanguage)) {
            this.backendToFrontendLanguageCache.put(rdLanguage, frontendLanguageId);
        }
    }
}

