/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerBase;
import com.jetbrains.rd.ide.editor.EditorVersionHolder;
import com.jetbrains.rd.ide.editor.EditorVersions;
import com.jetbrains.rd.ide.editor.EditorVersionsKt;
import com.jetbrains.rd.ide.editor.PatchEngineEditorSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretModelChange;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshotBase;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdEditorChange;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchEditorVersion;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.string.IPrintable;
import com.jetbrains.rd.util.string.IPrintableKt;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 _2\u00020\u00012\u00020\u0002:\u0002_`BA\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020*H\u0016J\b\u0010.\u001a\u00020*H\u0016J\u0010\u0010/\u001a\u00020*2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020*2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00103\u001a\u00020*2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020*2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00107\u001a\u00020*2\u0006\u00108\u001a\u00020\"H\u0002J\u0010\u00109\u001a\u00020*2\u0006\u00108\u001a\u00020\"H\u0002J\n\u0010:\u001a\u0004\u0018\u00010\u001bH\u0004J\b\u0010;\u001a\u00020\u001bH\u0014J\u0010\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020>H\u0014J\u0006\u0010?\u001a\u00020*J\u0010\u0010@\u001a\u00020*2\b\b\u0002\u0010A\u001a\u00020\"J\u0018\u0010B\u001a\u00020*2\u0006\u0010C\u001a\u00020D2\u0006\u0010A\u001a\u00020\"H\u0002J\u0018\u0010B\u001a\u00020*2\u0006\u0010E\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020*2\u0006\u0010G\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020*2\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020*2\u0006\u0010E\u001a\u00020\u001bH\u0002J\u0010\u0010S\u001a\u00020*2\u0006\u0010T\u001a\u00020UH\u0016J(\u0010V\u001a\u00020*2\u0006\u0010G\u001a\u00020W2\u0006\u0010X\u001a\u00020P2\u0006\u0010Y\u001a\u00020P2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010Z\u001a\u00020*H\u0002J\u0016\u0010[\u001a\u00020*2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020\"R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\u00020P8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010R\u00a8\u0006a"}, d2={"Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer;", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "PatchEngineEditorSynchronizer", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;Lcom/jetbrains/rd/ide/requests/PatchEngine;)V", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "getDocumentSynchronizer", "()Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "versionHolder", "Lcom/jetbrains/rd/ide/editor/EditorVersionHolder;", "idNumberCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "oldState", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "postponedState", "documentVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "x", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "x", "", "()Z", "allCaretsActionLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "documentChangesLifetimes", "x", "Lcom/jetbrains/rd/ide/model/RdCaretId;", "caretAdded", "", "e", "Lcom/intellij/openapi/editor/event/CaretEvent;", "beforeAllCaretsAction", "afterAllCaretsAction", "beforeDocumentChange", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "bulkUpdateStarting", "document", "Lcom/intellij/openapi/editor/Document;", "bulkUpdateFinished", "G", "documentChange", "x", "createModelCaretStateIfNotInBulkMode", "createModelCaretState", "sendCaretStateChange", "reason", "", "sendInitialCaretState", "sendCaretStateSnapshot", "force", "x", "mode", "Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer$SendingMode;", "newState", "receiveSelection", "change", "Lcom/jetbrains/rd/ide/model/RdCaretModelChange;", "x", "Lcom/jetbrains/rd/ide/model/RdCaretStateChange;", "x", "snapshot", "Lcom/jetbrains/rd/ide/model/RdCaretStateSnapshotBase;", "x", "version", "Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "getVersion", "()Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "resetVersion", "v", "Lcom/jetbrains/rd/ide/model/RdAbstractEditorVersion;", "x", "Lcom/jetbrains/rd/ide/model/RdEditorChange;", "oldVersion", "newVersion", "k", "softUpdate", "item", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "redo", "Companion", "SendingMode", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nPatchEngineEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineEditorSynchronizer.kt\ncom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n+ 4 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,362:1\n67#2,4:363\n67#2,4:367\n67#2,4:371\n67#2,4:378\n67#2,4:401\n11#3,3:375\n16#3,7:382\n11#3,12:389\n39#4,2:405\n*S KotlinDebug\n*F\n+ 1 PatchEngineEditorSynchronizer.kt\ncom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer\n*L\n72#1:363,4\n225#1:367,4\n249#1:371,4\n266#1:378,4\n286#1:401,4\n263#1:375,3\n263#1:382,7\n273#1:389,12\n307#1:405,2\n*E\n"})
public class PatchEngineEditorSynchronizer
extends EditorSynchronizerBase
implements DocumentListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PatchEngine engine;
    @NotNull
    private final PatchEngineDocumentSynchronizer documentSynchronizer;
    @NotNull
    private final EditorVersionHolder versionHolder;
    @NotNull
    private final AtomicLong idNumberCounter;
    @NotNull
    private RdCaretState oldState;
    @Nullable
    private RdCaretState postponedState;
    @NotNull
    private final SequentialLifetimes allCaretsActionLifetimes;
    @NotNull
    private final SequentialLifetimes documentChangesLifetimes;

    protected PatchEngineEditorSynchronizer(@NotNull Lifetime textControlLifetime, @NotNull ClientAppSession session, @NotNull Editor editor, @NotNull TextControlId editorId, @NotNull TextControlModel editorModel, @NotNull DocumentSynchronizer documentSynchronizer, @NotNull PatchEngine engine2) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)((Object)editorModel), (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
        Intrinsics.checkNotNullParameter((Object)engine2, (String)"engine");
        super(session, textControlLifetime, editorId, editorModel, editor);
        this.engine = engine2;
        this.documentSynchronizer = (PatchEngineDocumentSynchronizer)documentSynchronizer;
        this.versionHolder = new EditorVersionHolder(EditorVersionsKt.getInitialEditorVersion());
        this.idNumberCounter = new AtomicLong();
        this.allCaretsActionLifetimes = new SequentialLifetimes(textControlLifetime);
        this.documentChangesLifetimes = new SequentialLifetimes(textControlLifetime);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            Intrinsics.checkNotNull((Object)caret);
            UtilKt.setId(caret, this.x());
        }
        this.oldState = this.createModelCaretState();
        Logger logger = this.getLogger();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Initial caret state=" + UtilKt.toDebugString(this.oldState));
        }
    }

    @NotNull
    public final PatchEngineDocumentSynchronizer getDocumentSynchronizer() {
        return this.documentSynchronizer;
    }

    private final RdDocumentVersion x() {
        return this.documentSynchronizer.getVersion();
    }

    private final boolean x() {
        return !this.allCaretsActionLifetimes.isTerminated();
    }

    private final RdCaretId x() {
        long l = this.idNumberCounter.incrementAndGet();
        return new RdCaretId(true, l);
    }

    @Override
    public void caretAdded(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Caret caret = e.getCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCaret(...)");
        Caret caret2 = caret;
        if (UtilKt.getId(caret2) == null) {
            UtilKt.setId(caret2, this.x());
        }
        super.caretAdded(e);
    }

    public void beforeAllCaretsAction() {
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            return;
        }
        this.allCaretsActionLifetimes.next().bracketIfAliveEx(() -> PatchEngineEditorSynchronizer.x(this), arg_0 -> PatchEngineEditorSynchronizer.x(this, arg_0));
    }

    public void afterAllCaretsAction() {
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            return;
        }
        this.allCaretsActionLifetimes.terminateCurrent();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.G(true);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.x(true);
    }

    public void bulkUpdateStarting(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.G(false);
    }

    public void bulkUpdateFinished(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.x(false);
    }

    private final void G(boolean bl) {
        if (this.documentSynchronizer.isReceivingChange()) {
            return;
        }
        if (bl && this.getEditor().getDocument().isInBulkUpdate()) {
            return;
        }
        this.documentChangesLifetimes.next().bracketIfAliveEx(() -> PatchEngineEditorSynchronizer.x(this), arg_0 -> PatchEngineEditorSynchronizer.x(this, arg_0));
        this.x(SendingMode.DOCUMENT_WRAP_SNAPSHOT, true);
    }

    private final void x(boolean bl) {
        if (bl && this.getEditor().getDocument().isInBulkUpdate()) {
            return;
        }
        this.documentChangesLifetimes.terminateCurrent();
    }

    @Nullable
    protected final RdCaretState createModelCaretStateIfNotInBulkMode() {
        if (this.getEditor().getDocument().isInBulkUpdate()) {
            return null;
        }
        return this.createModelCaretState();
    }

    @NotNull
    protected RdCaretState createModelCaretState() {
        if (this.getEditor().getDocument().isInBulkUpdate()) {
            this.getLogger().error("This operation can lead to an exception in bulk mode");
        }
        CaretModel caretModel = this.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        return UtilKt.createModelCaretState(caretModel, this.documentSynchronizer.getVersion());
    }

    @Override
    protected void sendCaretStateChange(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.x(SendingMode.CHANGE, false);
    }

    public final void sendInitialCaretState() {
        RdCaretStateSnapshot rdCaretStateSnapshot = new RdCaretStateSnapshot(false, this.oldState, this.getTextControlId());
        EditorVersions editorVersions = this.versionHolder.incrementVersion(this.oldState);
        RdEditorVersion rdEditorVersion = editorVersions.component1();
        RdEditorVersion rdEditorVersion2 = editorVersions.component2();
        this.x(rdCaretStateSnapshot, rdEditorVersion, rdEditorVersion2, this.x());
    }

    public final void sendCaretStateSnapshot(boolean force) {
        this.x(SendingMode.SNAPSHOT, force);
    }

    public static /* synthetic */ void sendCaretStateSnapshot$default(PatchEngineEditorSynchronizer patchEngineEditorSynchronizer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendCaretStateSnapshot");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        patchEngineEditorSynchronizer.sendCaretStateSnapshot(bl);
    }

    private final void x(SendingMode sendingMode, boolean bl) {
        if (this.getDontSendChange()) {
            return;
        }
        if (this.x()) {
            if (this.postponedState != null && !this.documentSynchronizer.isReceivingChange()) {
                RdCaretState rdCaretState = this.postponedState;
                Intrinsics.checkNotNull((Object)rdCaretState);
                this.x(rdCaretState, sendingMode);
                this.postponedState = null;
            }
            return;
        }
        RdCaretState rdCaretState = this.createModelCaretStateIfNotInBulkMode();
        if (rdCaretState == null) {
            this.getLogger().error("Must not be called in bulk mode");
            return;
        }
        if (this.documentSynchronizer.isReceivingChange()) {
            RdCaretState rdCaretState2 = this.oldState;
            this.oldState = rdCaretState;
            Logger logger = this.getLogger();
            boolean bl2 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl3 = false;
                logger2.trace("sendCaretState(isReceivingChange=true): oldState " + UtilKt.toDebugString(rdCaretState2) + " updated to " + UtilKt.toDebugString(this.oldState));
            }
            return;
        }
        if (Intrinsics.areEqual((Object)rdCaretState, (Object)this.oldState) && !bl) {
            return;
        }
        this.x(rdCaretState, sendingMode);
    }

    private final void x(RdCaretState rdCaretState, SendingMode sendingMode) {
        RdSelectionChangeBase rdSelectionChangeBase = switch (WhenMappings.$EnumSwitchMapping$0[sendingMode.ordinal()]) {
            case 1 -> {
                if (!Intrinsics.areEqual((Object)this.oldState.getDocumentVersion(), (Object)rdCaretState.getDocumentVersion())) {
                    yield new RdCaretStateSnapshot(true, rdCaretState, this.getTextControlId());
                }
                yield new RdCaretStateChange(this.oldState, rdCaretState, this.getTextControlId());
            }
            case 2 -> new RdCaretStateSnapshot(false, rdCaretState, this.getTextControlId());
            case 3 -> new RdCaretStateSnapshot(true, rdCaretState, this.getTextControlId());
            default -> throw new NoWhenBranchMatchedException();
        };
        RdCaretState rdCaretState2 = this.oldState;
        this.oldState = rdCaretState;
        Object object = this.getLogger();
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("sendCaretState: oldState " + UtilKt.toDebugString(rdCaretState2) + " updated to " + UtilKt.toDebugString(this.oldState));
        }
        object = this.versionHolder.incrementVersion(rdCaretState);
        RdEditorVersion rdEditorVersion = ((EditorVersions)object).component1();
        RdEditorVersion rdEditorVersion2 = ((EditorVersions)object).component2();
        this.x(rdSelectionChangeBase, rdEditorVersion, rdEditorVersion2, this.x());
    }

    @Override
    public void receiveSelection(@NotNull RdCaretModelChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        RdCaretModelChange rdCaretModelChange = change;
        if (rdCaretModelChange instanceof RdCaretStateChange) {
            this.x((RdCaretStateChange)change);
        } else if (rdCaretModelChange instanceof RdCaretStateSnapshotBase) {
            this.x((RdCaretStateSnapshotBase)change);
        } else {
            throw new IllegalStateException(("Unexpected change type: " + Reflection.getOrCreateKotlinClass(change.getClass()).getSimpleName()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void x(RdCaretStateChange rdCaretStateChange) {
        PatchEngineEditorSynchronizer patchEngineEditorSynchronizer = this;
        KMutableProperty1 kMutableProperty1 = (KMutableProperty1)receiveCaretStateChange.1.INSTANCE;
        boolean bl = true;
        boolean bl2 = false;
        if (!((Boolean)kMutableProperty1.get((Object)patchEngineEditorSynchronizer) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            kMutableProperty1.set((Object)patchEngineEditorSynchronizer, (Object)true);
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)this.oldState, (Object)rdCaretStateChange.getOldState())) {
                Logger logger = this.getLogger();
                boolean bl4 = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl5 = false;
                    logger2.trace("expected old state: " + UtilKt.toDebugString(rdCaretStateChange.getOldState()) + ", actual: " + UtilKt.toDebugString(this.oldState));
                }
            }
            this.x(rdCaretStateChange.getNewState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            kMutableProperty1.set((Object)patchEngineEditorSynchronizer, (Object)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void x(RdCaretStateSnapshotBase rdCaretStateSnapshotBase) {
        PatchEngineEditorSynchronizer patchEngineEditorSynchronizer = this;
        KMutableProperty1 kMutableProperty1 = (KMutableProperty1)receiveCaretStateSnapshot.1.INSTANCE;
        boolean bl = true;
        boolean bl2 = false;
        if (!((Boolean)kMutableProperty1.get((Object)patchEngineEditorSynchronizer) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            kMutableProperty1.set((Object)patchEngineEditorSynchronizer, (Object)true);
            boolean bl3 = false;
            this.x(rdCaretStateSnapshotBase.getState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            kMutableProperty1.set((Object)patchEngineEditorSynchronizer, (Object)false);
        }
    }

    private final void x(RdCaretState rdCaretState) {
        UtilKt.applyStateTo(rdCaretState, this.getEditor());
        this.k();
        this.versionHolder.incrementVersion(rdCaretState);
        if (!Intrinsics.areEqual((Object)this.documentSynchronizer.getVersion(), (Object)rdCaretState.getDocumentVersion())) {
            this.getLogger().error("Received newState based on document version: " + IPrintableKt.printToString((Object)rdCaretState.getDocumentVersion()) + ", but actual document version is " + IPrintableKt.printToString((Object)this.documentSynchronizer.getVersion()) + ". NewState: " + IPrintableKt.printToString((Object)rdCaretState));
        }
        this.oldState = this.createModelCaretState();
        Logger logger = this.getLogger();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("receiveCaretState: oldState updated to " + UtilKt.toDebugString(this.oldState));
        }
        long l = EditorVersionsKt.computeHash(this.oldState);
        long l2 = EditorVersionsKt.computeHash(rdCaretState);
        if (l != l2) {
            this.getLogger().error("current state hash: " + l + ", doesn't match to received state hash: " + l2 + ". current: " + IPrintableKt.printToString((Object)this.oldState) + ", received: " + IPrintableKt.printToString((Object)rdCaretState));
        }
    }

    @Override
    @NotNull
    public RdEditorVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    @Override
    public void resetVersion(@NotNull RdAbstractEditorVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdEditorVersion cfr_ignored_0 = (RdEditorVersion)v;
        this.versionHolder.reset((RdEditorVersion)v);
    }

    private final void x(RdEditorChange rdEditorChange, RdEditorVersion rdEditorVersion, RdEditorVersion rdEditorVersion2, RdDocumentVersion rdDocumentVersion) {
        ClientId.Companion.withExplicitClientId(new ClientId(rdEditorChange.getEditorId().getClientId()), () -> PatchEngineEditorSynchronizer.x(this, rdEditorVersion, rdEditorChange, rdEditorVersion2, rdDocumentVersion));
    }

    private final void k() {
        if (this.versionHolder.getVersion() == EditorVersionsKt.getInitialEditorVersion()) {
            Editor editor = this.getEditor();
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            EditorUtil.runWhenViewportReady((EditorEx)((EditorEx)editor), () -> PatchEngineEditorSynchronizer.x(this));
        }
    }

    public final void softUpdate(@NotNull RdSelectionChangeBase item, boolean redo) {
        RdSelectionChangeBase rdSelectionChangeBase;
        IPrintable iPrintable;
        Object object;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!redo) {
            object = UtilKt.getActualState(item);
            if (!Intrinsics.areEqual((Object)this.documentSynchronizer.getVersion(), (Object)object.getDocumentVersion())) {
                this.getLogger().error("Received newState based on document version: " + IPrintableKt.printToString((Object)object.getDocumentVersion()) + ", but actual document version is " + IPrintableKt.printToString((Object)this.documentSynchronizer.getVersion()) + ". NewState: " + IPrintableKt.printToString((Object)object));
            }
        }
        if ((iPrintable = item) instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase = new RdCaretStateSnapshot(((RdCaretStateSnapshot)item).getDocumentChangeWrapping(), RdCaretState.copy$default(((RdCaretStateSnapshot)item).getState(), null, null, this.x(), 3, null), item.getEditorId());
        } else if (iPrintable instanceof RdCaretStateChange) {
            rdSelectionChangeBase = new RdCaretStateChange(RdCaretState.copy$default(((RdCaretStateChange)item).getOldState(), null, null, this.x(), 3, null), RdCaretState.copy$default(((RdCaretStateChange)item).getNewState(), null, null, this.x(), 3, null), item.getEditorId());
        } else {
            throw new IllegalStateException(("Unexpected change type: " + item).toString());
        }
        object = rdSelectionChangeBase;
        iPrintable = UtilKt.getActualState((RdSelectionChangeBase)object);
        EditorVersions editorVersions = this.versionHolder.incrementVersion((RdCaretState)iPrintable);
        RdEditorVersion rdEditorVersion = editorVersions.component1();
        RdEditorVersion rdEditorVersion2 = editorVersions.component2();
        this.oldState = iPrintable;
        if (redo) {
            this.x((RdEditorChange)object, rdEditorVersion, rdEditorVersion2, this.x());
        }
    }

    private static final Unit x(PatchEngineEditorSynchronizer patchEngineEditorSynchronizer) {
        patchEngineEditorSynchronizer.postponedState = patchEngineEditorSynchronizer.createModelCaretState();
        return Unit.INSTANCE;
    }

    private static final Unit x(PatchEngineEditorSynchronizer patchEngineEditorSynchronizer, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
        if (patchEngineEditorSynchronizer.postponedState == null) {
            patchEngineEditorSynchronizer.sendCaretStateSnapshot(true);
        }
        patchEngineEditorSynchronizer.postponedState = null;
        return Unit.INSTANCE;
    }

    private static final RdPatchEngine.ChangeAccumulatingSessionToken x(PatchEngineEditorSynchronizer patchEngineEditorSynchronizer) {
        return PatchEngine.openAccumulatingSession$default(patchEngineEditorSynchronizer.engine, true, "PatchEngineEditorSynchronizer::documentChange", null, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit x(PatchEngineEditorSynchronizer patchEngineEditorSynchronizer, RdPatchEngine.ChangeAccumulatingSessionToken changeAccumulatingSessionToken) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeAccumulatingSessionToken), (String)"it");
        AutoCloseable autoCloseable = (AutoCloseable)((Object)changeAccumulatingSessionToken);
        Throwable throwable = null;
        try {
            RdPatchEngine.ChangeAccumulatingSessionToken changeAccumulatingSessionToken2 = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl = false;
            patchEngineEditorSynchronizer.x(SendingMode.DOCUMENT_WRAP_SNAPSHOT, true);
            changeAccumulatingSessionToken2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit x(PatchEngineEditorSynchronizer patchEngineEditorSynchronizer, RdEditorVersion rdEditorVersion, RdEditorChange rdEditorChange, RdEditorVersion rdEditorVersion2, RdDocumentVersion rdDocumentVersion) {
        PatchEngine patchEngine = patchEngineEditorSynchronizer.engine;
        String string = "PatchEngineEditorSynchronizer.sendChange";
        boolean bl = false;
        AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default(patchEngine, true, string, null, 4, null));
        Throwable throwable = null;
        try {
            RdPatchEngine.ChangeAccumulatingSessionToken changeAccumulatingSessionToken = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl2 = false;
            ChangeScope changeScope = changeAccumulatingSessionToken.getSession().getChangeScope();
            boolean bl3 = false;
            RdPatchEditorVersion rdPatchEditorVersion = new RdPatchEditorVersion(rdEditorVersion, rdEditorChange.getEditorId());
            RdPatchEditorVersion rdPatchEditorVersion2 = new RdPatchEditorVersion(rdEditorVersion2, rdEditorChange.getEditorId());
            changeScope.pushExpected(rdPatchEditorVersion);
            if (RdPatchUtilsKt.updatingChange(rdEditorChange, rdEditorVersion, rdEditorVersion2)) {
                changeScope.pushUpdated(rdPatchEditorVersion2);
            }
            changeScope.pushExpected(new RdPatchDocumentVersion(rdDocumentVersion, patchEngineEditorSynchronizer.documentSynchronizer.getUniqueIdOrBlank(), rdEditorChange.getEditorId().getDocumentId()));
            changeScope.pushChange(rdEditorChange);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void x(PatchEngineEditorSynchronizer patchEngineEditorSynchronizer) {
        ScrollingModelEx scrollingModelEx = ((EditorEx)patchEngineEditorSynchronizer.getEditor()).getScrollingModel();
        boolean bl = false;
        scrollingModelEx.disableAnimation();
        try {
            scrollingModelEx.scrollToCaret(ScrollType.RELATIVE);
        }
        finally {
            scrollingModelEx.enableAnimation();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer$Companion;", "", "PatchEngineEditorSynchronizer$Companion", "()V", "create", "Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "engine", "Lcom/jetbrains/rd/ide/requests/RdPatchEngine;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PatchEngineEditorSynchronizer create(@NotNull ClientAppSession session, @NotNull Lifetime textControlLifetime, @NotNull TextControlId editorId, @NotNull TextControlModel editorModel, @NotNull Editor editor, @NotNull DocumentSynchronizer documentSynchronizer, @NotNull RdPatchEngine engine2) {
            PatchEngineEditorSynchronizer patchEngineEditorSynchronizer;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
            Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
            Intrinsics.checkNotNullParameter((Object)((Object)editorModel), (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
            Intrinsics.checkNotNullParameter((Object)engine2, (String)"engine");
            PatchEngineEditorSynchronizer patchEngineEditorSynchronizer2 = patchEngineEditorSynchronizer = new PatchEngineEditorSynchronizer(textControlLifetime, session, editor, editorId, editorModel, documentSynchronizer, engine2);
            boolean bl = false;
            patchEngineEditorSynchronizer2.init();
            return patchEngineEditorSynchronizer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/ide/editor/PatchEngineEditorSynchronizer$SendingMode;", "", "PatchEngineEditorSynchronizer$SendingMode", "(Ljava/lang/String;I)V", "SNAPSHOT", "DOCUMENT_WRAP_SNAPSHOT", "CHANGE", "intellij.rd.platform"})
    private static final class SendingMode
    extends Enum<SendingMode> {
        public static final /* enum */ SendingMode SNAPSHOT = new SendingMode();
        public static final /* enum */ SendingMode DOCUMENT_WRAP_SNAPSHOT = new SendingMode();
        public static final /* enum */ SendingMode CHANGE = new SendingMode();
        private static final /* synthetic */ SendingMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SendingMode[] values() {
            return (SendingMode[])$VALUES.clone();
        }

        public static SendingMode valueOf(String value2) {
            return Enum.valueOf(SendingMode.class, value2);
        }

        @NotNull
        public static EnumEntries<SendingMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sendingModeArray = new SendingMode[]{SendingMode.SNAPSHOT, SendingMode.DOCUMENT_WRAP_SNAPSHOT, SendingMode.CHANGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SendingMode.values().length];
            try {
                nArray[SendingMode.CHANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SendingMode.SNAPSHOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SendingMode.DOCUMENT_WRAP_SNAPSHOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

