/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.rd.DisposableEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogRangeShifter;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.document.DocumentUniqueIdSessionRegistry;
import com.jetbrains.rd.ide.document.DocumentVersionHolder;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizerKt;
import com.jetbrains.rd.ide.document.RdDocumentVersions;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.ide.vfs.IProtocolVirtualFile;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.string.IPrintableKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 T2\u00020\u00012\u00020\u0002:\u0001TBG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001f\u0010/\u001a\u00020,2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020$03H\u0082\bJ\u0010\u00104\u001a\u0002012\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u00105\u001a\u00020,J\u0016\u00106\u001a\u00020,2\u0006\u00100\u001a\u0002072\u0006\u00108\u001a\u00020\u0010J\u0018\u00109\u001a\u00020,2\u0006\u00100\u001a\u0002072\b\b\u0002\u0010:\u001a\u00020\u0010J\u0010\u0010;\u001a\u00020,2\u0006\u00100\u001a\u000207H\u0002J\u0010\u0010<\u001a\u00020,2\u0006\u00100\u001a\u000207H\u0002J\u0010\u0010=\u001a\u00020,2\u0006\u00100\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010@\u001a\u00020,2\u0006\u00100\u001a\u000201H\u0002J\u000e\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020CJ\u000e\u0010G\u001a\u00020,H\u0086@\u00a2\u0006\u0002\u0010HJ\u0010\u0010I\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010J\u001a\u00020KH\u0016J\u0010\u0010M\u001a\u00020,2\u0006\u0010N\u001a\u00020OH\u0016J\b\u0010P\u001a\u00020QH\u0016J\u0018\u0010R\u001a\u00020,2\u0006\u00100\u001a\u0002072\u0006\u0010S\u001a\u00020CH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010#\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010D\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0014\u0010B\u001a\u00020C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010F\u00a8\u0006U"}, d2={"Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "Lcom/intellij/openapi/editor/ex/PrioritizedDocumentListener;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "modelDocument", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "versionHolder", "Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "sendDocumentText", "", "forceWrite", "PatchEngineDocumentSynchronizer", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rd/ide/model/RdDocumentModel;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;Lcom/jetbrains/rd/ide/requests/PatchEngine;ZZ)V", "getDocumentLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getModelDocument", "()Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "getDocumentId", "()Lcom/jetbrains/rd/ide/model/RdDocumentId;", "backendUpdateInProgressMarker", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "()V", "documentLog", "Lcom/jetbrains/rd/ide/document/DocumentLog;", "uniqueId", "", "getUniqueId", "()Ljava/lang/String;", "uniqueIdOrBlank", "getUniqueIdOrBlank", "isReceivingChange", "()Z", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "x", "change", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "diagnosticData", "Lkotlin/Function0;", "x", "sendInitialTextChange", "updateDocumentLog", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "redo", "receiveDocumentChange", "forceRecordPatch", "x", "G", "x", "Lcom/jetbrains/rd/ide/model/RdResetDocumentChange;", "x", "G", "updateLastKnownVersion", "version", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "lastKnownVersion", "getLastKnownVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "waitForInitialDocumentChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "beforeDocumentChange", "getPriority", "", "getVersion", "resetVersion", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "createRangeShifter", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "x", "prevVersion", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nPatchEngineDocumentSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineDocumentSynchronizer.kt\ncom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,403:1\n95#1,9:405\n104#1,11:418\n95#1,9:445\n104#1,11:458\n1#2:404\n67#3,4:414\n67#3,4:429\n67#3,4:433\n67#3,4:437\n67#3,4:441\n67#3,4:454\n39#4,2:469\n*S KotlinDebug\n*F\n+ 1 PatchEngineDocumentSynchronizer.kt\ncom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer\n*L\n89#1:405,9\n89#1:418,11\n333#1:445,9\n333#1:458,11\n89#1:414,4\n103#1:429,4\n107#1:433,4\n158#1:437,4\n208#1:441,4\n333#1:454,4\n370#1:469,2\n*E\n"})
public final class PatchEngineDocumentSynchronizer
implements PrioritizedDocumentListener,
DocumentSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime documentLifetime;
    @NotNull
    private final Document document;
    @NotNull
    private final RdDocumentModel modelDocument;
    @NotNull
    private final RdDocumentId documentId;
    @NotNull
    private final DocumentVersionHolder versionHolder;
    @NotNull
    private final PatchEngine engine;
    private final boolean sendDocumentText;
    private final boolean forceWrite;
    private boolean backendUpdateInProgressMarker;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DocumentLog documentLog;
    private static int debugId;

    public PatchEngineDocumentSynchronizer(@NotNull Lifetime documentLifetime, @NotNull Document document, @NotNull RdDocumentModel modelDocument, @NotNull RdDocumentId documentId, @NotNull DocumentVersionHolder versionHolder, @NotNull PatchEngine engine2, boolean sendDocumentText, boolean forceWrite) {
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)modelDocument), (String)"modelDocument");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)versionHolder, (String)"versionHolder");
        Intrinsics.checkNotNullParameter((Object)engine2, (String)"engine");
        this.documentLifetime = documentLifetime;
        this.document = document;
        this.modelDocument = modelDocument;
        this.documentId = documentId;
        this.versionHolder = versionHolder;
        this.engine = engine2;
        this.sendDocumentText = sendDocumentText;
        this.forceWrite = forceWrite;
        this.documentLog = new DocumentLog(true);
        BuildersKt.launch$default((CoroutineScope)this.getDocumentLifetime().getCoroutineScope(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PatchEngineDocumentSynchronizer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 2 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl16
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        PatchEngineDocumentSynchronizer.access$getDocumentLog$p(this.this$0).updateLastKnownVersion(this.this$0.getLastKnownVersion());
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        String string = DocumentExKt.createLogCategory(this.getDocumentId());
        int n = debugId;
        debugId = n + 1;
        Logger logger = Logger.getInstance((String)("#com.jetbrains.rd.ide.document.Document#" + n + "(" + string + ")"));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.getDocument().addDocumentListener((DocumentListener)this, DisposableEx.createNestedDisposable$default(this.getDocumentLifetime(), null, 1, null));
    }

    @Override
    @NotNull
    public Lifetime getDocumentLifetime() {
        return this.documentLifetime;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public RdDocumentModel getModelDocument() {
        return this.modelDocument;
    }

    @Override
    @NotNull
    public RdDocumentId getDocumentId() {
        return this.documentId;
    }

    private static /* synthetic */ void getLogger$annotations() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getUniqueId() {
        PatchEngine patchEngine = this.engine;
        if (!(patchEngine instanceof RdPatchEngine)) return null;
        RdPatchEngine rdPatchEngine = (RdPatchEngine)patchEngine;
        RdPatchEngine rdPatchEngine2 = rdPatchEngine;
        if (rdPatchEngine2 == null) return null;
        patchEngine = rdPatchEngine2.getClientSession();
        if (patchEngine == null) return null;
        PatchEngine patchEngine2 = patchEngine;
        boolean bl = false;
        DocumentUniqueIdSessionRegistry documentUniqueIdSessionRegistry = DocumentUniqueIdSessionRegistry.Companion.getInstance((ClientAppSession)patchEngine2);
        if (documentUniqueIdSessionRegistry == null) return null;
        String string = documentUniqueIdSessionRegistry.getUniqueId(this.getDocument());
        return string;
    }

    @NotNull
    public final String getUniqueIdOrBlank() {
        String string = this.getUniqueId();
        if (string == null) {
            PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this;
            boolean bl = false;
            patchEngineDocumentSynchronizer.logger.error("Document (documentId=" + patchEngineDocumentSynchronizer.getDocumentId() + " uniqueId is null");
            string = "";
        }
        return string;
    }

    @Override
    public boolean isReceivingChange() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.backendUpdateInProgressMarker;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isReceivingChange()) {
            return;
        }
        RdDocumentChange rdDocumentChange = this.x(event);
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this;
        RdDocumentChange rdDocumentChange2 = rdDocumentChange;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)rdDocumentChange2.getNewVersion(), (Object)patchEngineDocumentSynchronizer.versionHolder.getVersion())) {
            patchEngineDocumentSynchronizer.logger.error("change versions: " + rdDocumentChange2.getNewVersion() + " is not synchronized with versionsHolder:" + patchEngineDocumentSynchronizer.versionHolder.getVersion());
        }
        DocumentSynchronizerListeners.Companion.getInstance(patchEngineDocumentSynchronizer.engine).change(rdDocumentChange2);
        patchEngineDocumentSynchronizer.documentLog.addOrUpdate(rdDocumentChange2.getNewVersion(), rdDocumentChange2);
        if (patchEngineDocumentSynchronizer.backendUpdateInProgressMarker) {
            Logger logger = patchEngineDocumentSynchronizer.logger;
            boolean bl2 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl3 = false;
                boolean bl4 = false;
                logger2.trace("Skip processing document change from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(event) + ", Version: " + patchEngineDocumentSynchronizer.versionHolder.getVersion());
            }
        } else {
            Logger logger = patchEngineDocumentSynchronizer.logger;
            boolean bl5 = false;
            if (logger.isTraceEnabled()) {
                Logger logger3 = logger;
                boolean bl6 = false;
                boolean bl7 = false;
                logger3.trace("Document was changed from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(event) + ", Version: " + patchEngineDocumentSynchronizer.versionHolder.getVersion() + ", Document length: " + patchEngineDocumentSynchronizer.getDocument().getTextLength());
            }
            patchEngineDocumentSynchronizer.x((RdDocumentChangeBase)rdDocumentChange2, rdDocumentChange2.getOldVersion());
            if (!Intrinsics.areEqual((Object)rdDocumentChange2.getNewVersion(), (Object)patchEngineDocumentSynchronizer.versionHolder.getVersion())) {
                patchEngineDocumentSynchronizer.logger.error("change versions: " + rdDocumentChange2.getNewVersion() + " is not synchronized with versionsHolder:" + patchEngineDocumentSynchronizer.versionHolder.getVersion());
            }
        }
    }

    private final void x(RdDocumentChange rdDocumentChange, Function0<String> function0) {
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)rdDocumentChange.getNewVersion(), (Object)this.versionHolder.getVersion())) {
            this.logger.error("change versions: " + rdDocumentChange.getNewVersion() + " is not synchronized with versionsHolder:" + this.versionHolder.getVersion());
        }
        DocumentSynchronizerListeners.Companion.getInstance(this.engine).change(rdDocumentChange);
        this.documentLog.addOrUpdate(rdDocumentChange.getNewVersion(), rdDocumentChange);
        if (this.backendUpdateInProgressMarker) {
            Logger logger = this.logger;
            boolean bl2 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl3 = false;
                logger2.trace("Skip processing document change from client side. Change event = " + function0.invoke() + ", Version: " + this.versionHolder.getVersion());
            }
            return;
        }
        Logger logger = this.logger;
        boolean bl4 = false;
        if (logger.isTraceEnabled()) {
            Logger logger3 = logger;
            boolean bl5 = false;
            logger3.trace("Document was changed from client side. Change event = " + function0.invoke() + ", Version: " + this.versionHolder.getVersion() + ", Document length: " + this.getDocument().getTextLength());
        }
        this.x((RdDocumentChangeBase)rdDocumentChange, rdDocumentChange.getOldVersion());
        if (!Intrinsics.areEqual((Object)rdDocumentChange.getNewVersion(), (Object)this.versionHolder.getVersion())) {
            this.logger.error("change versions: " + rdDocumentChange.getNewVersion() + " is not synchronized with versionsHolder:" + this.versionHolder.getVersion());
        }
    }

    private final RdDocumentChange x(DocumentEvent documentEvent) {
        CharSequence charSequence = documentEvent.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOldFragment(...)");
        RdTextModificationKind rdTextModificationKind = charSequence.length() == 0 && documentEvent instanceof DocumentEventImpl ? (((DocumentEventImpl)documentEvent).getInitialStartOffset() < ((DocumentEventImpl)documentEvent).getOffset() ? RdTextModificationKind.RightSide : (((DocumentEventImpl)documentEvent).getInitialStartOffset() + ((DocumentEventImpl)documentEvent).getInitialOldLength() > ((DocumentEventImpl)documentEvent).getOffset() ? RdTextModificationKind.LeftSide : RdTextModificationKind.NotSpecified)) : RdTextModificationKind.NotSpecified;
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getMoveOffset();
        String string = ((Object)documentEvent.getNewFragment()).toString();
        String string2 = ((Object)documentEvent.getOldFragment()).toString();
        int n3 = documentEvent.getDocument().getTextLength() + documentEvent.getOldLength() - documentEvent.getNewLength();
        RdDocumentVersions rdDocumentVersions = this.versionHolder.incrementVersion(n, n2, string2, string, n3);
        return new RdDocumentChange(n, n2, string, string2, rdTextModificationKind, n3, this.sendDocumentText ? documentEvent.getDocument().getText() : null, documentEvent.isWholeTextReplaced(), this.getDocumentId(), rdDocumentVersions.getNew(), rdDocumentVersions.getOld(), this.getUniqueIdOrBlank());
    }

    public final void sendInitialTextChange() {
        String string = this.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        RdDocumentVersions rdDocumentVersions = this.versionHolder.incrementVersion(string2);
        RdResetDocumentChange rdResetDocumentChange = new RdResetDocumentChange(string2, this.getDocumentId(), rdDocumentVersions.getNew(), rdDocumentVersions.getOld(), this.getUniqueIdOrBlank());
        this.documentLog.addOrUpdate(this.versionHolder.getVersion(), rdResetDocumentChange);
        Logger logger = this.logger;
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("[file] sendInitialTextChange: send RdResetDocumentChange by engine. documentId=" + DocumentExKt.toDebugString(this.getDocumentId()) + ", newVersion=" + this.versionHolder.getVersion());
        }
        this.x(rdResetDocumentChange, rdDocumentVersions.getOld());
    }

    public final void updateDocumentLog(@NotNull RdDocumentChangeBase change, boolean redo) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        RdDocumentChangeBase rdDocumentChangeBase = change;
        if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
            RdDocumentVersion rdDocumentVersion = this.getVersion();
            this.resetVersion(change.getNewVersion());
            if (redo) {
                this.x(change, rdDocumentVersion);
                this.documentLog.add(this.getVersion(), change);
            }
        } else if (rdDocumentChangeBase instanceof RdDocumentChange) {
            RdDocumentVersions rdDocumentVersions = this.versionHolder.incrementVersion(((RdDocumentChange)change).getOffset(), ((RdDocumentChange)change).getMoveOffset(), ((RdDocumentChange)change).getOldText(), ((RdDocumentChange)change).getNewText(), ((RdDocumentChange)change).getOldDocumentLength());
            if (!(redo || Intrinsics.areEqual((Object)change.getOldVersion(), (Object)rdDocumentVersions.getOld()) && Intrinsics.areEqual((Object)change.getNewVersion(), (Object)rdDocumentVersions.getNew()))) {
                this.logger.error("Unexpected version: " + this.versionHolder.getVersion() + ", expected: " + change.getOldVersion() + ". change: " + IPrintableKt.printToString((Object)change));
            }
            RdDocumentChange rdDocumentChange = new RdDocumentChange(((RdDocumentChange)change).getOffset(), ((RdDocumentChange)change).getMoveOffset(), ((RdDocumentChange)change).getNewText(), ((RdDocumentChange)change).getOldText(), ((RdDocumentChange)change).getModificationKind(), ((RdDocumentChange)change).getOldDocumentLength(), ((RdDocumentChange)change).getText(), ((RdDocumentChange)change).isWholeTextReplaced(), change.getDocumentId(), rdDocumentVersions.getNew(), rdDocumentVersions.getOld(), change.getUniqueId());
            if (redo) {
                this.x((RdDocumentChangeBase)rdDocumentChange, rdDocumentVersions.getOld());
            }
            if (!Intrinsics.areEqual((Object)this.versionHolder.getVersion(), (Object)rdDocumentChange.getNewVersion())) {
                this.logger.error("versionHolder.version: " + this.versionHolder.getVersion() + " != " + rdDocumentChange.getNewVersion());
            }
            this.documentLog.add(this.getVersion(), rdDocumentChange);
        } else {
            throw new IllegalStateException(("Unexpected change: " + change).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveDocumentChange(@NotNull RdDocumentChangeBase change, boolean forceRecordPatch) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        try {
            boolean bl = this.backendUpdateInProgressMarker = !forceRecordPatch;
            if (change instanceof RdDocumentChange && this.getDocument().getTextLength() != ((RdDocumentChange)change).getOldDocumentLength()) {
                throw new IllegalStateException(("expected document length: " + ((RdDocumentChange)change).getOldDocumentLength() + ", but actual length: " + this.getDocument().getTextLength()).toString());
            }
            Logger logger = this.logger;
            boolean bl2 = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl3 = false;
                logger2.trace("Applying client document change: " + IPrintableKt.printToString((Object)change) + ", document length: " + this.getDocument().getTextLength());
            }
            ApplicationKt.getApplication().runWriteAction(() -> PatchEngineDocumentSynchronizer.x(this, change, forceRecordPatch));
        }
        finally {
            this.backendUpdateInProgressMarker = false;
        }
    }

    public static /* synthetic */ void receiveDocumentChange$default(PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer, RdDocumentChangeBase rdDocumentChangeBase, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        patchEngineDocumentSynchronizer.receiveDocumentChange(rdDocumentChangeBase, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void x(RdDocumentChangeBase rdDocumentChangeBase) {
        if (this.forceWrite && !this.getDocument().isWritable()) {
            this.getDocument().setReadOnly(false);
            try {
                this.G(rdDocumentChangeBase);
            }
            finally {
                this.getDocument().setReadOnly(true);
            }
        } else {
            this.G(rdDocumentChangeBase);
        }
    }

    private final void G(RdDocumentChangeBase rdDocumentChangeBase) {
        RdDocumentChangeBase rdDocumentChangeBase2 = rdDocumentChangeBase;
        if (rdDocumentChangeBase2 instanceof RdResetDocumentChange) {
            this.x((RdResetDocumentChange)rdDocumentChangeBase);
        } else if (rdDocumentChangeBase2 instanceof RdDocumentChange) {
            if (!Intrinsics.areEqual((Object)rdDocumentChangeBase.getOldVersion(), (Object)this.versionHolder.getVersion())) {
                this.logger.error("Unexpected version: " + this.versionHolder.getVersion() + ", expected: " + rdDocumentChangeBase.getOldVersion() + ". change: " + IPrintableKt.printToString((Object)rdDocumentChangeBase));
            }
            this.x((RdDocumentChange)rdDocumentChangeBase);
            this.G((RdDocumentChange)rdDocumentChangeBase);
        } else {
            this.logger.error((Throwable)new IllegalStateException("Unknown document change type: " + rdDocumentChangeBase));
        }
    }

    private final void x(RdResetDocumentChange rdResetDocumentChange) {
        boolean bl;
        boolean bl2 = bl = this.getDocument().getTextLength() == rdResetDocumentChange.getText().length() && Intrinsics.areEqual((Object)this.getDocument().getText(), (Object)rdResetDocumentChange.getText());
        if (this.isReceivingChange() && bl) {
            this.versionHolder.resetVersion(rdResetDocumentChange.getNewVersion());
            this.documentLog.addOrUpdate(this.versionHolder.getVersion(), rdResetDocumentChange);
        } else {
            if (!bl) {
                VirtualFile virtualFile = Intrinsics.areEqual((Object)this.getVersion(), (Object)DocumentVersionsKt.getInitialDocVersion()) && PlatformUtils.isJetBrainsClient() ? FileDocumentManager.getInstance().getFile(this.getDocument()) : null;
                this.getDocument().setText((CharSequence)rdResetDocumentChange.getText());
                VirtualFile virtualFile2 = virtualFile;
                if (virtualFile2 != null) {
                    virtualFile2.putUserData(IProtocolVirtualFile.Companion.getFORBID_TEXT_GET(), null);
                }
            }
            this.resetVersion(rdResetDocumentChange.getNewVersion());
            if (!this.isReceivingChange()) {
                this.x(rdResetDocumentChange, rdResetDocumentChange.getOldVersion());
            } else {
                this.documentLog.addOrUpdate(this.versionHolder.getVersion(), rdResetDocumentChange);
            }
        }
    }

    private final void x(RdDocumentChange rdDocumentChange) {
        int n = rdDocumentChange.getOffset();
        String string = rdDocumentChange.getOldText();
        String string2 = rdDocumentChange.getNewText();
        if (Intrinsics.areEqual((Object)rdDocumentChange.isWholeTextReplaced(), (Object)true)) {
            String string3 = this.getDocument().getText(new TextRange(0, n)) + string2 + this.getDocument().getText(new TextRange(n + string.length(), this.getDocument().getTextLength()));
            this.getDocument().setText((CharSequence)string3);
            return;
        }
        if (((CharSequence)string).length() == 0 && rdDocumentChange.getModificationKind() == RdTextModificationKind.LeftSide) {
            int n2 = Math.min(this.getDocument().getTextLength(), n + 1);
            String string4 = string2 + this.getDocument().getText(new TextRange(n, n2));
            this.getDocument().replaceString(n, n2, (CharSequence)string4);
            return;
        }
        if (((CharSequence)string).length() == 0 && rdDocumentChange.getModificationKind() == RdTextModificationKind.RightSide) {
            int n3 = Math.max(0, n - 1);
            String string5 = this.getDocument().getText(new TextRange(n3, n)) + string2;
            this.getDocument().replaceString(n3, n, (CharSequence)string5);
            return;
        }
        if (this.getDocument() instanceof DocumentImpl) {
            ((DocumentImpl)this.getDocument()).replaceString(n, n + string.length(), rdDocumentChange.getMoveOffset(), (CharSequence)string2, LocalTimeCounter.currentTime(), false);
            return;
        }
        this.getDocument().replaceString(n, n + string.length(), (CharSequence)string2);
    }

    private final void G(RdDocumentChange rdDocumentChange) {
        if (Intrinsics.areEqual((Object)rdDocumentChange.getNewVersion(), (Object)this.versionHolder.getVersion())) {
            return;
        }
        this.resetVersion(rdDocumentChange.getNewVersion());
        if (rdDocumentChange.getNewVersion().getValue() > rdDocumentChange.getOldVersion().getValue()) {
            PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this;
            RdDocumentChange rdDocumentChange2 = rdDocumentChange;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)rdDocumentChange2.getNewVersion(), (Object)patchEngineDocumentSynchronizer.versionHolder.getVersion())) {
                patchEngineDocumentSynchronizer.logger.error("change versions: " + rdDocumentChange2.getNewVersion() + " is not synchronized with versionsHolder:" + patchEngineDocumentSynchronizer.versionHolder.getVersion());
            }
            DocumentSynchronizerListeners.Companion.getInstance(patchEngineDocumentSynchronizer.engine).change(rdDocumentChange2);
            patchEngineDocumentSynchronizer.documentLog.addOrUpdate(rdDocumentChange2.getNewVersion(), rdDocumentChange2);
            if (patchEngineDocumentSynchronizer.backendUpdateInProgressMarker) {
                Logger logger = patchEngineDocumentSynchronizer.logger;
                boolean bl2 = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    logger2.trace("Skip processing document change from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(rdDocumentChange) + ", Version: " + patchEngineDocumentSynchronizer.versionHolder.getVersion());
                }
            } else {
                Logger logger = patchEngineDocumentSynchronizer.logger;
                boolean bl5 = false;
                if (logger.isTraceEnabled()) {
                    Logger logger3 = logger;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    logger3.trace("Document was changed from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(rdDocumentChange) + ", Version: " + patchEngineDocumentSynchronizer.versionHolder.getVersion() + ", Document length: " + patchEngineDocumentSynchronizer.getDocument().getTextLength());
                }
                patchEngineDocumentSynchronizer.x((RdDocumentChangeBase)rdDocumentChange2, rdDocumentChange2.getOldVersion());
                if (!Intrinsics.areEqual((Object)rdDocumentChange2.getNewVersion(), (Object)patchEngineDocumentSynchronizer.versionHolder.getVersion())) {
                    patchEngineDocumentSynchronizer.logger.error("change versions: " + rdDocumentChange2.getNewVersion() + " is not synchronized with versionsHolder:" + patchEngineDocumentSynchronizer.versionHolder.getVersion());
                }
            }
        } else {
            DocumentSynchronizerListeners.Companion.getInstance(this.engine).change(rdDocumentChange);
        }
    }

    public final void updateLastKnownVersion(@NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.documentLog.updateLastKnownVersion(version);
    }

    @NotNull
    public final RdDocumentVersion getLastKnownVersion() {
        return this.documentLog.getLastKnownVersion();
    }

    @Nullable
    public final Object waitForInitialDocumentChange(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.documentLog.getDeferredNonInitialVersion$intellij_rd_platform().await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public int getPriority() {
        return 39;
    }

    @Override
    @NotNull
    public RdDocumentVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    @Override
    public void resetVersion(@NotNull AbstractDocumentVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdDocumentVersion cfr_ignored_0 = (RdDocumentVersion)v;
        this.versionHolder.resetVersion((RdDocumentVersion)v);
        this.documentLog.rollbackHistoryToVersion((RdDocumentVersion)v);
    }

    @Override
    @NotNull
    public IDocumentRangeShifter createRangeShifter() {
        return new DocumentLogRangeShifter(this.documentLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void x(RdDocumentChangeBase rdDocumentChangeBase, RdDocumentVersion rdDocumentVersion) {
        PatchEngine patchEngine = this.engine;
        String string = "PatchEngineDocumentSynchronizerKt.sendDocumentChange";
        boolean bl = false;
        AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default(patchEngine, true, string, null, 4, null));
        Throwable throwable = null;
        try {
            Pair pair;
            RdPatchEngine.ChangeAccumulatingSessionToken changeAccumulatingSessionToken = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl2 = false;
            ChangeScope changeScope = changeAccumulatingSessionToken.getSession().getChangeScope();
            boolean bl3 = false;
            Object object = rdDocumentChangeBase;
            if (object instanceof RdResetDocumentChange) {
                pair = new Pair((Object)rdDocumentVersion, (Object)rdDocumentChangeBase.getNewVersion());
            } else if (object instanceof RdDocumentChange) {
                pair = new Pair((Object)rdDocumentChangeBase.getOldVersion(), (Object)rdDocumentChangeBase.getNewVersion());
            } else {
                throw new IllegalStateException(("Unexpected change: " + rdDocumentChangeBase).toString());
            }
            Pair pair2 = pair;
            object = (RdDocumentVersion)pair2.component1();
            RdDocumentVersion rdDocumentVersion2 = (RdDocumentVersion)pair2.component2();
            if (!Intrinsics.areEqual((Object)object, (Object)rdDocumentVersion2)) {
                RdPatchDocumentVersion rdPatchDocumentVersion = new RdPatchDocumentVersion((RdDocumentVersion)object, this.getUniqueIdOrBlank(), rdDocumentChangeBase.getDocumentId());
                changeScope.pushExpected(rdPatchDocumentVersion);
                RdPatchDocumentVersion rdPatchDocumentVersion2 = new RdPatchDocumentVersion(rdDocumentVersion2, this.getUniqueIdOrBlank(), rdDocumentChangeBase.getDocumentId());
                changeScope.pushUpdated(rdPatchDocumentVersion2);
                changeScope.pushChange(rdDocumentChangeBase);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void x(PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer, RdDocumentChangeBase rdDocumentChangeBase, boolean bl) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (commandProcessor.isCommandInProgress()) {
            patchEngineDocumentSynchronizer.x(rdDocumentChangeBase);
        } else {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> PatchEngineDocumentSynchronizer.x(patchEngineDocumentSynchronizer, rdDocumentChangeBase));
        }
        if (rdDocumentChangeBase instanceof RdDocumentChange && ((RdDocumentChange)rdDocumentChangeBase).getText() != null && !Intrinsics.areEqual((Object)patchEngineDocumentSynchronizer.getDocument().getText(), (Object)((RdDocumentChange)rdDocumentChangeBase).getText())) {
            if (bl) {
                patchEngineDocumentSynchronizer.logger.warn("Not matched document text on version: " + patchEngineDocumentSynchronizer.versionHolder.getVersion().getValue() + ". Probably text was already changed during rebase.");
            } else {
                patchEngineDocumentSynchronizer.logger.error("Not matched document text on version: " + patchEngineDocumentSynchronizer.versionHolder.getVersion().getValue());
            }
        }
    }

    private static final void x(PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer, RdDocumentChangeBase rdDocumentChangeBase) {
        patchEngineDocumentSynchronizer.x(rdDocumentChangeBase);
    }

    public static final /* synthetic */ DocumentLog access$getDocumentLog$p(PatchEngineDocumentSynchronizer $this) {
        return $this.documentLog;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer$Companion;", "", "PatchEngineDocumentSynchronizer$Companion", "()V", "debugId", "", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

