/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\u001a,\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a6\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"shiftOnePoint", "", "changes", "", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "offset", "isStickingToRight", "", "surviveRangeRemoval", "shiftRange", "Lcom/intellij/openapi/util/TextRange;", "", "range", "isVerifiable", "isGreedyToLeft", "isGreedyToRight", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentLogRangeShifter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentLogRangeShifter.kt\ncom/jetbrains/rd/ide/document/DocumentLogRangeShifterKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
public final class DocumentLogRangeShifterKt {
    public static final int shiftOnePoint(@NotNull List<? extends RdDocumentChangeBase> changes, int offset, boolean isStickingToRight, boolean surviveRangeRemoval) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        int n = offset;
        int n2 = 0;
        for (RdDocumentChangeBase rdDocumentChangeBase : changes) {
            int n3;
            if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
                return -1;
            }
            if (!(rdDocumentChangeBase instanceof RdDocumentChange)) {
                n3 = 0;
                String string = "Unknown document change type: " + rdDocumentChangeBase;
                throw new IllegalStateException(string.toString());
            }
            int n4 = ((RdDocumentChange)rdDocumentChangeBase).getOldText().length();
            n3 = ((RdDocumentChange)rdDocumentChangeBase).getOffset();
            int n5 = n3 + n4;
            int n6 = ((RdDocumentChange)rdDocumentChangeBase).getNewText().length() - ((RdDocumentChange)rdDocumentChangeBase).getOldText().length();
            if (n < n3) continue;
            if (n == n5) {
                if (n6 > 0 && ((RdDocumentChange)rdDocumentChangeBase).getModificationKind() == RdTextModificationKind.RightSide) continue;
                if (isStickingToRight) {
                    n += n6;
                    continue;
                }
                if (n6 > 0 && n2 == 0) continue;
                n += n6;
                if (n6 < 0) {
                    ++n2;
                }
                if (n6 <= 0) continue;
                --n2;
                continue;
            }
            if (n > n5 || isStickingToRight && n4 == 0) {
                n += n6;
                continue;
            }
            if (n == n3) continue;
            if (surviveRangeRemoval) {
                n = n3;
                continue;
            }
            return -1;
        }
        return n;
    }

    @Nullable
    public static final TextRange shiftRange(@NotNull Iterable<? extends RdDocumentChangeBase> changes, @NotNull TextRange range, boolean isVerifiable, boolean isGreedyToLeft, boolean isGreedyToRight) {
        int n;
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int n2 = n = range.getStartOffset() <= range.getEndOffset() ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl = false;
            String string = "Range: " + range + " is not normalized";
            throw new AssertionError((Object)string);
        }
        n = range.getStartOffset();
        int n3 = range.getEndOffset();
        for (RdDocumentChangeBase rdDocumentChangeBase : changes) {
            int n4;
            if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
                return null;
            }
            if (!(rdDocumentChangeBase instanceof RdDocumentChange)) {
                n4 = 0;
                String string = "Unknown document change type: " + rdDocumentChangeBase;
                throw new IllegalStateException(string.toString());
            }
            int n5 = ((RdDocumentChange)rdDocumentChangeBase).getOldText().length();
            n4 = ((RdDocumentChange)rdDocumentChangeBase).getNewText().length();
            int n6 = ((RdDocumentChange)rdDocumentChangeBase).getOffset();
            int n7 = n6 + n5;
            int n8 = n4 - n5;
            if (n5 == 0 && ((RdDocumentChange)rdDocumentChangeBase).getMoveOffset() != n6) {
                int n9 = ((RdDocumentChange)rdDocumentChangeBase).getMoveOffset();
                boolean bl = false;
                int n10 = n9 > n6 ? n9 - n4 : n9;
                if (n10 <= n && n3 <= n10 + n4) {
                    int n11 = n6 - n10;
                    n += n11;
                    n3 += n11;
                    continue;
                }
            }
            if (!isVerifiable && n3 == n6 && (((RdDocumentChange)rdDocumentChangeBase).getModificationKind() == RdTextModificationKind.RightSide || isGreedyToRight)) {
                n3 += n8;
                continue;
            }
            if (n3 <= n6) continue;
            if (!isVerifiable && n == n7 && (((RdDocumentChange)rdDocumentChangeBase).getModificationKind() == RdTextModificationKind.LeftSide || isGreedyToLeft)) {
                n3 += n8;
                if (n8 >= 0) continue;
                n += n8;
                continue;
            }
            if (n >= n7) {
                n += n8;
                n3 += n8;
                continue;
            }
            if (n <= n6 && n7 <= n3 && !isVerifiable) {
                n3 += n8;
                continue;
            }
            return null;
        }
        return range.equalsToRange(n, n3) ? range : new TextRange(n, n3);
    }
}

