/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.SshConnectionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0018\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0001*\u00020\u0004\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0003*\u00020\u0004\u001a\u001e\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00010\f*\u00020\u000e\u001a2\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00100\f2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"findPublicKeyWithIndex", "Lkotlin/Pair;", "", "Lcom/intellij/ssh/config/AuthMethod$PublicKey;", "Lcom/intellij/ssh/config/AuthMethods;", "findPublicKey", "openSshLabel", "", "Lcom/intellij/ssh/config/AuthMethod;", "getOpenSshLabel", "(Lcom/intellij/ssh/config/AuthMethod;)Ljava/lang/String;", "toPairs", "", "", "Lcom/intellij/ssh/config/SshConnectionConfig;", "sshConnectionConfigDiff", "Lkotlin/Triple;", "old", "new", "defaultKexAlgorithms", "defaultHostKeyAlgorithms", "defaultCiphers", "defaultMacs", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshConnectionConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionConfig.kt\ncom/intellij/ssh/config/SshConnectionConfigKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,512:1\n360#2,7:513\n1617#2,9:520\n1869#2:529\n1870#2:531\n1626#2:532\n1#3:530\n*S KotlinDebug\n*F\n+ 1 SshConnectionConfig.kt\ncom/intellij/ssh/config/SshConnectionConfigKt\n*L\n315#1:513,7\n356#1:520,9\n356#1:529\n356#1:531\n356#1:532\n356#1:530\n*E\n"})
public final class SshConnectionConfigKt {
    @NotNull
    private static final List<String> defaultKexAlgorithms;
    @NotNull
    private static final List<String> defaultHostKeyAlgorithms;
    @NotNull
    private static final List<String> defaultCiphers;
    @NotNull
    private static final List<String> defaultMacs;

    @Nullable
    public static final Pair<Integer, AuthMethod.PublicKey> findPublicKeyWithIndex(@NotNull AuthMethods $this$findPublicKeyWithIndex) {
        Pair pair;
        int n;
        int n2;
        int n3;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$findPublicKeyWithIndex, (String)"<this>");
            List list2 = $this$findPublicKeyWithIndex;
            n3 = 0;
            n2 = 0;
            for (Object e : list2) {
                AuthMethod authMethod = (AuthMethod)e;
                boolean bl = false;
                if (authMethod instanceof AuthMethod.PublicKey) {
                    n = n2;
                    break block4;
                }
                ++n2;
            }
            n = -1;
        }
        n3 = n;
        n2 = 0;
        if (n3 >= 0) {
            Integer n4 = n3;
            AuthMethod authMethod = $this$findPublicKeyWithIndex.get(n3);
            Intrinsics.checkNotNull((Object)authMethod, (String)"null cannot be cast to non-null type com.intellij.ssh.config.AuthMethod.PublicKey");
            pair = TuplesKt.to((Object)n4, (Object)((AuthMethod.PublicKey)authMethod));
        } else {
            pair = null;
        }
        return pair;
    }

    @Nullable
    public static final AuthMethod.PublicKey findPublicKey(@NotNull AuthMethods $this$findPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$findPublicKey, (String)"<this>");
        Pair<Integer, AuthMethod.PublicKey> pair = SshConnectionConfigKt.findPublicKeyWithIndex($this$findPublicKey);
        return pair != null ? (AuthMethod.PublicKey)pair.getSecond() : null;
    }

    @NotNull
    public static final String getOpenSshLabel(@NotNull AuthMethod $this$openSshLabel) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$openSshLabel, (String)"<this>");
        AuthMethod authMethod = $this$openSshLabel;
        if (authMethod instanceof AuthMethod.PublicKey) {
            string = "publickey";
        } else if (Intrinsics.areEqual((Object)authMethod, (Object)AuthMethod.Password.INSTANCE)) {
            string = "password";
        } else if (Intrinsics.areEqual((Object)authMethod, (Object)AuthMethod.KeyboardInteractive.INSTANCE)) {
            string = "keyboard-interactive";
        } else if (Intrinsics.areEqual((Object)authMethod, (Object)AuthMethod.GssApi.INSTANCE)) {
            string = "gssapi-with-mic";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final List<Pair<String, Object>> toPairs(@NotNull SshConnectionConfig $this$toPairs) {
        Intrinsics.checkNotNullParameter((Object)$this$toPairs, (String)"<this>");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"authMethods", (Object)$this$toPairs.getAuthMethods()), TuplesKt.to((Object)"ciphers", $this$toPairs.getCiphers()), TuplesKt.to((Object)"compression", (Object)$this$toPairs.getCompression()), TuplesKt.to((Object)"connectTimeout", (Object)$this$toPairs.getConnectTimeout()), TuplesKt.to((Object)"environmentVariables", $this$toPairs.getEnvironmentVariables()), TuplesKt.to((Object)"forwardAgent", (Object)$this$toPairs.getForwardAgent()), TuplesKt.to((Object)"host", (Object)$this$toPairs.getHost()), TuplesKt.to((Object)"hostKeyAlgorithms", $this$toPairs.getHostKeyAlgorithms()), TuplesKt.to((Object)"hostKeyVerifier", (Object)$this$toPairs.getHostKeyVerifier()), TuplesKt.to((Object)"identityAgent", (Object)$this$toPairs.getIdentityAgent()), TuplesKt.to((Object)"initialLocalTcpForwardings", $this$toPairs.getInitialLocalTcpForwardings()), TuplesKt.to((Object)"initialRemoteTcpForwardings", $this$toPairs.getInitialRemoteTcpForwardings()), TuplesKt.to((Object)"kexAlgorithms", $this$toPairs.getKexAlgorithms()), TuplesKt.to((Object)"macs", $this$toPairs.getMacs()), TuplesKt.to((Object)"port", (Object)$this$toPairs.getPort()), TuplesKt.to((Object)"proxyConfig", (Object)$this$toPairs.getProxyConfig()), TuplesKt.to((Object)"serverAlive", (Object)$this$toPairs.getServerAlive()), TuplesKt.to((Object)"user", (Object)$this$toPairs.getUser()), TuplesKt.to((Object)"x11Forwarding", (Object)$this$toPairs.getX11Forwarding())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public static final List<Triple<String, Object, Object>> sshConnectionConfigDiff(@NotNull SshConnectionConfig old, @NotNull SshConnectionConfig sshConnectionConfig) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)sshConnectionConfig, (String)"new");
        Iterable iterable = CollectionsKt.zip((Iterable)SshConnectionConfigKt.toPairs(old), (Iterable)SshConnectionConfigKt.toPairs(sshConnectionConfig));
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator2 = iterable3.iterator();
        while (iterator2.hasNext()) {
            Triple triple;
            Object t;
            Object t2 = t = iterator2.next();
            boolean bl4 = false;
            Pair pair = (Pair)t2;
            boolean bl5 = false;
            Pair pair2 = (Pair)pair.component1();
            Pair pair3 = (Pair)pair.component2();
            boolean bl6 = Intrinsics.areEqual((Object)pair2.getFirst(), (Object)pair3.getFirst());
            if (_Assertions.ENABLED && !bl6) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if ((!Intrinsics.areEqual((Object)pair2, (Object)pair3) ? new Triple(pair2.getFirst(), pair2.getSecond(), pair3.getSecond()) : null) == null) continue;
            triple = triple;
            boolean bl7 = false;
            collection.add(triple);
        }
        return (List)collection;
    }

    public static final /* synthetic */ List access$getDefaultCiphers$p() {
        return defaultCiphers;
    }

    public static final /* synthetic */ List access$getDefaultHostKeyAlgorithms$p() {
        return defaultHostKeyAlgorithms;
    }

    public static final /* synthetic */ List access$getDefaultKexAlgorithms$p() {
        return defaultKexAlgorithms;
    }

    public static final /* synthetic */ List access$getDefaultMacs$p() {
        return defaultMacs;
    }

    static {
        Object[] objectArray = new String[]{"curve25519-sha256", "curve25519-sha256@libssh.org", "diffie-hellman-group-exchange-sha256", "ecdh-sha2-nistp521", "ecdh-sha2-nistp384", "ecdh-sha2-nistp256", "diffie-hellman-group-exchange-sha1", "diffie-hellman-group1-sha1", "diffie-hellman-group14-sha1", "diffie-hellman-group14-sha256", "diffie-hellman-group15-sha512", "diffie-hellman-group16-sha512", "diffie-hellman-group17-sha512", "diffie-hellman-group18-sha512", "diffie-hellman-group14-sha256@ssh.com", "diffie-hellman-group15-sha256", "diffie-hellman-group15-sha256@ssh.com", "diffie-hellman-group15-sha384@ssh.com", "diffie-hellman-group16-sha256", "diffie-hellman-group16-sha384@ssh.com", "diffie-hellman-group16-sha512@ssh.com", "diffie-hellman-group18-sha512@ssh.com"};
        defaultKexAlgorithms = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"ecdsa-sha2-nistp256-cert-v01@openssh.com", "ecdsa-sha2-nistp384-cert-v01@openssh.com", "ecdsa-sha2-nistp521-cert-v01@openssh.com", "sk-ecdsa-sha2-nistp256-cert-v01@openssh.com", "ssh-ed25519-cert-v01@openssh.com", "sk-ssh-ed25519-cert-v01@openssh.com", "rsa-sha2-512-cert-v01@openssh.com", "rsa-sha2-256-cert-v01@openssh.com", "ssh-rsa-cert-v01@openssh.com", "ecdsa-sha2-nistp256", "ecdsa-sha2-nistp384", "ecdsa-sha2-nistp521", "sk-ecdsa-sha2-nistp256@openssh.com", "ssh-ed25519", "sk-ssh-ed25519@openssh.com", "rsa-sha2-512", "rsa-sha2-256", "ssh-rsa"};
        defaultHostKeyAlgorithms = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"aes128-cbc", "aes128-ctr", "aes192-cbc", "aes192-ctr", "aes256-cbc", "aes256-ctr", "blowfish-cbc", "blowfish-ctr", "cast128-cbc", "cast128-ctr", "idea-cbc", "idea-ctr", "serpent128-cbc", "serpent128-ctr", "serpent192-cbc", "serpent192-ctr", "serpent256-cbc", "serpent256-ctr", "3des-cbc", "3des-ctr", "twofish128-cbc", "twofish128-ctr", "twofish192-cbc", "twofish192-ctr", "twofish256-cbc", "twofish256-ctr", "twofish-cbc", "arcfour", "arcfour128", "arcfour256"};
        defaultCiphers = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"hmac-sha1", "hmac-sha1-etm@openssh.com", "hmac-sha1-96", "hmac-sha1-96@openssh.com", "hmac-md5", "hmac-md5-etm@openssh.com", "hmac-md5-96", "hmac-md5-96-etm@openssh.com", "hmac-sha2-256", "hmac-sha2-256-etm@openssh.com", "hmac-sha2-512", "hmac-sha2-512-etm@openssh.com", "hmac-ripemd160", "hmac-ripemd160-etm@openssh.com", "hmac-ripemd160-96", "hmac-ripemd160@openssh.com"};
        defaultMacs = CollectionsKt.listOf((Object[])objectArray);
    }
}

