/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.delete.helper;

import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentVolume;
import com.intellij.docker.agent.delete.helper.DockerApplicationDependenciesGraphKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e7\u0080\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u0007\bJ\u0012\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph;", "A", "Lcom/intellij/docker/agent/DockerAgentApplication;", "", "getNodes", "", "Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node;", "Node", "DeleteQueueComputer", "intellij.clouds.docker.agent"})
@ApiStatus.Internal
@ApiStatus.Experimental
public interface DockerApplicationDependenciesGraph<A extends DockerAgentApplication> {
    @NotNull
    public List<Node<?>> getNodes();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0012H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\fj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$DeleteQueueComputer;", "A", "Lcom/intellij/docker/agent/DockerAgentApplication;", "", "graph", "Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph;", "exclude", "", "Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node;", "<init>", "(Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph;Ljava/util/List;)V", "myQueue", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getQueue", "computeQueueRec", "", "nodes", "", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerApplicationDependenciesGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerApplicationDependenciesGraph.kt\ncom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$DeleteQueueComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n774#2:86\n865#2,2:87\n1374#2:89\n1460#2,5:90\n*S KotlinDebug\n*F\n+ 1 DockerApplicationDependenciesGraph.kt\ncom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$DeleteQueueComputer\n*L\n76#1:86\n76#1:87,2\n81#1:89\n81#1:90,5\n*E\n"})
    public static final class DeleteQueueComputer<A extends DockerAgentApplication> {
        @NotNull
        private final DockerApplicationDependenciesGraph<A> graph;
        @NotNull
        private final List<Node<?>> exclude;
        @NotNull
        private final LinkedHashSet<Node<?>> myQueue;

        public DeleteQueueComputer(@NotNull DockerApplicationDependenciesGraph<A> graph, @NotNull List<? extends Node<?>> exclude) {
            Intrinsics.checkNotNullParameter(graph, (String)"graph");
            Intrinsics.checkNotNullParameter(exclude, (String)"exclude");
            this.graph = graph;
            this.exclude = exclude;
            this.myQueue = new LinkedHashSet();
            this.computeQueueRec((Collection)DockerApplicationDependenciesGraphKt.getRoots(this.graph));
        }

        public /* synthetic */ DeleteQueueComputer(DockerApplicationDependenciesGraph dockerApplicationDependenciesGraph, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(dockerApplicationDependenciesGraph, list);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Node<?>> getQueue() {
            void $this$filterTo$iv$iv;
            SequencedCollection sequencedCollection = this.myQueue.reversed();
            Intrinsics.checkNotNullExpressionValue((Object)sequencedCollection, (String)"reversed(...)");
            Iterable $this$filter$iv = SetsKt.plus((Set)((Set)((Object)sequencedCollection)), (Iterable)DockerApplicationDependenciesGraphKt.getStandaloneNodes(this.graph));
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Node it = (Node)element$iv$iv;
                boolean bl = false;
                if (!(!this.exclude.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final void computeQueueRec(Collection<? extends Node<?>> nodes) {
            if (!nodes.isEmpty()) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                this.myQueue.addAll(nodes);
                Iterable iterable = nodes;
                DeleteQueueComputer deleteQueueComputer = this;
                boolean $i$f$flatMap = false;
                void var4_5 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Node it = (Node)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.getChildren();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                deleteQueueComputer.computeQueueRec((List)destination$iv$iv);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003%&'B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0000\u00a2\u0006\u0002\b\u001eJ\u0019\u0010\u001f\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0000\u00a2\u0006\u0002\b J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u0006\u0010$\u001a\u00020\"R\u0013\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001b\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0000X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u0082\u0001\u0003()*\u00a8\u0006+"}, d2={"Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node;", "T", "Lcom/intellij/docker/agent/DockerAgentApplication;", "", "value", "<init>", "(Lcom/intellij/docker/agent/DockerAgentApplication;)V", "getValue", "()Lcom/intellij/docker/agent/DockerAgentApplication;", "Lcom/intellij/docker/agent/DockerAgentApplication;", "id", "", "getId", "()Ljava/lang/String;", "name", "getName", "children", "", "getChildren", "()Ljava/util/Set;", "myChildren", "", "parent", "getParent$intellij_clouds_docker_agent", "()Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node;", "setParent$intellij_clouds_docker_agent", "(Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node;)V", "addAndSetParent", "", "node", "addAndSetParent$intellij_clouds_docker_agent", "addChildren", "addChildren$intellij_clouds_docker_agent", "isRoot", "", "isLeaf", "isStandalone", "Image", "Volume", "Container", "Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node$Container;", "Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node$Image;", "Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node$Volume;", "intellij.clouds.docker.agent"})
    public static abstract sealed class Node<T extends DockerAgentApplication> {
        @NotNull
        private final T value;
        @NotNull
        private final String name;
        @NotNull
        private final Set<Node<?>> myChildren;
        @Nullable
        private Node<?> parent;

        private Node(T value) {
            this.value = value;
            String string = this.value.getPresentableName();
            Intrinsics.checkNotNull((Object)string);
            this.name = string;
            this.myChildren = new LinkedHashSet();
        }

        @NotNull
        public final T getValue() {
            return this.value;
        }

        @NotNull
        public abstract String getId();

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Set<Node<?>> getChildren() {
            return CollectionsKt.toSet((Iterable)this.myChildren);
        }

        @Nullable
        public final Node<?> getParent$intellij_clouds_docker_agent() {
            return this.parent;
        }

        public final void setParent$intellij_clouds_docker_agent(@Nullable Node<?> node) {
            this.parent = node;
        }

        public final void addAndSetParent$intellij_clouds_docker_agent(@NotNull Node<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            this.addChildren$intellij_clouds_docker_agent(node);
            node.parent = this;
        }

        public final void addChildren$intellij_clouds_docker_agent(@NotNull Node<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            this.myChildren.add(node);
        }

        public final boolean isRoot() {
            return !((Collection)this.myChildren).isEmpty() && this.parent == null;
        }

        public final boolean isLeaf() {
            return this.myChildren.isEmpty() && this.parent != null;
        }

        public final boolean isStandalone() {
            return this.myChildren.isEmpty() && this.parent == null;
        }

        public /* synthetic */ Node(DockerAgentApplication value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node$Container;", "Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node;", "Lcom/intellij/docker/agent/DockerAgentContainer;", "value", "<init>", "(Lcom/intellij/docker/agent/DockerAgentContainer;)V", "id", "", "getId", "()Ljava/lang/String;", "composeProject", "getComposeProject", "isRunning", "", "intellij.clouds.docker.agent"})
        public static final class Container
        extends Node<DockerAgentContainer> {
            @NotNull
            private final String id;
            @Nullable
            private final String composeProject;

            public Container(@NotNull DockerAgentContainer value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(value, null);
                this.id = value.getContainerId();
                this.composeProject = value.getContainerLabels().get("com.docker.compose.project");
            }

            @Override
            @NotNull
            public String getId() {
                return this.id;
            }

            @Nullable
            public final String getComposeProject() {
                return this.composeProject;
            }

            public final boolean isRunning() {
                String string = ((DockerAgentContainer)this.getValue()).getContainer().getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatus(...)");
                return StringsKt.startsWith$default((String)string, (String)"Up", (boolean)false, (int)2, null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node$Image;", "Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node;", "Lcom/intellij/docker/agent/DockerAgentImage;", "value", "<init>", "(Lcom/intellij/docker/agent/DockerAgentImage;)V", "id", "", "getId", "()Ljava/lang/String;", "isIntermediate", "", "isIntermediate$intellij_clouds_docker_agent", "()Z", "setIntermediate$intellij_clouds_docker_agent", "(Z)V", "intellij.clouds.docker.agent"})
        public static final class Image
        extends Node<DockerAgentImage> {
            @NotNull
            private final String id;
            private boolean isIntermediate;

            public Image(@NotNull DockerAgentImage value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(value, null);
                this.id = value.getImageId();
            }

            @Override
            @NotNull
            public String getId() {
                return this.id;
            }

            public final boolean isIntermediate$intellij_clouds_docker_agent() {
                return this.isIntermediate;
            }

            public final void setIntermediate$intellij_clouds_docker_agent(boolean bl) {
                this.isIntermediate = bl;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node$Volume;", "Lcom/intellij/docker/agent/delete/helper/DockerApplicationDependenciesGraph$Node;", "Lcom/intellij/docker/agent/DockerAgentVolume;", "value", "<init>", "(Lcom/intellij/docker/agent/DockerAgentVolume;)V", "id", "", "getId", "()Ljava/lang/String;", "intellij.clouds.docker.agent"})
        public static final class Volume
        extends Node<DockerAgentVolume> {
            @NotNull
            private final String id;

            public Volume(@NotNull DockerAgentVolume value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(value, null);
                String string = value.getVolume().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.id = string;
            }

            @Override
            @NotNull
            public String getId() {
                return this.id;
            }
        }
    }
}

