/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.intellij.plugins.xpathView.HistoryElement;
import org.intellij.plugins.xpathView.util.Namespace;
import org.intellij.plugins.xpathView.util.Variable;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="XPathView.XPathProjectComponent", storages={@Storage(value="$WORKSPACE_FILE$")})
public class XPathProjectComponent
implements PersistentStateComponent<Element> {
    protected static final String HISTORY_ELEMENT = "element";
    protected static final String HISTORY = "history";
    protected static final String FIND_HISTORY = "find-history";
    protected static final String EXPRESSION = "expression";
    protected static final String VARIABLE = "variable";
    protected static final String NAME = "name";
    protected static final String NAMESPACE = "namespace";
    protected static final String PREFIX = "prefix";
    protected static final String URI = "uri";
    private final LinkedHashMap<String, HistoryElement> history = new LinkedHashMap();
    private final LinkedHashMap<String, HistoryElement> findHistory = new LinkedHashMap();

    public void loadState(@NotNull Element state) {
        if (state == null) {
            XPathProjectComponent.$$$reportNull$$$0(0);
        }
        XPathProjectComponent.readHistory(state, HISTORY, this.history);
        XPathProjectComponent.readHistory(state, FIND_HISTORY, this.findHistory);
    }

    private static void readHistory(Element element, String s, LinkedHashMap<String, HistoryElement> hst) {
        Element historyElement = element.getChild(s);
        if (historyElement != null) {
            List entries = historyElement.getChildren(HISTORY_ELEMENT);
            for (Element entry : entries) {
                String expression = entry.getAttributeValue(EXPRESSION);
                if (expression == null) continue;
                List children = entry.getChildren(VARIABLE);
                ArrayList<Variable> variables = new ArrayList<Variable>(children.size());
                for (Element e : children) {
                    variables.add(new Variable(e.getAttributeValue(NAME), e.getAttributeValue(EXPRESSION)));
                }
                children = entry.getChildren(NAMESPACE);
                ArrayList<Namespace> namespaces = new ArrayList<Namespace>(children.size());
                for (Element namespaceElement : children) {
                    namespaces.add(new Namespace(namespaceElement.getAttributeValue(PREFIX), namespaceElement.getAttributeValue(URI)));
                }
                hst.put(expression, new HistoryElement(expression, variables, namespaces));
            }
        }
    }

    public Element getState() {
        Element element = new Element("xpathview");
        XPathProjectComponent.writeHistory(element, HISTORY, this.history);
        XPathProjectComponent.writeHistory(element, FIND_HISTORY, this.findHistory);
        return element;
    }

    private static void writeHistory(Element element, String s, LinkedHashMap<String, HistoryElement> hst) {
        Element historyElement = new Element(s);
        element.addContent(historyElement);
        for (String key : hst.keySet()) {
            Element entryElement = new Element(HISTORY_ELEMENT);
            entryElement.setAttribute(EXPRESSION, key);
            historyElement.addContent(entryElement);
            HistoryElement h = hst.get(key);
            for (Variable variable : h.variables) {
                Element varElement = new Element(VARIABLE);
                varElement.setAttribute(NAME, variable.getName());
                varElement.setAttribute(EXPRESSION, variable.getExpression());
                entryElement.addContent(varElement);
            }
            for (Namespace namespace : h.namespaces) {
                Element namespaceElement = new Element(NAMESPACE);
                namespaceElement.setAttribute(PREFIX, namespace.getPrefix());
                namespaceElement.setAttribute(URI, namespace.getUri());
                entryElement.addContent(namespaceElement);
            }
        }
    }

    public void addHistory(HistoryElement element) {
        String expression = element.expression;
        this.history.remove(expression);
        this.history.put(expression, element);
    }

    public void addFindHistory(HistoryElement element) {
        String expression = element.expression;
        this.findHistory.remove(expression);
        this.findHistory.put(expression, element);
    }

    public HistoryElement[] getHistory() {
        return this.history.values().toArray(new HistoryElement[0]);
    }

    public HistoryElement[] getFindHistory() {
        return this.findHistory.values().toArray(new HistoryElement[0]);
    }

    public static XPathProjectComponent getInstance(Project project) {
        return (XPathProjectComponent)project.getService(XPathProjectComponent.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/intellij/plugins/xpathView/XPathProjectComponent", "loadState"));
    }
}

