/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.fsharp.services.fsi.consoleRunners;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.FSharpLanguage;
import com.jetbrains.rider.model.SandboxInfo;
import com.jetbrains.rider.plugins.fsharp.FSharpBundle;
import com.jetbrains.rider.plugins.fsharp.FSharpIcons;
import com.jetbrains.rider.plugins.fsharp.services.fsi.CommandHistory;
import com.jetbrains.rider.plugins.fsharp.services.fsi.FsiHost;
import com.jetbrains.rider.plugins.fsharp.services.fsi.FsiInputOutputProcessor;
import com.jetbrains.rider.plugins.fsharp.services.fsi.FsiProcessHandler;
import com.jetbrains.rider.plugins.fsharp.services.fsi.FsiSandboxInfoUpdater;
import com.jetbrains.rider.plugins.fsharp.services.fsi.FsiSandboxInfoUpdaterKt;
import com.jetbrains.rider.plugins.fsharp.services.fsi.HistoryKeyListener;
import com.jetbrains.rider.plugins.fsharp.services.fsi.InputSeparatorGutterContentProvider;
import java.awt.Color;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001>B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\r\u0010 \u001a\u00070!\u00a2\u0006\u0002\b\"H\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020!H\u0014J\b\u0010&\u001a\u00020\u0002H\u0014J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020-H\u0014J&\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u000e\u00105\u001a\b\u0012\u0004\u0012\u0002000/H&J\u0006\u00106\u001a\u00020(J\u0006\u00107\u001a\u00020\u0019J\u0006\u00108\u001a\u00020\u001fJ \u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u00062\b\b\u0002\u0010<\u001a\u00020=R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006?"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/services/fsi/consoleRunners/FsiConsoleRunnerBase;", "Lcom/intellij/execution/runners/AbstractConsoleRunnerWithHistory;", "Lcom/intellij/execution/console/LanguageConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "consoleTitle", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "presentableCommandLineString", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/configurations/GeneralCommandLine;Ljava/lang/String;)V", "fsiHost", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/FsiHost;", "getFsiHost", "()Lcom/jetbrains/rider/plugins/fsharp/services/fsi/FsiHost;", "commandHistory", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/CommandHistory;", "getCommandHistory", "()Lcom/jetbrains/rider/plugins/fsharp/services/fsi/CommandHistory;", "inputSeparatorGutterContentProvider", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/InputSeparatorGutterContentProvider;", "fsiInputOutputProcessor", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/FsiInputOutputProcessor;", "contentDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "getContentDescriptor", "()Lcom/intellij/execution/ui/RunContentDescriptor;", "setContentDescriptor", "(Lcom/intellij/execution/ui/RunContentDescriptor;)V", "isAutoFocusContent", "", "createProcess", "Ljava/lang/Process;", "Lorg/jetbrains/annotations/NotNull;", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "process", "createConsoleView", "initAndRun", "", "setupGutters", "createExecuteActionHandler", "Lcom/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler;", "getConsoleIcon", "Ljavax/swing/Icon;", "fillToolBarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "defaultExecutor", "Lcom/intellij/execution/Executor;", "getToolBarActions", "stop", "getRunContentDescriptor", "isValid", "sendText", "visibleText", "fsiText", "lineStart", "", "OpenSettings", "intellij.rider.plugins.fsharp"})
public abstract class FsiConsoleRunnerBase
extends AbstractConsoleRunnerWithHistory<LanguageConsoleView> {
    @NotNull
    private final GeneralCommandLine commandLine;
    @Nullable
    private final String presentableCommandLineString;
    @NotNull
    private final FsiHost fsiHost;
    @NotNull
    private final CommandHistory commandHistory;
    @NotNull
    private final InputSeparatorGutterContentProvider inputSeparatorGutterContentProvider;
    @NotNull
    private final FsiInputOutputProcessor fsiInputOutputProcessor;
    protected RunContentDescriptor contentDescriptor;

    public FsiConsoleRunnerBase(@NotNull Project project, @Nls @NotNull String consoleTitle, @NotNull GeneralCommandLine commandLine, @Nullable String presentableCommandLineString) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleTitle, (String)"consoleTitle");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Object object = commandLine.getWorkDirectory();
        if (object == null || (object = ((File)object).getPath()) == null) {
            object = "";
        }
        super(project, consoleTitle, (String)object);
        this.commandLine = commandLine;
        this.presentableCommandLineString = presentableCommandLineString;
        this.fsiHost = FsiHost.Companion.getInstance(project);
        this.commandHistory = new CommandHistory();
        this.inputSeparatorGutterContentProvider = new InputSeparatorGutterContentProvider(true);
        this.fsiInputOutputProcessor = new FsiInputOutputProcessor(this);
    }

    public /* synthetic */ FsiConsoleRunnerBase(Project project, String string, GeneralCommandLine generalCommandLine, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(project, string, generalCommandLine, string2);
    }

    @NotNull
    public final FsiHost getFsiHost() {
        return this.fsiHost;
    }

    @NotNull
    public final CommandHistory getCommandHistory() {
        return this.commandHistory;
    }

    @NotNull
    protected final RunContentDescriptor getContentDescriptor() {
        RunContentDescriptor runContentDescriptor = this.contentDescriptor;
        if (runContentDescriptor != null) {
            return runContentDescriptor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"contentDescriptor");
        return null;
    }

    protected final void setContentDescriptor(@NotNull RunContentDescriptor runContentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)runContentDescriptor, (String)"<set-?>");
        this.contentDescriptor = runContentDescriptor;
    }

    public boolean isAutoFocusContent() {
        return true;
    }

    @NotNull
    protected Process createProcess() {
        Process process = this.commandLine.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
        return process;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(@NotNull Process process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Lifetime lifetime = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.fsiHost.getProject()));
        String string = this.presentableCommandLineString;
        if (string == null) {
            String string2 = this.commandLine.getCommandLineString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCommandLineString(...)");
        }
        FsiProcessHandler fsiProcessHandler = new FsiProcessHandler(lifetime, this.fsiInputOutputProcessor, process, string);
        FsiSandboxInfoUpdater sandboxInfoUpdater = new FsiSandboxInfoUpdater(this.fsiHost.getProject(), this.getConsoleView().getConsoleEditor(), this.commandHistory);
        fsiProcessHandler.addSandboxInfoUpdater(sandboxInfoUpdater);
        return fsiProcessHandler;
    }

    @NotNull
    protected LanguageConsoleView createConsoleView() {
        LanguageConsoleView languageConsoleView;
        Ref.ObjectRef consoleView = new Ref.ObjectRef();
        SandboxInfo sandboxInfo = FsiSandboxInfoUpdaterKt.createFSharpSandbox("do ()\n\n", false, CollectionsKt.emptyList());
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FsiSandboxInfoUpdaterKt.withGenericSandBoxing(sandboxInfo, project, (Function0<Unit>)((Function0)() -> FsiConsoleRunnerBase.createConsoleView$lambda$0(consoleView, this)));
        if (consoleView.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            languageConsoleView = null;
        } else {
            languageConsoleView = (LanguageConsoleView)consoleView.element;
        }
        return languageConsoleView;
    }

    public void initAndRun() {
        super.initAndRun();
        this.setupGutters();
    }

    private final void setupGutters() {
        EditorEx historyEditor = this.getConsoleView().getHistoryViewer();
        historyEditor.getSettings().setLineMarkerAreaShown(true);
        historyEditor.getSettings().setFoldingOutlineShown(true);
        historyEditor.getGutterComponentEx().setPaintBackground(true);
        historyEditor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, (Color)new JBColor((Color)Gray.xF2, (Color)Gray.x41));
    }

    @NotNull
    protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
        ProcessHandler processHandler = this.getProcessHandler();
        return new ProcessBackedConsoleExecuteActionHandler(this, processHandler){
            final /* synthetic */ FsiConsoleRunnerBase this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false);
            }

            public void runExecuteAction(LanguageConsoleView consoleView) {
                Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
                String string = consoleView.getConsoleEditor().getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String visibleText = StringsKt.removeSuffix((String)string, (CharSequence)";;");
                if (StringsKt.isBlank((CharSequence)visibleText)) {
                    return;
                }
                String fsiText = "\n" + visibleText + "\n# 1 \"stdin\"\n;;\n";
                FsiConsoleRunnerBase.sendText$default(this.this$0, visibleText, fsiText, 0, 4, null);
                consoleView.setInputText("");
            }
        };
    }

    @NotNull
    protected Icon getConsoleIcon() {
        return FSharpIcons.INSTANCE.getFSharpConsole();
    }

    @NotNull
    protected final List<AnAction> fillToolBarActions(@NotNull DefaultActionGroup toolbarActions, @NotNull Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)toolbarActions, (String)"toolbarActions");
        Intrinsics.checkNotNullParameter((Object)defaultExecutor, (String)"defaultExecutor");
        Intrinsics.checkNotNullParameter((Object)contentDescriptor, (String)"contentDescriptor");
        this.setContentDescriptor(contentDescriptor);
        List<AnAction> actionList = this.getToolBarActions();
        toolbarActions.add(this.createCloseAction(this.getExecutor(), contentDescriptor));
        toolbarActions.addAll((Collection)actionList);
        AnAction anAction = this.createConsoleExecAction(this.getConsoleExecuteActionHandler());
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"createConsoleExecAction(...)");
        actionList.add(anAction);
        return actionList;
    }

    @NotNull
    public abstract List<AnAction> getToolBarActions();

    public final void stop() {
        this.getProcessHandler().destroyProcess();
    }

    @NotNull
    public final RunContentDescriptor getRunContentDescriptor() {
        return this.getContentDescriptor();
    }

    public final boolean isValid() {
        return !this.getProcessHandler().isProcessTerminated() && !this.getProcessHandler().isProcessTerminating();
    }

    public final void sendText(@NotNull String visibleText, @NotNull String fsiText, int lineStart) {
        Intrinsics.checkNotNullParameter((Object)visibleText, (String)"visibleText");
        Intrinsics.checkNotNullParameter((Object)fsiText, (String)"fsiText");
        this.fsiInputOutputProcessor.processAllPendingMessages();
        UIUtil.invokeLaterIfNeeded(() -> FsiConsoleRunnerBase.sendText$lambda$0(this, visibleText, lineStart, fsiText));
    }

    public static /* synthetic */ void sendText$default(FsiConsoleRunnerBase fsiConsoleRunnerBase, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendText");
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        fsiConsoleRunnerBase.sendText(string, string2, n);
    }

    private static final Unit createConsoleView$lambda$0(Ref.ObjectRef $consoleView, FsiConsoleRunnerBase this$0) {
        LanguageConsoleView languageConsoleView;
        LanguageConsoleView languageConsoleView2;
        LanguageConsoleView languageConsoleView3;
        LanguageConsoleView languageConsoleView4;
        LanguageConsoleView languageConsoleView5 = new LanguageConsoleBuilder().gutterContentProvider((GutterContentProvider)this$0.inputSeparatorGutterContentProvider).build(this$0.getProject(), (Language)FSharpLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)languageConsoleView5, (String)"build(...)");
        $consoleView.element = languageConsoleView5;
        if ($consoleView.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            languageConsoleView4 = null;
        } else {
            languageConsoleView4 = (LanguageConsoleView)$consoleView.element;
        }
        MatteBorder consoleEditorBorder = BorderFactory.createMatteBorder(2, 0, 0, 0, languageConsoleView4.getConsoleEditor().getColorsScheme().getColor(EditorColors.INDENT_GUIDE_COLOR));
        if ($consoleView.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            languageConsoleView3 = null;
        } else {
            languageConsoleView3 = (LanguageConsoleView)$consoleView.element;
        }
        languageConsoleView3.getConsoleEditor().getComponent().setBorder(consoleEditorBorder);
        Project project = this$0.fsiHost.getProject();
        if ($consoleView.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            languageConsoleView2 = null;
        } else {
            languageConsoleView2 = (LanguageConsoleView)$consoleView.element;
        }
        HistoryKeyListener historyKeyListener = new HistoryKeyListener(project, languageConsoleView2.getConsoleEditor(), this$0.commandHistory);
        if ($consoleView.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
            languageConsoleView = null;
        } else {
            languageConsoleView = (LanguageConsoleView)$consoleView.element;
        }
        languageConsoleView.getConsoleEditor().getContentComponent().addKeyListener(historyKeyListener);
        this$0.commandHistory.getListeners().add(historyKeyListener);
        return Unit.INSTANCE;
    }

    private static final void sendText$lambda$0(FsiConsoleRunnerBase this$0, String $visibleText, int $lineStart, String $fsiText) {
        this$0.inputSeparatorGutterContentProvider.addLineSeparator(this$0.getConsoleView().getHistoryViewer().getDocument().getLineCount());
        FsiInputOutputProcessor fsiInputOutputProcessor = this$0.fsiInputOutputProcessor;
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.USER_INPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"USER_INPUT");
        fsiInputOutputProcessor.printInputText($visibleText, consoleViewContentType, $lineStart);
        this$0.commandHistory.addEntry(new CommandHistory.Entry($visibleText, $fsiText));
        RunContentManager.getInstance((Project)this$0.getProject()).selectRunContent(this$0.getContentDescriptor());
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(this$0.getExecutor().getId());
        if (toolWindow != null) {
            toolWindow.show(null);
        }
        OutputStream outputStream = this$0.getProcessHandler().getProcessInput();
        if (outputStream == null) {
            throw new IllegalStateException("Broken Fsi stream".toString());
        }
        OutputStream stream = outputStream;
        if (!StringsKt.isBlank((CharSequence)$visibleText)) {
            byte[] byArray = $fsiText.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            stream.write(byArray);
            stream.flush();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/services/fsi/consoleRunners/FsiConsoleRunnerBase$OpenSettings;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rider.plugins.fsharp"})
    protected static final class OpenSettings
    extends AnAction {
        @NotNull
        private final Project project;

        public OpenSettings(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(FSharpBundle.message("Fsi.actions.open.settings.title", new Object[0]), null, AllIcons.General.Settings);
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ShowSettingsUtil.getInstance().showSettingsDialog(this.project, "Fsi");
        }
    }
}

