/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.fsharp.services.fsi;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.highlighting.FSharpSyntaxHighlighter;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.highlighting.FsiOutputSyntaxHighlighter;
import com.jetbrains.rider.plugins.fsharp.services.fsi.FsiConsoleIndicatorRenderer;
import com.jetbrains.rider.plugins.fsharp.services.fsi.FsiIcons;
import com.jetbrains.rider.plugins.fsharp.services.fsi.IconWithTooltip;
import com.jetbrains.rider.plugins.fsharp.services.fsi.consoleRunners.FsiConsoleRunnerBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u001d\u001a\u00020\u0014J\u0006\u0010\u001e\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/services/fsi/FsiInputOutputProcessor;", "", "fsiRunner", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/consoleRunners/FsiConsoleRunnerBase;", "<init>", "(Lcom/jetbrains/rider/plugins/fsharp/services/fsi/consoleRunners/FsiConsoleRunnerBase;)V", "getFsiRunner", "()Lcom/jetbrains/rider/plugins/fsharp/services/fsi/consoleRunners/FsiConsoleRunnerBase;", "isInitialText", "", "nextOutputTextIsFirst", "fSharpSyntaxHighlighter", "Lcom/jetbrains/rider/ideaInterop/fileTypes/fsharp/highlighting/FSharpSyntaxHighlighter;", "fsiOutputSyntaxHighlighter", "Lcom/jetbrains/rider/ideaInterop/fileTypes/fsharp/highlighting/FsiOutputSyntaxHighlighter;", "fsiIconWithTooltipOnOutputText", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/IconWithTooltip;", "outputType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "printInputText", "", "text", "", "lineStart", "", "printOutputText", "printText", "iconWithTooltip", "highlighter", "onServerPrompt", "processAllPendingMessages", "intellij.rider.plugins.fsharp"})
@SourceDebugExtension(value={"SMAP\nFsiInputOutputProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FsiInputOutputProcessor.kt\ncom/jetbrains/rider/plugins/fsharp/services/fsi/FsiInputOutputProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,109:1\n1#2:110\n1104#3,3:111\n*S KotlinDebug\n*F\n+ 1 FsiInputOutputProcessor.kt\ncom/jetbrains/rider/plugins/fsharp/services/fsi/FsiInputOutputProcessor\n*L\n42#1:111,3\n*E\n"})
public final class FsiInputOutputProcessor {
    @NotNull
    private final FsiConsoleRunnerBase fsiRunner;
    private boolean isInitialText;
    private boolean nextOutputTextIsFirst;
    @NotNull
    private final FSharpSyntaxHighlighter fSharpSyntaxHighlighter;
    @NotNull
    private final FsiOutputSyntaxHighlighter fsiOutputSyntaxHighlighter;

    public FsiInputOutputProcessor(@NotNull FsiConsoleRunnerBase fsiRunner) {
        Intrinsics.checkNotNullParameter((Object)((Object)fsiRunner), (String)"fsiRunner");
        this.fsiRunner = fsiRunner;
        this.isInitialText = true;
        this.nextOutputTextIsFirst = true;
        this.fSharpSyntaxHighlighter = FSharpSyntaxHighlighter.Companion.getInstance();
        this.fsiOutputSyntaxHighlighter = FsiOutputSyntaxHighlighter.Companion.getInstance();
    }

    @NotNull
    public final FsiConsoleRunnerBase getFsiRunner() {
        return this.fsiRunner;
    }

    private final IconWithTooltip fsiIconWithTooltipOnOutputText(ConsoleViewContentType outputType) {
        if (this.nextOutputTextIsFirst) {
            ConsoleViewContentType consoleViewContentType = outputType;
            if (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT)) {
                return FsiIcons.INSTANCE.getRESULT();
            }
            if (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.ERROR_OUTPUT)) {
                return FsiIcons.INSTANCE.getERROR();
            }
        }
        return null;
    }

    public final void printInputText(@NotNull String text, @NotNull ConsoleViewContentType outputType, int lineStart) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
        ThreadingAssertions.assertEventDispatchThread();
        WriteCommandAction.runWriteCommandAction((Project)this.fsiRunner.getProject(), () -> FsiInputOutputProcessor.printInputText$lambda$0(this, text, outputType, lineStart));
        this.nextOutputTextIsFirst = true;
    }

    public final void printOutputText(@NotNull String text, @NotNull ConsoleViewContentType outputType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isInitialText) {
            this.fsiRunner.getConsoleView().print(text, outputType);
        } else {
            IconWithTooltip fsiResultIconWithTooltip = this.fsiIconWithTooltipOnOutputText(outputType);
            ConsoleViewContentType consoleViewContentType = outputType;
            if (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT)) {
                this.printText(text, fsiResultIconWithTooltip, this.fsiOutputSyntaxHighlighter, outputType);
            } else if (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.ERROR_OUTPUT)) {
                this.printText(text, fsiResultIconWithTooltip, null, outputType);
            }
            this.nextOutputTextIsFirst = false;
        }
    }

    private final void printText(String text, IconWithTooltip iconWithTooltip, FSharpSyntaxHighlighter highlighter, ConsoleViewContentType outputType) {
        RangeHighlighter rangeHighlighter;
        if (highlighter == null) {
            this.fsiRunner.getConsoleView().print(text, outputType);
        } else {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)((ConsoleView)this.fsiRunner.getConsoleView()), (String)text, (SyntaxHighlighter)((SyntaxHighlighter)highlighter));
        }
        if (iconWithTooltip == null) {
            return;
        }
        LanguageConsoleView languageConsoleView = this.fsiRunner.getConsoleView();
        Intrinsics.checkNotNull((Object)languageConsoleView, (String)"null cannot be cast to non-null type com.intellij.execution.console.LanguageConsoleImpl");
        ((LanguageConsoleImpl)languageConsoleView).flushDeferredText();
        int endOffset = this.fsiRunner.getConsoleView().getHistoryViewer().getDocument().getTextLength();
        int startOffset = endOffset - text.length();
        RangeHighlighter $this$printText_u24lambda_u240 = rangeHighlighter = this.fsiRunner.getConsoleView().getHistoryViewer().getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        boolean bl = false;
        $this$printText_u24lambda_u240.setGutterIconRenderer((GutterIconRenderer)new FsiConsoleIndicatorRenderer(iconWithTooltip));
    }

    public final void onServerPrompt() {
        this.isInitialText = false;
    }

    public final void processAllPendingMessages() {
        while (this.isInitialText) {
            Thread.yield();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void printInputText$lambda$0(FsiInputOutputProcessor this$0, String $text, ConsoleViewContentType $outputType, int $lineStart) {
        void $this$count$iv;
        LanguageConsoleView languageConsoleView = this$0.fsiRunner.getConsoleView();
        Intrinsics.checkNotNull((Object)languageConsoleView, (String)"null cannot be cast to non-null type com.intellij.execution.console.LanguageConsoleImpl");
        ((LanguageConsoleImpl)languageConsoleView).flushDeferredText();
        EditorEx historyViewer = this$0.fsiRunner.getConsoleView().getHistoryViewer();
        int lastLine = Math.max(historyViewer.getDocument().getLineCount() - 1, 0);
        CharSequence charSequence = $text;
        int n = 1;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int n2 = count$iv;
        int linesToAddCount = n + n2;
        historyViewer.getSettings().setLineNumbersShown(true);
        historyViewer.getGutter().setLineNumberConverter((LineNumberConverter)new LineNumberConverter.Increasing($lineStart, lastLine, linesToAddCount){
            final /* synthetic */ int $lineStart;
            final /* synthetic */ int $lastLine;
            final /* synthetic */ int $linesToAddCount;
            {
                this.$lineStart = $lineStart;
                this.$lastLine = $lastLine;
                this.$linesToAddCount = $linesToAddCount;
            }

            public Integer convert(Editor p0, int index) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return this.$lineStart + (index - this.$lastLine) - 1;
            }

            public Integer getMaxLineNumber(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return this.$linesToAddCount;
            }

            public String convertLineNumberToString(Editor editor, int lineNumber) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return lineNumber <= this.$lastLine || lineNumber > this.$lastLine + this.$linesToAddCount ? null : super.convertLineNumberToString(editor, lineNumber);
            }
        });
        this$0.printText($text + "\n", FsiIcons.INSTANCE.getCOMMAND_MARKER(), this$0.fSharpSyntaxHighlighter, $outputType);
        EditorUtil.scrollToTheEnd((Editor)((Editor)historyViewer));
    }
}

