/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.fsharp.services.fsi;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.FSharpLanguage;
import com.jetbrains.rider.plugins.fsharp.FSharpBundle;
import com.jetbrains.rider.plugins.fsharp.services.fsi.FsiHost;
import icons.ReSharperIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0015H\u0014J!\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0013H\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/services/fsi/BaseSendToFsiIntentionAction;", "Lcom/intellij/codeInsight/intention/BaseElementAtCaretIntentionAction;", "Lcom/intellij/openapi/actionSystem/ShortcutProvider;", "Lcom/intellij/openapi/util/Iconable;", "Lcom/intellij/openapi/project/DumbAware;", "debug", "", "actionId", "", "<init>", "(ZLjava/lang/String;)V", "isAvailable", "getFamilyName", "startInWriteAction", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiElement;", "checkFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "element", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getShortcut", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "intellij.rider.plugins.fsharp"})
public abstract class BaseSendToFsiIntentionAction
extends BaseElementAtCaretIntentionAction
implements ShortcutProvider,
Iconable,
DumbAware {
    private final boolean debug;
    @NotNull
    private final String actionId;
    private final boolean isAvailable;

    public BaseSendToFsiIntentionAction(boolean debug, @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        this.debug = debug;
        this.actionId = actionId;
        this.isAvailable = !this.debug || SystemInfo.isWindows;
    }

    @NotNull
    public String getFamilyName() {
        return FSharpBundle.message("Fsi.actions.send.to.fsi.intention.action.text", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.isAvailable && editor.getCaretModel().getCaretCount() == 1;
    }

    protected boolean checkFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getLanguage() instanceof FSharpLanguage;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        FsiHost fsiHost = FsiHost.Companion.getInstance(project);
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        fsiHost.sendToFsi(editor, psiFile, this.debug);
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = ReSharperIcons.Bulb.GhostBulb;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GhostBulb");
        return icon;
    }

    @Nullable
    public ShortcutSet getShortcut() {
        AnAction anAction = ActionManager.getInstance().getAction(this.actionId);
        return anAction != null ? anAction.getShortcutSet() : null;
    }
}

