/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.fsharp.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.resharper.assist.BracketMatcher;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.editors.TextControlUtilsKt;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.FSharpLanguage;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.lexer.FSharpTokenType;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.psi.FSharpInterpolatedStringLiteralExpression;
import com.jetbrains.rider.plugins.fsharp.editorActions.FSharpBracketMatcher;
import com.jetbrains.rider.plugins.fsharp.editorActions.FSharpEnterHandlerDelegateKt;
import com.jetbrains.rider.plugins.fsharp.editorActions.FSharpTypingAssistUtilsKt;
import com.jetbrains.rider.plugins.fsharp.editorActions.LineIndent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u0015\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u001e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aJ\u001e\u0010 \u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0013J\u001e\u0010#\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0013J\u0016\u0010%\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001aJ\u001e\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+J\u001e\u0010,\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0013J&\u0010-\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0013J&\u0010/\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0013J\u0016\u00101\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aJ \u00102\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0013H\u0002J\u0016\u00103\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aJ\u0018\u00104\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u0002072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u001aH\u0002J\u0018\u00109\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aH\u0002J\u0016\u0010:\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aJ\u0018\u0010;\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010<\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001aH\u0002J6\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020>\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u00132\u0006\u0010A\u001a\u00020\u001aH\u0002J&\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020>\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001aH\u0002J\u000e\u0010C\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010D\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010E\u001a\u00020\u001a2\u0006\u00106\u001a\u0002072\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010F\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aJ\u0016\u0010G\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aJ\u0018\u0010H\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001aH\u0002JF\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001a0M2\u0006\u0010O\u001a\u00020P2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\n\u001a$\u0012 \u0012\u001e\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/editorActions/FSharpEnterHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "<init>", "()V", "indentFromToken", "Lcom/intellij/psi/tree/TokenSet;", "allowKeepIndent", "indentFromPrevLine", "indentTokens", "deindentingTokens", "emptyBracketsToAddSpace", "", "Lkotlin/Pair;", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "leftBracketsToAddIndent", "Lorg/jetbrains/annotations/NotNull;", "rightBracketsToAddSpace", "isIgnored", "", "tokenType", "shouldTrimSpacesBeforeToken", "findUnmatchedBracketToLeft", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "minOffset", "getAdditionalSpacesBeforeToken", "editor", "Lcom/intellij/openapi/editor/Editor;", "lineStart", "trimTrailingSpacesAtOffset", "caretOffset", "trimAfterCaret", "getContinuedIndentLine", "continueByLeadingLParen", "getLineWhitespaceIndent", "line", "insertText", "", "insertOffset", "text", "", "trimTrailingSpaces", "insertNewLineAt", "indent", "insertIndentFromLine", "trimSpacesAfterCaret", "isInsideString", "doDumpIndent", "handleEnterInTripleQuotedString", "getIndentBeforeToken", "trimWhitespaceInLineCommentOnEnter", "document", "Lcom/intellij/openapi/editor/Document;", "caretPosition", "handleEnterInLineComment", "handleEnterFindLeftBracket", "isFirstTokenOnLine", "isLastTokenOnLine", "getLineIndent", "Lcom/jetbrains/rider/plugins/fsharp/editorActions/LineIndent;", "tryGetNestedIndentBelow", "preferComment", "currentIndent", "tryGetNestedIndentBelowLine", "findRightBracket", "isSingleLineBrackets", "getOffsetInLine", "handleEnterAddIndent", "handleEnterAddBiggerIndentFromBelow", "handleEnter", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "intellij.rider.plugins.fsharp"})
@SourceDebugExtension(value={"SMAP\nFSharpEnterHandlerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSharpEnterHandlerDelegate.kt\ncom/jetbrains/rider/plugins/fsharp/editorActions/FSharpEnterHandlerDelegate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,757:1\n1563#2:758\n1634#2,3:759\n1069#3,2:762\n648#3,5:764\n1#4:769\n67#5:770\n*S KotlinDebug\n*F\n+ 1 FSharpEnterHandlerDelegate.kt\ncom/jetbrains/rider/plugins/fsharp/editorActions/FSharpEnterHandlerDelegate\n*L\n114#1:758\n114#1:759,3\n188#1:762,2\n291#1:764,5\n243#1:770\n*E\n"})
public final class FSharpEnterHandlerDelegate
extends EnterHandlerDelegateAdapter {
    @NotNull
    private final TokenSet indentFromToken;
    @NotNull
    private final TokenSet allowKeepIndent;
    @NotNull
    private final TokenSet indentFromPrevLine;
    @NotNull
    private final TokenSet indentTokens;
    @NotNull
    private final TokenSet deindentingTokens;
    @NotNull
    private final Set<Pair<IElementType, IElementType>> emptyBracketsToAddSpace;
    @NotNull
    private final TokenSet leftBracketsToAddIndent;
    @NotNull
    private final Set<IElementType> rightBracketsToAddSpace;

    /*
     * WARNING - void declaration
     */
    public FSharpEnterHandlerDelegate() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IElementType[] iElementTypeArray = new IElementType[]{FSharpTokenType.LBRACK_LESS, FSharpTokenType.LQUOTE_TYPED, FSharpTokenType.LQUOTE_UNTYPED, FSharpTokenType.STRUCT, FSharpTokenType.CLASS, FSharpTokenType.INTERFACE, FSharpTokenType.TRY, FSharpTokenType.NEW, FSharpTokenType.LAZY};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.indentFromToken = tokenSet;
        iElementTypeArray = new IElementType[]{FSharpTokenType.LPAREN, FSharpTokenType.LBRACK, FSharpTokenType.LBRACE, FSharpTokenType.LBRACK_BAR, FSharpTokenType.EQUALS, FSharpTokenType.LARROW, FSharpTokenType.RARROW, FSharpTokenType.IF, FSharpTokenType.THEN, FSharpTokenType.ELIF, FSharpTokenType.ELSE, FSharpTokenType.MATCH, FSharpTokenType.WHILE, FSharpTokenType.WHEN, FSharpTokenType.DO, FSharpTokenType.DO_BANG, FSharpTokenType.YIELD, FSharpTokenType.YIELD_BANG, FSharpTokenType.BEGIN};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        this.allowKeepIndent = tokenSet2;
        iElementTypeArray = new IElementType[]{FSharpTokenType.FUNCTION, FSharpTokenType.EQUALS, FSharpTokenType.LARROW, FSharpTokenType.MATCH, FSharpTokenType.WHILE, FSharpTokenType.WHEN, FSharpTokenType.DO, FSharpTokenType.DO_BANG, FSharpTokenType.YIELD, FSharpTokenType.YIELD_BANG, FSharpTokenType.BEGIN};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(...)");
        this.indentFromPrevLine = tokenSet3;
        iElementTypeArray = new TokenSet[]{this.indentFromToken, this.indentFromPrevLine};
        TokenSet tokenSet4 = TokenSet.orSet((TokenSet[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"orSet(...)");
        this.indentTokens = tokenSet4;
        iElementTypeArray = new IElementType[]{FSharpTokenType.RPAREN, FSharpTokenType.RBRACK, FSharpTokenType.BAR_RBRACK, FSharpTokenType.GREATER_RBRACK, FSharpTokenType.RQUOTE_TYPED, FSharpTokenType.RQUOTE_UNTYPED, FSharpTokenType.RBRACE, FSharpTokenType.END};
        TokenSet tokenSet5 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet5, (String)"create(...)");
        this.deindentingTokens = tokenSet5;
        Object object = new Pair[]{new Pair((Object)FSharpTokenType.LBRACE, (Object)FSharpTokenType.RBRACE), new Pair((Object)FSharpTokenType.LBRACK, (Object)FSharpTokenType.RBRACK), new Pair((Object)FSharpTokenType.LBRACK_BAR, (Object)FSharpTokenType.BAR_RBRACK), new Pair((Object)FSharpTokenType.LBRACE_BAR, (Object)FSharpTokenType.BAR_RBRACE), new Pair((Object)FSharpTokenType.LQUOTE_TYPED, (Object)FSharpTokenType.RQUOTE_TYPED), new Pair((Object)FSharpTokenType.LQUOTE_UNTYPED, (Object)FSharpTokenType.RQUOTE_UNTYPED)};
        this.emptyBracketsToAddSpace = SetsKt.setOf((Object[])object);
        iElementTypeArray = new IElementType[]{FSharpTokenType.LPAREN, FSharpTokenType.LBRACE, FSharpTokenType.LBRACK, FSharpTokenType.LBRACK_BAR, FSharpTokenType.LBRACK_LESS, FSharpTokenType.LQUOTE_TYPED, FSharpTokenType.LQUOTE_UNTYPED};
        TokenSet tokenSet6 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet6, (String)"create(...)");
        this.leftBracketsToAddIndent = tokenSet6;
        object = this.emptyBracketsToAddSpace;
        FSharpEnterHandlerDelegate fSharpEnterHandlerDelegate = this;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((IElementType)it.getSecond());
        }
        fSharpEnterHandlerDelegate.rightBracketsToAddSpace = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final boolean isIgnored(IElementType tokenType) {
        return tokenType != null && (Intrinsics.areEqual((Object)tokenType, (Object)FSharpTokenType.WHITESPACE) || FSharpTypingAssistUtilsKt.isComment(tokenType));
    }

    private final boolean shouldTrimSpacesBeforeToken(IElementType tokenType) {
        return tokenType != null && !FSharpTokenType.RIGHT_BRACES.contains(tokenType) && !FSharpTypingAssistUtilsKt.isComment(tokenType);
    }

    private final boolean findUnmatchedBracketToLeft(HighlighterIterator iterator, int offset, int minOffset) {
        if (iterator.getEnd() > offset) {
            iterator.retreat();
        }
        FSharpBracketMatcher matcher = new FSharpBracketMatcher();
        boolean foundToken = false;
        BracketMatcher.TokenIterator tokenIterator = FSharpTypingAssistUtilsKt.asTokenIterator(iterator);
        while (!foundToken && !iterator.atEnd() && tokenIterator.getTokenStart() >= minOffset) {
            if (FSharpTokenType.RIGHT_BRACES.contains(tokenIterator.getTokenType()) && matcher.findMatchingBracket(tokenIterator) != null) {
                tokenIterator.retreat();
            }
            if (FSharpTokenType.LEFT_BRACES.contains(tokenIterator.getTokenType())) {
                foundToken = true;
                continue;
            }
            if (FSharpTokenType.RIGHT_BRACES.contains(tokenIterator.getTokenType())) continue;
            tokenIterator.retreat();
        }
        return foundToken;
    }

    public final int getAdditionalSpacesBeforeToken(@NotNull Editor editor, int offset, int lineStart) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.atEnd()) {
            return 0;
        }
        if (Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.RARROW)) {
            return 1;
        }
        if (!this.rightBracketsToAddSpace.contains(FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator))) {
            return 0;
        }
        int rightBracketOffset = iterator.getStart();
        if (!this.findUnmatchedBracketToLeft(iterator, offset, lineStart)) {
            return 0;
        }
        int leftBracketEndOffset = iterator.getEnd();
        iterator.advance();
        while (Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.WHITESPACE)) {
            iterator.advance();
        }
        return iterator.getStart() >= offset ? offset - leftBracketEndOffset - 1 : (iterator.getStart() == rightBracketOffset ? 0 : iterator.getStart() - leftBracketEndOffset);
    }

    public final int trimTrailingSpacesAtOffset(@NotNull Editor editor, int caretOffset, boolean trimAfterCaret) {
        int additionalSpaces;
        boolean bl;
        CharSequence buffer;
        int lineStartOffset;
        int line;
        Document document;
        block4: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Document document2 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            document = document2;
            line = document.getLineNumber(caretOffset);
            lineStartOffset = document.getLineStartOffset(line);
            CharSequence charSequence = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            buffer = charSequence;
            CharSequence $this$all$iv = buffer.subSequence(lineStartOffset, caretOffset);
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char p0 = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isWhitespace(p0)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (bl) {
            return caretOffset;
        }
        int lineEndOffset = document.getLineEndOffset(line);
        int startOffset = CharArrayUtil.shiftBackward((CharSequence)buffer, (int)-1, (int)(caretOffset - 1), (String)" ") + 1;
        int endOffset = trimAfterCaret ? CharArrayUtil.shiftForward((CharSequence)buffer, (int)caretOffset, (int)lineEndOffset, (String)" ") : caretOffset;
        int n = additionalSpaces = endOffset >= lineEndOffset ? 0 : this.getAdditionalSpacesBeforeToken(editor, endOffset, lineStartOffset);
        if (additionalSpaces > 0) {
            document.replaceString(startOffset, endOffset, (CharSequence)StringsKt.repeat((CharSequence)" ", (int)additionalSpaces));
            return startOffset;
        }
        if (startOffset != endOffset) {
            document.deleteString(startOffset, endOffset);
            return startOffset;
        }
        return caretOffset;
    }

    public final int getContinuedIndentLine(@NotNull Editor editor, int caretOffset, boolean continueByLeadingLParen) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int line = document2.getLineNumber(caretOffset);
        if (caretOffset == document2.getLineStartOffset(line)) {
            return line;
        }
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(caretOffset - 1);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.atEnd()) {
            return line;
        }
        int lineStartOffset = document2.getLineStartOffset(line);
        return FSharpEnterHandlerDelegate.getContinuedIndentLine$tryFindContinuedLine(iterator, editor, document2, this, continueByLeadingLParen, line, lineStartOffset, Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.LPAREN));
    }

    /*
     * WARNING - void declaration
     */
    public final int getLineWhitespaceIndent(@NotNull Editor editor, int line) {
        String string;
        int startOffset;
        block1: {
            void $this$takeWhile$iv;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            CharSequence charSequence = document2.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence buffer = charSequence;
            startOffset = document2.getLineStartOffset(line);
            int endOffset = document2.getLineEndOffset(line);
            String string2 = ((Object)buffer.subSequence(startOffset, endOffset)).toString();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                void var12_12 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = var12_12.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = $this$takeWhile$iv;
        }
        int pos = string.length() + startOffset;
        return pos - startOffset;
    }

    public final void insertText(@NotNull Editor editor, int insertOffset, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        editor.getDocument().insertString(insertOffset, (CharSequence)text);
        int newCaretPos = insertOffset + text.length();
        editor.getCaretModel().moveToOffset(newCaretPos);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public final int trimTrailingSpaces(@NotNull Editor editor, int caretOffset, boolean trimAfterCaret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int caretOffset2 = this.trimTrailingSpacesAtOffset(editor, caretOffset, trimAfterCaret);
        return caretOffset2;
    }

    public final void insertNewLineAt(@NotNull Editor editor, int indent, int caretOffset, boolean trimAfterCaret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int insertPos = this.trimTrailingSpaces(editor, caretOffset, trimAfterCaret);
        String text = "\n" + StringsKt.repeat((CharSequence)" ", (int)indent);
        this.insertText(editor, insertPos, text);
    }

    public final void insertIndentFromLine(@NotNull Editor editor, int line, int caretOffset, boolean trimSpacesAfterCaret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int indentSize = this.getLineWhitespaceIndent(editor, line);
        this.insertNewLineAt(editor, indentSize, caretOffset, trimSpacesAfterCaret);
    }

    public final boolean isInsideString(@NotNull Editor editor, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(caretOffset - 1);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        return !iterator.atEnd() && FSharpTokenType.ALL_STRINGS.contains(iterator.getTokenType()) && caretOffset > iterator.getStart() && caretOffset < iterator.getEnd();
    }

    private final void doDumpIndent(Editor editor, int caretOffset, boolean trimSpacesAfterCaret) {
        if (this.isInsideString(editor, caretOffset)) {
            this.insertNewLineAt(editor, 0, caretOffset, trimSpacesAfterCaret);
            return;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence buffer = charSequence;
        int caretLine = document2.getLineNumber(caretOffset);
        int line = this.getContinuedIndentLine(editor, caretOffset, false);
        if (line != caretLine) {
            this.insertIndentFromLine(editor, line, caretOffset, trimSpacesAfterCaret);
        } else {
            int startOffset = document2.getLineStartOffset(line);
            int pos = CharArrayUtil.shiftForward((CharSequence)buffer, (int)startOffset, (int)caretOffset, (String)" ");
            int indent = pos - startOffset;
            this.insertNewLineAt(editor, indent, caretOffset, trimSpacesAfterCaret);
        }
    }

    public final boolean handleEnterInTripleQuotedString(@NotNull Editor editor, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.atEnd()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.TRIPLE_QUOTED_STRING)) {
            return false;
        }
        if (caretOffset < iterator.getStart() + 3 || caretOffset > iterator.getEnd() - 3) {
            return false;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int strStartLine = document2.getLineNumber(iterator.getStart());
        int strEndLine = document2.getLineNumber(iterator.getEnd());
        if (strStartLine != strEndLine) {
            return false;
        }
        document2.insertString(iterator.getEnd() - 3, (CharSequence)"\n");
        this.insertText(editor, caretOffset, "\n");
        return true;
    }

    private final String getIndentBeforeToken(Editor editor, int offset) {
        int line = editor.getDocument().getLineNumber(offset);
        int lineStartOffset = editor.getDocument().getLineStartOffset(line);
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        String indent = ((Object)charSequence.subSequence(lineStartOffset, offset)).toString();
        return StringsKt.isBlank((CharSequence)indent) ? indent : StringsKt.repeat((CharSequence)" ", (int)indent.length());
    }

    private final int trimWhitespaceInLineCommentOnEnter(Document document, HighlighterIterator iterator, int caretPosition) {
        int newCaretPosition = caretPosition;
        int caretOffsetInComment = newCaretPosition - iterator.getStart();
        String currTokenText = FSharpTypingAssistUtilsKt.getTokenText(iterator);
        String string = currTokenText.substring(0, caretOffsetInComment);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String firstCommentPartText = string;
        for (int i = firstCommentPartText.length() - 1; -1 < i; --i) {
            if (CharsKt.isWhitespace((char)firstCommentPartText.charAt(i))) continue;
            int trimLength = firstCommentPartText.length() - i - 1;
            if (!(trimLength >= 0)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            int startOffset = newCaretPosition - trimLength;
            int endOffset = newCaretPosition;
            if (!((newCaretPosition -= trimLength) > 0)) {
                boolean bl = false;
                String string3 = "caretPos > 0";
                throw new IllegalArgumentException(string3.toString());
            }
            document.deleteString(startOffset, endOffset);
            break;
        }
        String string4 = currTokenText.substring(caretOffsetInComment);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String secondCommentPartText = string4;
        int n = ((CharSequence)secondCommentPartText).length();
        for (int i = 0; i < n; ++i) {
            if (CharsKt.isWhitespace((char)secondCommentPartText.charAt(i)) && i != secondCommentPartText.length() - 1) continue;
            document.deleteString(newCaretPosition, newCaretPosition + i);
            break;
        }
        return newCaretPosition;
    }

    private final boolean handleEnterInLineComment(Editor editor, int caretOffset) {
        Object object;
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(caretOffset - 1);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (!Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.LINE_COMMENT)) {
            return false;
        }
        String lineCommentStart = "//";
        String docCommentStart = "///";
        if (caretOffset - iterator.getStart() < lineCommentStart.length()) {
            return false;
        }
        String tokenText = FSharpTypingAssistUtilsKt.getTokenText(iterator);
        if (!StringsKt.startsWith$default((String)tokenText, (String)lineCommentStart, (boolean)false, (int)2, null)) {
            return false;
        }
        if (!StringsKt.startsWith$default((String)tokenText, (String)docCommentStart, (boolean)false, (int)2, null)) {
            int charCountAfterSelection = iterator.getEnd() - caretOffset;
            String string = tokenText.substring(tokenText.length() - charCountAfterSelection);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String textAfterSelection = string;
            if (StringsKt.isBlank((CharSequence)textAfterSelection)) {
                return false;
            }
        }
        String indent = this.getIndentBeforeToken(editor, iterator.getStart());
        String currTokenText = FSharpTypingAssistUtilsKt.getTokenText(iterator);
        int minimumCommentLength = Math.min(lineCommentStart.length() + 1, docCommentStart.length());
        if (!(currTokenText.length() >= minimumCommentLength)) {
            boolean $i$a$-require-FSharpEnterHandlerDelegate$handleEnterInLineComment$22 = false;
            String $i$a$-require-FSharpEnterHandlerDelegate$handleEnterInLineComment$22 = "Expected either a doc comment or non-empty line comment";
            throw new IllegalArgumentException($i$a$-require-FSharpEnterHandlerDelegate$handleEnterInLineComment$22.toString());
        }
        if (StringsKt.startsWith$default((String)currTokenText, (String)docCommentStart, (boolean)false, (int)2, null)) {
            String string = currTokenText.substring(0, docCommentStart.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = string + " ";
        } else {
            String string = currTokenText.substring(0, minimumCommentLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String it = string;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it, (String)" ", (boolean)false, (int)2, null)) {
                String string2 = it.substring(0, lineCommentStart.length());
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                object = it;
            }
        }
        String commentStart = object;
        String textToInsert = "\n" + indent + commentStart;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        int caretOffset2 = this.trimWhitespaceInLineCommentOnEnter(document, iterator, caretOffset);
        this.insertText(editor, caretOffset2, textToInsert);
        return true;
    }

    public final boolean handleEnterFindLeftBracket(@NotNull Editor editor, int caretOffset) {
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(caretOffset - 1);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.atEnd()) {
            return false;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int caretLine = document2.getLineNumber(caretOffset);
        int lineStartOffset = document2.getLineStartOffset(caretLine);
        if (!this.findUnmatchedBracketToLeft(iterator, caretOffset, lineStartOffset)) {
            return false;
        }
        int leftBracketOffset = iterator.getStart();
        IElementType leftBracketType = FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator);
        iterator.advance();
        while (Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.WHITESPACE)) {
            iterator.advance();
        }
        if (Intrinsics.areEqual((Object)leftBracketType, (Object)FSharpTokenType.LBRACE) && Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.NEW)) {
            int braceOffset = leftBracketOffset - document2.getLineStartOffset(caretLine);
            PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile((Editor)editor);
            Intrinsics.checkNotNull((Object)psiFile);
            int defaultIndent = CodeStyle.getIndentSize((PsiFile)psiFile);
            n = braceOffset + defaultIndent;
        } else {
            n = iterator.getStart() - lineStartOffset;
        }
        int indent = n;
        this.insertNewLineAt(editor, indent, caretOffset, true);
        return true;
    }

    private final boolean isFirstTokenOnLine(Editor editor, int offset) {
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        iterator.retreat();
        while (!iterator.atEnd() && this.isIgnored(iterator.getTokenType())) {
            iterator.retreat();
        }
        return iterator.atEnd() || Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)FSharpTokenType.NEW_LINE);
    }

    private final boolean isLastTokenOnLine(Editor editor, int offset) {
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        iterator.advance();
        while (!iterator.atEnd() && this.isIgnored(iterator.getTokenType())) {
            iterator.advance();
        }
        return iterator.atEnd() || Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)FSharpTokenType.NEW_LINE);
    }

    private final LineIndent getLineIndent(Editor editor, int line) {
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (line >= document2.getLineCount()) {
            return null;
        }
        int startOffset = document2.getLineStartOffset(line);
        int endOffset = document2.getLineEndOffset(line);
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.atEnd()) {
            return null;
        }
        LineIndent commentOffset = null;
        while (!iterator.atEnd() && iterator.getStart() < endOffset && this.isIgnored(iterator.getTokenType())) {
            if (commentOffset == null) {
                IElementType iElementType = iterator.getTokenType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
                if (FSharpTypingAssistUtilsKt.isComment(iElementType)) {
                    commentOffset = new LineIndent(LineIndent.Type.Comments, iterator.getStart() - startOffset);
                }
            }
            iterator.advance();
        }
        IElementType tokenType = FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator);
        return tokenType == null || this.isIgnored(tokenType) || Intrinsics.areEqual((Object)tokenType, (Object)FSharpTokenType.NEW_LINE) ? commentOffset : new LineIndent(LineIndent.Type.Source, iterator.getStart() - startOffset);
    }

    private final Pair<Integer, LineIndent> tryGetNestedIndentBelow(Editor editor, int line, boolean preferComment, int currentIndent) {
        return FSharpEnterHandlerDelegate.tryGetNestedIndentBelow$tryFindIndent(this, currentIndent, preferComment, editor, null, line + 1);
    }

    private final Pair<Integer, LineIndent> tryGetNestedIndentBelowLine(Editor editor, int line) {
        LineIndent lineIndent;
        LineIndent lineIndent2 = lineIndent = this.getLineIndent(editor, line);
        LineIndent.Type type = lineIndent2 != null ? lineIndent2.getType() : null;
        return switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case -1, 2 -> null;
            case 1 -> this.tryGetNestedIndentBelow(editor, line, false, lineIndent.getIndent());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean findRightBracket(@NotNull HighlighterIterator iterator) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        return this.leftBracketsToAddIndent.contains(iterator.getTokenType()) && new FSharpBracketMatcher().findMatchingBracket(FSharpTypingAssistUtilsKt.asTokenIterator(iterator)) != null;
    }

    public final boolean isSingleLineBrackets(@NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int startLine = document2.getLineNumber(iterator.getStart());
        return !this.findRightBracket(iterator) ? false : document2.getLineNumber(iterator.getStart()) == startLine;
    }

    public final int getOffsetInLine(@NotNull Document document, int line, int offset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return offset - document.getLineStartOffset(line);
    }

    public final boolean handleEnterAddIndent(@NotNull Editor editor, int caretOffset) {
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        HighlighterIterator iterator = null;
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(caretOffset - 1);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        iterator = highlighterIterator;
        if (iterator.atEnd()) {
            return false;
        }
        boolean encounteredNewLine = false;
        while (!iterator.atEnd() && (this.isIgnored(iterator.getTokenType()) || Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)FSharpTokenType.NEW_LINE))) {
            if (Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)FSharpTokenType.NEW_LINE)) {
                encounteredNewLine = true;
            }
            iterator.retreat();
        }
        if (iterator.atEnd()) {
            return false;
        }
        if (!(this.indentTokens.contains(iterator.getTokenType()) || !encounteredNewLine && this.allowKeepIndent.contains(iterator.getTokenType()))) {
            return false;
        }
        int tokenStart = iterator.getStart();
        IElementType tokenType = iterator.getTokenType();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int line = document2.getLineNumber(tokenStart);
        if (this.leftBracketsToAddIndent.contains(tokenType) && !this.isSingleLineBrackets(editor, tokenStart) && !this.isLastTokenOnLine(editor, tokenStart) && this.isFirstTokenOnLine(editor, tokenStart)) {
            return false;
        }
        int caretLine = document2.getLineNumber(caretOffset);
        Pair<Integer, LineIndent> nestedIndent = this.tryGetNestedIndentBelowLine(editor, line);
        if (nestedIndent != null) {
            Pair<Integer, LineIndent> pair = nestedIndent;
            int belowLine = ((Number)pair.component1()).intValue();
            LineIndent lineIndent = (LineIndent)pair.component2();
            if (belowLine == caretLine) {
                return false;
            }
            this.insertNewLineAt(editor, lineIndent.getIndent(), caretOffset, true);
            return true;
        }
        HighlighterIterator highlighterIterator2 = editor.getHighlighter().createIterator(caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator2, (String)"createIterator(...)");
        iterator = highlighterIterator2;
        if (!iterator.atEnd() && this.isFirstTokenOnLine(editor, iterator.getStart()) && !this.isLastTokenOnLine(editor, iterator.getStart())) {
            return false;
        }
        FSharpEnterHandlerDelegate $this$handleEnterAddIndent_u24lambda_u240 = this;
        boolean bl = false;
        LineIndent lineIndent = $this$handleEnterAddIndent_u24lambda_u240.getLineIndent(editor, caretLine);
        if (lineIndent != null && lineIndent.getType() == LineIndent.Type.Comments) {
            n = lineIndent.getIndent();
        } else {
            HighlighterIterator highlighterIterator3 = editor.getHighlighter().createIterator(caretOffset - 1);
            Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator3, (String)"createIterator(...)");
            iterator = highlighterIterator3;
            int indent = FSharpTypingAssistUtilsKt.getIndentSettings(editor).getIndentSize();
            if (Intrinsics.areEqual((Object)tokenType, (Object)FSharpTokenType.EQUALS) && !encounteredNewLine && $this$handleEnterAddIndent_u24lambda_u240.isFirstTokenOnLine(editor, iterator.getStart())) {
                n = $this$handleEnterAddIndent_u24lambda_u240.getOffsetInLine(document2, line, tokenStart);
            } else if ($this$handleEnterAddIndent_u24lambda_u240.indentFromToken.contains(tokenType)) {
                n = indent + $this$handleEnterAddIndent_u24lambda_u240.getOffsetInLine(document2, line, tokenStart);
            } else {
                FSharpEnterHandlerDelegate $this$handleEnterAddIndent_u24lambda_u240_u240 = $this$handleEnterAddIndent_u24lambda_u240;
                boolean bl2 = false;
                int continuedLine = $this$handleEnterAddIndent_u24lambda_u240_u240.getContinuedIndentLine(editor, tokenStart, true);
                int prevIndentSize = $this$handleEnterAddIndent_u24lambda_u240_u240.getLineWhitespaceIndent(editor, continuedLine);
                n = prevIndentSize + indent;
            }
        }
        int indentSize = n;
        this.insertNewLineAt(editor, indentSize, caretOffset, true);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean handleEnterAddBiggerIndentFromBelow(@NotNull Editor editor, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        v0 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDocument(...)");
        document = v0;
        caretCoords = TextControlUtilsKt.offsetToDocCoordinates((Document)document, (int)caretOffset);
        caretLine = caretCoords.getLine();
        if (caretLine + 1 >= document.getLineCount()) {
            return false;
        }
        lineStartOffset = document.getLineStartOffset(caretLine);
        v1 = editor.getHighlighter().createIterator(lineStartOffset);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"createIterator(...)");
        iterator = v1;
        seenComment = false;
        if (iterator.atEnd()) {
            return false;
        }
        while (!iterator.atEnd()) {
            if (!Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)FSharpTokenType.WHITESPACE)) {
                if (iterator.getTokenType() == null) break;
                v2 = iterator.getTokenType();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getTokenType(...)");
                if (!FSharpTypingAssistUtilsKt.isComment(v2) || iterator.getStart() >= caretOffset) break;
            }
            if (seenComment) ** GOTO lbl-1000
            v3 = iterator.getTokenType();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getTokenType(...)");
            if (FSharpTypingAssistUtilsKt.isComment(v3)) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = false;
            }
            seenComment = v4;
            iterator.advance();
        }
        if (!Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.NEW_LINE)) {
            return false;
        }
        currentIndent = seenComment != false ? 0 : caretCoords.getColumn();
        nestedIndentBelow = this.tryGetNestedIndentBelow(editor, caretLine, seenComment, currentIndent);
        if (nestedIndentBelow == null) {
            return false;
        }
        lineIndent = (LineIndent)nestedIndentBelow.component2();
        this.insertNewLineAt(editor, lineIndent.getIndent(), caretOffset, false);
        return true;
    }

    private final void handleEnter(Editor editor, int caretOffset) {
        boolean bl;
        if (this.handleEnterInTripleQuotedString(editor, caretOffset)) {
            return;
        }
        if (this.handleEnterInLineComment(editor, caretOffset)) {
            return;
        }
        if (this.handleEnterAddIndent(editor, caretOffset)) {
            return;
        }
        if (this.handleEnterFindLeftBracket(editor, caretOffset)) {
            return;
        }
        if (this.handleEnterAddBiggerIndentFromBelow(editor, caretOffset)) {
            return;
        }
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.atEnd()) {
            bl = false;
        } else {
            while (Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.WHITESPACE)) {
                iterator.advance();
            }
            bl = this.shouldTrimSpacesBeforeToken(FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator));
        }
        boolean trimSpacesAfterCaret = bl;
        this.doDumpIndent(editor, caretOffset, trimSpacesAfterCaret);
    }

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)FSharpLanguage.INSTANCE))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return EnterHandlerDelegate.Result.Stop;
        }
        Object object = this;
        try {
            FSharpEnterHandlerDelegate $this$preprocessEnter_u24lambda_u240 = object;
            boolean bl = false;
            Object object2 = caretOffset.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            $this$preprocessEnter_u24lambda_u240.handleEnter(editor, ((Number)object2).intValue());
            return EnterHandlerDelegate.Result.Stop;
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable exception = throwable;
                boolean bl2 = false;
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                Object[] objectArray = stackTraceElementArray;
                String string = System.lineSeparator();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
                String trace = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)string, null, null, (int)0, null, FSharpEnterHandlerDelegate::preprocessEnter$lambda$1$0, (int)30, null);
                FSharpEnterHandlerDelegateKt.access$getLogger$p().error("Couldn't execute enter handler for F#: " + exception.getMessage() + System.lineSeparator() + trace);
                return EnterHandlerDelegate.Result.Continue;
            }
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final int getContinuedIndentLine$tryFindContinuedLine(HighlighterIterator iterator, Editor $editor, Document document, FSharpEnterHandlerDelegate this$0, boolean $continueByLeadingLParen, int line, int lineStartOffset, boolean hasLeadingLeftBracket) {
        while (!iterator.atEnd()) {
            FSharpInterpolatedStringLiteralExpression interpolatedStringExpr;
            if (iterator.getEnd() <= lineStartOffset && !hasLeadingLeftBracket) {
                return line;
            }
            if (!FSharpTokenType.INTERPOLATED_STRING_ENDINGS.contains(FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator))) {
                v0 = null;
            } else {
                Project project = $editor.getProject();
                Intrinsics.checkNotNull((Object)project);
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                manager.commitDocument(document);
                PsiFile psiFileAfterCommit = manager.getPsiFile($editor.getDocument());
                if (psiFileAfterCommit == null) {
                    v0 = null;
                } else {
                    FSharpInterpolatedStringLiteralExpression interpolatedString;
                    FSharpInterpolatedStringLiteralExpression fSharpInterpolatedStringLiteralExpression;
                    PsiElement elementAtCaret = psiFileAfterCommit.findElementAt(iterator.getEnd() - 1);
                    if (elementAtCaret != null) {
                        void $this$parentOfType$iv;
                        boolean withSelf$iv = true;
                        boolean $i$f$parentOfType = false;
                        fSharpInterpolatedStringLiteralExpression = (FSharpInterpolatedStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, FSharpInterpolatedStringLiteralExpression.class, (boolean)false);
                    } else {
                        fSharpInterpolatedStringLiteralExpression = null;
                    }
                    v0 = interpolatedStringExpr = (interpolatedString = fSharpInterpolatedStringLiteralExpression);
                }
            }
            if (interpolatedStringExpr != null) {
                FSharpInterpolatedStringLiteralExpression it;
                boolean bl = false;
                int interpolatedStringExprStartOffset = PsiTreeUtilKt.getStartOffset((PsiElement)it);
                while (iterator.getStart() > interpolatedStringExprStartOffset) {
                    iterator.retreat();
                }
            }
            int continuedLine = this$0.deindentingTokens.contains(FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator)) ? (new FSharpBracketMatcher().findMatchingBracket(FSharpTypingAssistUtilsKt.asTokenIterator(iterator)) == null ? line : document.getLineNumber(iterator.getStart())) : (iterator.getStart() >= lineStartOffset ? line : document.getLineNumber(iterator.getStart()));
            int newLineStartOffset = line == continuedLine ? lineStartOffset : document.getLineStartOffset(continuedLine);
            boolean hasLeadingLeftParen = $continueByLeadingLParen && iterator.getStart() > newLineStartOffset && Intrinsics.areEqual((Object)FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator), (Object)FSharpTokenType.LPAREN) || hasLeadingLeftBracket && this$0.isIgnored(FSharpTypingAssistUtilsKt.getTokenTypeSafe(iterator));
            iterator.retreat();
            line = continuedLine;
            lineStartOffset = newLineStartOffset;
            hasLeadingLeftBracket = hasLeadingLeftParen;
        }
        return line;
    }

    private static final Pair<Integer, LineIndent> tryGetNestedIndentBelow$tryFindIndent(FSharpEnterHandlerDelegate this$0, int $currentIndent, boolean $preferComment, Editor editor, Pair<Integer, LineIndent> firstFoundCommentIndent, int line) {
        Pair<Integer, LineIndent> pair;
        block4: while (true) {
            LineIndent lineIndent;
            if (line >= editor.getDocument().getLineCount()) {
                return firstFoundCommentIndent;
            }
            if (this$0.getLineIndent(editor, line) == null) {
                Editor editor2 = editor;
                Pair<Integer, LineIndent> pair2 = firstFoundCommentIndent;
                int n = line + 1;
                editor = editor2;
                firstFoundCommentIndent = pair2;
                line = n;
                continue;
            }
            Pair<Integer, LineIndent> indent = new Pair<Integer, LineIndent>((Object)line, (Object)lineIndent);
            switch (WhenMappings.$EnumSwitchMapping$0[lineIndent.getType().ordinal()]) {
                case 1: {
                    if (lineIndent.getIndent() > $currentIndent) {
                        pair = indent;
                        break block4;
                    }
                    pair = firstFoundCommentIndent;
                    break block4;
                }
                case 2: {
                    if ($preferComment) {
                        pair = indent;
                        break block4;
                    }
                    if (firstFoundCommentIndent == null && lineIndent.getIndent() > $currentIndent) {
                        Editor editor3 = editor;
                        int n = line + 1;
                        editor = editor3;
                        firstFoundCommentIndent = indent;
                        line = n;
                        continue block4;
                    }
                    Editor editor4 = editor;
                    Pair<Integer, LineIndent> pair3 = firstFoundCommentIndent;
                    int n = line + 1;
                    editor = editor4;
                    firstFoundCommentIndent = pair3;
                    line = n;
                    continue block4;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            break;
        }
        return pair;
    }

    private static final CharSequence preprocessEnter$lambda$1$0(StackTraceElement it) {
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineIndent.Type.values().length];
            try {
                nArray[LineIndent.Type.Source.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineIndent.Type.Comments.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

