/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.fsharp.editorActions;

import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.resharper.assist.BracketMatcher;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.editors.DocCoordinates;
import com.jetbrains.rider.editors.TextControlUtilsKt;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.FSharpLanguage;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.lexer.FSharpTokenType;
import com.jetbrains.rider.plugins.fsharp.editorActions.FSharpBracketMatcher;
import com.jetbrains.rider.plugins.fsharp.editorActions.FSharpTypingAssistUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ*\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000f0\u0014J\u001e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/editorActions/FSharpBackspaceHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandler;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "executeWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "handleBackspace", "", "handleBackspaceInInterpolatedString", "handleBackspaceInTripleQuotedString", "doHandleBackspacePressed", "isStringLiteralToken", "Lkotlin/Function1;", "Lcom/intellij/psi/tree/IElementType;", "handleBackspaceInString", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "intellij.rider.plugins.fsharp"})
public final class FSharpBackspaceHandlerDelegate
extends BackspaceHandler {
    public FSharpBackspaceHandlerDelegate(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        super(originalHandler);
    }

    public void executeWriteAction(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                if (!PatchEngineRegistryKt.isPatchEngineEnabled() || dataContext == null) break block2;
                PsiFile psiFile = (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE);
                if ((psiFile != null ? psiFile.getLanguage() : null) instanceof FSharpLanguage && editor.getCaretModel().getCaretCount() == 1 && caret.getOffset() > 0 && this.handleBackspace(editor, caret)) break block3;
            }
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }

    private final boolean handleBackspace(Editor editor, Caret caret) {
        if (this.handleBackspaceInInterpolatedString(editor, caret)) {
            return true;
        }
        if (this.handleBackspaceInTripleQuotedString(editor, caret)) {
            return true;
        }
        return this.doHandleBackspacePressed(editor, caret, (Function1<? super IElementType, Boolean>)((Function1)FSharpBackspaceHandlerDelegate::handleBackspace$lambda$0));
    }

    public final boolean handleBackspaceInInterpolatedString(@NotNull Editor editor, @NotNull Caret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int caretOffset = caret.getOffset();
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getStart() != caretOffset) {
            return false;
        }
        IElementType tokenType = iterator.getTokenType();
        if (!FSharpTokenType.INTERPOLATED_STRING_MIDDLES.contains(tokenType) && !FSharpTokenType.INTERPOLATED_STRING_ENDS.contains(tokenType)) {
            return false;
        }
        iterator.retreat();
        IElementType prevTokenType = iterator.getTokenType();
        if (!FSharpTokenType.INTERPOLATED_STRING_STARTS.contains(prevTokenType) && !FSharpTokenType.INTERPOLATED_STRING_MIDDLES.contains(prevTokenType)) {
            return false;
        }
        caret.moveToOffset(caretOffset - 1);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        editor.getDocument().deleteString(caretOffset - 1, caretOffset + 1);
        return true;
    }

    public final boolean handleBackspaceInTripleQuotedString(@NotNull Editor editor, @NotNull Caret caret) {
        String string;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int offset = caret.getOffset();
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.atEnd()) {
            return false;
        }
        IElementType tokenType = iterator.getTokenType();
        if (!Intrinsics.areEqual((Object)tokenType, (Object)FSharpTokenType.TRIPLE_QUOTED_STRING) && !Intrinsics.areEqual((Object)tokenType, (Object)FSharpTokenType.TRIPLE_QUOTE_INTERPOLATED_STRING) || iterator.getStart() == offset) {
            return false;
        }
        IElementType iElementType = tokenType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)FSharpTokenType.TRIPLE_QUOTED_STRING)) {
            string = "\"\"\"";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)FSharpTokenType.TRIPLE_QUOTE_INTERPOLATED_STRING)) {
            string = "$\"\"\"";
        } else {
            throw new IllegalArgumentException("Unexpected token type: " + tokenType);
        }
        String strStart = string;
        String strEnd = "\"\"\"";
        int newLineLength = 1;
        if (iterator.getStart() == offset - strStart.length() && iterator.getEnd() == offset + strEnd.length()) {
            editor.getDocument().deleteString(offset - 1, offset + 3);
            caret.moveToOffset(offset - 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            return true;
        }
        if (iterator.getStart() + strStart.length() + newLineLength == offset) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            DocCoordinates strStartCoords = TextControlUtilsKt.offsetToDocCoordinates((Document)document2, (int)iterator.getStart());
            DocCoordinates strEndCoords = TextControlUtilsKt.offsetToDocCoordinates((Document)document2, (int)iterator.getEnd());
            int caretLine = document2.getLineNumber(offset);
            if (caretLine != strStartCoords.getLine() + 1) {
                return false;
            }
            if (offset != document2.getLineStartOffset(caretLine)) {
                return false;
            }
            if (strStartCoords.getLine() + 2 != strEndCoords.getLine()) {
                return false;
            }
            if (strEndCoords.getColumn() != 3) {
                return false;
            }
            int lastNewLineOffset = iterator.getEnd() - strEnd.length() - newLineLength;
            editor.getDocument().deleteString(lastNewLineOffset, lastNewLineOffset + newLineLength);
            editor.getDocument().deleteString(offset - newLineLength, offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            return true;
        }
        return false;
    }

    public final boolean doHandleBackspacePressed(@NotNull Editor editor, @NotNull Caret caret, @NotNull Function1<? super IElementType, Boolean> isStringLiteralToken) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter(isStringLiteralToken, (String)"isStringLiteralToken");
        int caretOffset = caret.getOffset();
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        if (iterator.atEnd()) {
            return false;
        }
        IElementType iElementType = iterator.getTokenType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
        if (((Boolean)isStringLiteralToken.invoke((Object)iElementType)).booleanValue()) {
            return this.handleBackspaceInString(editor, caret, iterator);
        }
        if (iterator.getStart() != caretOffset) {
            return false;
        }
        int rightBracketPos = iterator.getStart();
        FSharpBracketMatcher bracketMatcher = new FSharpBracketMatcher();
        iterator.retreat();
        IElementType prevTokenType = iterator.getTokenType();
        if (bracketMatcher.findMatchingBracket(FSharpTypingAssistUtilsKt.asTokenIterator(iterator)) == null || iterator.getStart() != rightBracketPos) {
            return false;
        }
        int leftBracketPos = iterator.getStart();
        do {
            if (Intrinsics.areEqual((Object)iterator.getTokenType(), (Object)prevTokenType) && bracketMatcher.isStackEmpty()) {
                leftBracketPos = iterator.getStart();
            } else {
                BracketMatcher bracketMatcher2 = bracketMatcher;
                IElementType iElementType2 = iterator.getTokenType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"getTokenType(...)");
                if (!BracketMatcher.proceedStack$default((BracketMatcher)bracketMatcher2, (IElementType)iElementType2, (boolean)false, (int)2, null)) break;
            }
            iterator.retreat();
        } while (!iterator.atEnd());
        HighlighterIterator highlighterIterator2 = editor.getHighlighter().createIterator(leftBracketPos);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator2, (String)"createIterator(...)");
        BracketMatcher.TokenIterator iterator2 = FSharpTypingAssistUtilsKt.asTokenIterator(highlighterIterator2);
        int caretOffset2 = caretOffset - 1;
        caret.moveToOffset(caretOffset2);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        editor.getDocument().deleteString(caretOffset2, caretOffset2 + (bracketMatcher.findMatchingBracket(iterator2) != null ? 2 : 1));
        return true;
    }

    public final boolean handleBackspaceInString(@NotNull Editor editor, @NotNull Caret caret, @NotNull HighlighterIterator iterator) {
        boolean escaped;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        int caretOffset = caret.getOffset();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence buffer = charSequence;
        char prevChar = buffer.charAt(caretOffset - 1);
        if (prevChar != '\'' && prevChar != '\"') {
            return false;
        }
        if (caretOffset != iterator.getEnd() - 1 || prevChar != buffer.charAt(caretOffset)) {
            return false;
        }
        boolean bl = escaped = caretOffset > 1 && buffer.charAt(caretOffset - 2) == '\\';
        if (!escaped) {
            caret.moveToOffset(caretOffset - 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            editor.getDocument().deleteString(caretOffset - 1, caretOffset + 1);
        } else {
            caret.moveToOffset(caretOffset - 2);
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            editor.getDocument().deleteString(caretOffset - 2, caretOffset);
        }
        return true;
    }

    private static final boolean handleBackspace$lambda$0(IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return Intrinsics.areEqual((Object)tokenType, (Object)FSharpTokenType.STRING) || Intrinsics.areEqual((Object)tokenType, (Object)FSharpTokenType.REGULAR_INTERPOLATED_STRING) || Intrinsics.areEqual((Object)tokenType, (Object)FSharpTokenType.VERBATIM_STRING) || Intrinsics.areEqual((Object)tokenType, (Object)FSharpTokenType.VERBATIM_INTERPOLATED_STRING);
    }
}

