/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.fsharp.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.ModelUtilKt;
import com.jetbrains.rider.completion.ProtocolCompletionContributor;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.psi.FSharpStringLiteralExpression;
import com.jetbrains.rider.plugins.fsharp.completion.FSharpCompletionUtilsKt;
import com.jetbrains.rider.plugins.fsharp.completion.NuGetProtocolCompletionContributorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J@\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0016\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/completion/NuGetProtocolCompletionContributor;", "Lcom/jetbrains/rider/completion/ProtocolCompletionContributor;", "<init>", "()V", "containsExclusive", "", "range", "Lkotlin/ranges/IntRange;", "value", "", "ensureCompletionIsRunning", "helper", "Lcom/jetbrains/rider/completion/FrontendCompletionHost;", "context", "Lcom/intellij/codeInsight/completion/CompletionInitializationContext;", "content", "", "cursorPosition", "host", "strictGroup", "Lkotlin/text/MatchGroup;", "zoneGroup", "isPreemptive", "()Z", "shouldStopOnPrefix", "prefix", "isAutoPopup", "isAvailable", "file", "Lcom/intellij/psi/PsiFile;", "offset", "beforeCompletion", "", "intellij.rider.plugins.fsharp"})
public final class NuGetProtocolCompletionContributor
extends ProtocolCompletionContributor {
    private final boolean isPreemptive;

    private final boolean containsExclusive(IntRange range, int value) {
        return value >= range.getFirst() && value <= range.getLast() + 1;
    }

    private final boolean ensureCompletionIsRunning(FrontendCompletionHost helper, CompletionInitializationContext context, String content, int cursorPosition, String host, MatchGroup strictGroup, MatchGroup zoneGroup) {
        if (this.containsExclusive(strictGroup.getRange(), cursorPosition)) {
            String string = content.substring(strictGroup.getRange().getFirst(), cursorPosition);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String completionPrefix = string;
            Editor editor = context.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            helper.ensureCompletionIsRunning(editor, CompletionType.BASIC, context.getInvocationCount(), completionPrefix, host);
            return true;
        }
        if (this.containsExclusive(zoneGroup.getRange(), cursorPosition)) {
            Editor editor = context.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            helper.ensureCompletionIsRunning(editor, CompletionType.BASIC, context.getInvocationCount(), "", host);
            return true;
        }
        return false;
    }

    public boolean isPreemptive() {
        return this.isPreemptive;
    }

    public boolean shouldStopOnPrefix(@NotNull String prefix, boolean isAutoPopup) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return false;
    }

    public boolean isAvailable(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FSharpCompletionUtilsKt.insideReferenceDirective(file, offset) && PatchEngineRegistryKt.isTypingSessionEnabled();
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!PatchEngineRegistryKt.isTypingSessionEnabled()) {
            return;
        }
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        FSharpStringLiteralExpression fSharpStringLiteralExpression = FSharpCompletionUtilsKt.getStringInsideReferenceDirective(psiFile, context.getStartOffset());
        if (fSharpStringLiteralExpression == null) {
            return;
        }
        FSharpStringLiteralExpression psiElement = fSharpStringLiteralExpression;
        Project project = context.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FrontendCompletionHost helper = FrontendCompletionHost.Companion.getInstance(project);
        String string = ElementManipulators.getValueText((PsiElement)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueText(...)");
        String stringText = string;
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange stringRange = textRange;
        int stringContentRange = PsiTreeUtilKt.getStartOffset((PsiElement)psiElement) + stringRange.getStartOffset();
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        TextControlModel textControlModel = DocumentExKt.getTextControlModel((Editor)editor);
        if (textControlModel == null) {
            return;
        }
        TextControlModel textControlModel2 = textControlModel;
        MatchResult matchResult = Regex.find$default((Regex)NuGetProtocolCompletionContributorKt.getPACKAGE_REFERENCE_REGEX(), (CharSequence)stringText, (int)0, (int)2, null);
        if (matchResult == null) {
            return;
        }
        MatchResult match = matchResult;
        int cursorPosition = ModelUtilKt.getCurrentOffsetSafe((TextControlModel)textControlModel2) - stringContentRange;
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"package");
        Intrinsics.checkNotNull((Object)matchGroup);
        MatchGroup matchGroup2 = matchGroup;
        MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"packageZone");
        Intrinsics.checkNotNull((Object)matchGroup3);
        MatchGroup packageZone = matchGroup3;
        MatchGroup version = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"version");
        MatchGroup versionZone = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"versionZone");
        context.setReplacementOffset(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement) + stringRange.getEndOffset());
        if (!this.ensureCompletionIsRunning(helper, context, stringText, cursorPosition, "NuGet:name", matchGroup2, packageZone) && versionZone != null && ((CharSequence)matchGroup2.getValue()).length() > 0) {
            String string2 = "NuGet:version|" + matchGroup2.getValue();
            MatchGroup matchGroup4 = version;
            Intrinsics.checkNotNull((Object)matchGroup4);
            this.ensureCompletionIsRunning(helper, context, stringText, cursorPosition, string2, matchGroup4, versionZone);
        }
    }
}

