/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.fsharp.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.completion.patchEngine.CompletionRegistryKt;
import com.jetbrains.rider.completion.patchEngine.RiderPatchEngineCompletionContributor;
import com.jetbrains.rider.completion.patchEngine.RiderPatchEngineProtocolProvider;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.psi.FSharpStringLiteralExpression;
import com.jetbrains.rider.plugins.fsharp.completion.FSharpCompletionUtilsKt;
import com.jetbrains.rider.plugins.fsharp.completion.NuGetProtocolCompletionContributorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J8\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/completion/NuGetPatchEngineCompletionContributor;", "Lcom/jetbrains/rider/completion/patchEngine/RiderPatchEngineCompletionContributor;", "<init>", "()V", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "beforeCompletion", "", "context", "Lcom/intellij/codeInsight/completion/CompletionInitializationContext;", "prepareCustomParams", "content", "", "cursorPosition", "host", "strictGroup", "Lkotlin/text/MatchGroup;", "zoneGroup", "editor", "Lcom/intellij/openapi/editor/Editor;", "containsExclusive", "range", "Lkotlin/ranges/IntRange;", "value", "intellij.rider.plugins.fsharp"})
public final class NuGetPatchEngineCompletionContributor
extends RiderPatchEngineCompletionContributor {
    public boolean isAvailable(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FSharpCompletionUtilsKt.insideReferenceDirective(file, offset);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled() || !CompletionRegistryKt.isPreemptiveCompletionEnabled()) {
            return;
        }
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        FSharpStringLiteralExpression fSharpStringLiteralExpression = FSharpCompletionUtilsKt.getStringInsideReferenceDirective(psiFile, context.getStartOffset());
        if (fSharpStringLiteralExpression == null) {
            return;
        }
        FSharpStringLiteralExpression psiElement = fSharpStringLiteralExpression;
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange stringRange = textRange;
        int stringContentRange = PsiTreeUtilKt.getStartOffset((PsiElement)psiElement) + stringRange.getStartOffset();
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        int startOffset = PlatformTextControlUtilsKt.getStartOffset((Editor)editor) - stringContentRange;
        context.setReplacementOffset(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement) + stringRange.getEndOffset());
        String string = ElementManipulators.getValueText((PsiElement)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueText(...)");
        String stringText = string;
        MatchResult matchResult = Regex.find$default((Regex)NuGetProtocolCompletionContributorKt.getPACKAGE_REFERENCE_REGEX(), (CharSequence)stringText, (int)0, (int)2, null);
        if (matchResult == null) {
            return;
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"package");
        Intrinsics.checkNotNull((Object)matchGroup);
        MatchGroup matchGroup2 = matchGroup;
        MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"packageZone");
        Intrinsics.checkNotNull((Object)matchGroup3);
        MatchGroup packageZone = matchGroup3;
        MatchGroup version = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"version");
        MatchGroup versionZone = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"versionZone");
        Editor editor2 = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        if (!this.prepareCustomParams(stringText, startOffset, "NuGet:name", matchGroup2, packageZone, editor2)) {
            String string2 = "NuGet:version|" + matchGroup2.getValue();
            MatchGroup matchGroup4 = version;
            Intrinsics.checkNotNull((Object)matchGroup4);
            MatchGroup matchGroup5 = versionZone;
            Intrinsics.checkNotNull((Object)matchGroup5);
            Editor editor3 = context.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
            this.prepareCustomParams(stringText, startOffset, string2, matchGroup4, matchGroup5, editor3);
        }
    }

    private final boolean prepareCustomParams(String content, int cursorPosition, String host, MatchGroup strictGroup, MatchGroup zoneGroup, Editor editor) {
        if (this.containsExclusive(strictGroup.getRange(), cursorPosition)) {
            String string = content.substring(strictGroup.getRange().getFirst(), cursorPosition);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String completionPrefix = string;
            EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer((Editor)editor);
            RiderPatchEngineProtocolProvider.Companion.getInstance().setCustomHostDocumentVersion((RdAbstractEditorVersion)(editorSynchronizer != null ? editorSynchronizer.getVersion() : null));
            RiderPatchEngineProtocolProvider.Companion.getInstance().setCustomHost(host);
            RiderPatchEngineProtocolProvider.Companion.getInstance().setCustomPrefix(completionPrefix);
            return true;
        }
        if (this.containsExclusive(zoneGroup.getRange(), cursorPosition)) {
            EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer((Editor)editor);
            RiderPatchEngineProtocolProvider.Companion.getInstance().setCustomHostDocumentVersion((RdAbstractEditorVersion)(editorSynchronizer != null ? editorSynchronizer.getVersion() : null));
            RiderPatchEngineProtocolProvider.Companion.getInstance().setCustomHost(host);
            RiderPatchEngineProtocolProvider.Companion.getInstance().setCustomPrefix("");
            return true;
        }
        return false;
    }

    private final boolean containsExclusive(IntRange range, int value) {
        return value >= range.getFirst() && value <= range.getLast() + 1;
    }
}

