/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.fileTypes.fsharp.injections;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.lexer.FSharpTokenType;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.psi.FSharpInterpolatedStringLiteralExpression;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.psi.FSharpInterpolatedStringLiteralExpressionPart;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.psi.FSharpStringLiteralExpression;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.psi.FSharpStringLiteralExpressionUtilKt;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.psi.FSharpStringLiteralType;
import com.jetbrains.rider.languages.fileTypes.clr.psi.ClrLanguageInterpolatedStringLiteralExpression;
import com.jetbrains.rider.languages.fileTypes.clr.psi.ClrLanguageInterpolatedStringLiteralExpressionPart;
import com.jetbrains.rider.languages.fileTypes.clr.psi.ClrLanguageStringLiteralExpression;
import com.jetbrains.rider.plugins.appender.database.SqlAwareClrLanguageConcatenationAwareInjector;
import com.jetbrains.rider.plugins.appender.lang.common.ClrLanguageConcatenationAwareInjector;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/ideaInterop/fileTypes/fsharp/injections/FSharpConcatenationAwareInjector;", "Lcom/jetbrains/rider/plugins/appender/database/SqlAwareClrLanguageConcatenationAwareInjector;", "<init>", "()V", "getInjectionProcessor", "Lcom/jetbrains/rider/plugins/appender/lang/common/ClrLanguageConcatenationAwareInjector$InjectionProcessor;", "injection", "Lorg/intellij/plugins/intelliLang/inject/config/BaseInjection;", "host", "Lcom/jetbrains/rider/languages/fileTypes/clr/psi/ClrLanguageStringLiteralExpression;", "isInjectionHost", "", "concatenationOperand", "Lcom/intellij/psi/PsiElement;", "FSharpInjectionProcessor", "intellij.rider.plugins.fsharp"})
public final class FSharpConcatenationAwareInjector
extends SqlAwareClrLanguageConcatenationAwareInjector {
    public FSharpConcatenationAwareInjector() {
        super("F#");
    }

    @NotNull
    protected ClrLanguageConcatenationAwareInjector.InjectionProcessor getInjectionProcessor(@NotNull BaseInjection injection, @NotNull ClrLanguageStringLiteralExpression host) {
        Intrinsics.checkNotNullParameter((Object)injection, (String)"injection");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return (ClrLanguageConcatenationAwareInjector.InjectionProcessor)new FSharpInjectionProcessor(injection, host);
    }

    protected boolean isInjectionHost(@NotNull PsiElement concatenationOperand) {
        Intrinsics.checkNotNullParameter((Object)concatenationOperand, (String)"concatenationOperand");
        return concatenationOperand instanceof FSharpStringLiteralExpression;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0014\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/ideaInterop/fileTypes/fsharp/injections/FSharpConcatenationAwareInjector$FSharpInjectionProcessor;", "Lcom/jetbrains/rider/plugins/appender/database/SqlAwareClrLanguageConcatenationAwareInjector$ClrLanguageSqlAwareInjectionProcessor;", "injection", "Lorg/intellij/plugins/intelliLang/inject/config/BaseInjection;", "host", "Lcom/jetbrains/rider/languages/fileTypes/clr/psi/ClrLanguageStringLiteralExpression;", "<init>", "(Lorg/intellij/plugins/intelliLang/inject/config/BaseInjection;Lcom/jetbrains/rider/languages/fileTypes/clr/psi/ClrLanguageStringLiteralExpression;)V", "getFragmentStartAfterTemplate", "", "matchResult", "Lkotlin/text/MatchResult;", "getPlaceholderForTemplate", "", "disableInspections", "", "getInterpolatedStringPartTextRange", "Lcom/intellij/openapi/util/TextRange;", "literal", "Lcom/jetbrains/rider/languages/fileTypes/clr/psi/ClrLanguageInterpolatedStringLiteralExpression;", "part", "Lcom/jetbrains/rider/languages/fileTypes/clr/psi/ClrLanguageInterpolatedStringLiteralExpressionPart;", "previousPart", "Companion", "intellij.rider.plugins.fsharp"})
    private static final class FSharpInjectionProcessor
    extends SqlAwareClrLanguageConcatenationAwareInjector.ClrLanguageSqlAwareInjectionProcessor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String SLASH_NEWLINE = "slashNewLine";
        @NotNull
        private static final List<FSharpStringLiteralType> rawStringTypes;

        public FSharpInjectionProcessor(@NotNull BaseInjection injection, @NotNull ClrLanguageStringLiteralExpression host) {
            Intrinsics.checkNotNullParameter((Object)injection, (String)"injection");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SLASH_NEWLINE, (Object)"\\\\\\n"), TuplesKt.to((Object)"jetbrainsRiderDummyIdentifier", (Object)"\\{\\d+}")};
            Map map = MapsKt.mapOf((Pair[])pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)SLASH_NEWLINE, (Object)"\\\\\\n"), TuplesKt.to((Object)"jetbrainsRiderDummyIdentifier", (Object)FSharpInjectionProcessor.Companion.createInterpolatedStringFormattingPlaceholderRegex(host))};
            super(injection, map, MapsKt.mapOf((Pair[])pairArray));
        }

        protected int getFragmentStartAfterTemplate(@NotNull MatchResult matchResult) {
            Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
            return RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)SLASH_NEWLINE) != null ? matchResult.getRange().getLast() : super.getFragmentStartAfterTemplate(matchResult);
        }

        @NotNull
        protected String getPlaceholderForTemplate(@NotNull MatchResult matchResult) {
            Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
            return RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)SLASH_NEWLINE) != null ? " " : "jetbrainsRiderDummyIdentifier";
        }

        protected boolean disableInspections(@NotNull MatchResult matchResult) {
            Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
            return RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)SLASH_NEWLINE) == null;
        }

        @NotNull
        protected TextRange getInterpolatedStringPartTextRange(@NotNull ClrLanguageInterpolatedStringLiteralExpression literal, @NotNull ClrLanguageInterpolatedStringLiteralExpressionPart part, @Nullable ClrLanguageInterpolatedStringLiteralExpressionPart previousPart) {
            int n;
            int startOffsetInPart;
            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)literal));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
            TextRange wholeLiteralRange = textRange;
            FSharpInterpolatedStringLiteralExpression fsharpLiteral = (FSharpInterpolatedStringLiteralExpression)literal;
            int interpolationBracketsCount = FSharpStringLiteralExpressionUtilKt.getDollarsCount(fsharpLiteral);
            if (part instanceof FSharpInterpolatedStringLiteralExpressionPart) {
                int partLength = ((FSharpInterpolatedStringLiteralExpressionPart)part).getTextLength();
                String partText = ((FSharpInterpolatedStringLiteralExpressionPart)part).getText();
                if (FSharpTokenType.INTERPOLATED_STRINGS_WITHOUT_INSERTIONS.contains((IElementType)((FSharpInterpolatedStringLiteralExpressionPart)part).getTokenType())) {
                    return wholeLiteralRange;
                }
                int n2 = startOffsetInPart = FSharpTokenType.INTERPOLATED_STRING_STARTS.contains((IElementType)((FSharpInterpolatedStringLiteralExpressionPart)part).getTokenType()) ? wholeLiteralRange.getStartOffset() : ((FSharpInterpolatedStringLiteralExpressionPart)part).getStartOffsetInParent() + interpolationBracketsCount;
                if (FSharpTokenType.INTERPOLATED_STRING_ENDS.contains((IElementType)((FSharpInterpolatedStringLiteralExpressionPart)part).getTokenType())) {
                    n = wholeLiteralRange.getEndOffset();
                } else {
                    int formatSpecifierOffset = interpolationBracketsCount + 2;
                    boolean containsFormatSpecifier = partLength > formatSpecifierOffset && partText.charAt(partLength - formatSpecifierOffset) == '%' && Character.isLetter(partText.charAt(partLength - formatSpecifierOffset + 1));
                    n = ((FSharpInterpolatedStringLiteralExpressionPart)part).getStartOffsetInParent() + partLength - interpolationBracketsCount - (containsFormatSpecifier ? 2 : 0);
                }
            } else {
                throw new IllegalStateException(("Unexpected interpolated part type: " + part).toString());
            }
            int endOffsetInPart = n;
            return new TextRange(startOffsetInPart, endOffsetInPart);
        }

        static {
            FSharpStringLiteralType[] fSharpStringLiteralTypeArray = new FSharpStringLiteralType[]{FSharpStringLiteralType.TripleQuoteString, FSharpStringLiteralType.TripleQuoteInterpolatedString, FSharpStringLiteralType.RawInterpolatedString};
            rawStringTypes = CollectionsKt.listOf((Object[])fSharpStringLiteralTypeArray);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/ideaInterop/fileTypes/fsharp/injections/FSharpConcatenationAwareInjector$FSharpInjectionProcessor$Companion;", "", "<init>", "()V", "SLASH_NEWLINE", "", "createInterpolatedStringFormattingPlaceholderRegex", "host", "Lcom/jetbrains/rider/languages/fileTypes/clr/psi/ClrLanguageStringLiteralExpression;", "rawStringTypes", "", "Lcom/jetbrains/rider/ideaInterop/fileTypes/fsharp/psi/FSharpStringLiteralType;", "intellij.rider.plugins.fsharp"})
        public static final class Companion {
            private Companion() {
            }

            private final String createInterpolatedStringFormattingPlaceholderRegex(ClrLanguageStringLiteralExpression host) {
                if (!(host instanceof FSharpStringLiteralExpression)) {
                    return "\\{\\d+}";
                }
                if (!rawStringTypes.contains((Object)((FSharpStringLiteralExpression)host).getLiteralType())) {
                    return "\\{\\{\\d+}}";
                }
                return "\\{\\d+}";
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

