/*
 * Decompiled with CFR 0.152.
 */
package intellij.rider.plugins.debuggerLinq;

import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InsetPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.MouseButtonKt;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.debugger.streams.core.action.TraceStreamRunner;
import com.intellij.debugger.streams.shared.ChainStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.EDT;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.debugger.DotNetSuspendContext;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextType;
import intellij.rider.plugins.debuggerLinq.LinqDebuggerBundle;
import intellij.rider.plugins.debuggerLinq.LinqInlayDisplayCollector;
import intellij.rider.plugins.debuggerLinq.settings.Settings;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lintellij/rider/plugins/debuggerLinq/LinqInlayDisplay;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/xdebugger/XDebugSession;)V", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "sessionPaused", "", "beforeSessionResume", "displayLinqInlay", "lifetime", "topFramePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "createRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "position", "shouldShowLinqInlay", "", "suspendReason", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextType;", "shouldShowLinqInlayForSuspendReason", "isEnabled", "Companion", "ClickHandler", "HoverHandler", "intellij.rider.plugins.debuggerLinq"})
public final class LinqInlayDisplay
implements XDebugSessionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final SequentialLifetimes lifetimes;

    private LinqInlayDisplay(Lifetime sessionLifetime, XDebugSession session) {
        this.session = session;
        this.lifetimes = new SequentialLifetimes(sessionLifetime);
    }

    public void sessionPaused() {
        RdDocumentId rdDocumentId;
        EDT.assertIsEdt();
        XSourcePosition xSourcePosition = this.session.getTopFramePosition();
        if (xSourcePosition == null) {
            return;
        }
        XSourcePosition topFramePosition = xSourcePosition;
        DotNetSuspendContext dotNetSuspendContext = DotnetDebuggerExtKt.getDotnetSuspendContext((XDebugSession)this.session);
        if (dotNetSuspendContext == null) {
            return;
        }
        DotNetSuspendContext dotnetSuspendContext = dotNetSuspendContext;
        if (!this.shouldShowLinqInlay(dotnetSuspendContext.getSuspendReason())) {
            return;
        }
        Editor editor = this.getEditor(topFramePosition);
        if (editor != null && (editor = editor.getDocument()) != null) {
            Project project = this.session.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            rdDocumentId = DocumentExKt.getDocumentId((Document)editor, (Project)project);
        } else {
            rdDocumentId = null;
        }
        if (rdDocumentId == null) {
            return;
        }
        LifetimeDefinition pauseLifetime = this.lifetimes.next();
        LifetimeCoroutineUtilKt.launch$default((Lifetime)pauseLifetime.getLifetime(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pauseLifetime, topFramePosition, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ LinqInlayDisplay this$0;
            final /* synthetic */ LifetimeDefinition $pauseLifetime;
            final /* synthetic */ XSourcePosition $topFramePosition;
            {
                this.this$0 = $receiver;
                this.$pauseLifetime = $pauseLifetime;
                this.$topFramePosition = $topFramePosition;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = LinqInlayDisplay.access$getSession$p(this.this$0).getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
                        traceStreamRunner = TraceStreamRunner.Companion.getInstance(v0);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)traceStreamRunner);
                        this.label = 1;
                        v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.debugger.streams.core.action.TraceStreamRunner intellij.rider.plugins.debuggerLinq.LinqInlayDisplay ), ()Lcom/intellij/debugger/streams/shared/ChainStatus;)((TraceStreamRunner)traceStreamRunner, (LinqInlayDisplay)this.this$0), (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        traceStreamRunner = (TraceStreamRunner)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl18:
                        // 2 sources

                        if ((chainStatus = (ChainStatus)v1) == ChainStatus.FOUND) {
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)traceStreamRunner);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)chainStatus);
                            this.label = 2;
                            v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$pauseLifetime, this.$topFramePosition, null){
                                int label;
                                final /* synthetic */ LinqInlayDisplay this$0;
                                final /* synthetic */ LifetimeDefinition $pauseLifetime;
                                final /* synthetic */ XSourcePosition $topFramePosition;
                                {
                                    this.this$0 = $receiver;
                                    this.$pauseLifetime = $pauseLifetime;
                                    this.$topFramePosition = $topFramePosition;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            LinqInlayDisplay.access$displayLinqInlay(this.this$0, (Lifetime)this.$pauseLifetime, LinqInlayDisplay.access$getSession$p(this.this$0), this.$topFramePosition);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var4_2) {
                                return var4_2;
                            }
                        }
                        ** GOTO lbl31
                    }
                    case 2: {
                        chainStatus = (ChainStatus)this.L$1;
                        traceStreamRunner = (TraceStreamRunner)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl31:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final ChainStatus invokeSuspend$lambda$0(TraceStreamRunner $traceStreamRunner, LinqInlayDisplay this$0) {
                return $traceStreamRunner.getChainStatus(LinqInlayDisplay.access$getSession$p(this$0));
            }
        }), (int)2, null);
    }

    public void beforeSessionResume() {
        EDT.assertIsEdt();
        this.lifetimes.terminateCurrent();
    }

    private final void displayLinqInlay(Lifetime lifetime, XDebugSession session, XSourcePosition topFramePosition) {
        Editor editor = this.getEditor(topFramePosition);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        int lineEnd = editor2.getDocument().getLineEndOffset(topFramePosition.getLine());
        EditorCustomElementRenderer renderer = this.createRenderer(editor2, session);
        Inlay iconInlayElement = editor2.getInlayModel().addAfterLineEndElement(lineEnd, false, renderer);
        if (iconInlayElement == null) {
            return;
        }
        lifetime.onTermination(() -> LinqInlayDisplay.displayLinqInlay$lambda$0(iconInlayElement));
    }

    private final EditorCustomElementRenderer createRenderer(Editor editor, XDebugSession session) {
        String message = LinqDebuggerBundle.INSTANCE.message("show.linq.inlay.text", new Object[0]);
        PresentationFactory $this$createRenderer_u24lambda_u240 = new PresentationFactory(editor);
        boolean bl = false;
        InsetPresentation presentation = PresentationFactory.inset$default((PresentationFactory)$this$createRenderer_u24lambda_u240, (InlayPresentation)$this$createRenderer_u24lambda_u240.mouseHandling($this$createRenderer_u24lambda_u240.roundWithBackground($this$createRenderer_u24lambda_u240.smallTextWithoutBackground(message)), (InlayPresentationFactory.ClickListener)new ClickHandler(session), (InlayPresentationFactory.HoverListener)new HoverHandler(editor)), (int)2, (int)2, (int)0, (int)0, (int)24, null);
        return (EditorCustomElementRenderer)new PresentationRenderer((InlayPresentation)presentation);
    }

    private final Editor getEditor(XSourcePosition position) {
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.session.getProject()).getSelectedEditor(position.getFile());
        if (fileEditor == null) {
            return null;
        }
        FileEditor selectedEditor = fileEditor;
        TextEditor textEditor = selectedEditor instanceof TextEditor ? (TextEditor)selectedEditor : null;
        if (textEditor == null) {
            return null;
        }
        TextEditor textEditor2 = textEditor;
        return textEditor2.getEditor();
    }

    private final boolean shouldShowLinqInlay(ExecutionContextType suspendReason) {
        return this.isEnabled() && this.shouldShowLinqInlayForSuspendReason(suspendReason);
    }

    private final boolean shouldShowLinqInlayForSuspendReason(ExecutionContextType suspendReason) {
        return switch (WhenMappings.$EnumSwitchMapping$0[suspendReason.ordinal()]) {
            case 1 -> true;
            case 2 -> true;
            case 3 -> false;
            case 4 -> false;
            case 5 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isEnabled() {
        return Settings.Companion.getInstance().getShowInlays();
    }

    private static final Unit displayLinqInlay$lambda$0(Inlay $iconInlayElement) {
        Disposer.dispose((Disposable)((Disposable)$iconInlayElement));
        return Unit.INSTANCE;
    }

    public /* synthetic */ LinqInlayDisplay(Lifetime sessionLifetime, XDebugSession session, DefaultConstructorMarker $constructor_marker) {
        this(sessionLifetime, session);
    }

    public static final /* synthetic */ XDebugSession access$getSession$p(LinqInlayDisplay $this) {
        return $this.session;
    }

    public static final /* synthetic */ void access$displayLinqInlay(LinqInlayDisplay $this, Lifetime lifetime, XDebugSession session, XSourcePosition topFramePosition) {
        $this.displayLinqInlay(lifetime, session, topFramePosition);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lintellij/rider/plugins/debuggerLinq/LinqInlayDisplay$ClickHandler;", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory$ClickListener;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;)V", "onClick", "", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "logToFus", "getActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "intellij.rider.plugins.debuggerLinq"})
    @SourceDebugExtension(value={"SMAP\nLinqInlayDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinqInlayDisplay.kt\nintellij/rider/plugins/debuggerLinq/LinqInlayDisplay$ClickHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
    private static final class ClickHandler
    implements InlayPresentationFactory.ClickListener {
        @NotNull
        private final XDebugSession session;

        public ClickHandler(@NotNull XDebugSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        public void onClick(@NotNull MouseEvent event, @NotNull Point translated) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
            this.logToFus(event);
            if (MouseButtonKt.getMouseButton((MouseEvent)event) == MouseButton.Left) {
                Project project = this.session.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                TraceStreamRunner.Companion.getInstance(project).actionPerformed(this.session);
            } else if (MouseButtonKt.getMouseButton((MouseEvent)event) == MouseButton.Right) {
                JBPopupMenu.showByEvent((MouseEvent)event, (String)"InlayMenu", (ActionGroup)this.getActionGroup());
            }
        }

        private final void logToFus(MouseEvent event) {
            block0: {
                MouseButton mouseButton = MouseButtonKt.getMouseButton((MouseEvent)event);
                if (mouseButton == null) break block0;
                MouseButton it = mouseButton;
                boolean bl = false;
                LinqInlayDisplayCollector.INSTANCE.logClick(it);
            }
        }

        private final ActionGroup getActionGroup() {
            AnAction anAction = ActionManager.getInstance().getAction("LinqInlayPopup");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            return (ActionGroup)anAction;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lintellij/rider/plugins/debuggerLinq/LinqInlayDisplay$Companion;", "", "<init>", "()V", "start", "", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "intellij.rider.plugins.debuggerLinq"})
    public static final class Companion {
        private Companion() {
        }

        public final void start(@NotNull Lifetime sessionLifetime, @NotNull XDebugSession session) {
            Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            session.addSessionListener((XDebugSessionListener)new LinqInlayDisplay(sessionLifetime, session, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lintellij/rider/plugins/debuggerLinq/LinqInlayDisplay$HoverHandler;", "Lcom/intellij/codeInsight/hints/InlayPresentationFactory$HoverListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "onHover", "", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "onHoverFinished", "intellij.rider.plugins.debuggerLinq"})
    private static final class HoverHandler
    implements InlayPresentationFactory.HoverListener {
        @NotNull
        private final Editor editor;

        public HoverHandler(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
        }

        public void onHover(@NotNull MouseEvent event, @NotNull Point translated) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
                Editor editor = this.editor;
                EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
                if (editorEx == null) break block0;
                editorEx.setCustomCursor(HoverHandler.class, Cursor.getPredefinedCursor(12));
            }
        }

        public void onHoverFinished() {
            block0: {
                Editor editor = this.editor;
                EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
                if (editorEx == null) break block0;
                editorEx.setCustomCursor(HoverHandler.class, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExecutionContextType.values().length];
            try {
                nArray[ExecutionContextType.OnStop.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionContextType.OnBreakpoint.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionContextType.OnDataBreakpoint.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionContextType.OnException.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionContextType.OnStepCompleted.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

