/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.secret;

import java.util.HashMap;
import java.util.Map;

public enum TokenType {
    Unknown(null, 0),
    Access("Azure Directory Access Token", 1),
    Refresh("Azure Directory Refresh Token", 2),
    Personal("Personal Access Token", 3),
    Federated("Federated Authentication Token", 4),
    Test("Test-only Token", 5);

    private static final Map<Integer, TokenType> valueToTokenType;
    private final String description;
    private final int value;

    private TokenType(String description, int value) {
        this.description = description;
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public static TokenType fromValue(int value) {
        return valueToTokenType.get(value);
    }

    static {
        valueToTokenType = new HashMap<Integer, TokenType>();
        for (TokenType value : TokenType.values()) {
            valueToTokenType.put(value.getValue(), value);
        }
    }
}

