/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import java.util.LinkedHashMap;
import java.util.Map;

public class SimpleJson {
    private SimpleJson() {
    }

    static void error(char c, State s) {
        String message = "Unexpected character '" + c + "' at state " + (Object)((Object)s) + ".";
        throw new IllegalArgumentException(message);
    }

    static boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    static boolean isHexDigit(char c) {
        return Character.digit(c, 16) != -1;
    }

    static boolean isInsignificantWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    static boolean isLeftCurlyBracket(char c) {
        return c == '{';
    }

    static boolean isRightCurlyBracket(char c) {
        return c == '}';
    }

    static boolean isLeftSquareBracket(char c) {
        return c == '[';
    }

    static boolean isRightSquareBracket(char c) {
        return c == ']';
    }

    static boolean isColon(char c) {
        return c == ':';
    }

    static boolean isComma(char c) {
        return c == ',';
    }

    static boolean isPeriod(char c) {
        return c == '.';
    }

    static boolean isDoubleQuote(char c) {
        return c == '\"';
    }

    static boolean isLiteralStart(char c) {
        return c == 't' || c == 'f' || c == 'n';
    }

    static boolean isMinus(char c) {
        return c == '-';
    }

    static boolean isExp(char c) {
        return c == 'e' || c == 'E' || c == '-' || c == '+';
    }

    static boolean isEscape(char c) {
        return c == '\\';
    }

    static Object decodeLiteral(String input) {
        if ("true".equals(input)) {
            return true;
        }
        if ("false".equals(input)) {
            return false;
        }
        if ("null".equals(input)) {
            return null;
        }
        throw new IllegalArgumentException("Invalid literal '" + input + "'. Expected one of 'true', 'false' or 'null'.");
    }

    public static Map<String, Object> parse(String input) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        SimpleJson.parse(input, result);
        return result;
    }

    static void parse(String input, Map<String, Object> destination) {
        StringBuilder token2 = new StringBuilder();
        StringBuilder unicodeHex = new StringBuilder();
        State state = State.START;
        String key = null;
        block28: for (char c : input.toCharArray()) {
            switch (state) {
                case START: {
                    if (SimpleJson.isLeftCurlyBracket(c)) {
                        state = State.PRE_KEY;
                        continue block28;
                    }
                    if (SimpleJson.isInsignificantWhitespace(c)) continue block28;
                    SimpleJson.error(c, state);
                    continue block28;
                }
                case PRE_KEY: {
                    if (SimpleJson.isDoubleQuote(c)) {
                        state = State.KEY;
                        continue block28;
                    }
                    if (SimpleJson.isRightCurlyBracket(c)) {
                        state = State.END;
                        continue block28;
                    }
                    if (SimpleJson.isInsignificantWhitespace(c)) continue block28;
                    SimpleJson.error(c, state);
                    continue block28;
                }
                case KEY: {
                    if (SimpleJson.isDoubleQuote(c)) {
                        key = token2.toString();
                        token2.setLength(0);
                        state = State.PRE_VALUE;
                        continue block28;
                    }
                    token2.append(c);
                    continue block28;
                }
                case PRE_VALUE: {
                    if (SimpleJson.isColon(c)) {
                        state = State.VALUE;
                        continue block28;
                    }
                    if (SimpleJson.isInsignificantWhitespace(c)) continue block28;
                    SimpleJson.error(c, state);
                    continue block28;
                }
                case VALUE: {
                    if (SimpleJson.isDoubleQuote(c)) {
                        state = State.STRING_VALUE;
                        continue block28;
                    }
                    if (SimpleJson.isMinus(c) || SimpleJson.isDigit(c)) {
                        token2.append(c);
                        state = State.NUMBER_VALUE;
                        continue block28;
                    }
                    if (SimpleJson.isLiteralStart(c)) {
                        token2.append(c);
                        state = State.LITERAL_VALUE;
                        continue block28;
                    }
                    if (SimpleJson.isLeftSquareBracket(c)) {
                        state = State.SQUARE_BRACKET_STRING;
                        continue block28;
                    }
                    if (SimpleJson.isInsignificantWhitespace(c)) continue block28;
                    SimpleJson.error(c, state);
                    continue block28;
                }
                case NUMBER_VALUE: {
                    Object value;
                    if (SimpleJson.isComma(c) || SimpleJson.isInsignificantWhitespace(c) || SimpleJson.isRightCurlyBracket(c)) {
                        String candidateDouble = token2.toString();
                        token2.setLength(0);
                        value = Double.parseDouble(candidateDouble);
                        destination.put(key, value);
                        if (SimpleJson.isComma(c)) {
                            state = State.PRE_KEY;
                            continue block28;
                        }
                        if (SimpleJson.isRightCurlyBracket(c)) {
                            state = State.END;
                            continue block28;
                        }
                        state = State.POST_VALUE;
                        continue block28;
                    }
                    if (SimpleJson.isDigit(c) || SimpleJson.isExp(c) || SimpleJson.isPeriod(c)) {
                        token2.append(c);
                        continue block28;
                    }
                    SimpleJson.error(c, state);
                    continue block28;
                }
                case STRING_VALUE: {
                    Object value;
                    if (SimpleJson.isEscape(c)) {
                        state = State.STRING_VALUE_ESCAPE;
                        continue block28;
                    }
                    if (SimpleJson.isDoubleQuote(c)) {
                        value = token2.toString();
                        token2.setLength(0);
                        destination.put(key, value);
                        state = State.POST_VALUE;
                        continue block28;
                    }
                    token2.append(c);
                    continue block28;
                }
                case STRING_VALUE_ESCAPE: {
                    switch (c) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            token2.append(c);
                            state = State.STRING_VALUE;
                            continue block28;
                        }
                        case 'b': {
                            token2.append('\b');
                            state = State.STRING_VALUE;
                            continue block28;
                        }
                        case 'f': {
                            token2.append('\f');
                            state = State.STRING_VALUE;
                            continue block28;
                        }
                        case 'n': {
                            token2.append('\n');
                            state = State.STRING_VALUE;
                            continue block28;
                        }
                        case 'r': {
                            token2.append('\r');
                            state = State.STRING_VALUE;
                            continue block28;
                        }
                        case 't': {
                            token2.append('\t');
                            state = State.STRING_VALUE;
                            continue block28;
                        }
                        case 'u': {
                            state = State.STRING_VALUE_UNICODE;
                            continue block28;
                        }
                    }
                    SimpleJson.error(c, state);
                    continue block28;
                }
                case STRING_VALUE_UNICODE: {
                    if (SimpleJson.isHexDigit(c)) {
                        unicodeHex.append(c);
                        if (unicodeHex.length() != 4) continue block28;
                        String candidateHex = unicodeHex.toString();
                        unicodeHex.setLength(0);
                        int codePoint = Integer.parseInt(candidateHex, 16);
                        char[] chars = Character.toChars(codePoint);
                        token2.append(chars);
                        state = State.STRING_VALUE;
                        continue block28;
                    }
                    SimpleJson.error(c, state);
                    continue block28;
                }
                case SQUARE_BRACKET_STRING: {
                    Object value;
                    if (SimpleJson.isRightSquareBracket(c)) {
                        value = token2.toString();
                        token2.setLength(0);
                        destination.put(key, value);
                        state = State.POST_VALUE;
                        continue block28;
                    }
                    token2.append(c);
                    continue block28;
                }
                case LITERAL_VALUE: {
                    switch (c) {
                        case 'a': 
                        case 'e': 
                        case 'l': 
                        case 'r': 
                        case 's': 
                        case 'u': {
                            token2.append(c);
                            continue block28;
                        }
                        case ',': 
                        case '}': {
                            String candidateLiteral = token2.toString();
                            token2.setLength(0);
                            Object literal = SimpleJson.decodeLiteral(candidateLiteral);
                            destination.put(key, literal);
                            if (SimpleJson.isComma(c)) {
                                state = State.POST_VALUE;
                                continue block28;
                            }
                            state = State.END;
                            continue block28;
                        }
                    }
                    SimpleJson.error(c, state);
                    continue block28;
                }
                case POST_VALUE: {
                    if (SimpleJson.isComma(c)) {
                        state = State.PRE_KEY;
                        continue block28;
                    }
                    if (SimpleJson.isRightCurlyBracket(c)) {
                        state = State.END;
                        continue block28;
                    }
                    if (SimpleJson.isInsignificantWhitespace(c)) continue block28;
                    SimpleJson.error(c, state);
                    continue block28;
                }
                case END: {
                    if (SimpleJson.isInsignificantWhitespace(c)) continue block28;
                    SimpleJson.error(c, state);
                }
            }
        }
    }

    public static String format(Map<String, Object> input) {
        return null;
    }

    static enum State {
        START,
        PRE_KEY,
        KEY,
        PRE_VALUE,
        VALUE,
        NUMBER_VALUE,
        STRING_VALUE,
        STRING_VALUE_ESCAPE,
        STRING_VALUE_UNICODE,
        SQUARE_BRACKET_STRING,
        LITERAL_VALUE,
        POST_VALUE,
        END;

    }
}

