/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Environment {
    public static final String NewLine = System.getProperty("line.separator");

    public static String getCurrentDirectory() {
        File currentDir = new File("");
        String result = currentDir.getAbsolutePath();
        return result;
    }

    public static String getFolderPath(SpecialFolder folder) {
        switch (folder) {
            case ApplicationData: {
                return System.getenv("APPDATA");
            }
            case LocalApplicationData: {
                return System.getenv("LOCALAPPDATA");
            }
            case UserProfile: {
                return System.getProperty("user.home");
            }
        }
        throw new IllegalArgumentException("Very few SpecialFolder flags are supported.");
    }

    public static String getMachineName() {
        String machineName = null;
        if (machineName == null) {
            machineName = System.getenv("COMPUTERNAME");
        }
        if (machineName == null) {
            machineName = System.getenv("HOSTNAME");
        }
        if (machineName == null) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                machineName = address.getHostName();
            }
            catch (UnknownHostException e) {
                machineName = "unknown";
            }
        }
        return machineName;
    }

    public static enum SpecialFolder {
        Desktop,
        Programs,
        MyDocuments,
        Personal,
        Favorites,
        Startup,
        Recent,
        SendTo,
        StartMenu,
        MyMusic,
        MyVideos,
        DesktopDirectory,
        MyComputer,
        NetworkShortcuts,
        Fonts,
        Templates,
        CommonStartMenu,
        CommonPrograms,
        CommonStartup,
        CommonDesktopDirectory,
        ApplicationData,
        PrinterShortcuts,
        LocalApplicationData,
        InternetCache,
        Cookies,
        History,
        CommonApplicationData,
        Windows,
        System,
        ProgramFiles,
        MyPictures,
        UserProfile,
        SystemX86,
        ProgramFilesX86,
        CommonProgramFiles,
        CommonProgramFilesX86,
        CommonTemplates,
        CommonDocuments,
        CommonAdminTools,
        AdminTools,
        CommonMusic,
        CommonPictures,
        CommonVideos,
        Resources,
        LocalizedResources,
        CommonOemLinks,
        CDBurning;

    }
}

