/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.simulatorSupport;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorConfiguration;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorDeviceType;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorRuntime;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorsRegistry;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Xcode6SimulatorConfiguration
extends SimulatorConfiguration {
    @NotNull
    private final String myUDID;
    @NotNull
    private final String myName;
    @NotNull
    private final SimulatorDeviceType myDeviceType;
    @NotNull
    private final SimulatorRuntime myRuntime;
    @NotNull
    private final File mySimulatorDir;
    @NotNull
    private static final Set<String> ourMissingDeviceTypes = ConcurrentCollectionFactory.createConcurrentSet();
    @NotNull
    private static final Set<String> ourMissingRuntimes = ConcurrentCollectionFactory.createConcurrentSet();
    @NotNull
    private static final String ourOSVersion = Xcode6SimulatorConfiguration.determineOSVersion();
    public static final Comparator<Xcode6SimulatorConfiguration> COMPARATOR = (o1, o2) -> {
        int result = o1.getLaunchDeviceFamily() - o2.getLaunchDeviceFamily();
        if (result != 0) {
            return result;
        }
        result = -StringUtil.compareVersionNumbers((String)o1.getRuntime().getVersion(), (String)o2.getRuntime().getVersion());
        if (result != 0) {
            return result;
        }
        result = o1.getLaunchArchitecture().getType().compareTo((Enum)o2.getLaunchArchitecture().getType());
        if (result != 0) {
            return result;
        }
        result = o1.getName().compareToIgnoreCase(o2.getName());
        if (result != 0) {
            return result;
        }
        return 0;
    };

    @NotNull
    private static String determineOSVersion() {
        Version version = Version.parseVersion((String)SystemInfo.OS_VERSION);
        if (version == null || version.major >= 11) {
            String string = SystemInfo.OS_VERSION;
            if (string == null) {
                Xcode6SimulatorConfiguration.$$$reportNull$$$0(0);
            }
            return string;
        }
        GeneralCommandLine gcl = new GeneralCommandLine(new String[]{"sw_vers", "-productVersion"});
        gcl.getEnvironment().put("SYSTEM_VERSION_COMPAT", "0");
        String result = ExecUtil.execAndReadLine((GeneralCommandLine)gcl);
        String string = result == null ? SystemInfo.OS_VERSION : result;
        if (string == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static Xcode6SimulatorConfiguration read(@NotNull File dir, @NotNull SimulatorsRegistry.State state) throws InvalidSpecException, IOException {
        File plistFile;
        if (dir == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(2);
        }
        if (state == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(3);
        }
        if (!(plistFile = new File(dir, "device.plist")).exists() || !plistFile.isFile()) {
            return null;
        }
        Plist device = PlistDriver.readAnyFormat((File)plistFile);
        String udid = device.getNotNullString("UDID");
        String name = device.getNotNullString("name");
        String deviceTypeID = device.getNotNullString("deviceType");
        String runtimeID = device.getNotNullString("runtime");
        SimulatorDeviceType deviceType = state.findDeviceType(deviceTypeID);
        SimulatorRuntime runtime = state.findRuntime(runtimeID);
        if (deviceType == null || runtime == null) {
            if (deviceType == null && ourMissingDeviceTypes.add(deviceTypeID)) {
                XCLog.LOG.info("Simulator deviceType not found: " + deviceTypeID);
            }
            if (runtime == null && ourMissingRuntimes.add(runtimeID)) {
                XCLog.LOG.info("Simulator runtime not found: " + runtimeID);
            }
            return null;
        }
        ourMissingDeviceTypes.remove(deviceTypeID);
        ourMissingRuntimes.remove(runtimeID);
        return new Xcode6SimulatorConfiguration(udid, name, deviceType, runtime, dir);
    }

    public Xcode6SimulatorConfiguration(@NotNull String udid, @NotNull String name, @NotNull SimulatorDeviceType deviceType, @NotNull SimulatorRuntime runtime, @NotNull File simulatorDir) {
        if (udid == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(4);
        }
        if (name == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(5);
        }
        if (deviceType == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(6);
        }
        if (runtime == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(7);
        }
        if (simulatorDir == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(8);
        }
        this.myUDID = udid;
        this.myName = name;
        this.myDeviceType = deviceType;
        this.myRuntime = runtime;
        this.mySimulatorDir = simulatorDir;
    }

    @Override
    @NotNull
    public String getUDID() {
        String string = this.myUDID;
        if (string == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    public String getMinRuntimeVersion() {
        return this.myDeviceType.getMinRuntimeVersion();
    }

    @Override
    @Nullable
    public String getMaxRuntimeVersion() {
        return this.myDeviceType.getMaxRuntimeVersion();
    }

    @Override
    @NotNull
    public String getVersion() {
        String string = this.myRuntime.getVersion();
        if (string == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public String getBuildVersion() {
        return this.myRuntime.getBuildVersion();
    }

    @Override
    public int getScale() {
        return this.myDeviceType.getScale();
    }

    @Override
    public int getHeight() {
        return this.myDeviceType.getHeight();
    }

    @Override
    public Set<Integer> getSupportedDeviceFamilies() {
        TreeSet<Integer> copy = new TreeSet<Integer>(this.myDeviceType.getSupportedDeviceFamilies());
        copy.retainAll(this.myRuntime.getSupportedDeviceFamilies());
        return Collections.unmodifiableSet(copy);
    }

    @Override
    public List<ArchitectureValue> getSupportedArchitectures() {
        return this.myDeviceType.getSupportedArchitectures();
    }

    @Override
    @Nullable
    public ArchitectureValue getRunArchitectureIfCompatible(@NotNull Collection<Integer> applicationDeviceFamilies, @NotNull Collection<ArchitectureValue> applicationArchitectures) {
        if (applicationDeviceFamilies == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(12);
        }
        if (applicationArchitectures == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(13);
        }
        if (!Xcode6SimulatorConfiguration.isVersionBetween(ourOSVersion, this.myRuntime.getMinHostVersion(), this.myRuntime.getMaxHostVersion())) {
            return null;
        }
        return super.getRunArchitectureIfCompatible(applicationDeviceFamilies, applicationArchitectures);
    }

    @NotNull
    public SimulatorDeviceType getDeviceType() {
        SimulatorDeviceType simulatorDeviceType = this.myDeviceType;
        if (simulatorDeviceType == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(14);
        }
        return simulatorDeviceType;
    }

    @Override
    @NotNull
    public SimulatorRuntime getRuntime() {
        SimulatorRuntime simulatorRuntime = this.myRuntime;
        if (simulatorRuntime == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(15);
        }
        return simulatorRuntime;
    }

    @Override
    @NotNull
    public File getSimulatorDir() {
        File file = this.mySimulatorDir;
        if (file == null) {
            Xcode6SimulatorConfiguration.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NonNls
    public String toString() {
        return "SimulatorConfiguration{myUDID='" + this.myUDID + "', myName='" + this.myName + "', myDeviceType=" + String.valueOf(this.myDeviceType) + ", myRuntime=" + String.valueOf(this.myRuntime) + ", mySimulatorDir=" + String.valueOf(this.mySimulatorDir) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Xcode6SimulatorConfiguration that = (Xcode6SimulatorConfiguration)o;
        if (!this.myDeviceType.equals(that.myDeviceType)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.myRuntime.equals(that.myRuntime)) {
            return false;
        }
        if (!this.myUDID.equals(that.myUDID)) {
            return false;
        }
        return FileUtil.filesEqual((File)this.mySimulatorDir, (File)that.mySimulatorDir);
    }

    public int hashCode() {
        int result = this.myUDID.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myDeviceType.hashCode();
        result = 31 * result + this.myRuntime.hashCode();
        result = 31 * result + FileUtil.fileHashCode((File)this.mySimulatorDir);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/simulatorSupport/Xcode6SimulatorConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "udid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simulatorDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationDeviceFamilies";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationArchitectures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "determineOSVersion";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/Xcode6SimulatorConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUDID";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntime";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimulatorDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRunArchitectureIfCompatible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

