/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.simulatorSupport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.OCCorePathManager;
import com.jetbrains.cidr.OCPathManager;
import com.jetbrains.cidr.execution.PreferredPlatformBuildForSdkBuildProvider;
import com.jetbrains.cidr.execution.XcodeSimulatorsOnlineIndexPreferredPlatformBuildForSdkBuild;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorConfiguration;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorDeviceType;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorRuntime;
import com.jetbrains.cidr.execution.simulatorSupport.Xcode6SimulatorConfiguration;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.Xcode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.APP})
public final class SimulatorsRegistry
implements Disposable {
    private static final File CORE_SIMULATOR_VOLUMES_DIR = new File("/Library/Developer/CoreSimulator/Volumes");
    private static final PreferredPlatformBuildForSdkBuildProvider DEFAULT_BUILD_PREFERENCES_PROVIDER = XcodeSimulatorsOnlineIndexPreferredPlatformBuildForSdkBuild.Provider;
    private static PreferredPlatformBuildForSdkBuildProvider BUILD_PREFERENCES_PROVIDER_OVERRIDE = null;
    @NotNull
    private volatile State myState = new State();
    private final Alarm myUpdateAlarm;
    final CompletableFuture<?> initRefreshFuture = new CompletableFuture();

    public static SimulatorsRegistry getInstance() {
        return (SimulatorsRegistry)ApplicationManager.getApplication().getService(SimulatorsRegistry.class);
    }

    @TestOnly
    @NotNull
    public static SimulatorsRegistry getInstanceAndWaitLoadedBlocking() {
        SimulatorsRegistry registry = SimulatorsRegistry.getInstance();
        try {
            registry.initRefreshFuture.get();
        }
        catch (InterruptedException e) {
            XCLog.LOG.warn("Interrupted when waiting for refresh completed", (Throwable)e);
        }
        catch (ExecutionException e) {
            XCLog.LOG.error("Failed to wait for refresh completed", (Throwable)e);
        }
        SimulatorsRegistry simulatorsRegistry = registry;
        if (simulatorsRegistry == null) {
            SimulatorsRegistry.$$$reportNull$$$0(0);
        }
        return simulatorsRegistry;
    }

    public static List<File> getDefaultProfilesDirs() {
        File[] files;
        File volumes;
        File[] bundledPlatforms;
        ArrayList<File> platforms = new ArrayList<File>();
        File dir = SimulatorsRegistry.getXcodePlatformsDir();
        if (dir.exists() && (bundledPlatforms = dir.listFiles((dir1, name) -> name.endsWith(".platform"))) != null) {
            platforms.addAll(Arrays.asList(bundledPlatforms));
        }
        if ((volumes = SimulatorsRegistry.getCoreSimulatorVolumesDir()).exists() && (files = volumes.listFiles()) != null) {
            platforms.addAll(Arrays.asList(files));
        }
        return ContainerUtil.prepend((List)ContainerUtil.map(platforms, platform -> new File((File)platform, "Library/Developer/CoreSimulator/Profiles")), (Object[])new File[]{OCPathManager.getLibrarySubFile((String)"Developer/CoreSimulator/Profiles")});
    }

    public static File getDefaultConfigsDir() {
        return OCCorePathManager.getUserLibrarySubFile((String)"Developer/CoreSimulator/Devices");
    }

    private static File getXcodePlatformsDir() {
        return Xcode.getInstance().getSubFile("Platforms");
    }

    private static File getCoreSimulatorVolumesDir() {
        return CORE_SIMULATOR_VOLUMES_DIR;
    }

    public static List<Path> getWatchingDirs() {
        ArrayList<File> result = new ArrayList<File>();
        result.add(SimulatorsRegistry.getDefaultConfigsDir());
        result.add(SimulatorsRegistry.getXcodePlatformsDir());
        result.add(SimulatorsRegistry.getCoreSimulatorVolumesDir());
        List<File> defaultProfilesDirs = SimulatorsRegistry.getDefaultProfilesDirs();
        result.addAll(ContainerUtil.map(defaultProfilesDirs, it -> new File((File)it, "DeviceTypes")));
        result.addAll(ContainerUtil.map(defaultProfilesDirs, it -> new File((File)it, "Runtimes")));
        return ContainerUtil.map(result, File::toPath);
    }

    public SimulatorsRegistry() {
        if (!Xcode.getInstance().isInstalled()) {
            this.myUpdateAlarm = null;
            return;
        }
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myState = SimulatorsRegistry.readState(SimulatorsRegistry.getDefaultProfilesDirs(), SimulatorsRegistry.getDefaultConfigsDir(), false);
        this.refreshOnBackgroundThread();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                SimulatorsRegistry.this.scheduleRefresh();
            }

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(1);
                }
                SimulatorsRegistry.this.myUpdateAlarm.cancelAllRequests();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ideFrame";
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applicationActivated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applicationDeactivated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void scheduleRefresh() {
        if (this.myUpdateAlarm == null || !this.myUpdateAlarm.isEmpty()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> this.refresh(), 300);
    }

    @NotNull
    public List<SimulatorDeviceType> getDeviceTypes() {
        List<SimulatorDeviceType> list = this.myState.deviceTypes;
        if (list == null) {
            SimulatorsRegistry.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public SimulatorDeviceType findDeviceTypes(@Nullable String id) {
        return this.myState.findDeviceType(id);
    }

    @NotNull
    public List<SimulatorRuntime> getRuntimes() {
        List<SimulatorRuntime> list = this.myState.runtimes;
        if (list == null) {
            SimulatorsRegistry.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public SimulatorRuntime findRuntime(@Nullable String id) {
        return this.myState.findRuntime(id);
    }

    @NotNull
    public @Unmodifiable List<? extends SimulatorConfiguration> getConfigurations() {
        List<? extends SimulatorConfiguration> list = this.myState.configurations;
        if (list == null) {
            SimulatorsRegistry.$$$reportNull$$$0(3);
        }
        return list;
    }

    public Future<SimulatorsRegistry> refreshOnBackgroundThread() {
        return ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.refresh();
            return this;
        });
    }

    @TestOnly
    public Future<SimulatorsRegistry> refreshOnBackgroundThread(@NotNull List<File> profilesDirs, @NotNull File configurationsDir) {
        if (profilesDirs == null) {
            SimulatorsRegistry.$$$reportNull$$$0(4);
        }
        if (configurationsDir == null) {
            SimulatorsRegistry.$$$reportNull$$$0(5);
        }
        return ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.refresh(profilesDirs, configurationsDir);
            return this;
        });
    }

    @RequiresBackgroundThread
    private void refresh() {
        ThreadingAssertions.assertBackgroundThread();
        this.refresh(SimulatorsRegistry.getDefaultProfilesDirs(), SimulatorsRegistry.getDefaultConfigsDir());
    }

    @RequiresBackgroundThread
    private void refresh(@NotNull List<File> profilesDirs, @NotNull File configurationsDir) {
        if (profilesDirs == null) {
            SimulatorsRegistry.$$$reportNull$$$0(6);
        }
        if (configurationsDir == null) {
            SimulatorsRegistry.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertBackgroundThread();
        this.myState = SimulatorsRegistry.readState(profilesDirs, configurationsDir, true);
        if (!this.initRefreshFuture.isDone()) {
            this.initRefreshFuture.complete(null);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> RefreshListener.EP_NAME.forEachExtensionSafe(it -> it.refreshFinished()));
    }

    @NotNull
    private static synchronized State readState(@NotNull List<File> profilesDirs, @NotNull File configurationsDir, boolean filterAvailableRuntimes) {
        if (profilesDirs == null) {
            SimulatorsRegistry.$$$reportNull$$$0(8);
        }
        if (configurationsDir == null) {
            SimulatorsRegistry.$$$reportNull$$$0(9);
        }
        State newState = new State();
        newState.deviceTypes = SimulatorsRegistry.doRead(profilesDirs, "DeviceTypes", ".simdevicetype", "device types", new Reader<SimulatorDeviceType>(){

            @Override
            public SimulatorDeviceType read(@NotNull File file) throws InvalidSpecException, IOException {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return SimulatorDeviceType.read(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry$2", "read"));
            }
        });
        List<SimulatorRuntime> readRuntimes = SimulatorsRegistry.doRead(profilesDirs, "Runtimes", ".simruntime", "runtimes", new Reader<SimulatorRuntime>(){

            @Override
            public SimulatorRuntime read(@NotNull File file) throws InvalidSpecException, IOException {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                return SimulatorRuntime.read(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry$3", "read"));
            }
        });
        newState.runtimes = filterAvailableRuntimes ? SimulatorsRegistry.getBuildPreferencesProvider().get().filterRuntimesWithAvailablePlatforms(readRuntimes) : readRuntimes;
        SimulatorsRegistry.readConfigurations(configurationsDir, newState);
        State state = newState;
        if (state == null) {
            SimulatorsRegistry.$$$reportNull$$$0(10);
        }
        return state;
    }

    private static void readConfigurations(@NotNull File configurationsDir, @NotNull State state) {
        File[] devicesSubDirs;
        if (configurationsDir == null) {
            SimulatorsRegistry.$$$reportNull$$$0(11);
        }
        if (state == null) {
            SimulatorsRegistry.$$$reportNull$$$0(12);
        }
        if ((devicesSubDirs = configurationsDir.listFiles()) == null) {
            XCLog.LOG.warn("Simulator configurations not found at " + String.valueOf(configurationsDir));
            return;
        }
        ArrayList configurations = new ArrayList();
        for (File eachDir : devicesSubDirs) {
            if (!eachDir.isDirectory()) continue;
            try {
                ContainerUtil.addIfNotNull(configurations, (Object)Xcode6SimulatorConfiguration.read(eachDir, state));
            }
            catch (InvalidSpecException | IOException e) {
                XCLog.LOG.warn(e);
            }
        }
        state.configurations = ContainerUtil.sorted(configurations, Xcode6SimulatorConfiguration.COMPARATOR);
    }

    private static <T> List<T> doRead(@NotNull List<File> profilesDirs, @NotNull @NonNls String dirName, @NotNull @NonNls String extension, @NotNull @NonNls String displayName, @NotNull Reader<T> reader) {
        if (profilesDirs == null) {
            SimulatorsRegistry.$$$reportNull$$$0(13);
        }
        if (dirName == null) {
            SimulatorsRegistry.$$$reportNull$$$0(14);
        }
        if (extension == null) {
            SimulatorsRegistry.$$$reportNull$$$0(15);
        }
        if (displayName == null) {
            SimulatorsRegistry.$$$reportNull$$$0(16);
        }
        if (reader == null) {
            SimulatorsRegistry.$$$reportNull$$$0(17);
        }
        ArrayList runtimes = new ArrayList();
        for (File profileDir : profilesDirs) {
            Object[] listFiles = new File(profileDir, dirName).listFiles();
            if (listFiles == null) continue;
            ContainerUtil.addAll(runtimes, (Object[])listFiles);
        }
        if (runtimes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(runtimes.size());
        for (File each : runtimes) {
            if (!each.isDirectory() || !StringUtil.endsWithIgnoreCase((String)each.getName(), (String)extension)) continue;
            try {
                result.add(reader.read(each));
            }
            catch (InvalidSpecException | IOException e) {
                XCLog.LOG.error(e);
            }
        }
        if (result.isEmpty()) {
            XCLog.LOG.warn("No compatible simulators " + displayName + " found at " + String.valueOf(profilesDirs));
        }
        return Collections.unmodifiableList(result);
    }

    public void dispose() {
    }

    @TestOnly
    public static synchronized void setBuildPreferencesProviderInTests(@Nullable PreferredPlatformBuildForSdkBuildProvider provider) {
        BUILD_PREFERENCES_PROVIDER_OVERRIDE = provider;
    }

    @NotNull
    private static synchronized PreferredPlatformBuildForSdkBuildProvider getBuildPreferencesProvider() {
        PreferredPlatformBuildForSdkBuildProvider override = BUILD_PREFERENCES_PROVIDER_OVERRIDE;
        PreferredPlatformBuildForSdkBuildProvider preferredPlatformBuildForSdkBuildProvider = override != null ? override : DEFAULT_BUILD_PREFERENCES_PROVIDER;
        if (preferredPlatformBuildForSdkBuildProvider == null) {
            SimulatorsRegistry.$$$reportNull$$$0(18);
        }
        return preferredPlatformBuildForSdkBuildProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilesDirs";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationsDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAndWaitLoadedBlocking";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildPreferencesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshOnBackgroundThread";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readConfigurations";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    static class State {
        private List<SimulatorDeviceType> deviceTypes = Collections.emptyList();
        private List<SimulatorRuntime> runtimes = Collections.emptyList();
        private @Unmodifiable List<? extends SimulatorConfiguration> configurations = Collections.emptyList();

        State() {
        }

        @Nullable
        protected SimulatorDeviceType findDeviceType(@Nullable String id) {
            for (SimulatorDeviceType each : this.deviceTypes) {
                if (!each.getID().equals(id)) continue;
                return each;
            }
            return null;
        }

        @Nullable
        protected SimulatorRuntime findRuntime(@Nullable String id) {
            for (SimulatorRuntime each : this.runtimes) {
                if (!each.getID().equals(id)) continue;
                return each;
            }
            return null;
        }
    }

    private static interface Reader<T> {
        public T read(@NotNull File var1) throws InvalidSpecException, IOException;
    }

    static interface RefreshListener {
        public static final ExtensionPointName<RefreshListener> EP_NAME = ExtensionPointName.create((String)"cidr.cocoa.simulatorsRegistryRefreshListener");

        public void refreshFinished();
    }
}

