/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.simulatorSupport;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimulatorRuntime {
    @NotNull
    private final String myID;
    @NotNull
    private final String myVersion;
    @Nullable
    private final String myMinHostVersion;
    @Nullable
    private final String myMaxHostVersion;
    @Nullable
    private final String myBuildVersion;
    @NotNull
    private final File myRoot;
    @NotNull
    private final List<Integer> mySupportedDeviceFamilies;

    @NotNull
    public static SimulatorRuntime read(@NotNull File dir) throws InvalidSpecException, IOException {
        if (dir == null) {
            SimulatorRuntime.$$$reportNull$$$0(0);
        }
        File root = new File(dir, "Contents");
        Plist info = PlistDriver.readAnyFormat((File)new File(root, "Info.plist"));
        @NonNls String id = info.getNotNullString("CFBundleIdentifier");
        Plist profile = PlistDriver.readAnyFormat((File)new File(root, "Resources/profile.plist"));
        @NonNls String version = profile.getNotNullString("defaultVersionString");
        @NonNls String bundleName = info.getNotNullString("CFBundleName");
        if (version.equals("11.3") && info.getNotNullString("DTXcodeBuild").equals("9P107g") && (bundleName.equals("iOS 11.4") || bundleName.equals("tvOS 11.4"))) {
            version = "11.4";
        }
        String minHostVersion = profile.getString("minHostVersion");
        String maxHostVersion = profile.getString("maxHostVersion");
        List devices = profile.getAttributeList("supportedProductFamilyIDs", Number.class, Collections.emptyList());
        ArrayList<Integer> intDevices = new ArrayList<Integer>(devices.size());
        for (Number each : devices) {
            intDevices.add(each.intValue());
        }
        File systemVersionPlistFile = new File(root, "Resources/RuntimeRoot/System/Library/CoreServices/SystemVersion.plist");
        Plist systemVersionPlist = systemVersionPlistFile.exists() ? PlistDriver.readAnyFormatSafe((File)systemVersionPlistFile) : null;
        String buildVersion = null;
        if (systemVersionPlist != null) {
            buildVersion = systemVersionPlist.getString("ProductBuildVersion");
        }
        return new SimulatorRuntime(id, version, minHostVersion, maxHostVersion, buildVersion, intDevices, root);
    }

    public SimulatorRuntime(@NotNull String id, @NotNull String version, @Nullable String minHostVersion, @Nullable String maxHostVersion, @Nullable String buildVersion, @NotNull List<Integer> supportedDeviceFamilies, @NotNull File root) {
        if (id == null) {
            SimulatorRuntime.$$$reportNull$$$0(1);
        }
        if (version == null) {
            SimulatorRuntime.$$$reportNull$$$0(2);
        }
        if (supportedDeviceFamilies == null) {
            SimulatorRuntime.$$$reportNull$$$0(3);
        }
        if (root == null) {
            SimulatorRuntime.$$$reportNull$$$0(4);
        }
        this.myID = id;
        this.myVersion = version;
        this.myMinHostVersion = minHostVersion;
        this.myMaxHostVersion = maxHostVersion;
        this.myBuildVersion = buildVersion;
        this.mySupportedDeviceFamilies = Collections.unmodifiableList(supportedDeviceFamilies);
        this.myRoot = root;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            SimulatorRuntime.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            SimulatorRuntime.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getMinHostVersion() {
        return this.myMinHostVersion;
    }

    @Nullable
    public String getMaxHostVersion() {
        return this.myMaxHostVersion;
    }

    @Nullable
    public String getBuildVersion() {
        return this.myBuildVersion;
    }

    @NotNull
    public List<Integer> getSupportedDeviceFamilies() {
        List<Integer> list = this.mySupportedDeviceFamilies;
        if (list == null) {
            SimulatorRuntime.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public File getRootSubFile(@Nullable String relativePath) {
        return relativePath == null ? this.myRoot : new File(this.myRoot, relativePath);
    }

    @NotNull
    public String getRootSubFilePath(@NonNls @Nullable String relativePath) {
        String string = this.getRootSubFile(relativePath).getPath();
        if (string == null) {
            SimulatorRuntime.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NonNls
    public String toString() {
        return "SimulatorRuntime{myID='" + this.myID + "', myVersion='" + this.myVersion + "', myMinHostVersion='" + this.myMinHostVersion + "', myMaxHostVersion='" + this.myMaxHostVersion + "', myBuildVersion='" + this.myBuildVersion + "', mySupportedDeviceFamilies=" + String.valueOf(this.mySupportedDeviceFamilies) + ", myRoot=" + String.valueOf(this.myRoot) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulatorRuntime runtime = (SimulatorRuntime)o;
        if (!this.myID.equals(runtime.myID)) {
            return false;
        }
        if (!this.myVersion.equals(runtime.myVersion)) {
            return false;
        }
        if (!Objects.equals(this.myBuildVersion, runtime.myBuildVersion)) {
            return false;
        }
        if (!Objects.equals(this.myMaxHostVersion, runtime.myMaxHostVersion)) {
            return false;
        }
        if (!Objects.equals(this.myMinHostVersion, runtime.myMinHostVersion)) {
            return false;
        }
        if (!this.mySupportedDeviceFamilies.equals(runtime.mySupportedDeviceFamilies)) {
            return false;
        }
        return FileUtil.filesEqual((File)this.myRoot, (File)runtime.myRoot);
    }

    public int hashCode() {
        int result = this.myID.hashCode();
        result = 31 * result + this.myVersion.hashCode();
        result = 31 * result + Objects.hashCode(this.myMinHostVersion);
        result = 31 * result + Objects.hashCode(this.myMaxHostVersion);
        result = 31 * result + Objects.hashCode(this.myBuildVersion);
        result = 31 * result + this.mySupportedDeviceFamilies.hashCode();
        result = 31 * result + FileUtil.fileHashCode((File)this.myRoot);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedDeviceFamilies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDeviceFamilies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootSubFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

