/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.simulatorSupport;

import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorConfiguration;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorRuntime;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimulatorDeviceType {
    @NotNull
    private final String myID;
    @NotNull
    private final String myPresentableName;
    @Nullable
    private final String myModelIdentifier;
    @Nullable
    private final String myMinRuntimeVersion;
    @Nullable
    private final String myMaxRuntimeVersion;
    @Nullable
    private final VersionRange myCreateByDefaultForRuntimeVersions;
    private final int myScale;
    private final int myHeight;
    @NotNull
    private final List<Integer> mySupportedDeviceFamilies;
    @NotNull
    private final List<ArchitectureValue> mySupportedArchitectures;
    private static final String SIM_DEVICE_TYPE_EXTENSION = ".simdevicetype";

    @NotNull
    public static SimulatorDeviceType read(@NotNull File dir) throws InvalidSpecException, IOException {
        if (dir == null) {
            SimulatorDeviceType.$$$reportNull$$$0(0);
        }
        String presentableName = SimulatorDeviceType.removeSimDeviceTypeExtension(dir.getName());
        Plist info = PlistDriver.readAnyFormat((File)new File(dir, "Contents/Info.plist"));
        String id = info.getNotNullString("CFBundleIdentifier");
        Plist profile = PlistDriver.readAnyFormat((File)new File(dir, "Contents/Resources/profile.plist"));
        String modelIdentifier = profile.getString("modelIdentifier");
        String minRuntimeVersion = profile.getString("minRuntimeVersion");
        String maxRuntimeVersion = profile.getString("maxRuntimeVersion");
        VersionRange createByDefaultForRuntimeVersions = null;
        Dictionary createByDefaultForRuntimeVersionsDict = profile.getDictionary("createByDefaultForRuntimeVersions", null);
        if (createByDefaultForRuntimeVersionsDict != null) {
            String versionMin = createByDefaultForRuntimeVersionsDict.getNotNullString("versionMin");
            String versionMax = createByDefaultForRuntimeVersionsDict.getNotNullString("versionMax");
            createByDefaultForRuntimeVersions = new VersionRange(versionMin, versionMax);
        }
        int scale = SimulatorDeviceType.intFromNumberOrString(profile.get((Object)"mainScreenScale"));
        int height = SimulatorDeviceType.intFromNumberOrString(profile.get((Object)"mainScreenHeight"));
        ArrayList<Integer> deviceFamilies = new ArrayList<Integer>();
        for (Number each : profile.getAttributeList("supportedProductFamilyIDs", Number.class, Collections.emptyList())) {
            deviceFamilies.add(each.intValue());
        }
        ArrayList<ArchitectureValue> archs = new ArrayList<ArchitectureValue>();
        for (String each : profile.getAttributeList("supportedArchs", String.class, Collections.emptyList())) {
            archs.add(new ArchitectureValue(each));
        }
        return new SimulatorDeviceType(id, presentableName, modelIdentifier, minRuntimeVersion, maxRuntimeVersion, createByDefaultForRuntimeVersions, scale, height, deviceFamilies, archs);
    }

    public SimulatorDeviceType(@NotNull String id, @NotNull String presentableName, @Nullable String modelIdentifier, @Nullable String minRuntimeVersion, @Nullable String maxRuntimeVersion, @Nullable VersionRange createByDefaultForRuntimeVersions, int scale, int height, @NotNull List<Integer> deviceFamilies, @NotNull List<ArchitectureValue> architectures) {
        if (id == null) {
            SimulatorDeviceType.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            SimulatorDeviceType.$$$reportNull$$$0(2);
        }
        if (deviceFamilies == null) {
            SimulatorDeviceType.$$$reportNull$$$0(3);
        }
        if (architectures == null) {
            SimulatorDeviceType.$$$reportNull$$$0(4);
        }
        this.myID = id;
        this.myPresentableName = presentableName;
        this.myModelIdentifier = modelIdentifier;
        this.myMinRuntimeVersion = minRuntimeVersion;
        this.myMaxRuntimeVersion = maxRuntimeVersion;
        this.myCreateByDefaultForRuntimeVersions = createByDefaultForRuntimeVersions;
        this.myScale = scale;
        this.myHeight = height;
        this.mySupportedDeviceFamilies = Collections.unmodifiableList(deviceFamilies);
        this.mySupportedArchitectures = Collections.unmodifiableList(architectures);
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            SimulatorDeviceType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            SimulatorDeviceType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getModelIdentifier() {
        return this.myModelIdentifier;
    }

    @Nullable
    public String getMinRuntimeVersion() {
        return this.myMinRuntimeVersion;
    }

    @Nullable
    public String getMaxRuntimeVersion() {
        return this.myMaxRuntimeVersion;
    }

    public boolean createByDefaultFor(SimulatorRuntime runtime) {
        if (this.myCreateByDefaultForRuntimeVersions == null) {
            return false;
        }
        return runtime.getSupportedDeviceFamilies().containsAll(this.mySupportedDeviceFamilies) && SimulatorConfiguration.isVersionBetween(runtime.getVersion(), this.getMinRuntimeVersion(), this.getMaxRuntimeVersion()) && this.myCreateByDefaultForRuntimeVersions.include(runtime.getVersion());
    }

    public int getScale() {
        return this.myScale;
    }

    public int getHeight() {
        return this.myHeight;
    }

    @NotNull
    public List<Integer> getSupportedDeviceFamilies() {
        List<Integer> list = this.mySupportedDeviceFamilies;
        if (list == null) {
            SimulatorDeviceType.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<ArchitectureValue> getSupportedArchitectures() {
        List<ArchitectureValue> list = this.mySupportedArchitectures;
        if (list == null) {
            SimulatorDeviceType.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static int intFromNumberOrString(Object value) {
        Number number = value instanceof String ? (Number)Double.parseDouble((String)value) : (Number)((Number)value);
        return number.intValue();
    }

    @NonNls
    public String toString() {
        return "SimulatorDeviceType{myID='" + this.myID + "', myPresentableName='" + this.myPresentableName + "', myModelIdentifier='" + this.myModelIdentifier + "', myMinRuntimeVersion='" + this.myMinRuntimeVersion + "', myMaxRuntimeVersion='" + this.myMaxRuntimeVersion + "', myScale=" + this.myScale + ", myHeight=" + this.myHeight + ", mySupportedDeviceFamilies=" + String.valueOf(this.mySupportedDeviceFamilies) + ", mySupportedArchitectures=" + String.valueOf(this.mySupportedArchitectures) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulatorDeviceType type = (SimulatorDeviceType)o;
        if (this.myHeight != type.myHeight) {
            return false;
        }
        if (this.myScale != type.myScale) {
            return false;
        }
        if (!this.myID.equals(type.myID)) {
            return false;
        }
        if (this.myModelIdentifier != null ? !this.myModelIdentifier.equals(type.myModelIdentifier) : type.myModelIdentifier != null) {
            return false;
        }
        if (this.myMaxRuntimeVersion != null ? !this.myMaxRuntimeVersion.equals(type.myMaxRuntimeVersion) : type.myMaxRuntimeVersion != null) {
            return false;
        }
        if (this.myMinRuntimeVersion != null ? !this.myMinRuntimeVersion.equals(type.myMinRuntimeVersion) : type.myMinRuntimeVersion != null) {
            return false;
        }
        if (!this.mySupportedArchitectures.equals(type.mySupportedArchitectures)) {
            return false;
        }
        return this.mySupportedDeviceFamilies.equals(type.mySupportedDeviceFamilies);
    }

    public int hashCode() {
        int result = this.myID.hashCode();
        result = 31 * result + (this.myModelIdentifier != null ? this.myModelIdentifier.hashCode() : 0);
        result = 31 * result + (this.myMinRuntimeVersion != null ? this.myMinRuntimeVersion.hashCode() : 0);
        result = 31 * result + (this.myMaxRuntimeVersion != null ? this.myMaxRuntimeVersion.hashCode() : 0);
        result = 31 * result + this.myScale;
        result = 31 * result + this.myHeight;
        result = 31 * result + this.mySupportedDeviceFamilies.hashCode();
        result = 31 * result + this.mySupportedArchitectures.hashCode();
        return result;
    }

    private static String removeSimDeviceTypeExtension(@NotNull String from) {
        if (from == null) {
            SimulatorDeviceType.$$$reportNull$$$0(9);
        }
        if (!from.endsWith(SIM_DEVICE_TYPE_EXTENSION)) {
            return from;
        }
        return from.substring(0, from.length() - SIM_DEVICE_TYPE_EXTENSION.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFamilies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architectures";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorDeviceType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorDeviceType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDeviceFamilies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedArchitectures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeSimDeviceTypeExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static class VersionRange {
        private final String versionMin;
        private final String versionMax;

        private VersionRange(String versionMin, String versionMax) {
            this.versionMin = versionMin;
            this.versionMax = versionMax;
        }

        boolean include(String version) {
            return SimulatorConfiguration.isVersionBetween(version, this.versionMin, this.versionMax);
        }
    }
}

