/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.deviceSupport;

import com.google.common.collect.ImmutableSet;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.OCPathManager;
import com.jetbrains.cidr.execution.JBDeviceFramework;
import com.jetbrains.cidr.execution.deviceSupport.AMDevice;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceException;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceListener;
import com.jetbrains.cidr.execution.deviceSupport.AMDevicePairingStatus;
import com.jetbrains.cidr.execution.deviceSupport.OCDeviceLog;
import com.jetbrains.cidr.xcode.Xcode;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class AMDeviceManager {
    public static final Topic<AMDeviceListener> DEVICE_LISTENER_TOPIC = Topic.create((String)"Apple Mobile Devices observation", AMDeviceListener.class);
    private final Callback DEVICE_ATTACHED = new Callback(){

        public void callback(ID self, Pointer selector, ID deviceInfo, boolean visible, boolean paired) {
            AMDevice device = new AMDevice(deviceInfo, visible, new AMDevicePairingStatus(paired, false));
            AMDeviceManager.this.myConnectedDevices.add(device);
            AMDeviceManager.getPublisher().deviceAttached(device);
            Notification notification = AMDeviceManager.this.myLastMountErrorNotification;
            if (notification != null) {
                notification.expire();
                AMDeviceManager.this.myLastMountErrorNotification = null;
            }
        }
    };
    private final Callback DEVICE_DETACHED = new Callback(){

        public void callback(ID self, Pointer selector, ID deviceInfo) {
            AMDevice device = new AMDevice(deviceInfo, false, new AMDevicePairingStatus(false, false));
            AMDeviceManager.this.myConnectedDevices.remove(device);
            AMDeviceManager.getPublisher().deviceDetached(device);
        }
    };
    private final Callback DEVICE_VISIBILITY_UPDATED = new Callback(){

        public void callback(ID self, Pointer selector, ID deviceInfo, boolean visible, boolean paired, boolean didUserRefusedPairing) {
            AMDevice device = new AMDevice(deviceInfo, visible, new AMDevicePairingStatus(paired, didUserRefusedPairing));
            AMDeviceManager.this.myConnectedDevices.remove(device);
            AMDeviceManager.this.myConnectedDevices.add(device);
            AMDeviceManager.getPublisher().deviceVisibilityUpdated(device);
        }
    };
    private final Callback DEVICE_PASSCODE_STATUS_UPDATED = new Callback(this){

        public void callback(ID self, Pointer selector, ID deviceInfo, boolean passcodeLocked) {
            AMDevice device = new AMDevice(deviceInfo, false, new AMDevicePairingStatus(false, false));
            AMDeviceManager.getPublisher().devicePasscodeStatusChanged(device, passcodeLocked);
        }
    };
    private final Callback IMAGE_MOUNT_FAILED = new Callback(){

        public void callback(ID self, Pointer selector, ID error, ID device, boolean wireless) {
            AMDeviceManager.this.handleMountError(error, new AMDevice(device, false, new AMDevicePairingStatus(false, false)), wireless);
        }
    };
    private static final Callback JB_DEVICE_LOG = new Callback(){

        public void callback(ID self, Pointer selector, ID message) {
            OCDeviceLog.LOG.debug(Foundation.toStringViaUTF8((ID)message));
        }
    };
    private static final Callback PING = new Callback(){

        public void callback(ID self, Pointer selector) {
        }
    };
    private final Set<AMDevice> myConnectedDevices = ConcurrentCollectionFactory.createConcurrentSet();
    private volatile Notification myLastMountErrorNotification;

    public AMDeviceManager() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> JBDeviceFramework.getInstance());
    }

    public static NotificationGroup getNotificationGroup() {
        return NotificationGroupManager.getInstance().getNotificationGroup("Device Support");
    }

    private static AMDeviceListener getPublisher() {
        return (AMDeviceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DEVICE_LISTENER_TOPIC);
    }

    @Nullable
    public static File findSymbolsDirectoryOrShowError(@NotNull AMDevice device) {
        if (device == null) {
            AMDeviceManager.$$$reportNull$$$0(0);
        }
        List<File> possibleDeviceSupportBaseDirectories = AMDeviceManager.collectPossibleDeviceSupportDirectories(device.getDeviceType());
        String deviceCpuArchitecture = device.getCpuArchitecture();
        String deviceType = device.getProductType();
        String productVersion = device.getProductVersion();
        String buildVersion = device.getBuildVersion();
        for (File deviceSupportDir : possibleDeviceSupportBaseDirectories) {
            File symbolsDir = AMDeviceManager.findExistingSymbolsDirectory(deviceSupportDir, deviceType, productVersion, buildVersion, deviceCpuArchitecture);
            if (symbolsDir == null) continue;
            return symbolsDir;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            String osVersion = StringUtil.notNullize((String)device.getOSVersion(), (String)"unknown");
            String message = new HtmlBuilder().append(CocoaCommonBundle.message((String)"failed.to.lookup.device.support.symbols.description.0", (Object[])new Object[]{osVersion})).br().append(CocoaCommonBundle.message((String)"failed.to.lookup.device.support.symbols.description.1", (Object[])new Object[0])).br().append(CocoaCommonBundle.message((String)"failed.to.lookup.device.support.symbols.description.2", (Object[])new Object[0])).toString();
            AMDeviceManager.getNotificationGroup().createNotification(CocoaCommonBundle.message((String)"failed.to.lookup.device.support.symbols", (Object[])new Object[0]), message, NotificationType.WARNING).notify(null);
        });
        return null;
    }

    @NotNull
    private static List<File> collectPossibleDeviceSupportDirectories(@NotNull AMDevice.Type deviceType) {
        if (deviceType == null) {
            AMDeviceManager.$$$reportNull$$$0(1);
        }
        Pair<String, String> userAndSystemDirectoryNames = AMDeviceManager.getUserAndSystemDeviceSupportDirectoryNames(deviceType);
        List<File> list = Arrays.asList(new File(OCPathManager.getUserLibraryDir(), (String)userAndSystemDirectoryNames.first), new File(Xcode.getInstance().getBaseFile(), (String)userAndSystemDirectoryNames.second));
        if (list == null) {
            AMDeviceManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private static File findExistingSymbolsDirectory(@NotNull File baseDir, @Nullable String deviceType, @Nullable String productVersion, @Nullable String buildVersion, @Nullable String cpuArchitecture) {
        if (baseDir == null) {
            AMDeviceManager.$$$reportNull$$$0(3);
        }
        File symbolsDir = null;
        if (productVersion != null && buildVersion != null) {
            if (deviceType != null) {
                if (cpuArchitecture != null) {
                    symbolsDir = AMDeviceManager.findSymbolsDir(baseDir, "%s %s (%s) %s", deviceType, productVersion, buildVersion, cpuArchitecture);
                }
                if (symbolsDir == null) {
                    symbolsDir = AMDeviceManager.findSymbolsDir(baseDir, "%s %s (%s)", deviceType, productVersion, buildVersion);
                }
            }
            if (symbolsDir == null && cpuArchitecture != null) {
                symbolsDir = AMDeviceManager.findSymbolsDir(baseDir, "%s (%s) %s", productVersion, buildVersion, cpuArchitecture);
            }
            if (symbolsDir == null) {
                symbolsDir = AMDeviceManager.findSymbolsDir(baseDir, "%s (%s)", productVersion, buildVersion);
            }
        }
        return symbolsDir;
    }

    @Nullable
    private static File findSymbolsDir(@NotNull File baseDir, @NotNull @NonNls @PrintFormat String dirNameFormat, Object ... parameters) {
        if (baseDir == null) {
            AMDeviceManager.$$$reportNull$$$0(4);
        }
        if (dirNameFormat == null) {
            AMDeviceManager.$$$reportNull$$$0(5);
        }
        if (parameters == null) {
            AMDeviceManager.$$$reportNull$$$0(6);
        }
        String directoryName = String.format(Locale.US, dirNameFormat, parameters);
        File symbolsDir = new File(FileUtil.join((String[])new String[]{baseDir.getAbsolutePath(), directoryName, "Symbols"}));
        File symbolsDirAbsoluteFile = symbolsDir.getAbsoluteFile();
        if (symbolsDir.exists()) {
            OCDeviceLog.LOG.debug("Found device support symbols in ", new Object[]{symbolsDirAbsoluteFile});
            return symbolsDir;
        }
        OCDeviceLog.LOG.debug("Failed to lookup device support symbols in ", new Object[]{symbolsDirAbsoluteFile});
        return null;
    }

    public static @NotNull Pair<@NonNls String, @NonNls String> getUserAndSystemDeviceSupportDirectoryNames(@NotNull AMDevice.Type type) {
        if (type == null) {
            AMDeviceManager.$$$reportNull$$$0(7);
        }
        if (type.isTv()) {
            Pair pair = Pair.create((Object)"/Developer/Xcode/tvOS DeviceSupport/", (Object)"/Platforms/AppleTVOS.platform/DeviceSupport/");
            if (pair == null) {
                AMDeviceManager.$$$reportNull$$$0(8);
            }
            return pair;
        }
        if (type.isWatch()) {
            Pair pair = Pair.create((Object)"/Developer/Xcode/watchOS DeviceSupport/", (Object)"/Platforms/WatchOS.platform/DeviceSupport/");
            if (pair == null) {
                AMDeviceManager.$$$reportNull$$$0(9);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)"/Developer/Xcode/iOS DeviceSupport/", (Object)"/Platforms/iPhoneOS.platform/DeviceSupport/");
        if (pair == null) {
            AMDeviceManager.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @NotNull
    public ID createServiceDelegate() {
        ID observerClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"JBDeviceManagerObserver");
        Foundation.addMethod((ID)observerClass, (Pointer)Foundation.createSelector((String)"deviceAttached:isVisible:isPaired:"), (Callback)this.DEVICE_ATTACHED, (String)"v@:@BB");
        Foundation.addMethod((ID)observerClass, (Pointer)Foundation.createSelector((String)"deviceDetached:"), (Callback)this.DEVICE_DETACHED, (String)"v@:@");
        Foundation.addMethod((ID)observerClass, (Pointer)Foundation.createSelector((String)"device:passcodeStatusUpdated:"), (Callback)this.DEVICE_PASSCODE_STATUS_UPDATED, (String)"v@:@B");
        Foundation.addMethod((ID)observerClass, (Pointer)Foundation.createSelector((String)"deviceVisibilityUpdated:isVisible:isPaired:userRefusedPairing:"), (Callback)this.DEVICE_VISIBILITY_UPDATED, (String)"v@:@BBB");
        Foundation.addMethod((ID)observerClass, (Pointer)Foundation.createSelector((String)"mountFailedWithError:forDevice:isWireless:"), (Callback)this.IMAGE_MOUNT_FAILED, (String)"v@:@@B");
        Foundation.addMethod((ID)observerClass, (Pointer)Foundation.createSelector((String)"jbDeviceLog:"), (Callback)JB_DEVICE_LOG, (String)"v@:@");
        Foundation.addMethod((ID)observerClass, (Pointer)Foundation.createSelector((String)"ping"), (Callback)PING, (String)"v@:");
        Foundation.addProtocol((ID)observerClass, (ID)Foundation.getProtocol((String)"JBDeviceClientProtocol"));
        Foundation.registerObjcClassPair((ID)observerClass);
        ID iD = Foundation.invoke((ID)Foundation.invoke((ID)observerClass, (String)"alloc", (Object[])new Object[0]), (String)"init", (Object[])new Object[0]);
        if (iD == null) {
            AMDeviceManager.$$$reportNull$$$0(11);
        }
        return iD;
    }

    @NotNull
    public static AMDeviceManager getInstance() {
        AMDeviceManager aMDeviceManager = (AMDeviceManager)ApplicationManager.getApplication().getService(AMDeviceManager.class);
        if (aMDeviceManager == null) {
            AMDeviceManager.$$$reportNull$$$0(12);
        }
        return aMDeviceManager;
    }

    @Nullable
    public AMDevice getDevice(String deviceID) {
        for (AMDevice device : this.getDevices()) {
            if (!device.getDeviceIdentifier().equals(deviceID)) continue;
            return device;
        }
        return null;
    }

    public List<AMDevice> getDevices() {
        return this.getMatchingDevices(null, null);
    }

    public List<AMDevice> getMatchingDevices(@Nullable AMDevice.Type type, @Nullable String minVersion) {
        List devices = ContainerUtil.sorted((Collection)ContainerUtil.filter(this.myConnectedDevices, device -> {
            AMDevice.Type deviceType = device.getDeviceType();
            return device.isVisible() && (type == null || type == AMDevice.Type.IOS_ANY && deviceType.isIOS() || type == deviceType) && (minVersion == null || AMDeviceManager.isProductVersionNewer(minVersion, device));
        }), (d1, d2) -> StringUtil.naturalCompare((String)d1.getName(), (String)d2.getName()));
        return devices;
    }

    public static boolean isProductVersionNewer(String minVersion, AMDevice device) {
        if (minVersion == null) {
            return true;
        }
        String productVersion = device.getOSVersion();
        List matches = StringUtil.findMatches((String)productVersion, (Pattern)Pattern.compile("(.+) *(\\(.+\\))*"));
        if (!matches.isEmpty()) {
            String productMajorVersion = (String)matches.get(0);
            return StringUtil.compareVersionNumbers((String)minVersion, (String)productMajorVersion) <= 0;
        }
        return false;
    }

    @Nullable
    public String selectSuitableArchitecture(@NotNull AMDevice device, @NotNull List<String> applicationArchitectures) {
        if (device == null) {
            AMDeviceManager.$$$reportNull$$$0(13);
        }
        if (applicationArchitectures == null) {
            AMDeviceManager.$$$reportNull$$$0(14);
        }
        return AMDeviceManager.selectSuitableArchitecture(this.getDeviceArchitecture(device), applicationArchitectures);
    }

    @Nullable
    public static String selectSuitableArchitecture(@NotNull String deviceArchitecture, @NotNull List<String> applicationArchitectures) {
        int index;
        if (deviceArchitecture == null) {
            AMDeviceManager.$$$reportNull$$$0(15);
        }
        if (applicationArchitectures == null) {
            AMDeviceManager.$$$reportNull$$$0(16);
        }
        if (applicationArchitectures.contains(deviceArchitecture)) {
            return deviceArchitecture;
        }
        Object allowedArchitectures = AMDeviceDatabase.ALLOWED_ARCHS_DESCENDING_BY_DEVICE_ARCH.get(deviceArchitecture);
        if (allowedArchitectures == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                OCDeviceLog.LOG.error("Unknown device architecture " + deviceArchitecture + ". We may select wrong run/build compatible architecture.");
            }
            allowedArchitectures = AMDeviceDatabase.ARCHS_DESCENDING.asList();
        }
        if ((index = allowedArchitectures.indexOf(deviceArchitecture)) != -1) {
            allowedArchitectures = allowedArchitectures.subList(index, allowedArchitectures.size());
        }
        return AMDeviceManager.selectSuitableArchitecture((Collection<String>)allowedArchitectures, applicationArchitectures);
    }

    @Nullable
    public static String selectSuitableFallbackArchitecture(@NotNull List<String> applicationArchitectures) {
        if (applicationArchitectures == null) {
            AMDeviceManager.$$$reportNull$$$0(17);
        }
        return AMDeviceManager.selectSuitableArchitecture(AMDeviceDatabase.ARCHS_DESCENDING, applicationArchitectures);
    }

    @Nullable
    private static String selectSuitableArchitecture(@NotNull Collection<String> allowedArchitectures, @NotNull List<String> applicationArchitectures) {
        if (allowedArchitectures == null) {
            AMDeviceManager.$$$reportNull$$$0(18);
        }
        if (applicationArchitectures == null) {
            AMDeviceManager.$$$reportNull$$$0(19);
        }
        for (String each : allowedArchitectures) {
            if (!applicationArchitectures.contains(each)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public static Set<String> getAllDeviceArchitectures() {
        ImmutableSet<String> immutableSet = AMDeviceDatabase.ARCHS_DESCENDING;
        if (immutableSet == null) {
            AMDeviceManager.$$$reportNull$$$0(20);
        }
        return immutableSet;
    }

    @NotNull
    public String getDeviceArchitecture(@NotNull AMDevice device) {
        String result;
        if (device == null) {
            AMDeviceManager.$$$reportNull$$$0(21);
        }
        OCDeviceLog.LOG.assertTrue((result = device.getCpuArchitecture()) != null);
        String string = result;
        if (string == null) {
            AMDeviceManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    private void handleMountError(ID error, AMDevice device, boolean wireless) {
        int errorCode = Foundation.invoke((ID)error, (String)"code", (Object[])new Object[0]).intValue();
        OCDeviceLog.LOG.warn(AMDeviceException.getLocalizedDescription(error));
        try {
            String title;
            String message = !wireless && (errorCode == 10003 || errorCode == -402652958 || errorCode == -402653183 && device.isPasscodeLocked()) ? new HtmlBuilder().append(CocoaCommonBundle.message((String)"device.locked.message.0", (Object[])new Object[0])).br().br().append(CocoaCommonBundle.message((String)"device.locked.message.1", (Object[])new Object[0])).toString() : (errorCode == 8 ? new HtmlBuilder().append(CocoaCommonBundle.message((String)"developer.mode.disabled.0", (Object[])new Object[0])).br().br().append(CocoaCommonBundle.message((String)"developer.mode.disabled.1", (Object[])new Object[0])).toString() : null);
            if (message != null && (title = device.getName()) != null) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    this.myLastMountErrorNotification = AMDeviceManager.getNotificationGroup().createNotification(title, message, NotificationType.WARNING);
                    this.myLastMountErrorNotification.notify(null);
                });
            }
        }
        catch (AMDeviceException e) {
            OCDeviceLog.LOG.warn((Throwable)((Object)e));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9, 10, 11, 12, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceType";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/deviceSupport/AMDeviceManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNameFormat";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationArchitectures";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceArchitecture";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedArchitectures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/deviceSupport/AMDeviceManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPossibleDeviceSupportDirectories";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAndSystemDeviceSupportDirectoryNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createServiceDelegate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDeviceArchitectures";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceArchitecture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSymbolsDirectoryOrShowError";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleDeviceSupportDirectories";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExistingSymbolsDirectory";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSymbolsDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUserAndSystemDeviceSupportDirectoryNames";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "selectSuitableArchitecture";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectSuitableFallbackArchitecture";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceArchitecture";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9, 10, 11, 12, 20, 22 -> new IllegalStateException(string);
        };
    }

    private static class AMDeviceDatabase {
        @NonNls
        private static final String arm = "arm";
        @NonNls
        private static final String arm64v8 = "arm64v8";
        @NonNls
        private static final String armv8 = "armv8";
        @NonNls
        private static final String armv5e = "armv5e";
        @NonNls
        private static final String armv5 = "armv5";
        @NonNls
        private static final String armv7f = "armv7f";
        @NonNls
        private static final String armv7k = "armv7k";
        @NonNls
        private static final String armv6 = "armv6";
        @NonNls
        private static final String armv7 = "armv7";
        @NonNls
        private static final String armv7s = "armv7s";
        @NonNls
        private static final String arm64 = "arm64";
        @NonNls
        private static final String arm64_32 = "arm64_32";
        @NonNls
        private static final String arm64e = "arm64e";
        @NonNls
        private static final ImmutableSet<String> ARCHS_DESCENDING = ImmutableSet.of((Object)"arm64e", (Object)"arm64", (Object)"arm64_32", (Object)"armv7s", (Object)"armv7", (Object)"armv6", (Object[])new String[0]);
        private static final Map<@NonNls String, List<@NonNls String>> ALLOWED_ARCHS_DESCENDING_BY_DEVICE_ARCH = Map.ofEntries(Map.entry("arm", List.of("arm")), Map.entry("arm64", List.of("arm64v8", "arm64", "armv8")), Map.entry("arm64_32", List.of("arm64_32")), Map.entry("arm64e", List.of("arm64e", "arm64v8", "arm64", "armv8")), Map.entry("arm64v8", List.of("arm64v8", "arm64", "armv8")), Map.entry("armv5", List.of("armv5e", "armv5", "arm")), Map.entry("armv5e", List.of("armv5e", "armv5", "arm")), Map.entry("armv6", List.of("armv6", "armv5e", "armv5", "arm")), Map.entry("armv7", List.of("armv7", "armv6", "armv5e", "armv5", "arm")), Map.entry("armv7f", List.of("armv7f", "armv7", "armv6", "armv5e", "armv5", "arm")), Map.entry("armv7k", List.of("armv7k", "armv7", "armv6", "armv5e", "armv5", "arm")), Map.entry("armv7s", List.of("armv7s", "armv7", "armv6", "armv5e", "armv5", "arm")), Map.entry("armv8", List.of("arm64v8", "arm64", "armv8")));

        private AMDeviceDatabase() {
        }
    }
}

