/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.deviceSupport;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.FoundationUtil;
import com.jetbrains.cidr.execution.JBDeviceFramework;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceBusyException;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceException;
import com.jetbrains.cidr.execution.deviceSupport.AMDevicePairingStatus;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceProgressListener;
import com.jetbrains.cidr.execution.deviceSupport.OCDeviceLog;
import com.jetbrains.cidr.xcode.BoolMapper;
import com.jetbrains.cidr.xcode.LongMapper;
import com.jetbrains.cidr.xcode.ObjMapper2;
import com.jetbrains.cidr.xcode.ObjMapper3;
import com.jetbrains.cidr.xcode.XPCServiceConnectionKt;
import com.sun.jna.Callback;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AMDevice {
    private volatile ID myJbDeviceInfo;
    private final boolean myVisible;
    private final AMDevicePairingStatus myPairingStatus;
    private static final Set<String> UNKNOWN_DEVICE_TYPES = ConcurrentCollectionFactory.createConcurrentSet();

    @NotNull
    private static ID createAppInstallationDelegate(@NotNull Callback statusCallback) {
        if (statusCallback == null) {
            AMDevice.$$$reportNull$$$0(0);
        }
        ID iD = Foundation.invoke((ID)Foundation.invoke((ID)Foundation.invoke((ID)Foundation.getObjcClass((String)"AppCodeInstallationDelegate"), (String)"alloc", (Object[])new Object[0]), (String)"initWithStatusUpdatedCallback:", (Object[])new Object[]{statusCallback}), (String)"autorelease", (Object[])new Object[0]);
        if (iD == null) {
            AMDevice.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @NotNull
    private static Callback createStatusUpdateCallback(final @NotNull AMDeviceProgressListener listener) {
        if (listener == null) {
            AMDevice.$$$reportNull$$$0(2);
        }
        return new Callback(){

            public void callback(ID status, int percentComplete) {
                listener.endStage(true, (double)percentComplete / 100.0);
                @NlsSafe String statusText = Foundation.toStringViaUTF8((ID)status);
                listener.beginStage(statusText);
            }
        };
    }

    public Type getDeviceType() {
        String nativeType = this.getType();
        Type type = Type.getType(nativeType);
        if (type != null) {
            return type;
        }
        if (UNKNOWN_DEVICE_TYPES.add(nativeType)) {
            OCDeviceLog.LOG.warn("Unknown device type '" + nativeType + "'. Treating as 'iPhone'");
        }
        return Type.IPHONE;
    }

    public AMDevice(ID jbDeviceInfo, boolean visible, AMDevicePairingStatus pairingStatus) {
        this.myJbDeviceInfo = Foundation.invoke((ID)jbDeviceInfo, (String)"retain", (Object[])new Object[0]);
        this.myVisible = visible;
        this.myPairingStatus = pairingStatus;
    }

    @Nullable
    @NlsSafe
    public String getOSVersion() {
        return this.getString("osVersion");
    }

    public String getProductType() {
        return this.getString("productType");
    }

    @NlsSafe
    public String getName() {
        return this.getString("name");
    }

    public String getType() {
        String type = this.getString("type");
        if (!this.isCoreDevice()) {
            type = Type.AMDEVICE_TYPE_MAP.getOrDefault(type, type);
        }
        return type;
    }

    public String getModelNumber() {
        return this.getString("modelNumber");
    }

    @Deprecated(forRemoval=true)
    public String getSerialNumber() {
        return this.getString("serialNumber");
    }

    @Deprecated(forRemoval=true)
    public ID getSerialNumberNSString() {
        return Foundation.invoke((ID)this.myJbDeviceInfo, (String)"serialNumber", (Object[])new Object[0]);
    }

    public String getDeviceUUID() {
        return this.getString("uuid");
    }

    public ID getDeviceUUIDAsNSString() {
        return Foundation.invoke((ID)this.myJbDeviceInfo, (String)"uuid", (Object[])new Object[0]);
    }

    public String getDeviceIdentifier() {
        return this.getString("deviceIdentifier");
    }

    @Nullable
    public String getCpuArchitecture() {
        return this.getString("cpuArchitecture");
    }

    @Nullable
    public String getBuildVersion() {
        return this.getString("buildVersion");
    }

    @Nullable
    public String getProductVersion() {
        return this.getString("productVersion");
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public boolean isPaired() {
        return this.myPairingStatus.isPaired();
    }

    public boolean getUserRefusedPairing() {
        return this.myPairingStatus.getUserRefusedPairing();
    }

    public boolean hasUsbConnection() {
        return Foundation.invoke((ID)this.myJbDeviceInfo, (String)"hasUsbConnection", (Object[])new Object[0]).byteValue() != 0;
    }

    public boolean isCoreDevice() {
        return Foundation.invoke((ID)this.myJbDeviceInfo, (String)"isCoreDevice", (Object[])new Object[0]).byteValue() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getString(@NotNull @NonNls String deviceInfoPropertyName) {
        if (deviceInfoPropertyName == null) {
            AMDevice.$$$reportNull$$$0(3);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            String string = Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)this.myJbDeviceInfo, (String)deviceInfoPropertyName, (Object[])new Object[0]));
            return string;
        }
        catch (RuntimeException e) {
            OCDeviceLog.LOG.warn((Throwable)e);
        }
        finally {
            pool.drain();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppInstallationResult installAppBundle(@NotNull @NonNls String path, AMDeviceProgressListener listener) throws AMDeviceException {
        if (path == null) {
            AMDevice.$$$reportNull$$$0(4);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            record TemporaryResult(@Nullable String appPath, @Nullable String appDataContainer, @Nullable AMDeviceException exception) {
            }
            Callback statusUpdateCallback = AMDevice.createStatusUpdateCallback(listener);
            ID delegate = AMDevice.createAppInstallationDelegate(statusUpdateCallback);
            ObjMapper3 mapper = XPCServiceConnectionKt.ObjMapper3((arg0, arg1, arg2) -> new TemporaryResult(Foundation.toStringViaUTF8((ID)arg0), Foundation.toStringViaUTF8((ID)arg1), AMDevice.map(arg0, arg2)));
            TemporaryResult value = (TemporaryResult)JBDeviceFramework.getValue(mapper, 0, "installAppBundle:onDevice:delegate:reply:", new Object[]{Foundation.nsString((String)path), this.getDeviceUUIDAsNSString(), delegate});
            if (value.exception != null) {
                throw value.exception;
            }
            AppInstallationResult appInstallationResult = new AppInstallationResult(Objects.requireNonNull(value.appPath), Objects.requireNonNull(value.appDataContainer));
            return appInstallationResult;
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transferDirectoryToApplicationSandbox(@NotNull @NonNls String path, @NotNull @NonNls String pathOnDevice, @NotNull @NonNls String bundleId) throws AMDeviceException {
        if (path == null) {
            AMDevice.$$$reportNull$$$0(5);
        }
        if (pathOnDevice == null) {
            AMDevice.$$$reportNull$$$0(6);
        }
        if (bundleId == null) {
            AMDevice.$$$reportNull$$$0(7);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ObjMapper2 mapper = XPCServiceConnectionKt.ObjMapper2((arg0, arg1) -> Pair.create((Object)Foundation.toStringViaUTF8((ID)arg0), (Object)((Object)(JBDeviceFramework.isNilOrNo(arg1) ? null : new AMDeviceException((ID)arg1)))));
            Pair result = (Pair)JBDeviceFramework.getValue(mapper, 0, "transferOnDevice:path:pathOnDevice:toSandboxOfApplicationWithIdentifier:reply:", new Object[]{this.getDeviceUUIDAsNSString(), Foundation.nsString((String)path), Foundation.nsString((String)pathOnDevice), Foundation.nsString((String)bundleId)});
            if (result.second != null) {
                throw (AMDeviceException)((Object)result.second);
            }
            String string = (String)result.first;
            return string;
        }
        finally {
            pool.drain();
        }
    }

    @NotNull
    private static ObjMapper2<AMDeviceException> getMapper() {
        ObjMapper2 objMapper2 = XPCServiceConnectionKt.ObjMapper2((arg0, arg1) -> AMDevice.map(arg0, arg1));
        if (objMapper2 == null) {
            AMDevice.$$$reportNull$$$0(8);
        }
        return objMapper2;
    }

    @Nullable
    private static AMDeviceException map(ID arg0, ID arg1) {
        if (!JBDeviceFramework.isNilOrNo(arg1)) {
            return new AMDeviceException(arg1);
        }
        if (JBDeviceFramework.isNilOrNo(arg0)) {
            return new AMDeviceException(CocoaCommonBundle.message((String)"dialog.message.unknown.error", (Object[])new Object[0]));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(@NotNull String pathOnDevice, @NotNull String pathOnMac, boolean removeOnDevice, @NotNull String bundleId) throws AMDeviceException {
        if (pathOnDevice == null) {
            AMDevice.$$$reportNull$$$0(9);
        }
        if (pathOnMac == null) {
            AMDevice.$$$reportNull$$$0(10);
        }
        if (bundleId == null) {
            AMDevice.$$$reportNull$$$0(11);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ObjMapper2<AMDeviceException> mapper = AMDevice.getMapper();
            AMDeviceException error = JBDeviceFramework.getValue(mapper, 0, "downloadFromDevice:file:toPath:fromContainerWithIdentifier:removeOnDevice:reply:", new Object[]{this.getDeviceUUIDAsNSString(), Foundation.nsString((String)pathOnDevice), Foundation.nsString((String)pathOnMac), Foundation.nsString((String)bundleId), removeOnDevice});
            if (error != null) {
                throw error;
            }
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ProcessInfo> getRunningProcesses() throws AMDeviceException {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        ObjMapper2 mapper = XPCServiceConnectionKt.ObjMapper2((arg0, arg1) -> {
            List list = FoundationUtil.mapNotNullNSArray((ID)arg0, processDictId -> {
                Foundation.NSDictionary dict = new Foundation.NSDictionary(processDictId);
                int pid = Foundation.invoke((ID)dict.get("pid"), (String)"intValue", (Object[])new Object[0]).intValue();
                String name = Foundation.toStringViaUTF8((ID)dict.get("name"));
                String executablePath = StringUtil.notNullize((String)Foundation.toStringViaUTF8((ID)dict.get("realAppName")));
                if (pid == 0 || name == null) {
                    return null;
                }
                return new ProcessInfo(pid, executablePath, name, "", executablePath);
            });
            return Pair.create((Object)list, (Object)((Object)(JBDeviceFramework.isNilOrNo(arg1) ? null : new AMDeviceException((ID)arg1))));
        });
        Pair values = (Pair)JBDeviceFramework.getValue(mapper, 10, "runningProcessesOnDevice:reply:", new Object[]{this.getDeviceUUIDAsNSString()});
        if (values.second != null) {
            throw (AMDeviceException)((Object)values.second);
        }
        List list = (List)values.first;
        List list2 = list;
        if (list2 == null) {
            AMDevice.$$$reportNull$$$0(12);
        }
        return list2;
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Pair<Integer, String> startDebugserver() throws AMDeviceException {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        ObjMapper3 mapper = XPCServiceConnectionKt.ObjMapper3((arg0, arg1, arg2) -> Trinity.create((Object)Foundation.invoke((ID)arg0, (String)"intValue", (Object[])new Object[0]).intValue(), (Object)Foundation.toStringViaUTF8((ID)arg1), (Object)((Object)AMDevice.map(arg0, arg2))));
        Trinity values = (Trinity)JBDeviceFramework.getValue(mapper, 35, "startDebugServerOnDevice:reply:", new Object[]{this.getDeviceUUIDAsNSString()});
        if (values.third != null) {
            throw (AMDeviceException)((Object)values.third);
        }
        Pair pair = Pair.create((Object)((Integer)values.first), (Object)((String)values.second));
        Pair pair2 = pair;
        if (pair2 == null) {
            AMDevice.$$$reportNull$$$0(13);
        }
        return pair2;
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateLocation(double latitude, double longitude) {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            JBDeviceFramework.invokeBlocking("locationSimulationOnDevice:setLatitude:longitude:", this.getDeviceUUIDAsNSString(), latitude, longitude);
        }
        finally {
            pool.drain();
        }
    }

    public void stopLocationSimulation() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            JBDeviceFramework.invokeBlocking("stopLocationSimulationOnDevice:", this.getDeviceUUIDAsNSString());
        }
        finally {
            pool.drain();
        }
    }

    public void stopDebugserver(int debugServerID) {
        JBDeviceFramework.invokeBlocking("stopDebugServerOnDevice:debugServerId:", this.getDeviceUUIDAsNSString(), debugServerID);
    }

    public boolean isLocked() {
        try {
            return this.getBoolean("isDeviceLocked:reply:", 1);
        }
        catch (AMDeviceException e) {
            OCDeviceLog.LOG.warn((Throwable)((Object)e));
            return true;
        }
    }

    public boolean isPasscodeLocked() throws AMDeviceException {
        return this.getBoolean("isPasscodeLocked:reply:", 1);
    }

    public void lock() throws AMDeviceException {
        this.lock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(boolean ignoreExistingLock) throws AMDeviceException {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            boolean res = (Boolean)JBDeviceFramework.getValue(BoolMapper.INSTANCE, 1, "lockDevice:ignoreExisting:reply:", new Object[]{this.getDeviceUUIDAsNSString(), ignoreExistingLock});
            if (!res) {
                throw new AMDeviceBusyException(this);
            }
        }
        finally {
            pool.drain();
        }
    }

    public void unlock() {
        JBDeviceFramework.invokeBlocking("unlockDevice:", this.getDeviceUUIDAsNSString());
    }

    @NonNls
    public String toString() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        String description = Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)this.myJbDeviceInfo, (String)"description", (Object[])new Object[0]));
        pool.drain();
        return description != null ? description : "UNKNOWN " + String.valueOf(this.myJbDeviceInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AMDevice device = (AMDevice)o;
        return this.getDeviceIdentifier().equals(device.getDeviceIdentifier());
    }

    public int hashCode() {
        return this.getDeviceIdentifier().hashCode();
    }

    protected void finalize() {
        Foundation.invoke((ID)this.myJbDeviceInfo, (String)"release", (Object[])new Object[0]);
        this.myJbDeviceInfo = null;
    }

    public long createPowerAssertion(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            AMDevice.$$$reportNull$$$0(14);
        }
        return this.getLongCancellable("createPowerAssertion:reply:", progressIndicator);
    }

    public void releasePowerAssertion(long assertion) {
        if (assertion != 0L && assertion != -1L) {
            JBDeviceFramework.invokeBlocking("releasePowerAssertion:", assertion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getBoolean(@NotNull @NonNls String selector, int timeoutSeconds) throws AMDeviceException {
        if (selector == null) {
            AMDevice.$$$reportNull$$$0(15);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            boolean bl = (Boolean)JBDeviceFramework.getValue(BoolMapper.INSTANCE, timeoutSeconds, selector, new Object[]{this.getDeviceUUIDAsNSString()});
            return bl;
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLongCancellable(@NotNull @NonNls String selector, @NotNull ProgressIndicator progressIndicator) {
        if (selector == null) {
            AMDevice.$$$reportNull$$$0(16);
        }
        if (progressIndicator == null) {
            AMDevice.$$$reportNull$$$0(17);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            long l = (Long)JBDeviceFramework.getValueWithProgress(progressIndicator, LongMapper.INSTANCE, selector, new Object[]{this.getDeviceUUIDAsNSString()});
            return l;
        }
        finally {
            pool.drain();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusCallback";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/deviceSupport/AMDevice";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceInfoPropertyName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathOnDevice";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathOnMac";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/deviceSupport/AMDevice";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppInstallationDelegate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapper";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningProcesses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugserver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAppInstallationDelegate";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStatusUpdateCallback";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installAppBundle";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "transferDirectoryToApplicationSandbox";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPowerAssertion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLongCancellable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 12, 13 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        IPHONE("iPhone"),
        IPAD("iPad"),
        IOS_ANY(null),
        TV("appleTV"),
        WATCH("appleWatch"),
        VISION("realityDevice");

        private static final Map<String, String> AMDEVICE_TYPE_MAP;
        @Nullable
        private final String nativeType;

        private Type(String type) {
            this.nativeType = type;
        }

        public boolean isIOS() {
            return this == IPHONE || this == IPAD || this == IOS_ANY;
        }

        public boolean isTv() {
            return this == TV;
        }

        public boolean isWatch() {
            return this == WATCH;
        }

        @Nullable
        @NonNls
        public String getNativeType() {
            return this.nativeType;
        }

        @Nullable
        public static Type getType(@NotNull String nativeType) {
            if (nativeType == null) {
                Type.$$$reportNull$$$0(0);
            }
            return (Type)((Object)ContainerUtil.find((Object[])Type.values(), type -> nativeType.equals(type.getNativeType())));
        }

        static {
            AMDEVICE_TYPE_MAP = Map.of("AppleTV", "appleTV", "Watch", "appleWatch");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeType", "com/jetbrains/cidr/execution/deviceSupport/AMDevice$Type", "getType"));
        }
    }

    public record AppInstallationResult(@NotNull String appPath, @NotNull String appDataContainer) {
        @NotNull
        private final String appPath;
        @NotNull
        private final String appDataContainer;

        public AppInstallationResult(@NotNull String appPath, @NotNull String appDataContainer) {
            if (appPath == null) {
                AppInstallationResult.$$$reportNull$$$0(0);
            }
            if (appDataContainer == null) {
                AppInstallationResult.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String appPath() {
            String string = this.appPath;
            if (string == null) {
                AppInstallationResult.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String appDataContainer() {
            String string = this.appDataContainer;
            if (string == null) {
                AppInstallationResult.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appDataContainer";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/deviceSupport/AMDevice$AppInstallationResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/deviceSupport/AMDevice$AppInstallationResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appDataContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

