/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.ArrayUtil;
import com.jetbrains.apple.sdk.CidrNativeLibraryPaths;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.OCPathManager;
import com.jetbrains.cidr.execution.JBDeviceFramework;
import com.jetbrains.cidr.execution.JBDeviceFrameworkError;
import com.jetbrains.cidr.execution.deviceSupport.AMDevice;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceException;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceManager;
import com.jetbrains.cidr.execution.deviceSupport.OCDeviceLog;
import com.jetbrains.cidr.xcode.Mapper;
import com.jetbrains.cidr.xcode.XPCServiceConnection;
import com.jetbrains.cidr.xcode.XPCServiceConnectionDelegate;
import com.jetbrains.cidr.xcode.XPCServiceConnectionError;
import com.jetbrains.cidr.xcode.Xcode;
import com.sun.jna.NativeLibrary;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/JBDeviceFramework;", "", "<init>", "()V", "serviceDelegate", "Lcom/intellij/ui/mac/foundation/ID;", "xpcServiceConnection", "Lcom/jetbrains/cidr/xcode/XPCServiceConnection;", "value", "Lcom/jetbrains/cidr/execution/JBDeviceFrameworkError;", "error", "getError", "()Lcom/jetbrains/cidr/execution/JBDeviceFrameworkError;", "initComponent", "", "createDelegate", "Lcom/jetbrains/cidr/xcode/XPCServiceConnectionDelegate;", "findDeveloperImageDirs", "Companion", "intellij.cidr.cocoaDevices"})
public final class JBDeviceFramework {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ID serviceDelegate;
    @NotNull
    private final XPCServiceConnection xpcServiceConnection = new XPCServiceConnection("JBDevice.framework/Versions/A/Resources/JBDeviceService", this.createDelegate(), 0, JBDeviceFramework::xpcServiceConnection$lambda$0, 4, null);
    @NotNull
    private volatile JBDeviceFrameworkError error = JBDeviceFrameworkError.NO_ERROR;

    public JBDeviceFramework() {
        this.initComponent();
    }

    @NotNull
    public final JBDeviceFrameworkError getError() {
        return this.error;
    }

    private final void initComponent() {
        boolean bl;
        Xcode xcode = Xcode.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)xcode, (String)"getInstance(...)");
        Xcode xcode2 = xcode;
        if (!xcode2.isInstalled()) {
            this.error = JBDeviceFrameworkError.XCODE_NOT_FOUND;
            return;
        }
        try {
            NativeLibrary.getInstance((String)OCPathManager.getBinFile((String)"JBDevice.framework/Versions/A/JBDevice").getAbsolutePath());
            bl = true;
        }
        catch (UnsatisfiedLinkError e) {
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
                OCDeviceLog.LOG.warn("JBDevice framework was not loaded: " + e.getMessage());
            } else {
                OCDeviceLog.LOG.error("JBDevice framework was not loaded: " + e.getMessage());
            }
            this.error = JBDeviceFrameworkError.JB_DEVICE_FRAMEWORK_LOAD_ERROR;
            bl = false;
        }
        boolean frameworkLoaded = bl;
        if (frameworkLoaded) {
            this.serviceDelegate = AMDeviceManager.getInstance().createServiceDelegate();
            String string = xcode2.getSubFilePath("Platforms/MacOSX.platform/Developer/Library/Frameworks");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubFilePath(...)");
            String xcTestPath = string;
            String string2 = xcode2.getApplicationContentsSubFilePath("PlugIns/Xcode3Core.ideplugin/Contents/Frameworks");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getApplicationContentsSubFilePath(...)");
            String xcode3CorePath = string2;
            String string3 = xcode2.getApplicationContentsSubFilePath("Frameworks");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getApplicationContentsSubFilePath(...)");
            String frameworksPath = string3;
            String string4 = xcode2.getApplicationContentsSubFilePath("PlugIns");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getApplicationContentsSubFilePath(...)");
            String pluginsPath = string4;
            Object[] objectArray = new String[]{xcTestPath, xcode3CorePath, frameworksPath, pluginsPath};
            List extraSearchPaths = CollectionsKt.listOf((Object[])objectArray);
            String string5 = OCPathManager.getBinFile((String)"libObjCHelper.dylib").getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAbsolutePath(...)");
            CidrNativeLibraryPaths.libObjCHelper.setPath(string5);
            XPCServiceConnection.establishConnection$default((XPCServiceConnection)this.xpcServiceConnection, (List)extraSearchPaths, null, null, (int)6, null);
        }
    }

    private final XPCServiceConnectionDelegate createDelegate() {
        return new XPCServiceConnectionDelegate(this){
            final /* synthetic */ JBDeviceFramework this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterConnectAttempt(boolean connected) {
                if (!connected) {
                    return;
                }
                ID iD = JBDeviceFramework.access$getServiceDelegate$p(this.this$0);
                if (iD != null) {
                    ID iD2 = iD;
                    JBDeviceFramework jBDeviceFramework = this.this$0;
                    ID it = iD2;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{it};
                    JBDeviceFramework.access$getXpcServiceConnection$p(jBDeviceFramework).invokeServiceWithAvailableConnection("setClient:", objectArray);
                }
                XPCServiceConnection xPCServiceConnection = JBDeviceFramework.access$getXpcServiceConnection$p(this.this$0);
                Object[] objectArray = new Object[2];
                objectArray[0] = JBDeviceFramework.access$findDeveloperImageDirs(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)Foundation.nsString((String)Xcode.getInstance().getBasePath()), (String)"nsString(...)");
                xPCServiceConnection.invokeServiceWithAvailableConnection("initializeWithDeviceSupportDirs:developerDir:", objectArray);
            }

            public ID getRemoteObjectInterface() {
                ID iD = Foundation.invoke((String)"JBDeviceServiceInterfaces", (String)"serviceInterface", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"invoke(...)");
                return iD;
            }

            public void onDisconnect() {
            }

            public void onError(XPCServiceConnectionError connectionError) {
                Intrinsics.checkNotNullParameter((Object)connectionError, (String)"connectionError");
                JBDeviceFramework.access$setError$p(this.this$0, switch (createDelegate.WhenMappings.$EnumSwitchMapping$0[connectionError.ordinal()]) {
                    case 1 -> JBDeviceFrameworkError.BRIDGE_SERVICE_FILE_ERROR;
                    case 2 -> JBDeviceFrameworkError.BRIDGE_SERVICE_PLIST_FILE_ERROR;
                    case 3 -> JBDeviceFrameworkError.JB_DEVICE_SERVICE_FILE_ERROR;
                    default -> throw new NoWhenBranchMatchedException();
                });
            }
        };
    }

    private final ID findDeveloperImageDirs() {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (AMDevice.Type type : EntriesMappings.entries$0) {
            if (type.getNativeType() == null) continue;
            String string = type.getNativeType();
            Intrinsics.checkNotNull((Object)string);
            keys.add(string);
            values.add(new File(Xcode.getInstance().getBaseFile(), (String)AMDeviceManager.getUserAndSystemDeviceSupportDirectoryNames((AMDevice.Type)type).second).getAbsolutePath());
        }
        ID iD = Foundation.createDict((String[])ArrayUtil.toStringArray((Collection)keys), (Object[])ArrayUtil.toStringArray((Collection)values));
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"createDict(...)");
        return iD;
    }

    private static final boolean xpcServiceConnection$lambda$0() {
        return OCDeviceLog.LOG.isDebugEnabled() || ApplicationManager.getApplication().isEAP();
    }

    @NotNull
    public static final JBDeviceFramework getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final <T> T getValueWithProgress(@NotNull ProgressIndicator progressIndicator, @NotNull Mapper<T> mapper, @NonNls @NotNull String selector, Object ... args) {
        return Companion.getValueWithProgress(progressIndicator, mapper, selector, args);
    }

    @JvmStatic
    public static final <T> T getValue(@NotNull Mapper<T> mapper, int timeoutSeconds, @NonNls @NotNull String selector, Object ... args) throws AMDeviceException {
        return Companion.getValue(mapper, timeoutSeconds, selector, args);
    }

    @JvmStatic
    @Nullable
    public static final Object invoke(@NonNls @NotNull String selector, @NotNull Object[] args, @NotNull Continuation<? super ID> $completion) throws XPCServiceConnection.UnavailableException {
        return Companion.invoke(selector, args, $completion);
    }

    @JvmStatic
    @NotNull
    public static final ID invokeBlocking(@NonNls @NotNull String selector, Object ... args) throws XPCServiceConnection.UnavailableException {
        return Companion.invokeBlocking(selector, args);
    }

    @JvmStatic
    public static final boolean isNilOrNo(@Nullable ID okValue) {
        return Companion.isNilOrNo(okValue);
    }

    @JvmStatic
    public static final void dumpTraceLogs() {
        Companion.dumpTraceLogs();
    }

    public static final /* synthetic */ ID access$getServiceDelegate$p(JBDeviceFramework $this) {
        return $this.serviceDelegate;
    }

    public static final /* synthetic */ ID access$findDeveloperImageDirs(JBDeviceFramework $this) {
        return $this.findDeveloperImageDirs();
    }

    public static final /* synthetic */ void access$setError$p(JBDeviceFramework $this, JBDeviceFrameworkError jBDeviceFrameworkError) {
        $this.error = jBDeviceFrameworkError;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0013JG\u0010\u0014\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0017JL\u0010\u0014\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00120\u001aH\u0086@\u00a2\u0006\u0004\b\u001b\u0010\u001cJB\u0010\u0014\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00120\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001dJ,\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001H\u0087@\u00a2\u0006\u0002\u0010 J+\u0010!\u001a\u00020\u001f2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u001fH\u0007J\b\u0010&\u001a\u00020'H\u0007R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006("}, d2={"Lcom/jetbrains/cidr/execution/JBDeviceFramework$Companion;", "", "<init>", "()V", "instance", "Lcom/jetbrains/cidr/execution/JBDeviceFramework;", "getInstance$annotations", "getInstance", "()Lcom/jetbrains/cidr/execution/JBDeviceFramework;", "getValueWithProgress", "T", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "mapper", "Lcom/jetbrains/cidr/xcode/Mapper;", "selector", "", "args", "", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/jetbrains/cidr/xcode/Mapper;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "getValue", "timeoutSeconds", "", "(Lcom/jetbrains/cidr/xcode/Mapper;ILjava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "timeout", "Lkotlin/time/Duration;", "Lkotlin/Function0;", "getValue-WPwdCS8", "(Lcom/jetbrains/cidr/xcode/Mapper;JLjava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lcom/jetbrains/cidr/xcode/Mapper;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invoke", "Lcom/intellij/ui/mac/foundation/ID;", "(Ljava/lang/String;[Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invokeBlocking", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/intellij/ui/mac/foundation/ID;", "isNilOrNo", "", "okValue", "dumpTraceLogs", "", "intellij.cidr.cocoaDevices"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JBDeviceFramework getInstance() {
            Object object = ApplicationManager.getApplication().getService(JBDeviceFramework.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JBDeviceFramework)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @JvmStatic
        public final <T> T getValueWithProgress(@NotNull ProgressIndicator progressIndicator, @NotNull Mapper<T> mapper, @NonNls @NotNull String selector, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Deferred job2 = BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(mapper, selector, args, null){
                int label;
                final /* synthetic */ Mapper<T> $mapper;
                final /* synthetic */ String $selector;
                final /* synthetic */ Object[] $args;
                {
                    this.$mapper = $mapper;
                    this.$selector = $selector;
                    this.$args = $args;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = JBDeviceFramework.Companion.getValue(this.$mapper, this.$selector, (Function0<? extends Object[]>)((Function0)() -> getValueWithProgress.job.1.invokeSuspend$lambda$0(this.$args)), (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Object[] invokeSuspend$lambda$0(Object[] $args) {
                    return $args;
                }
            }, (int)3, null);
            return (T)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(job2, progressIndicator, null){
                int label;
                final /* synthetic */ Deferred<T> $job;
                final /* synthetic */ ProgressIndicator $progressIndicator;
                {
                    this.$job = $job;
                    this.$progressIndicator = $progressIndicator;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
lbl5:
                            // 2 sources

                            while (!this.$job.isCompleted()) {
                                this.label = 1;
                                v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl16
                            }
                            break;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            this.$progressIndicator.checkCanceled();
                            ** GOTO lbl5
                        }
                    }
                    this.label = 2;
                    v1 = this.$job.await((Continuation)this);
                    if (v1 == var2_2) {
                        return var2_2;
                    }
                    ** GOTO lbl26
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl26:
                            // 2 sources

                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, (int)1, null);
        }

        @JvmStatic
        public final <T> T getValue(@NotNull Mapper<T> mapper, int timeoutSeconds, @NonNls @NotNull String selector, Object ... args) throws AMDeviceException {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            try {
                return (T)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(timeoutSeconds, mapper, selector, args, null){
                    int label;
                    final /* synthetic */ int $timeoutSeconds;
                    final /* synthetic */ Mapper<T> $mapper;
                    final /* synthetic */ String $selector;
                    final /* synthetic */ Object[] $args;
                    {
                        this.$timeoutSeconds = $timeoutSeconds;
                        this.$mapper = $mapper;
                        this.$selector = $selector;
                        this.$args = $args;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object;
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                if (this.$timeoutSeconds != 0) break;
                                this.label = 1;
                                object = JBDeviceFramework.access$getXpcServiceConnection$p(JBDeviceFramework.Companion.getInstance()).getValue(this.$mapper, this.$selector, () -> getValue.1.invokeSuspend$lambda$0(this.$args), (Continuation)this);
                                if (object != object2) return object;
                                return object2;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                object = $result;
                                return object;
                            }
                        }
                        this.label = 2;
                        object = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)this.$timeoutSeconds, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this.$mapper, this.$selector, this.$args, null){
                            int label;
                            final /* synthetic */ Mapper<T> $mapper;
                            final /* synthetic */ String $selector;
                            final /* synthetic */ Object[] $args;
                            {
                                this.$mapper = $mapper;
                                this.$selector = $selector;
                                this.$args = $args;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = JBDeviceFramework.access$getXpcServiceConnection$p(JBDeviceFramework.Companion.getInstance()).getValue(this.$mapper, this.$selector, () -> getValue.2.invokeSuspend$lambda$0(this.$args), (Continuation)this);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Object[] invokeSuspend$lambda$0(Object[] $args) {
                                return $args;
                            }
                        }), (Continuation)((Continuation)this));
                        if (object != object2) return object;
                        return object2;
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                object = $result;
                                return object;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Object[] invokeSuspend$lambda$0(Object[] $args) {
                        return $args;
                    }
                }, (int)1, null);
            }
            catch (TimeoutCancellationException e) {
                throw new AMDeviceException(CocoaCommonBundle.message((String)"dialog.message.timeout.when.communication.with.device", (Object[])new Object[0]), e);
            }
            catch (XPCServiceConnection.UnavailableException e) {
                throw new AMDeviceException(CocoaCommonBundle.message((String)"dialog.message.error.when.communication.with.device", (Object[])new Object[0]), e);
            }
        }

        @Nullable
        public final <T> Object getValue-WPwdCS8(@NotNull Mapper<T> mapper, long l, @NonNls @NotNull String selector, @NotNull Function0<? extends Object[]> args, @NotNull Continuation<? super T> $completion) {
            return TimeoutKt.withTimeout-KLykuaI((long)l, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(mapper, selector, args, null){
                int label;
                final /* synthetic */ Mapper<T> $mapper;
                final /* synthetic */ String $selector;
                final /* synthetic */ Function0<Object[]> $args;
                {
                    this.$mapper = $mapper;
                    this.$selector = $selector;
                    this.$args = $args;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = JBDeviceFramework.Companion.getValue(this.$mapper, this.$selector, this.$args, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, $completion);
        }

        @Nullable
        public final <T> Object getValue(@NotNull Mapper<T> mapper, @NonNls @NotNull String selector, @NotNull Function0<? extends Object[]> args, @NotNull Continuation<? super T> $completion) {
            return this.getInstance().xpcServiceConnection.getValue(mapper, selector, args, $completion);
        }

        @JvmStatic
        @Nullable
        public final Object invoke(@NonNls @NotNull String selector, @NotNull Object[] args, @NotNull Continuation<? super ID> $completion) throws XPCServiceConnection.UnavailableException {
            return this.getInstance().xpcServiceConnection.awaitForConnectionAndInvokeService(selector, Arrays.copyOf(args, args.length), $completion);
        }

        @JvmStatic
        @NotNull
        public final ID invokeBlocking(@NonNls @NotNull String selector, Object ... args) throws XPCServiceConnection.UnavailableException {
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return (ID)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ID>, Object>(selector, args, null){
                int label;
                final /* synthetic */ String $selector;
                final /* synthetic */ Object[] $args;
                {
                    this.$selector = $selector;
                    this.$args = $args;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = JBDeviceFramework.Companion.invoke(this.$selector, Arrays.copyOf(this.$args, this.$args.length), (Continuation<? super ID>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super ID> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        @JvmStatic
        public final boolean isNilOrNo(@Nullable ID okValue) {
            return okValue == null || Intrinsics.areEqual((Object)okValue, (Object)ID.NIL) || okValue.intValue() == 0;
        }

        @JvmStatic
        public final void dumpTraceLogs() {
            this.getInstance().xpcServiceConnection.dumpTraceLogs();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<AMDevice.Type> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])AMDevice.Type.values());
        }
    }
}

