/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.file;

import com.dmarcotte.handlebars.HbLanguage;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0006"}, d2={"guessTemplateFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "guessTemplateLanguage", "Lcom/intellij/lang/Language;", "intellij.handlebars"})
public final class HbTemplateUtilKt {
    @Nullable
    public static final FileType guessTemplateFileType(@Nullable VirtualFile virtualFile) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (virtualFile == null || virtualFile instanceof VirtualFileWindow) {
            return null;
        }
        List list = StringUtil.split((String)virtualFile.getName(), (String)".");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        String string = (String)CollectionsKt.lastOrNull((List)list);
        if (string == null) {
            return null;
        }
        String extension = string;
        FileType fileType = fileTypeManager.getFileTypeByExtension(extension);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
        FileType fileType2 = fileType;
        return fileType2 == UnknownFileType.INSTANCE ? null : fileType2;
    }

    @NotNull
    public static final Language guessTemplateLanguage(@NotNull VirtualFile virtualFile) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        FileType fileType = HbTemplateUtilKt.guessTemplateFileType(virtualFile);
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType == null) {
            Language language2 = HbLanguage.getDefaultTemplateLang().getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
            return language2;
        }
        LanguageFileType fileType2 = languageFileType;
        Language language3 = fileType2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language3, (String)"getLanguage(...)");
        Language language4 = language3;
        if (language4 instanceof TemplateLanguage || language4.isKindOf((Language)HbLanguage.INSTANCE)) {
            fileType = HbLanguage.getDefaultTemplateLang().getLanguage();
            Intrinsics.checkNotNull((Object)fileType);
            language = fileType;
        } else {
            language = language4;
        }
        return language;
    }
}

