/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.editor.comments;

import com.dmarcotte.handlebars.HbLanguage;
import com.dmarcotte.handlebars.config.HbConfig;
import com.dmarcotte.handlebars.editor.comments.HandlebarsCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import org.jetbrains.annotations.Nullable;

public final class HbCommenter
implements Commenter {
    private static final Commenter ourHandlebarsCommenter = new HandlebarsCommenter();

    @Nullable
    public String getLineCommentPrefix() {
        Commenter commenter = HbCommenter.getCommenter();
        return commenter != null ? commenter.getLineCommentPrefix() : null;
    }

    @Nullable
    public String getBlockCommentPrefix() {
        Commenter commenter = HbCommenter.getCommenter();
        return commenter != null ? commenter.getBlockCommentPrefix() : null;
    }

    @Nullable
    public String getBlockCommentSuffix() {
        Commenter commenter = HbCommenter.getCommenter();
        return commenter != null ? commenter.getBlockCommentSuffix() : null;
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        Commenter commenter = HbCommenter.getCommenter();
        return commenter != null ? commenter.getCommentedBlockCommentPrefix() : null;
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        Commenter commenter = HbCommenter.getCommenter();
        return commenter != null ? commenter.getCommentedBlockCommentSuffix() : null;
    }

    private static Commenter getCommenter() {
        Language commenterLanguage = HbConfig.getCommenterLanguage();
        if (commenterLanguage.isKindOf((Language)HbLanguage.INSTANCE)) {
            return ourHandlebarsCommenter;
        }
        return (Commenter)LanguageCommenters.INSTANCE.forLanguage(commenterLanguage);
    }
}

